//
//  WCTCompanyContactMultiSelectViewController.m
//  
//
//  Created by Howard on 2016/4/14.
//
//

#import "WCTCompanyContactMultiSelectViewController.h"

// Define
#import "WCTCompanyContactViewController+ResourceDefine.h"
#import "WCTRestClientController+ParameterDefine.h"

// Controller
#import "WCTCompanyContactFetchDataController.h"
#import "PPRefreshController.h"

// Cateogory
#import "WCTableViewController+ContactPageSearch.h"
#import "WCTableViewController+CompanyCardModel.h"
#import "WCTableViewController+CompanyContactFetchDataDelegate.h"
#import "UIViewController+ShareApplication.h"
#import "NSObject+PPBusyView.h"


////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Interface WCTCompanyContactMultiSelectViewController

@interface WCTCompanyContactMultiSelectViewController ()
<
PPRefreshControllerDelegate
>

@property (nonatomic,retain) PPRefreshController *refreshController;

@end


////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Implementation WCTCompanyContactMultiSelectViewController

@implementation WCTCompanyContactMultiSelectViewController

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Dellocating Object

//================================================================================
//
//================================================================================
- (id)initWithMode:(PPSIC_Mode)mode
{
    if(self = [super initWithMode:mode])
    {
        // 建立refreshController
        self.refreshController = [PPRefreshController refreshControllerWithDelegate:self];
        
        if(self.refreshController!=nil)
        {
            self.refreshController.enabled = YES;
            self.refreshController.backgroundColor = WCTCompanyContactViewAppearance_BackgroundColor;
            // 設定indicator顏色
            [[PPActivityIndicatorView appearance] setLineColor:WCTCompanyContactViewAppearance_IndicatorColor];
            
            self.refreshController.infoPosition = PPRefreshControllerInfoPosition_Bottom;
        }
    }
    
    //////////////////////////////////////////////////

    return self;
}


//================================================================================
//
//================================================================================
- (void)dealloc
{
    self.contactMultiSelectViewControllerDelegate = nil;
    
    self.curViewAccountGuid = nil;
    self.curViewCategoryGuid = nil;
    
    self.refreshController = nil;
    
    //////////////////////////////////////////////////

    [super dealloc];
}



////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Responding to View's event

//================================================================================
//
//================================================================================
- (void)viewWillAppear:(BOOL)animated
{
    [super viewWillAppear:animated];
    
    //////////////////////////////////////////////////

    [WCTCompanyContactFetchDataController shareInstance].delegate = self;
}


//================================================================================
//
//================================================================================
- (void)viewDidAppear:(BOOL)animated
{
    [super viewDidAppear:animated];
    
    //////////////////////////////////////////////////
    
    self.refreshController.targetScrollView = self.tableView;
    
    //////////////////////////////////////////////////
    
    self.refreshController.enabled = self.totalCardCount>self.cardIDArray.count ? YES: NO;
}


//================================================================================
//
//================================================================================
- (void)viewWillDisappear:(BOOL)animated
{
    [self.refreshController hideInfoView];
    
    //////////////////////////////////////////////////

    [super viewWillDisappear:animated];
    
    //////////////////////////////////////////////////

    [WCTCompanyContactFetchDataController shareInstance].delegate = nil;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance For Inherit Method

//================================================================================
//
//================================================================================
- (PPRefreshController *)companyRefreseController
{
    return self.refreshController;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Method

//================================================================================
//
//================================================================================
- (void)searchBar:(UISearchBar *)searchBar textDidChange:(NSString *)searchText
{
    // do nothing 公司連絡人無法即時搜尋回傳結果
}


//================================================================================
//
//================================================================================
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    WCCardHolderCell *cardHolderCell = (WCCardHolderCell *)[super tableView:tableView cellForRowAtIndexPath:indexPath];
    
    if(cardHolderCell!=nil)
    {
        cardHolderCell.additionButton.enabled = NO;
        
        //////////////////////////////////////////////////

        if([self contactDownloadStatusWithCardID:cardHolderCell.cardID]==WCTCompanyCardModelDownloadStatus_Done)
        {
            [cardHolderCell.additionButton setImageWithName:ImageNameCompanyContactViewControllerButtonDownloaded];
        }
        else if([self contactDownloadStatusWithCardID:cardHolderCell.cardID]==WCTCompanyCardModelDownloadStatus_Downloading)
        {
            [cardHolderCell.additionButton setImageWithName:ImageNameCompanyContactViewControllerButtonNeedDownload];
        }
        else
        {
            [cardHolderCell.additionButton setImageWithName:ImageNameCompanyContactViewControllerButtonNeedDownload];
        }
    }
    
    return cardHolderCell;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override WCTableViewController Method

//================================================================================
//
//================================================================================
- (NSString *)companyContactCustomMessageFromError:(NSError *)error
{
    NSString *message = nil;
    
    if([self.contactMultiSelectViewControllerDelegate respondsToSelector:@selector(companyContactMultiSelectViewController:requestMessageFromError:)]==YES)
    {
        message = [self.contactMultiSelectViewControllerDelegate companyContactMultiSelectViewController:self requestMessageFromError:error];
    }
    
    return message;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPRefreshControllerDelegate method

//================================================================================
//
//================================================================================
- (void)refreshControllerInfoViewWillAppear:(PPRefreshController *)refreshController
{
    if([self.contactMultiSelectViewControllerDelegate respondsToSelector:@selector(multiSelectViewControllerWillShowUpPullView)]==YES)
    {
        [self.contactMultiSelectViewControllerDelegate multiSelectViewControllerWillShowUpPullView];
    }
    
    //////////////////////////////////////////////////

    //取列表資料
    [[WCTCompanyContactFetchDataController shareInstance] fetchCardSectionModelWithContactAccountGuid:self.curViewAccountGuid
                                                                                         categoryGuid:self.curViewCategoryGuid
                                                                                            pageIndex:[self.cardIDArray count]/WCTClientControllerNumberPerPage];

}


//================================================================================
//
//================================================================================
- (void)refreshControllerInfoViewWillDisappear:(PPRefreshController *)refreshController
{
    if([self.contactMultiSelectViewControllerDelegate respondsToSelector:@selector(multiSelectViewControllerWillShowHidePullView)]==YES)
    {
        [self.contactMultiSelectViewControllerDelegate multiSelectViewControllerWillShowHidePullView];
    }
}

@end
