//
//  WCTableViewController+ShowError.m
//
//
//  Created by Howard on 2017/5/8.
//
//

#import "WCTableViewController+ShowError.h"

// Define
#import "WCTCompanyContactViewController+ResourceDefine.h"

// Category
#import "NSError+Custom.h"

// Controller
#import "PPAlertController.h"
#import "PPNetworkReachabilityController.h"
#import "WCToastController.h"

@implementation WCTableViewController (ShowError)


//================================================================================
//
//================================================================================
+ (NSString *)networkMessageFromError:(NSError *)error
{
    NSString *errorMessage = nil;
    
    do
    {
        if(error==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([error findNetworkError]==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        //無網路
        if([PPNetworkReachabilityController checkForInternetConnection]==NO)
        {
            errorMessage = WCTCCV_MLS_FailedToConnectInternet;
        }
        //手機有網路，伺服器問題
        else
        {
            errorMessage = WCTCCV_MLS_FailedToConnectServer;
        }
    }
    while (0);
    
    
    return errorMessage;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Method

//================================================================================
//
//================================================================================
- (NSString *)companyContactCustomMessageFromError:(NSError *)error
{
    return [error alertMessage];
}






////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

//================================================================================
//
//================================================================================
+ (void)showAlertError:(NSError *)error fromViewController:(UIViewController *)viewController failConnectCompletion:(void(^)(void))failConnectCompletion
{
    do
    {
        if(error==nil ||
           viewController==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////

        if(error.code==NSURLErrorCancelled)
        {
            break;
        }
        
        //////////////////////////////////////////////////
    
        NSString *errorMessage = nil;
        
        if([viewController respondsToSelector:@selector(companyContactCustomMessageFromError:)]==YES)
        {
            errorMessage = [viewController performSelector:@selector(companyContactCustomMessageFromError:) withObject:error];
        }
        else
        {
            errorMessage = [error alertMessage];
        }
        
        //////////////////////////////////////////////////

        PPAlertController *alertController = [PPAlertController alertControllerWithTitle:@""
                                                                                 message:errorMessage
                                                                          preferredStyle:UIAlertControllerStyleAlert];
        
        //////////////////////////////////////////////////
        
        [alertController addAction:[UIAlertAction actionWithTitle:WCTCCV_MLS_OK
                                                            style:UIAlertActionStyleDefault
                                                          handler:^(UIAlertAction * _Nonnull action) {
                                                              if(failConnectCompletion!=nil)
                                                              {
                                                                  failConnectCompletion();
                                                              }
                                                          }]];
        
        [viewController presentViewController:alertController animated:YES completion:nil];
    }
    while (0);
}


//================================================================================
//
//================================================================================
+ (void)showToastError:(NSError *)error fromViewController:(UIViewController *)viewController
{
    do
    {
        if(error==nil ||
           viewController==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////

        if(error.code==NSURLErrorCancelled)
        {
            break;
        }
        
        //////////////////////////////////////////////////

        NSString *errorMessage = nil;
        
        if([viewController respondsToSelector:@selector(companyContactCustomMessageFromError:)]==YES)
        {
            errorMessage = [viewController performSelector:@selector(companyContactCustomMessageFromError:) withObject:error];
        }
        else
        {
            errorMessage = [error alertMessage];
        }
        
        //////////////////////////////////////////////////
        
        [WCToastController showMessageToastFromSuperView:viewController.view
                                             withMessage:errorMessage
                                                position:PPToastPositionCenter];
    }
    while (0);
}


@end
