//
//  WCTableViewController+ContactPageSearch.m
//
//
//  Created by Howard on 2017/3/17.
//
//

#import "WCTableViewController+ContactPageSearch.h"

// Define
#import "WCTRestClientController+ParameterDefine.h"


@implementation WCTableViewController (ContactPageSearch)

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Contact Page Request Method

//================================================================================
//
//================================================================================
- (WCTRCContactGetByAccountRequest *)prepareContactGetAccountRequestWithAccountGuid:(NSString *)accountGuid
{
    WCTRCContactGetByAccountRequest *request = nil;
    
    do
    {
        request = [[[WCTRCContactGetByAccountRequest alloc] init] autorelease];
        
        if(request==nil)
        {
            break;
        }
        
        request.accountGuid = accountGuid;
        
        //!!特殊做法， [accountGuid length]=0, 將request.accountGuid = nil, 取得所有公司聯絡人
        if([accountGuid length]<=0)
        {
            request.accountGuid = nil;
        }
        
        //////////////////////////////////////////////////
        
        WCTRCPageInfo *pageInfo = [[[WCTRCPageInfo alloc] init] autorelease];
        
        if(pageInfo==nil)
        {
            break;
        }
        
        pageInfo.numberPerPage = WCTClientControllerNumberPerPage;
        pageInfo.pageIndex = self.cardIDArray.count/WCTClientControllerNumberPerPage;
        
        //////////////////////////////////////////////////
        
        // TODO: 之後要從設定值抓排序欄位
        pageInfo.fieldOrderBy = WCTRC_ContactSortField_CreatedTime;
        request.pageInfo = pageInfo;
    }
    while (0);
    
    return request;
}


@end
