//
//  WCTableViewController+CompanyContactFetchDataDelegate.m
//  
//
//  Created by Howard on 2016/5/31.
//
//

#import "WCTableViewController+CompanyContactFetchDataDelegate.h"

#import <objc/runtime.h>

// Define
#import "WCTRestClientController+ErrorCodeDefine.h"
#import "WCTRestClientController+ParameterDefine.h"
#import "WCTCompanyContactViewController+ParameterDefine.h"
#import "WCTCompanyContactViewController+ResourceDefine.h"

// Controller
#import "PPAlertController.h"
#import "WCToastController.h"
#import "WCTAccountDataController.h"

// Model
#import "WCTAccountRelationModel.h"

// Category
#import "UIViewController+ShareApplication.h"
#import "NSError+Custom.h"
#import "NSObject+PPBusyView.h"
#import "WCTableViewController+CompanyCardModel.h"
#import "WCTableViewController+ShowError.h"


@implementation WCTableViewController (CompanyContactFetchDataDelegate)

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Property Method

//================================================================================
//
//================================================================================
- (void)setCompanyContactAccessFlowDelegateController:(WCTCompanyContactAccessFlowDelegateController *)companyContactAccessFlowDelegateController
{
    objc_setAssociatedObject(self, @selector(companyContactAccessFlowDelegateController), companyContactAccessFlowDelegateController, OBJC_ASSOCIATION_RETAIN_NONATOMIC);
}


//================================================================================
//
//================================================================================
- (WCTCompanyContactAccessFlowDelegateController *)companyContactAccessFlowDelegateController
{
    return objc_getAssociatedObject(self, @selector(companyContactAccessFlowDelegateController));
}


//================================================================================
//
//================================================================================
- (void)setAccountDictionary:(NSMutableDictionary *)accountDictionary
{
    objc_setAssociatedObject(self, @selector(accountDictionary), accountDictionary, OBJC_ASSOCIATION_RETAIN_NONATOMIC);
}


//================================================================================
//
//================================================================================
- (NSMutableDictionary *)accountDictionary
{
    return objc_getAssociatedObject(self, @selector(accountDictionary));
}


//================================================================================
//
//================================================================================
- (void)setTotalCardCount:(NSUInteger)totalCardCount
{
    objc_setAssociatedObject(self, @selector(totalCardCount), @(totalCardCount), OBJC_ASSOCIATION_RETAIN);
}


//================================================================================
//
//================================================================================
- (NSUInteger)totalCardCount
{
    return [objc_getAssociatedObject(self, @selector(totalCardCount)) integerValue];
}


//================================================================================
//
//================================================================================
- (void)setWaitShowingForContactInfo:(BOOL)waitShowingForContactInfo
{
    objc_setAssociatedObject(self, @selector(waitShowingForContactInfo), @(waitShowingForContactInfo), OBJC_ASSOCIATION_RETAIN);
}


//================================================================================
//
//================================================================================
- (BOOL)waitShowingForContactInfo
{
    return [objc_getAssociatedObject(self, @selector(waitShowingForContactInfo)) boolValue];
}


//================================================================================
//
//================================================================================
- (void)setContactInfoHasChanged:(BOOL)contactInfoHasChanged
{
    objc_setAssociatedObject(self, @selector(contactInfoHasChanged), @(contactInfoHasChanged), OBJC_ASSOCIATION_RETAIN);
}


//================================================================================
//
//================================================================================
- (BOOL)contactInfoHasChanged
{
    return [objc_getAssociatedObject(self, @selector(contactInfoHasChanged)) boolValue];
}




////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private ContactList Load

//================================================================================
//
//================================================================================
- (void)loadContactList:(NSArray *)contactList withTableViewController:(WCTableViewController *)tableViewController
{
    do
    {
        if(tableViewController==nil ||
           contactList.count<=0 ||
           [[contactList firstObject] isKindOfClass:[WCCardSectionModel class]]==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        tableViewController.allCardSectionArray = [NSMutableArray arrayWithArray:contactList];
        
        [tableViewController.tableView reloadData];
        
        //////////////////////////////////////////////////
        
        [self companyRefreseController].enabled = YES;
    }
    while (0);
}


//================================================================================
//
//================================================================================
- (void)reloadDataAndAddContactList:(NSArray *)contactList withTableViewController:(WCTableViewController *)tableViewController
{
    do
    {
        @autoreleasepool
        {
            if([contactList count]==0)
            {
                [tableViewController.allCardSectionArray removeAllObjects];
                
                [tableViewController.tableView reloadData];
                
                break;
            }
            
            //////////////////////////////////////////////////
        
            if(tableViewController==nil ||
               [[contactList firstObject] isKindOfClass:[WCCardSectionModel class]]==NO)
            {
                break;
            }
            
            //////////////////////////////////////////////////

            NSMutableArray *addedIndexPaths = [NSMutableArray array];
            
            if(addedIndexPaths==nil)
            {
                break;
            }
            
            //////////////////////////////////////////////////
            
            BOOL needReloadTable = YES;
            
            if([tableViewController allCardSectionArray].count>0)
            {
                needReloadTable = NO;
            }
            
            //////////////////////////////////////////////////
            
            if(tableViewController.allCardSectionArray==nil)
            {
                tableViewController.allCardSectionArray = [NSMutableArray array];
            }
            
            //////////////////////////////////////////////////
            
            // 加資料
            WCCardSectionModel *sectionModel = [contactList firstObject];
            
            WCCardSectionModel *exitSectionModel;
            
            //////////////////////////////////////////////////
            
            for(WCTCompanyCardModel *cardModel in sectionModel.cardArray)
            {
                NSInteger section = [tableViewController sectionForCardModel:cardModel];
                
                //沒有存在對應的 sectionModel
                if(section==NSNotFound)
                {
                    exitSectionModel = [[[WCCardSectionModel alloc] init] autorelease];
                    
                    if(exitSectionModel!=nil)
                    {
                        exitSectionModel.title = cardModel.sectionTitle;
                        exitSectionModel.cardArray = [NSMutableArray array];
                        
                        //////////////////////////////////////////////////
                        
                        [tableViewController.allCardSectionArray addObject:exitSectionModel];
                        
                        //////////////////////////////////////////////////
                        
                        //一定要 section存在時，才能 insert, 所以此次用 reload
                        needReloadTable = YES;
                    }
                }
                else
                {
                    exitSectionModel = [tableViewController.allCardSectionArray objectAtIndex:section];
                }
                
                //////////////////////////////////////////////////
                
                if(exitSectionModel!=nil)
                {
                    [addedIndexPaths addObject:[NSIndexPath indexPathForRow:exitSectionModel.cardArray.count
                                                                  inSection:[tableViewController sectionForCardModel:cardModel]]];
                    
                    //////////////////////////////////////////////////
                    
                    [exitSectionModel.cardArray addObject:cardModel];
                }
            }
            
            //////////////////////////////////////////////////
            
            if(needReloadTable==NO&&
               addedIndexPaths.count>0)
            {
                [tableViewController.tableView insertRowsAtIndexPaths:addedIndexPaths withRowAnimation:UITableViewRowAnimationNone];
            }
            else
            {
                [tableViewController.tableView reloadData];
            }
        }
    }
    while (0);
}


//================================================================================
//
//================================================================================
- (void)addContactList:(NSArray *)contactList
        withTotalCount:(NSUInteger)totalCount
                 error:(NSError *)error
{
    [self setBusy:@(NO)];
    
    //////////////////////////////////////////////////
    
    PPRefreshController *refreshController = [self companyRefreseController];

    [refreshController hideInfoView];
    
    //////////////////////////////////////////////////
    
    if(error==nil)
    {
        [self reloadDataAndAddContactList:contactList withTableViewController:self];
   
        //////////////////////////////////////////////////
        
        //此次沒取足一次所需筆數資訊，代表已到最後
        if(self.cardIDArray.count<totalCount)
        {
            refreshController.enabled = YES;
        }
        else
        {
            refreshController.enabled = NO;
        }
        
        //////////////////////////////////////////////////
        
        self.totalCardCount = totalCount;
    }
    else
    {
        // !! PPLoadControl 會觀察 superView.Contentsize, ContentOffset, frame 的變化，調整自身的 Frame, 當讀取列表失敗時， contentSize 變化讓它能調整成正確的 Frame
        self.tableView.contentSize = CGSizeMake(self.tableView.contentSize.width, self.tableView.contentSize.height+1);
        self.tableView.contentSize = CGSizeMake(self.tableView.contentSize.width, self.tableView.contentSize.height-1);
        
        //////////////////////////////////////////////////
        
        [WCTableViewController showToastError:error fromViewController:self];
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - WCTCompanyContactFetchDataController Delegate Method

//================================================================================
// MARK: 主界面連絡人資訊回傳
//================================================================================
- (void)companyContactListUnderAccount:(NSArray *)contactList totalCount:(NSUInteger)totalCount withError:(NSError *)error
{
    [self addContactList:contactList withTotalCount:totalCount error:error];
}


//================================================================================
// MARK: 透過關鍵字結果回傳
//================================================================================
- (void)searchCompanyContactList:(NSArray *)contactList totalCount:(NSUInteger)totalCount withError:(NSError *)error
{
    [self addContactList:contactList withTotalCount:totalCount error:error];
}


//================================================================================
// MARK: 取得單筆詳細聯絡人資料結果
//================================================================================
- (void)detailCompanyContactInfo:(WCTRCContactInfo *)detailContactInfo withError:(NSError *)error
{
    if(error==nil)
    {
        //清除暫存帳號資訊
        [self.accountDictionary removeAllObjects];
        
        //////////////////////////////////////////////////
        
        //更新帳號資訊，進連絡人檢視頁面會用到
        __block typeof(self) blockself = self;
    
        dispatch_async(dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_DEFAULT, 0), ^{
           
            [WCTAccountDataController updateAccountListFromServerWithCompleteHandler:^(NSArray *allAccountList, NSError *error) {
                
                dispatch_async(dispatch_get_main_queue(), ^{
                    
                    [blockself setBusy:@(NO)];
                    
                    //////////////////////////////////////////////////
                    
                    if(error==nil)
                    {
                        for(WCTAccountRelationModel *accountReleationModel in allAccountList)
                        {
                            [blockself.accountDictionary setObject:accountReleationModel forKey:accountReleationModel.guid];
                        }
                        
                        //////////////////////////////////////////////////
                        
                        WCTCompanyContactAccessFlowDelegateController *companyContactAccessFlowDelegateController = [[[WCTCompanyContactAccessFlowDelegateController alloc] init] autorelease];
                        
                        if(companyContactAccessFlowDelegateController!=nil)
                        {
                            companyContactAccessFlowDelegateController.accountDictionary = blockself.accountDictionary;
                            
                            [companyContactAccessFlowDelegateController showContactInfoViewControllerWithDetailContactInfo:detailContactInfo
                                                                                                   fromSuperViewController:blockself];
                        }
                        
                        blockself.companyContactAccessFlowDelegateController = companyContactAccessFlowDelegateController;
                        
                    }
                    else
                    {
                        //取得聯絡人資料失敗，重新開放點選聯絡人
                        blockself.waitShowingForContactInfo = NO;
                        
                        //////////////////////////////////////////////////
                        
                        // 取得連絡人詳細資訊失敗
                        [WCTableViewController showToastError:error fromViewController:blockself];
                    }
                });
            }];
        });
    }
    else
    {
        [self setBusy:@(NO)];
        
        //////////////////////////////////////////////////
        
        __block typeof(self) blockself = self;
        
        [WCTableViewController showAlertError:error
                           fromViewController:self
                        failConnectCompletion:^{
                            [blockself goBackAnimated:YES];
                        }];
    }
}






////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance For Inherit Method

//================================================================================
//
//================================================================================
- (PPRefreshController *)companyRefreseController
{
    return nil;
}






////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance For Betch CallBack Method

//================================================================================
// MARK: 刪除連絡人結果回傳
//================================================================================
- (void)deletedCompanyContactGuids:(NSArray *)contactGuids
              contactFailureResult:(NSArray <WCTRCGuidWithData *> *)contactFailureResult
                         withError:(NSError *)error
{
    if(error==nil)
    {
        __block typeof(self) blockself = self;
        
        dispatch_async(dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_DEFAULT, 0), ^{
            
            do
            {
                blockself.contactInfoHasChanged = YES;
                
                //////////////////////////////////////////////////
                
                if(contactGuids.count<=0)
                {
                    break;
                }
                
                //////////////////////////////////////////////////
                
                //移除刪除失敗的 guid
                
                NSMutableArray *successDeletedContactGuids = [NSMutableArray arrayWithArray:contactGuids];
                
                if(successDeletedContactGuids==nil)
                {
                    break;
                }
                
                for(WCTRCGuidWithData *guidWithData in contactFailureResult)
                {
                    [successDeletedContactGuids removeObject:guidWithData.guid];
                }
                
                //////////////////////////////////////////////////
                
                //移除對應的 CompanyCardModel
                for(NSString *cardID in successDeletedContactGuids)
                {
                    WCTCompanyCardModel *model = [blockself companyCardModelWithCardID:cardID];
                    
                    if(model!=nil)
                    {
                        NSIndexPath *indexPath = [blockself indexPathForCompanyCardModel:model];
                        
                        //////////////////////////////////////////////////
                        
                        if(indexPath==nil)
                        {
                            continue;
                        }
                        
                        WCCardSectionModel *cardSectionModel = [[blockself allCardSectionArray] objectAtIndex:indexPath.section];
                        
                        if(cardSectionModel==nil)
                        {
                            break;
                        }
                        
                        [cardSectionModel.cardArray removeObject:model];
                    }
                }
                
                //////////////////////////////////////////////////
                
                //移除對應的 SectionModel
                
                for(NSUInteger index=0; index<blockself.allCardSectionArray.count; index++)
                {
                    WCCardSectionModel *sectionModel = [[blockself allCardSectionArray] objectAtIndex:index];
                    
                    // section 不存在任何資料
                    if([sectionModel.cardArray count]<=0)
                    {
                        [[blockself allCardSectionArray] removeObject:sectionModel];
                        
                        index--;
                    }
                }
                
                //////////////////////////////////////////////////
                
                dispatch_async(dispatch_get_main_queue(), ^{
                    [blockself setBusy:@(NO)];
                    
                    //////////////////////////////////////////////////
                    
                    [blockself.tableView reloadData];
                    
                    //////////////////////////////////////////////////
                    
                    [[NSNotificationCenter defaultCenter] postNotificationName:WCTCompanyContactHasDeletedNotificationName object:nil userInfo:nil];
                    
                    //////////////////////////////////////////////////
                    
                    if(contactFailureResult.count>0)
                    {
                        WCTRCGuidWithData *dataInfo = [contactFailureResult firstObject];
                        
                        NSError *failDeleteContactError = PPErrorMake([[dataInfo data] integerValue], @"Delete Contact Failed", nil);
                        
                        NSString *failReasonMessage = [blockself companyContactCustomMessageFromError:failDeleteContactError];
                        
                        if([failReasonMessage length]>0)
                        {
                            [WCToastController showMessageToastFromSuperView:blockself.view
                                                                 withMessage:failReasonMessage
                                                                    position:PPToastPositionCenter];
                        }
                        else
                        {
                            [WCToastController showMessageToastFromSuperView:blockself.view
                                                                 withMessage:[NSString stringWithFormat:WCTCCV_MLS_DontDeleteOwnerContactsBeDownloadedByOther,contactFailureResult.count]
                                                                    position:PPToastPositionCenter];
                        }
                    }
                    else
                    {
                        [blockself goBackAnimated:YES];
                    }
                });
            }
            while (0);
        });
    }
    else
    {
        [self setBusy:@(NO)];
        
        //////////////////////////////////////////////////
        
        __block typeof(self) blockself = self;
    
        [WCTableViewController showAlertError:error
                           fromViewController:self
                        failConnectCompletion:^{
            [blockself goBackAnimated:YES];
        }];
    }
}


//================================================================================
// MARK: 名片分享至同事結果回傳
//================================================================================
- (void)shareCompanyContactsToAccountGuidsWithError:(NSError *)error
{
    self.contactInfoHasChanged = YES;
    
    //////////////////////////////////////////////////
    
    [self setBusy:@(NO)];
    
    //////////////////////////////////////////////////
    
    if(error==nil)
    {
        [self goBackAnimated:YES];
    }
    else
    {
        __block typeof(self) blockself = self;
        
        [WCTableViewController showAlertError:error fromViewController:self failConnectCompletion:^{
            [blockself goBackAnimated:YES];
        }];
    }
}
@end
