//
//  SearchAccountSelectViewController.m
//  Extension
//
//  Created by AndrewLai on 2018/4/16.
//

//Define
#import "ContactApperanceDefine.h"
#import "WCAdvancedSearchViewController+ParameterDefine.h"
#import "WCAdvancedSearchViewController+ResourceDefine.h"
#import "WCTAdvancedSearchViewController+ParameterDefine.h"
#import "WCTAdvancedSearchViewController+ResourceDefine.h"
#import "WCAppearanceDefine.h"

//category
#import "NSObject+PPBusyView.h"
#import "PPButton+Factory.h"

//Model
#import "SearchSelectModel.h"

//View

#import "PPTableView.h"
#import "PPTableViewCell.h"
#import "PPNavigationBarView.h"
#import "SearchCheckBoxAccountTableViewCell.h"
#import "PPBusyView.h"
#import "SearchTableSectionHeaderView.h"

//Controller
#import "SearchAccountSelectViewController.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

static NSInteger const SearchAccountSelectViewController_MaxSectionCount = 2;
static NSString *const CheckBoxTextFieldIdentifier = @"CheckBoxTextFieldIdentifier";

////////////////////////////////////////////////////////////////////////////////////////////////////

typedef NS_ENUM(NSUInteger, SearchAccountSelectViewController_Section)
{
    SearchAccountSelectViewController_Section_SearchType = 0,
    SearchAccountSelectViewController_Section_Account
};

typedef NS_ENUM(NSUInteger, SearchAccountSelectViewController_ButtonTag)
{
    SearchAccountSelectViewController_ButtonTag_Back = 0,
    SearchAccountSelectViewController_ButtonTag_Finish
};

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface SearchAccountSelectViewController () <UITableViewDataSource, UITableViewDelegate, PPButtonDelegate>

@property (nonatomic, retain) NSMutableArray *searchTypeArray;
@property (nonatomic, retain) NSMutableArray *accountListArray;

@property (nonatomic, retain) PPNavigationBarView *ppNavigationBarView;
@property (nonatomic, retain) PPTableView *accountTableView;
@property (nonatomic, retain) PPBusyView  *busyView;

@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation SearchAccountSelectViewController

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Dellocating Objects

//================================================================================
//
//================================================================================
- (id)init
{
    if (self = [super init])
    {
        _currentSearchTypeSelected  = WCTSearchType_Creator;
        
        self.accountListArray = [NSMutableArray array];
        self.searchTypeArray  = [NSMutableArray arrayWithObjects:@(WCTSearchType_Creator),
                                                                 @(WCTSearchType_Editor),
                                                                 @(WCTSearchType_Owner), nil];
    }
    
    return self;
}


//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_searchTypeArray removeAllObjects];
    [_searchTypeArray release];
    _searchTypeArray = nil;
    
    [_accountListArray removeAllObjects];
    [_accountListArray release];
    _accountListArray = nil;
    
    [_accountSelected release];
    _accountSelected = nil;
    
    [_accountTableView removeFromSuperview];
    [_accountTableView release];
    _accountTableView = nil;
    
    [_busyView removeFromSuperview];
    [_busyView release];
    _busyView = nil;
    
    self.navigationItem.leftBarButtonItem = nil;
    
    [_ppNavigationBarView release];
    _ppNavigationBarView = nil;
    //////////////////////////////////////////////////
    [super dealloc];
}




////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Responding to View Events

//================================================================================
//
//================================================================================
- (void)viewWillAppear:(BOOL)animated
{
    [super viewWillAppear:animated];
    
    //////////////////////////////////////////////////
    self.ppNavigationBarView = [[[PPNavigationBarView alloc] initWithFrame:self.navigationController.navigationBar.bounds] autorelease];
    if (self.ppNavigationBarView!=nil)
    {
        self.ppNavigationBarView.style      = PPBarViewStyle_CenteredAbsolute;
        self.ppNavigationBarView.tintColor  = self.navigationController.navigationBar.tintColor;
        self.ppNavigationBarView.titleLabel.text = WCTASVC_MLS_NavigationAccountAdd;
        
        UIBarButtonItem *leftBarButtonItem = [[[UIBarButtonItem alloc] initWithCustomView:self.ppNavigationBarView] autorelease];
        if (leftBarButtonItem!=nil)
        {
            self.navigationItem.leftBarButtonItem = leftBarButtonItem;
        }
        
        //////////////////////////////////////////////////
        PPButton *backButton = [PPButton ppButtonWithIconImageName:ImageNamePPButtonIconForSystemBackImitation
                                                               tag:SearchAccountSelectViewController_ButtonTag_Back
                                                          delegate:self
                                             normalBackgroundColor:nil
                                        highlightedBackgroundColor:WCAppearanceDefine_ButtonBackgroundColor
                                                   imageEdgeInsets:WCAppearanceDefine_ButtonImageEdgeInset];
        {
            [backButton addControlEvents:UIControlEventTouchUpInside];
            [self.ppNavigationBarView setViews:@[backButton]
                                  forBlockType:PPBarViewBlockType_Left];
        }
        
        //////////////////////////////////////////////////
        PPButton *finishButton = [PPButton ppButtonWithIconImageName:WCAdvancedSearchViewControllerButtonName_Done
                                                                  tag:SearchAccountSelectViewController_ButtonTag_Finish
                                                             delegate:self
                                                normalBackgroundColor:nil
                                           highlightedBackgroundColor:WCAppearanceDefine_ButtonBackgroundColor
                                                      imageEdgeInsets:WCAppearanceDefine_ButtonImageEdgeInset];
        if(finishButton!=nil)
        {
            [finishButton addControlEvents:UIControlEventTouchUpInside];
            
            [self.ppNavigationBarView setViews:@[finishButton]
                                  forBlockType:PPBarViewBlockType_Right];
        }
    }
    
    //////////////////////////////////////////////////
    _accountTableView = [[PPTableView alloc] initWithFrame:CGRectZero style:UITableViewStylePlain];
    if(self.accountTableView!=nil)
    {
        self.accountTableView.separatorInset = UIEdgeInsetsZero;
        self.accountTableView.dataSource = self;
        self.accountTableView.delegate   = self;
        self.accountTableView.separatorColor = WCAppearanceDefine_SeparatorColor;
        
        if([self.accountTableView respondsToSelector:@selector(setEstimatedRowHeight:)]==YES)
        {
            self.accountTableView.rowHeight = UITableViewAutomaticDimension;
            [self.accountTableView setEstimatedRowHeight:PPTableViewDefaultRowHeight];
        }
        
        [self.view addSubview:self.accountTableView];
    }
    
    //////////////////////////////////////////////////
    [self setBusy:@(YES)];
    
    __block typeof(self) blockSelf = self;
    dispatch_async(dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_DEFAULT, 0), ^{
        if (blockSelf.delegate!=nil && [blockSelf.delegate respondsToSelector:@selector(requestAccountListInSearchAccountSelectViewController:)]==YES)
        {
            NSMutableArray *accountRelationArray = [blockSelf.delegate requestAccountListInSearchAccountSelectViewController:blockSelf];
            for (WCTAccountRelationModel *relationModel in accountRelationArray)
            {
                @autoreleasepool
                {
                    SearchSelectModel *accountSelectModel = [[[SearchSelectModel alloc] init] autorelease];
                    accountSelectModel.relationModel = relationModel;
                    [blockSelf.accountListArray addObject:accountSelectModel];
                }
            }
            
            for (NSString *guidSelected in blockSelf.accountSelected)
            {
                for (SearchSelectModel *selectModel in blockSelf.accountListArray)
                {
                    WCTAccountRelationModel *accountRelationModel = selectModel.relationModel;
                    if ([accountRelationModel.guid isEqualToString:guidSelected]==YES)
                    {
                        selectModel.isSelected = YES;
                        break;
                    }
                }
            }
        }
        
        dispatch_async(dispatch_get_main_queue(), ^{
            [blockSelf.accountTableView reloadData];
            [blockSelf setBusy:@(NO)];
        });
    });
}


//================================================================================
//
//================================================================================
- (void)viewWillLayoutSubviews
{
    [super viewWillLayoutSubviews];
    
    //////////////////////////////////////////////////
    self.accountTableView.frame = self.view.bounds;
}


//================================================================================
//
//================================================================================
- (void)viewDidDisappear:(BOOL)animated
{
    [self.accountTableView removeFromSuperview];
    self.accountTableView.delegate = nil;
    self.accountTableView.dataSource = nil;
    self.accountTableView = nil;
    
    [self.ppNavigationBarView removeFromSuperview];
    self.ppNavigationBarView = nil;
    
    //////////////////////////////////////////////////
    [super viewDidDisappear:animated];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - UITableViewDataSource

//================================================================================
//
//================================================================================
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView
{
    return SearchAccountSelectViewController_MaxSectionCount;
}


//================================================================================
//
//================================================================================
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    switch (section)
    {
        case SearchAccountSelectViewController_Section_SearchType:
        {
            return self.searchTypeArray.count;
        }
        case SearchAccountSelectViewController_Section_Account:
        default:
        {
            return self.accountListArray.count;
        }
    }
}


//================================================================================
//
//================================================================================
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    UITableViewCell *cell = nil;
    
    switch (indexPath.section)
    {
        case SearchAccountSelectViewController_Section_SearchType:
        {
            cell = [tableView dequeueReusableCellWithIdentifier:[NSString stringWithFormat:@"%td-%td",indexPath.section,indexPath.row]];
            if(cell==nil)
            {
                cell = [[[PPTableViewCell alloc] initWithStyle:UITableViewCellStyleDefault
                                               reuseIdentifier:[NSString stringWithFormat:@"%td-%td",indexPath.section,indexPath.row]] autorelease];
            }
            
            [cell.textLabel setTextColor:WCAppearanceDefine_CellTitleColor];
            
            //////////////////////////////////////////////////
            NSNumber *typeNumber = [self.searchTypeArray objectAtIndex:indexPath.row];
            switch (typeNumber.integerValue)
            {
                case WCTSearchType_Owner:
                {
                    cell.textLabel.text = WCTASVC_MLS_SearchTypeOwner;
                    break;
                }
                case WCTSearchType_Creator:
                {
                    cell.textLabel.text = WCCV_MLS_SearchTypeCreater;
                    break;
                }
                case WCTSearchType_Editor:
                default:
                {
                    cell.textLabel.text = WCTASVC_MLS_SearchTypeEditor;
                    break;
                }
            }
            
            //////////////////////////////////////////////////
            if (typeNumber.integerValue==self.currentSearchTypeSelected)
            {
                cell.accessoryType = UITableViewCellAccessoryCheckmark;
            }
            else
            {
                cell.accessoryType = UITableViewCellAccessoryNone;
            }
            
            break;
        }
        case SearchAccountSelectViewController_Section_Account:
        default:
        {
            cell = [tableView dequeueReusableCellWithIdentifier:CheckBoxTextFieldIdentifier];
            if(cell==nil)
            {
                cell = [[[SearchCheckBoxAccountTableViewCell alloc] initWithStyle:UITableViewCellStyleDefault
                                                                  reuseIdentifier:CheckBoxTextFieldIdentifier] autorelease];
            }
            
            //////////////////////////////////////////////////
            SearchCheckBoxAccountTableViewCell *checkBoxCell = (SearchCheckBoxAccountTableViewCell *)cell;
            [checkBoxCell.textLabel setTextColor:WCAppearanceDefine_CellTitleColor];

            //////////////////////////////////////////////////
            SearchSelectModel *accountSelectModel = [self.accountListArray objectAtIndex:indexPath.row];
            WCTAccountRelationModel *accoutRelationModel = accountSelectModel.relationModel;
            
            [checkBoxCell setCheckBoxViewStatus:accountSelectModel.isSelected];
            [checkBoxCell.textLabel setText:accoutRelationModel.name];
            
            break;
        }
    }

    return cell;
}


//================================================================================
//
//================================================================================
- (NSString *)tableView:(UITableView *)tableView titleForHeaderInSection:(NSInteger)section
{
    NSString *titleSection = nil;
    
    if (section==SearchAccountSelectViewController_Section_SearchType)
    {
        titleSection = WCTASVC_MLS_NavigationAccountProperty;
    }
    else if (section==SearchAccountSelectViewController_Section_Account)
    {
        titleSection = WCTASVC_MLS_SectionTitleAccountSelect;
    }
    return titleSection;
}


//==============================================================================
//
//==============================================================================
- (CGFloat)tableView:(UITableView *)tableView heightForHeaderInSection:(NSInteger)section
{
    return WCAppearanceDefine_SectionHeaderHeight;
}


//================================================================================
//
//================================================================================
- (UIView *)tableView:(UITableView *)tableView viewForHeaderInSection:(NSInteger)section
{
    SearchTableSectionHeaderView *sectionHeaderView = [[[SearchTableSectionHeaderView alloc] initWithFrame:CGRectZero] autorelease];
    if (sectionHeaderView!=nil)
    {
        sectionHeaderView.backgroundColor = WCAppearanceDefine_SectionHeaderBGColor;
        [sectionHeaderView.sectionLabel setTextColor:WCAppearanceDefine_SectionHeaderTitleColor];
        [sectionHeaderView.sectionLabel setFont:[UIFont systemFontOfSize:WCAppearanceDefine_SectionHeaderFontSize]];
        
        sectionHeaderView.sectionLabel.text =  [self tableView:tableView titleForHeaderInSection:section];
    }
    
    return sectionHeaderView;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - AdvanceSearchViewDelegate

//================================================================================
//
//================================================================================
- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    [tableView deselectRowAtIndexPath:indexPath animated:NO];
    
    //////////////////////////////////////////////////
    if (indexPath.section==SearchAccountSelectViewController_Section_SearchType)
    {
        NSNumber *typeNumber = [self.searchTypeArray objectAtIndex:indexPath.row];
        self.currentSearchTypeSelected = typeNumber.integerValue;
    }
    else
    {
        SearchSelectModel *accountSelectModel = [self.accountListArray objectAtIndex:indexPath.row];
        accountSelectModel.isSelected = !accountSelectModel.isSelected;
    }
    
    //////////////////////////////////////////////////
    [tableView reloadSections:[NSIndexSet indexSetWithIndex:indexPath.section] withRowAnimation:UITableViewRowAnimationNone];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPButtonDelegate

//================================================================================
//
//================================================================================
- (void)ppButton:(PPButton *)ppButton controlEvent:(UIControlEvents)controlEvent
{
    BOOL isGoBack = YES;
    
    //////////////////////////////////////////////////
    if (ppButton.tag==SearchAccountSelectViewController_ButtonTag_Finish)
    {
        if (self.delegate!=nil && [self.delegate respondsToSelector:@selector(searchAccountSelectViewController:didFinishSelectAccounts:)]==YES)
        {
            NSMutableArray *accountList = [NSMutableArray array];
            for (SearchSelectModel *selectModel in self.accountListArray)
            {
                if (selectModel.isSelected==YES)
                {
                    [accountList addObject:selectModel.relationModel];
                }
            }
            
            // !! 改為不秀訊息
//            if ([accountList count]==0)
//            {
//                isGoBack = NO;
//
//                //////////////////////////////////////////////////
//                __block typeof(self) blockSelf = self;
//                dispatch_async(dispatch_get_main_queue(), ^{
//
//                    UIAlertController *alertController = [UIAlertController alertControllerWithTitle:@""
//                                                                                             message:WCASVC_MLS_AccountNotSelected
//                                                                                      preferredStyle:UIAlertControllerStyleAlert];
//                    [alertController addAction:[UIAlertAction actionWithTitle:WCASVC_MLS_Confirm
//                                                                        style:UIAlertActionStyleDefault
//                                                                      handler:nil]];
//
//                    [blockSelf presentViewController:alertController animated:YES completion:nil];
//                });
//            }
//            else
            {
                [self.delegate searchAccountSelectViewController:self didFinishSelectAccounts:accountList];
            }
        }
    }
    
    //////////////////////////////////////////////////
    if (isGoBack==YES)
    {
        [self goBackAnimated:YES];
    }
}

@end
