//
//  ASVCSectionController.m
//  Pods
//
//  Created by AndrewLai on 2016/4/21.
//
//

#import "ASVCSectionController.h"

// Define
#import "WCTAccountSelectViewController+ResourceDefine.h"

////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark
#pragma mark - ASVCSectionController Extension

@interface ASVCSectionController ()

@property (nonatomic, retain) NSMutableArray *selectedGuidArray;
@property (nonatomic, retain) NSString *ownerGuid;

@end





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark
#pragma mark - ASVCSectionController Implementation

@implementation ASVCSectionController





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark
#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_sourceArray release];
    _sourceArray = nil;
    
    [_selectedGuidArray removeAllObjects];
    [_selectedGuidArray release];
    _selectedGuidArray = nil;
    
    [_ownerGuid release];
    _ownerGuid = nil;
    
    //////////////////////////////////////////////////
    [super dealloc];
}




////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark
#pragma mark - Instance Methods

//================================================================================
//
//================================================================================
- (void)fetchAccountListFromSourceArray:(NSArray *)sourceArray
                      selectedGuidArray:(NSArray *)selectedGuidArray
                              ownerGuid:(NSString *)ownerGuid
              sectionModelsForSearching:(BOOL)searching
{
    do
    {
        //!! 移除現在存在的資料
        [[self sectionModelsForSearching:searching] removeAllObjects];
        
        //////////////////////////////////////////////////
        self.sourceArray = sourceArray;
        self.selectedGuidArray = [NSMutableArray arrayWithArray:selectedGuidArray];//加快添加速度用途
        self.ownerGuid = ownerGuid;
        
        //////////////////////////////////////////////////
        PPSectionModel *sectionModel = [self listSectionModelForGeneral];
        if (sectionModel!=nil && sectionModel.rowModels.count>0)
        {
            [[self sectionModelsForSearching:searching] addObject:sectionModel];
        }
    } while (0);
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark
#pragma mark - SectionModel Methods

//================================================================================
//
//================================================================================
- (PPSectionModel *)listSectionModelForGeneral
{
    PPSectionModel *listSectionModel = [[PPSectionModel alloc] init];
    if (listSectionModel!=nil)
    {
        NSMutableArray *updateSourceArray = [NSMutableArray array];
        
        PPRowModel *bossRowModel  = nil;
        PPRowModel *ownerRowModel = nil;
        WCTAccountRelationModel *bossRelationModel  = nil;
        WCTAccountRelationModel *ownerRelationModel = nil;
        
        for (WCTAccountRelationModel *infoModel in self.sourceArray)
        {
            @autoreleasepool
            {
                //離職帳號，改變擁有者，分享給同事，切換檢視帳號，變換檢視帳號都不能選擇
                if(infoModel.isOutgoingEmployee==YES)
                {
                    continue;
                }
                else if(infoModel.isLimitedAccount==YES)
                {
                    // !! 暫停使用的用戶不顯示
                    continue;
                }
                else if (infoModel.relation==WCTAccountRelationModel_Relation_Boss)
                {
                    [bossRowModel release];
                    bossRowModel = [[PPRowModel rowModelWithRow:0
                                                           text:[infoModel.name stringByAppendingString:[NSString stringWithFormat:@"(%@)", WASVC_MLS_Boss]]
                                                     detailText:nil
                                                         object:[ASVCAccountSelectModel accountSelectModelWithAccountRole:ASVCAccountSelectModel_AccountRole_Boss
                                                                                                        shareContactCount:infoModel.shareContactCount
                                                                                                               isSelected:YES]] retain];
                    bossRelationModel = infoModel;
                }
                else if ([self.ownerGuid isEqualToString:infoModel.guid]==YES)
                {
                    [ownerRowModel release];
                    ownerRowModel = [[PPRowModel rowModelWithRow:0
                                                            text:[infoModel.name stringByAppendingString:[NSString stringWithFormat:@"(%@)", WASVC_MLS_Owner]]
                                                      detailText:nil
                                                          object:[ASVCAccountSelectModel accountSelectModelWithAccountRole:ASVCAccountSelectModel_AccountRole_Owner
                                                                                                         shareContactCount:infoModel.shareContactCount
                                                                                                                isSelected:YES]] retain];
                    ownerRelationModel = infoModel;
                }
                else
                {
                    BOOL isSelected = NO;
                    for (NSString *selectedGuid in self.selectedGuidArray)
                    {
                        if ([selectedGuid isEqualToString:infoModel.guid]==YES)
                        {
                            isSelected = YES;
                            [self.selectedGuidArray removeObject:selectedGuid];
                            
                            break;
                        }
                    }
                    
                    
                    PPRowModel *accountRowModel = [PPRowModel rowModelWithRow:0
                                                                         text:infoModel.name
                                                                   detailText:nil
                                                                       object:[ASVCAccountSelectModel accountSelectModelWithAccountRole:ASVCAccountSelectModel_AccountRole_Normal
                                                                                                                      shareContactCount:infoModel.shareContactCount
                                                                                                                             isSelected:isSelected]];
                    if (accountRowModel!=nil)
                    {
                        [listSectionModel.rowModels addObject:accountRowModel];
                        
                        [updateSourceArray addObject:infoModel];
                    }
                }
            }
        }
        
        //////////////////////////////////////////////////
        //!! 加入Boss帳號的RowModel
        if (bossRowModel!=nil)
        {
            [updateSourceArray insertObject:bossRelationModel atIndex:0];
            [listSectionModel.rowModels insertObject:bossRowModel atIndex:0];
            [bossRowModel release];
        }
        
        //////////////////////////////////////////////////
        //!! 加入Owner帳號的RowModel
        if (ownerRowModel!=nil)
        {
            [updateSourceArray insertObject:ownerRelationModel atIndex:0];
            [listSectionModel.rowModels insertObject:ownerRowModel atIndex:0];
            [ownerRowModel release];
        }
        
        self.sourceArray = updateSourceArray;
    }
    
    return [listSectionModel autorelease];
}

@end
