//
//  AIVCImageViewCustomCell.m
//  Pods
//
//  Created by AndrewLai on 2016/4/14.
//
//

#import "AIVCImageViewCustomCell.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - AIVCImageViewCustomCell Implementation

@implementation AIVCImageViewCustomCell





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark
#pragma mark - Creating, Copying, and Dellocating Objects

//================================================================================
//
//================================================================================
- (id)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier
{
    if (self = [super initWithStyle:style reuseIdentifier:reuseIdentifier])
    {
        _headImageView = [[UIImageView alloc] init];
        if (self.headImageView!=nil)
        {
            self.headImageView.clipsToBounds = YES;
            self.headImageView.contentMode   = UIViewContentModeScaleAspectFill;
            [self.contentView addSubview:self.headImageView];
        }
    }
    
    return self;
}


//================================================================================
//
//================================================================================
- (void)dealloc
{
    [self.headImageView removeFromSuperview];
    self.headImageView = nil;
    
    //////////////////////////////////////////////////
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Method

//================================================================================
//
//================================================================================
- (void)layoutSubviews
{
    [super layoutSubviews];
    
    //////////////////////////////////////////////////
    CGRect imageViewFrame   = CGRectZero;
    CGRect textLabelFrame   = self.textLabel.frame;
    CGRect detailLabelFrame = self.detailTextLabel.frame;

    if (self.headImageView.image!=nil)
    {
        imageViewFrame.origin.x    = self.contentInsets.left + AIVCImageViewCustomCellImageViewMargin.left;
        imageViewFrame.origin.y    = self.contentInsets.top + AIVCImageViewCustomCellImageViewMargin.top;
        imageViewFrame.size.width  = AIVCImageViewCustomCellImageViewSize.width;
        imageViewFrame.size.height = AIVCImageViewCustomCellImageViewSize.height;
        self.headImageView.frame   = imageViewFrame;
    }
    
    
    //////////////////////////////////////////////////
    if (self.style==UITableViewCellStyleSubtitle)
    {
        textLabelFrame.origin.x = imageViewFrame.origin.x+imageViewFrame.size.width+AIVCImageViewCustomCellImageViewMargin.right;
 
        detailLabelFrame.origin.x = imageViewFrame.origin.x+imageViewFrame.size.width+AIVCImageViewCustomCellImageViewMargin.right;
        
        textLabelFrame.size.width -= (imageViewFrame.size.width+self.contentInsets.right);
        detailLabelFrame.size.width -= (imageViewFrame.size.width+self.contentInsets.right);
    }
    else if (self.style==UITableViewCellStyleValue1)
    {
        textLabelFrame.origin.x = self.contentInsets.left + imageViewFrame.origin.x+imageViewFrame.size.width+AIVCImageViewCustomCellImageViewMargin.right;

        detailLabelFrame.origin.x += self.contentInsets.left + imageViewFrame.origin.x+imageViewFrame.size.width+AIVCImageViewCustomCellImageViewMargin.right;

        textLabelFrame.size.width -= (self.contentInsets.left + imageViewFrame.size.width+self.contentInsets.right)/2;
        detailLabelFrame.size.width -= (self.contentInsets.left + imageViewFrame.size.width+self.contentInsets.right)/2;
    }
    else
    {
        textLabelFrame.origin.x = self.contentInsets.left + imageViewFrame.origin.x+imageViewFrame.size.width+AIVCImageViewCustomCellImageViewMargin.right;
        
        textLabelFrame.size.width -= (self.contentInsets.left + imageViewFrame.size.width+self.contentInsets.right)/2;
    }
    
    self.textLabel.frame = textLabelFrame;
    self.detailTextLabel.frame = detailLabelFrame;

    //////////////////////////////////////////////////
    if (self.subType==AccountInfoSubType_ColleaguesRelationship_Boss || self.subType==AccountInfoSubType_ColleaguesRelationship_Subordinate)
    {
        self.separatorInset = UIEdgeInsetsMake(0, self.textLabel.frame.origin.x, 0, 0);
    }
}

@end
