//
//  WCTAccountFlowController.m
//  Pods
//
//  Created by AndrewLai on 2016/5/5.
//
//

#import "WCTAccountFlowController.h"

//Define
#import "WCTSettingsKey.h"
#import "WCTAccountFlowController+ResourceDefine.h"

//category
#import "NSError+Custom.h"
#import "WCTRestClientController+Password.h"
#import "NSObject+PPBusyView.h"

// model
#import "WCTAccountRelationModel.h"

//view
#import "PPAlertView.h"

//Controller
#import "PPNavigationController.h"
#import "PPNetworkReachabilityController.h"
#import "PPSettingsController.h"
#import "WCTAccountInfoViewController.h"
#import "WCTAFCUpdateInfoViewController.h"
#import "WCTPasswordViewController.h"
#import "WCToastController.h"

#import "WCTAccountDataController.h"
#import "WCTDataController.h"
#import "WCTRestClientController.h"

////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - WCTAccountFlowController Extension

@interface WCTAccountFlowController () <WCTAccountInfoViewControllerDelegate, WCTAFCUpdateInfoViewControllerDelegate, WCTPasswordViewControllerDelegate>

@property (nonatomic, retain) WCTAccountInfoViewController *accountInfoViewController;
@end

////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - WCTAccountFlowController Implementation

@implementation WCTAccountFlowController





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - init/dealloc methods


//==============================================================================
//
//==============================================================================
- (instancetype)init
{
    self = [super init];
    if (self)
    {
        
    }
    return self;
}


//==============================================================================
//
//==============================================================================
- (void)dealloc
{
    self.accountInfoViewController = nil;
    //////////////////////////////////////////////////
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Instance Method

//================================================================================
//
//================================================================================
- (void)showFromSuperViewController:(UIViewController *)superViewController
{
    self.accountInfoViewController = [[[WCTAccountInfoViewController alloc] init] autorelease];
    if (self.accountInfoViewController!=nil)
    {
        self.accountInfoViewController.delegate = self;
        
        PPNavigationController *ppNavigationController = [[PPNavigationController alloc] initWithRootViewController:self.accountInfoViewController];
        if (ppNavigationController!=nil)
        {
            [superViewController presentViewController:ppNavigationController animated:YES completion:nil];
            
            [ppNavigationController release];
        }
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - WCTAccountInfoViewControllerDelegate

//================================================================================
//
//================================================================================
- (void)accountInfoViewController:(WCTAccountInfoViewController *)accountInfoViewController didSelectAction:(WCTAccountInfoViewControllerAction)action
{
    __block typeof(self) blockSelf = self;
    
    dispatch_async(dispatch_get_main_queue(), ^{
        switch (action)
        {
            case WCTAccountInfoViewControllerAction_Account:
            {
                BOOL hasNetwork = [PPNetworkReachabilityController checkForInternetConnection];
                if (hasNetwork==YES)
                {
                    WCTAFCUpdateInfoViewController *updateInfoViewController = [[WCTAFCUpdateInfoViewController alloc] init];
                    if (updateInfoViewController!=nil)
                    {
                        updateInfoViewController.delegate = blockSelf;
                        
                        //////////////////////////////////////////////////
                        //抓出資料庫內使用者帳號名稱
                        NSString *accountGuid = [PPSettingsController stringValueWithKey:WCTSettingsKey_AccountGUID];
                        
                        
                        WCTDataController *dataController = [[WCTDataController alloc] initWithAccessMode:WCDC_AM_All];
                        if (dataController!=nil)
                        {
                            WCTAccountRelationModel *infoModel = [dataController accountRelationWithAcountGuid:accountGuid];

                            updateInfoViewController.accountName = infoModel.name;

                            [dataController release];
                        }

                        //////////////////////////////////////////////////
                        
                        [accountInfoViewController.navigationController pushViewController:updateInfoViewController animated:YES];
                        
                        [updateInfoViewController release];
                    }
                }
                else
                {
                    [WCToastController showMessageToastFromSuperView:accountInfoViewController.view
                                                         withMessage:WCTAFC_MLS_ChangeAccountErrorNetwork
                                                            position:PPToastPositionCenter];
                }
                
                break;
            }
            case WCTAccountInfoViewControllerAction_Back:
            {
                [accountInfoViewController goBackAnimated:YES];
                
                //////////////////////////////////////////////////
                if (self.delegate!=nil && [self.delegate respondsToSelector:@selector(accountFlowControllerWillDismissViewController:)]==YES)
                {
                    [self.delegate accountFlowControllerWillDismissViewController:self];
                }
                
                break;
            }
            case WCTAccountInfoViewControllerAction_Edit:
            {
                NSLog(@"Edit");
                break;
            }
            case WCTAccountInfoViewControllerAction_Logout:
            {
                [accountInfoViewController goBackAnimated:YES];
                
                //////////////////////////////////////////////////
                if (self.delegate!=nil && [self.delegate respondsToSelector:@selector(accountFlowControllerWillLogoutAccount:)]==YES)
                {
                    [self.delegate accountFlowControllerWillLogoutAccount:self];
                }
                
                break;
            }
            case WCTAccountInfoViewControllerAction_Template:
            {
                NSLog(@"Template");
                break;
            }
            default:
                break;
        }
    });
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - WCTAFCUpdateInfoViewControllerDelegate

//================================================================================
//
//================================================================================
- (void)updateInfoViewControllerDidSelectChangePassword:(WCTAFCUpdateInfoViewController *)updateInfoViewController
{
    __block typeof(self) blockSelf = self;
    
    dispatch_async(dispatch_get_main_queue(), ^{
//        NSLog(@"ChangePassword");
        
        if([WCTAccountDataController isADAccount])
        {
            [PPAlertView showWithStyle:UIAlertViewStyleDefault
                                 title:@""
                               message:WCTAFC_MLS_PasswordChangeForADAccount
                     cancelButtonTitle:WCTAFC_MLS_Ok
                     otherButtonTitles:nil];
        }
        else        
        {
            __block typeof(self) blockSelf = self;
            
            dispatch_async(dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_DEFAULT, 0), ^{
                
                BOOL isV6Server = ([WCTRestClientController shareRestClientController].serverVersionInfo.majorVersion>=6.0);
                
                //////////////////////////////////////////////////
                dispatch_async(dispatch_get_main_queue(), ^{
                    
                    WCTPasswordViewController *changePasswordViewController = [[WCTPasswordViewController alloc] init];
                    if(changePasswordViewController!=nil)
                    {
                        changePasswordViewController.passwordViewControllerStyle = WCTPasswordViewControllerStyle_ChangePassword;
                        changePasswordViewController.delegate = blockSelf;
                        changePasswordViewController.isV6Server = isV6Server;
                        
                        PPNavigationController *navigationController = [[PPNavigationController alloc] initWithRootViewController:changePasswordViewController];
                        if(navigationController!=nil)
                        {
                            [updateInfoViewController presentViewController:navigationController animated:YES completion:nil];
                            
                            [navigationController release];
                        }
                        
                        
                    }
                });
            });
            //////////////////////////////////////////////////

        }
    });
}


//================================================================================
// 更新使用者名稱 與更新至資料庫
//================================================================================
- (void)updateInfoViewController:(WCTAFCUpdateInfoViewController *)updateInfoViewController didSelectBackWithAccountName:(NSString *)accountName
{
    // !! 沒有修改不用做處理
    if([updateInfoViewController.accountName isEqualToString:accountName]==YES)
    {
        return ;
    }
    
    //////////////////////////////////////////////////
    if([PPNetworkReachabilityController checkForInternetConnection]==NO)
    {
        [PPAlertView showWithStyle:UIAlertViewStyleDefault
                             title:@""
                           message:WCTAFC_MLS_ChangeAccountErrorNetwork
                 cancelButtonTitle:[@"MLS_Ok" localized]
                 otherButtonTitles:nil];
        return ;
    }
    
    dispatch_after(dispatch_time(DISPATCH_TIME_NOW, (int64_t)(0.5 * NSEC_PER_SEC)), dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_DEFAULT, 0), ^{
        
        dispatch_async(dispatch_get_main_queue(), ^{
            
            [self.accountInfoViewController setBusy:@(YES)];
        });
             
        NSError *error = nil;
        [[WCTRestClientController shareRestClientController] changeDisplayName:accountName withError:&error];

        
        //////////////////////////////////////////////////
        dispatch_after(dispatch_time(DISPATCH_TIME_NOW, (int64_t)(0.5 * NSEC_PER_SEC)), dispatch_get_main_queue(), ^{

            
            if(error==nil)
            {
                // !! 更新accountInfoViewController中的資料，返回時才會更新為新的
                [self.accountInfoViewController reloadData];
            }
            
            [self.accountInfoViewController setBusy:@(NO)];

            //////////////////////////////////////////////////
            if(error)
            {
                NSString *errorMessage = nil;
                NSError *customError = PPErrorMake(WCTAccountFlowErrorCode_ChangeNameFailed, @"Failed to change name", error);
                if ([self.delegate respondsToSelector:@selector(accountFlowController:requestErrorMessageWithError:)])
                {
                    errorMessage = [self.delegate accountFlowController:self requestErrorMessageWithError:customError];
                }
                
                if([errorMessage length]>0)
                {
                    [PPAlertView showWithStyle:UIAlertViewStyleDefault
                                         title:@""
                                       message:errorMessage
                             cancelButtonTitle:[@"MLS_Ok" localized]
                             otherButtonTitles:nil];
                }
            }
            
        });
    });
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - WCTPasswordViewControllerDelegate


//==============================================================================
//
//==============================================================================
- (NSString *)passwordViewController:(WCTPasswordViewController *)passwordViewController
        requestErrorMessageWithError:(NSError *)error
{
    if ([self.delegate respondsToSelector:@selector(accountFlowController:requestErrorMessageWithError:)])
    {
        return [self.delegate accountFlowController:self requestErrorMessageWithError:error];
    }
    return nil;
}


//================================================================================
//
//================================================================================
- (void)passwordViewController:(WCTPasswordViewController *)passwordViewController didChangeWithNewPassword:(NSString *)newPassword
{
    [WCTRestClientController encryptAccountPasswordToUserDefault:newPassword];
    
    //////////////////////////////////////////////////
    [passwordViewController goBackAnimated:YES];
}

@end
