//
//  WCTAFCUpdateInfoSectionController.m
//  Pods
//
//  Created by AndrewLai on 2016/5/6.
//
//

#import "WCTAFCUpdateInfoSectionController.h"

//Define
#import "WCTAccountFlowController+ResourceDefine.h"

////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - WCTAFCUpdateInfoSectionController Implementation

@implementation WCTAFCUpdateInfoSectionController





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Private Method

//================================================================================
//
//================================================================================
- (PPSectionModel *)accountNameSectionModelWithAccountName:(NSString *)accountName
{
    PPSectionModel *accountNameSectionModel = nil;
    
    do
    {
        accountNameSectionModel = [[[PPSectionModel alloc] init] autorelease];
        if(accountNameSectionModel==nil)
        {
            break;
        }
        
        accountNameSectionModel.section = WCTAFCUpdateInfoSection_AccountName;
        accountNameSectionModel.title   = WCTAFC_MLS_AccountName;
        
        //////////////////////////////////////////////////
        PPRowModel *accountNameRowModel = [[[PPRowModel alloc] init] autorelease];
        if(accountNameRowModel==nil)
        {
            break;
        }
        
        accountNameRowModel.row    = WCTAFCUpdateInfoSectionAccountName_Row_AccountName;
        accountNameRowModel.object = accountName;
        [accountNameSectionModel.rowModels addObject:accountNameRowModel];
        
    }
    while (0);
    
    return accountNameSectionModel;
}


//================================================================================
//
//================================================================================
- (PPSectionModel *)passwordChangeSectionModel
{
    PPSectionModel *passwordChangeSectionModel = nil;
    
    do
    {
        passwordChangeSectionModel = [[[PPSectionModel alloc] init] autorelease];
        passwordChangeSectionModel.title = WCTAFC_MLS_Password;
        if(passwordChangeSectionModel==nil)
        {
            break;
        }
        
        passwordChangeSectionModel.section = WCTAFCUpdateInfoSection_PasswordChange;
        
        //////////////////////////////////////////////////
        PPRowModel *accountNameRowModel = [[[PPRowModel alloc] init] autorelease];
        if(accountNameRowModel==nil)
        {
            break;
        }
        
        accountNameRowModel.row    = WCTAFCUpdateInfoSectionPasswordChange_Row_PasswordChange;
        accountNameRowModel.object = WCTAFC_MLS_PasswordChange;
        [passwordChangeSectionModel.rowModels addObject:accountNameRowModel];
        
    }
    while (0);
    
    return passwordChangeSectionModel;
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Instance Method

//================================================================================
//
//================================================================================
- (void)prepareDataWithAccountName:(NSString *)accountName
{
    [[self sectionModelsForSearching:NO] removeAllObjects];
    
    //////////////////////////////////////////////////
    do
    {
        PPSectionModel *accountNameSectionModel = [self accountNameSectionModelWithAccountName:accountName];
        if (accountNameSectionModel==nil || accountNameSectionModel.rowModels.count<=0)
        {
            break;
        }
        
        [[self sectionModelsForSearching:NO] addObject:accountNameSectionModel];
        
        //////////////////////////////////////////////////
        PPSectionModel *passwordChangeSectionModel = [self passwordChangeSectionModel];
        if (passwordChangeSectionModel==nil || passwordChangeSectionModel.rowModels.count<=0)
        {
            break;
        }
        
        [[self sectionModelsForSearching:NO] addObject:passwordChangeSectionModel];
    }
    while (0);
}

@end
