//
//  WCTAccountDataController.h
//  WorldCardTeam
//
//  Created by sanhue on 2016/4/25.
//  Copyright © 2016年 penpower. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "WCDisplayNameDefine.h"
#import "WCFieldDefine.h"
#import "WCTDataController.h"

extern NSString * const WCTAccountDataController_SettingsKey_SettingsModifiedTime;


typedef void(^CompleteHandler)(BOOL hasNetwork);

////////////////////////////////////////////////////////////////////////////////////////////////////
@interface WCTAccountDataController : NSObject

////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Account list methods

/**
 *  (sync api)在有網路的狀態下，從server上取得新的聯絡人清單與使用者關係
 *
 *  @param error 錯誤回報
 *
 *  @return 回傳帳號關係清單
 */
+ (NSArray *)allAccountListWithError:(NSError **)error;



/**
 *  (sync api)如果有網路的話，從server上取得新的聯絡人清單與使用者關係，並更新到local
 *
 *  @param completeHandler 回傳結果，
 *  @param allAccountList 所有帳號列表
 *  @param error 錯誤回報
 *  @return YES，成功, else 失敗
 */
+ (BOOL)updateAccountListFromServerWithCompleteHandler:(void(^)(NSArray *allAccountList, NSError *error))completeHandler;

/**
 * 取得此帳號所在的server的帳號數, 只會包含可用的帳號(active, inactive，且不包含暫停用戶)
 * @param error 錯誤回報
 * @return 帳號數，沒有error時，才會有正確的值，有error時會回傳0
 */
+ (NSInteger)numberOfAccountWithError:(NSError **)error;

////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark Account info methods

/**
 *  (sync api)如果有網路的話，從server上取得使用者資訊，並更新到local
 *
 *  @param completeHandler 完成動作後的通知
 */
+ (void)updateAccountInfoFromServerWithCompleteHandler:(CompleteHandler)completeHandler;

/**
 * 取得目前登入帳號是否AD帳號
 * @return BOOL YES，if is AD account
 */
+ (BOOL)isADAccount;

////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - display settings methods

/**
 * (async api)如果有網路的話，從server上取得全公司共享的設定值，並更新到local
 * @param completeHandler 完成動作後，回傳是否為全全司共享
 */
+ (void)fetchGlobalShareRuleWithCompleteHandler:(void(^)(BOOL shareToCompany))completeHandler;


/**
 * (async api)如果有網路的話，從server上取得新的設定值，並更新到local
 * @param completeHandler 完成動作後的通知
 */
+ (void)updateSettingsFromServerWithCompleteHandler:(CompleteHandler)completeHandler;


/**
 * (sync api)如果有網路的話，寫入設定值，沒有的話回傳錯誤
 * @param easternNameOrder 姓名順序
 * @param completeHandler 完成動作後的通知
 */
+ (BOOL)setEasternNameOrder:(WCDisplayNameOrder)easternNameOrder withCompleteHandler:(void(^)(NSError *error, BOOL hasNetwork))completeHandler;


/**
 * (sync api)如果有網路的話，寫入設定值，沒有的話回傳錯誤
 * @param westernNameOrder 姓名順序
 * @param completeHandler 完成動作後的通知
 */
+ (BOOL)setWesternNameOrder:(WCDisplayNameOrder)westernNameOrder withCompleteHandler:(void(^)(NSError *error, BOOL hasNetwork))completeHandler;


/**
 * (sync api)如果有網路的話，寫入設定值，沒有的話回傳錯誤
 * @param autoShare 自動分享設定
 * @param completeHandler 完成動作後的通知
 */
+ (BOOL)setAutoShare:(BOOL)autoShare withCompleteHandler:(void(^)(NSError *error, BOOL hasNetwork))completeHandler;


/**
 * (sync api)如果有網路的話，寫入設定值，沒有的話回傳錯誤
 * @param shareContatToAccountGuids 目前的自動分享列表
 * @param completeHandler 完成動作後的通知
 */
+ (BOOL)setShareContatToAccountGuids:(NSArray *)shareContatToAccountGuids withCompleteHandler:(void(^)(NSError *error, BOOL hasNetwork))completeHandler;


/**
 * (sync api)如果有網路的話，寫入設定值，沒有的話回傳錯誤
 * @param shareContatToAccountGuids 目前的自動分享列表
 * @param item WCRC_ShareItem
 * @param completeHandler 完成動作後的通知
 */
+ (BOOL)setShareAccountGuids:(NSArray *)shareContatToAccountGuids withItem:(NSString *)item completeHandler:(void(^)(NSError *error, BOOL hasNetwork))completeHandler;


/**
 * (sync api)如果有網路的話，寫入設定值，沒有的話回傳錯誤
 * @param chineseRecognizeOutput 中文辨識結果輸出
 * @param completeHandler 完成動作後的通知
 */
+ (BOOL)setChineseRecognizeOutput:(NSInteger)chineseRecognizeOutput withCompleteHandler:(void(^)(NSError *error, BOOL hasNetwork))completeHandler;


/**
 * (sync api)如果有網路的話，寫入設定值，沒有的話回傳錯誤
 * @param userMapEngine 地圖顯示引擎
 * @param completeHandler 完成動作後的通知
 */
+ (BOOL)setUserMapEngine:(NSInteger)userMapEngine withCompleteHandler:(void(^)(NSError *error, BOOL hasNetwork))completeHandler;


/**
 * (sync api)如果有網路的話，寫入設定值，沒有的話回傳錯誤
 * @param sortByField 依欄位排序
 * @param completeHandler 完成動作後的通知
 */
+ (BOOL)setSortByField:(WC_SortedByField)sortByField withCompleteHandler:(void(^)(NSError *error, BOOL hasNetwork))completeHandler;


/**
 * (sync api)如果有網路的話，寫入設定值，沒有的話回傳錯誤
 * @param editAfterRecog 辨識後進入編輯
 * @param completeHandler 完成動作後的通知
 */
+ (BOOL)setEditAfterRecog:(BOOL)editAfterRecog withCompleteHandler:(void(^)(NSError *error, BOOL hasNetwork))completeHandler;


/**
 * (sync api)如果有網路的話，寫入設定值，沒有的話回傳錯誤
 * @param addNoteAfterRecog 辨識後進入備註
 * @param completeHandler 完成動作後的通知
 */

+ (BOOL)setAddNoteAfterRecog:(BOOL)addNoteAfterRecog withCompleteHandler:(void(^)(NSError *error, BOOL hasNetwork))completeHandler;


/**
 * (sync api)如果有網路的話，寫入設定值，沒有的話回傳錯誤
 * @param exportMode CRMExportMode, WCTRC_CRMExportMode_ContactSyncAuto, WCTRC_CRMExportMode_Manual
 * @param companyAssignmentOption WCTRC_CRMCompanyAssignmentOption_Manul, WCTRC_CRMCompanyAssignmentOption_Auto,WCTRC_CRMCompanyAssignmentOption_None
 * @param completeHandler 完成動作後的通知
 */
+ (BOOL)setCRMExportMode:(NSString *)exportMode
 companyAssignmentOption:(NSString *)companyAssignmentOption
     withCompleteHandler:(void(^)(NSError *error, BOOL hasNetwork))completeHandler;


/**
 * (sync api)如果有網路的話，寫入設定值，沒有的話回傳錯誤
 * @param exportMode CRMExportMode, WCTRC_CRMExportMode_ContactSyncAuto, WCTRC_CRMExportMode_Manual
 * @param completeHandler 完成動作後的通知
 */
+ (BOOL)setExchangeExportMode:(NSString *)exportMode withCompleteHandler:(void(^)(NSError *error, BOOL hasNetwork))completeHandler;


/**
 * (sync api)如果有網路的話，寫入設定值，沒有的話回傳錯誤
 * @param exportMode WCTRC_ExportMode_ContactSyncAuto, WCTRC_ExportMode_Manual, WCTRC_ExportMode_Auto
 * @param completeHandler 完成動作後的通知
 */
+ (BOOL)setQcontactzExportMode:(NSString *)exportMode withCompleteHandler:(void(^)(NSError *error, BOOL hasNetwork))completeHandler;


////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - get system category methods

/**
 * (sync api)如果有網路的話，從server上取得system category guid，並更新到local
 * @param completeHandler 完成動作後的通知
 */
+ (BOOL)fetchSystemCategoryGuidsWithCompleteHandler:(void(^)(BOOL success, NSString *categoryGuid_All, NSString *categoryGuid_Other, NSString *categoryGuid_Favorites))completeHandler;



////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - custom field methods


/**
 * (sync api) 如果有網路的話，從server上取得Custom field info，並更新到local
 * @param completeHandler 完成動作後的通知
 * @return BOOL <#or add return description here#>
 */
+ (BOOL)fetchSystemCustomFieldInfosWithCompleteHandler:(void(^)(BOOL success, BOOL hasNetwork))completeHandler;



////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - load all data



/**
 * (sync api)如果有網路的話，從server上取得所有需要的資料，儲存到local
 * @param willStartHandler 動作開始前的通知
 * @param completeHandler 完成動作後的通知
 */
+ (void)updateSettingsFromServerWithWillStartHandler:(CompleteHandler)willStartHandler
                                     CompleteHandler:(CompleteHandler)completeHandler;


/**
 * (sync api)如果有網路的話，從server上取得所有需要的資料，儲存到local
 * @param completeHandler 完成動作後的通知
 */
+ (void)updateAllDataFromServerWithCompleteHandler:(void(^)(BOOL hasNetwork, NSError *error))completeHandler;






////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - display string
/**
 * 回傳可檢視用戶的顯示字串
 * @param visibleAccountGuids array of shared account guid
 * @param ownerGuid guid of owner
 * @return NSString 可檢視用戶的顯示字串, 無法顯示會回傳空字串
 */
+ (NSString *)displayStringForVisibleAccountGuids:(NSArray *)visibleAccountGuids ownerGuid:(NSString *)ownerGuid;





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - reset methods
/**
 * 登出時需呼叫這個API來重設設定的變更時間
 */
+ (void)resetSetttingsModifiedTime;



////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - get personal category methods

/**
 1.3.0後，category資料改由server下載。

 @param accountGuid 要下載的帳號guid
 @param dataController 使用的dataController
 @param isHelpScanningMode 是否為幫助掃描模式
 @param completeHandler 完成動作後的通知
 */
+ (void)updateCategoriesFromServerWithAccountGuid:(NSString *)accountGuid
                                   dataController:(WCTDataController *)dataController
                               isHelpScanningMode:(BOOL)isHelpScanningMode
                                  completeHandler:(void(^)(NSError *error, BOOL hasRemovedGroup, BOOL hasRemovedNonEmptyCardsGroup))completeHandler;

/**
 * 與 |updateCategoriesFromServerWithAccountGuid: dataController: isHelpScanningMode: completeHandler:|一樣功能，
 * accountGuid會用 [PPSettingsController stringValueWithKey:WCTSettingsKey_AccountGUID];
 * dataController會用 [[WCTDataController alloc] initWithAccessMode:WCDC_AM_Text];
 * isHelpScanningMode會用 NO
 * @param completeHandler 完成動作後的通知
 */
+ (void)updateCategoriesFromServerWithCompleteHandler:(void(^)(NSError *error))completeHandler;



////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - handle unsync categories methods
/**
 * 升到1.3.0後，可能有一些還沒同步的category,需要在下載server category之前先同步上去，不然這邊變動會無效
 * !!需在updatePersonalCategoriesWithCompleteHandler之前使用
 */
+ (void)handleUnsyncCategoriesToServer;

@end
