//
//  WCRecognitionFieldModel.m
//
//
//  Created by Howard.Lin on 13/12/10.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "WCRecognitionFieldModel.h"

@interface WCRecognitionFieldModel()

@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation WCRecognitionFieldModel

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Synthesize

@synthesize
 fieldMainType                          = fieldMainType_,
 fieldLabelType                         = fieldLabelType_,
 fieldSource                            = fieldSource_,
 fieldOrder                             = fieldOrder_,
 recognitionContextModelDictionary      = recognitionContextModelDictionary_;





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Dellocating Object

//===============================================================================
//
//===============================================================================
- (id)init
{
    if(self=[super init])
    {
        fieldMainType_  = WCRecognitionFieldMainType_None;
        fieldLabelType_ = WCRecognitionFieldLabelType_None;
        recognitionContextModelDictionary_  = [[NSMutableDictionary alloc] init];
    }
    
    return self;
}


//===============================================================================
//
//===============================================================================
- (void)dealloc
{
    [recognitionContextModelDictionary_ removeAllObjects];
    [recognitionContextModelDictionary_ release];
    recognitionContextModelDictionary_ = nil;
    
    ////////////////////////////////////////////////////////////
    
    [super dealloc];
}




////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Method

//===============================================================================
//
//===============================================================================
- (NSString *)description
{
    NSMutableString *totalContextModelDescription = [NSMutableString stringWithFormat:@""];
   
    for (id key in self.recognitionContextModelDictionary.allKeys)
    {
        @autoreleasepool
        {
            WCRecognitionContextModel *contextModel = [self.recognitionContextModelDictionary objectForKey:key];
            
            NSString *contextModelDescription = [contextModel description];
            
            [totalContextModelDescription appendFormat:@"%@\n",contextModelDescription];
        }
    }
    
    return [NSString stringWithFormat:@"%@{fieldOrder:%tu fieldSource:%tu fieldMainType:%tu fieldLabelType:%tu, totalContextModelDescription:%@}",
            [super description],
            self.fieldOrder,
            self.fieldSource,
            self.fieldMainType,
            self.fieldLabelType,
            totalContextModelDescription];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

//===============================================================================
//
//===============================================================================
- (BOOL)validRecognitionFieldModel
{
    if(self.recognitionContextModelDictionary.count>0)
    {
        return YES;
    }
    else
    {
        return NO;
    }
}


//===============================================================================
//
//===============================================================================
- (NSNumber *)keyForWCRecognitionFieldSubType:(WCRecognitionFieldSubType)subType
{
    return [NSNumber numberWithUnsignedInteger:subType];
}


//===============================================================================
//
//===============================================================================
- (void)setWCRecognitionContextModel:(WCRecognitionContextModel *)recognitionContextModel
        forWCRecognitionFieldSubType:(WCRecognitionFieldSubType)subType
{
    recognitionContextModel.recognitionFieldSubType = subType;
    
    [self.recognitionContextModelDictionary setObject:recognitionContextModel forKey:[self keyForWCRecognitionFieldSubType:subType]];
}


//===============================================================================
//
//===============================================================================
- (WCRecognitionContextModel *)recognitionContextModelForWCRecognitionFieldSubType:(WCRecognitionFieldSubType)subType
{
    return [self.recognitionContextModelDictionary objectForKey:[self keyForWCRecognitionFieldSubType:subType]];
}

@end
