//
//  WCNewCardFlowDatasource.h
//  Pods
//
//  Created by Howard on 2015/7/23.
//
//

#ifndef Pods_WCNewCardFlowDatasource_h
#define Pods_WCNewCardFlowDatasource_h

#import "WCDisplayNameDefine.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

@protocol WCNewCardFlowDatasource <NSObject>

@required

- (WCDisplayNameOrder)displayNameOrderWithEasternName:(BOOL)isEasternName;

/**
 *  取得辨識語系模型集合
 *  用來呈現辨識語系列表
 *
 *  @return The recognition languages array of WCKernelRecogLanModels
 */
- (NSArray *)newCardFlowRequestRecogLangModels;


/**
 *  取得辨識欄位的模型集合
 *
 *  @return The recognition types array of WCKernelRecogFieldTypes
 */
- (NSArray *)newCardFlowRecognizeFieldTypes;


/**
 * 取得讀音候還列表
 *
 * @param phonetic 目前的讀音
 * @param sourceValue 用來查詢的原文
 * @param isCompanyPhonetic 是否公司讀音
 *
 * @return The phonetic array of NSString
 */
- (NSMutableArray *)newCardFlowRequestPhoneticArrayWithClickedPhonetic:(NSString *)phonetic
                                                           sourceValue:(NSString *)sourceValue
                                                     isCompanyPhonetic:(BOOL)isCompanyPhonetic;


@optional
/**
 *  取得儲存前是否先編輯Note的設定
 *
 *  @return YES, if it need to edit note before save;
 */
- (BOOL)shouldEditNoteBeforeSave;

/**
 *  取得是否顯示編輯頁面
 *
 *  @return YES,  if it need to enter edit view before save
 */
- (BOOL)shouldShowEditViewBeforeSave;

/**
 *  目前是否在新增我的名片
 *
 *  @return YES,  if we are adding MyCard，defualt NO;
 */
- (BOOL)isAddingMyCard;

@end

#endif
