//
//  NCFCBaseFlowController.h
//
//  NOTE
//  --------------------------------------------------
//  1. 所有可以繼承的、外部可使用的property/method都放在這裡。
//  2. 所有可以繼承的、僅供內部使用的property/method放在NCFCBaseFlowController+Private。
//


#import <Foundation/Foundation.h>
#import "WCNewCardFlowDatasource.h"
#import "WCNewCardFlowDelegate.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface NCFCBaseFlowController : NSObject

/// datasource
@property (nonatomic,assign) id<WCNewCardFlowDatasource> datasource;

/// delegate
@property (nonatomic,assign) id<WCNewCardFlowDelegate> delegate;

/// super view controller
@property (nonatomic,retain) UIViewController *superViewController;

// first view Controller (ex captureViewController, albumViewController etc)
@property (nonatomic,assign) UIViewController *firstViewController;

/// 最多新增數量，-1代表無限制。
@property (nonatomic,assign) NSInteger maxNewCardCount;

/// current added card count
@property (nonatomic,assign) NSUInteger curNewCardCount;

// 新增圖片尺寸
@property (nonatomic,assign) CGSize     defaultImageSize;

// 儲存圖片品質
@property (nonatomic,assign) CGFloat    imageQuality;

@property (atomic,retain) NSError *lastError;

/// 到達上限的alert是否顯示"馬上訂閱", default NO
@property (nonatomic,assign) BOOL showSubscribeWhenReachMaxCount;

/// 幫同事掃描的對象，只有在mode是WCNewCardFlowController_Mode_HelpScan時才用得到
@property (nonatomic, retain) NSString *helpScanTargetAccountName;

/// start flow
- (void)start;

@end
