//
//  NCFCAlbumFlowController.m
//

#import "NCFCAlbumFlowController.h"
#import <AssetsLibrary/AssetsLibrary.h>

// Define
#import "WCAppearanceDefine.h"
#import "WCNewCardFlowController+ParameterDefine.h"
#import "WCNewCardFlowController+SettingsKey.h"
#import "WCCaptureViewController+SettingsKey.h"
#import "NCFCBaseFlowController+Private.h"
#import "WCNewCardFlowController+ResourceDefine.h"
#import "WCAlbumFlowController+ParameterDefine.h"

// Model
#import "WCKernelRecogLangModel.h"
#import "PPProgressModel.h"

// Controller
#import "PPAlbumViewController.h"
#import "PPNavigationController.h"
#import "PPSettingsController.h"
#import "PPLogController.h"
#import "WCAlbumFlowController.h"

// Category
#import "NSError+Custom.h"
#import "NSString+Additions.h"



////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Interface 

@interface NCFCAlbumFlowController() <WCAlbumFlowControllerDatasource,WCAlbumFlowControllerDelegate>

@property (nonatomic,retain) WCAlbumFlowController *albumFlowController;


@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation NCFCAlbumFlowController

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Dellocating Object

//================================================================================
//
//================================================================================
- (id)init
{
    if(self=[super init])
    {
        [[PPAlbumViewController appearance] setNavigationBarViewButtonImageEdgeInset:WCAppearanceDefine_ButtonImageEdgeInset];
        [[PPAlbumViewController appearance] setNavigationBarViewButtonHighlightedBackgroundColor:WCAppearanceDefine_ButtonBackgroundColor];;
    }
    
    return self;
}


//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_albumFlowController release];
    _albumFlowController = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Method

//================================================================================
//
//================================================================================
- (void)start
{
    self.curNewCardCount = [[CardRecognitionController shareRecognitionInstance] silentRecognitionCount];
    
    //////////////////////////////////////////////////
    
    self.albumFlowController = [[[WCAlbumFlowController alloc] init] autorelease];
    
    if(self.albumFlowController!=nil)
    {
#if defined (PRODUCTLINE_WCSF) ||defined (PRODUCTLINE_WCO365)
        self.albumFlowController.showSubscribeWhenReachMaxCount = YES;
#endif
        self.albumFlowController.maxAddedCardCount = self.maxNewCardCount;
        self.albumFlowController.curAddedCardCount = self.curNewCardCount;
        [self.albumFlowController presentNewImageViewControllerFromSuperViewController:self.superViewController
                                                         albumFlowControllerDatasource:self
                                                           albumFlowControllerDelegate:self];
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - WCAlbumFlowController Delegate Method

//================================================================================
//
//================================================================================
- (void)albumFlowController:(WCAlbumFlowController *)albumFlowController didFinishSelectImage:(UIImage *)image
{
    // DO nothing，不會跑到這
}


//================================================================================
//
//================================================================================
- (void)albumFlowController:(WCAlbumFlowController *)albumFlowController didFinishAssetImageDictionary:(NSMutableDictionary *)assetImageDictionary recogLanguageTitle:(NSString *)recogLanguageTitle fromViewContrller:(UIViewController *)viewContrller
{
    if(assetImageDictionary.count>1)
    {
        __block typeof(self) blockself = self;
        
        __block PPBusyView *busyView = [[PPBusyView alloc] initWithSuperView:[[UIApplication sharedApplication] keyWindow]];
        
        dispatch_async(dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_DEFAULT, 0), ^(void)
                       {
                           PPProgressModel *progressModel = [[PPProgressModel alloc] init];
                           
                           if(progressModel!=nil)
                           {
                               progressModel.denominator = assetImageDictionary.count;
                           }
                           
                           //////////////////////////////////////////////////
                           
                           float updateProgress = 0;
                           
                           //////////////////////////////////////////////////
                           
                           [PPBusyView postMessage:@"0%"];
                           
                           //////////////////////////////////////////////////
                           
                           // MARK 多張辨識
                           for(id key in assetImageDictionary)
                           {
                               @autoreleasepool
                               {
                                   PHAsset *asset = [assetImageDictionary objectForKey:key];
                                   
                                   if(asset==nil)
                                   {
                                       break;
                                   }
                                   
                                   //////////////////////////////////////////////////
                                   
                                   NSString *cardID = [NSString GUID];
                                   
                                   //////////////////////////////////////////////////
                                   
                                   //取圖資訊
                                   WCRecogSourceModel *recogSourceModel = [blockself nextRecogSourceModelWithCardID:cardID imageType:WC_IT_FrontSide addMode:WCRecogSourceModelAddMode_Album];
                                   
                                   if(recogSourceModel==nil)
                                   {
                                       break;
                                   }
                                   
                                   //////////////////////////////////////////////////

                                   recogSourceModel.imageSource = asset;
                                   
                                   //////////////////////////////////////////////////
                                   
                                   //辨識語系
                                   recogSourceModel.recogLang = [self requestRecogLangCodeWithRecogLangauge:recogLanguageTitle];
    
                                   //////////////////////////////////////////////////

                                   //!! 選擇圖片多張辨識，設定255，強制核心旋轉
                                   recogSourceModel.rotateDegree = 255;
                                   
                                   //////////////////////////////////////////////////
                                   
                                   [blockself.recogSourceModels addObject:recogSourceModel];
                                   
                                   //////////////////////////////////////////////////
                                   
                                   if(progressModel!=nil)
                                   {
                                       progressModel.numerator++;
                                       
                                       //不要每次一直丟
                                       if([progressModel progress]>(updateProgress+0.01) || progressModel.progress==1)
                                       {
                                           updateProgress = [progressModel progress];
                                           
                                           [PPBusyView postMessage:[NSString stringWithFormat:@"%d%%", (int)(progressModel.progress*100)]];
                                       }
                                   }
                                   
                                   // autorelease pool
                               }
                               //for loop
                           }
                           
                           //////////////////////////////////////////////////
                           
                           [progressModel release];
                           progressModel = nil;
                           
                           //////////////////////////////////////////////////
                           
                           dispatch_async(dispatch_get_main_queue(), ^{
                               
                               [busyView removeFromSuperview];
                               [busyView release];
                               
                               //////////////////////////////////////////////////
                               
                               [PPSettingsController setIntegerValue:[self requestRecogLangCodeWithRecogLangauge:recogLanguageTitle]
                                                             withKey:WCNewCardFlowController_SettingsKey_FrontCardRecogLanguage];
                               
                               //////////////////////////////////////////////////
                               
                               [blockself prepareRecogsourceModelsToRecognitionProgressWithAddCardMode:WCNewCardFlowControllerAddCardMode_Multi
                                                                                    fromViewController:viewContrller];
                           });
                       });
    }
    else
    {
        do
        {
            PHAsset *asset = [assetImageDictionary objectForKey:[[assetImageDictionary allKeys] firstObject]];
            
            if(asset==nil)
            {
                break;
            }
            
            //////////////////////////////////////////////////
            
            NSString *cardID = [NSString GUID];
            
            //////////////////////////////////////////////////
            
            //取圖資訊
            WCRecogSourceModel *recogSourceModel = [self nextRecogSourceModelWithCardID:cardID imageType:WC_IT_FrontSide addMode:WCRecogSourceModelAddMode_Album];
            
            if(recogSourceModel==nil)
            {
                break;
            }

            recogSourceModel.recogLang = [self requestRecogLangCodeWithRecogLangauge:recogLanguageTitle];
            
            //////////////////////////////////////////////////
            
            recogSourceModel.imageSource = asset;

            //////////////////////////////////////////////////
            
            if(recogSourceModel.imageType==WC_IT_BackSide)
            {
                [PPSettingsController setIntegerValue:recogSourceModel.recogLang
                                              withKey:WCNewCardFlowController_SettingsKey_RearCardRecogLanguage];
            }
            else if(recogSourceModel.imageType==WC_IT_FrontSide)
            {
                [PPSettingsController setIntegerValue:recogSourceModel.recogLang
                                              withKey:WCNewCardFlowController_SettingsKey_FrontCardRecogLanguage];
            }
            
            //////////////////////////////////////////////////
            
            PPLogFunction(@" %s, recogSourceModel.CardID:%@, recogSourceModel.imageType:%td",__func__,recogSourceModel.cardID,recogSourceModel.imageType);
            
            //////////////////////////////////////////////////

            //強制設定255, 讓核心判斷圖片要不要旋轉
            recogSourceModel.rotateDegree = 255;

            //////////////////////////////////////////////////

            [self.recogSourceModels addObject:recogSourceModel];
            
            //////////////////////////////////////////////////
            
            [PPSettingsController setIntegerValue:[self requestRecogLangCodeWithRecogLangauge:recogLanguageTitle]
                                          withKey:WCNewCardFlowController_SettingsKey_FrontCardRecogLanguage];
            
            //////////////////////////////////////////////////
            
            [self prepareRecogsourceModelsToRecognitionProgressWithAddCardMode:WCNewCardFlowControllerAddCardMode_Single
                                                            fromViewController:viewContrller];
        }
        while (0);
    }
}


//================================================================================
//
//================================================================================
- (void)albumFlowControllerDidFinish:(WCAlbumFlowController *)albumFlowController
{
    self.albumFlowController = nil;
    
    //////////////////////////////////////////////////

    [self didFinishWithError:nil];
}


//==============================================================================
//
//==============================================================================
- (void)albumFlowControllerDidFinishWithSubscribeNow:(WCAlbumFlowController *)albumFlowController
{
    self.albumFlowController = nil;
    
    //////////////////////////////////////////////////
    NSError *error = PPErrorMake(WCNewCardFlow_Error_SubscribeNow, @"馬上訂閱", nil);
    [self didFinishWithError:error];
}



//================================================================================
//
//================================================================================
- (BOOL)albumFlowRequestShowError:(NSError *)error
{
    return YES;
}


//================================================================================
//
//================================================================================
- (NSString *)albumFlowRequestTitleWithError:(NSError *)error
{
    NSString *customTitle = nil;
    
    if(error.code==WCAlbumFlowControllerErrorCode_ReachMaximumCount)
    {
        customTitle = WCNCFC_MLS_FailedToNewCard;
    }
    
    return customTitle;
}


//================================================================================
//
//================================================================================
- (NSString *)albumFlowRequestMessageWithError:(NSError *)error
{
    NSString *customMessage = [self requestMessageWithError:error];
    
    if (customMessage==nil)
    {
        if(error.code==WCAlbumFlowControllerErrorCode_ReachMaximumCount)
        {
            customMessage = WCNCFC_MLS_ReachMaxNewCardCount;
        }
        else if(error.code==WCAlbumFlowControllerErrorCode_NonImageSelect)
        {
            customMessage = WCNCFC_MLS_NoImageSelect;
        }
        else
        {
            customMessage = error.localizedFailureReason;
        }
    }
    
    return customMessage;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - WCAlbumFlowController Datasource Method

//================================================================================
//
//================================================================================
- (NSString *)frontCardRecognitionTitle
{
    return [self recogTitleWithRecogLangCode:[PPSettingsController integerValueWithKey:WCNewCardFlowController_SettingsKey_FrontCardRecogLanguage]];
}


//================================================================================
//
//================================================================================
- (NSArray *)recognitionLanguageTitleArrayWithCurRecognitionLanguageTitle:(NSString *)curRecognitionLanguageTitle
{
    return [self recogLangTitlesWithSelectedTitle:curRecognitionLanguageTitle];
}
@end
