//
//  WCMapAnnotation.m
//  
//
//  Created by Howard on 2015/12/30.
//
//

#import "WCMapAnnotation.h"

// Define
#import "WCMapViewController+ResourceDefine.h"

// Controller
#import "PPLocationController.h"

// Model
#import "WCCardModel.h"

@implementation WCMapAnnotation

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Dellocating object

//================================================================================
//
//================================================================================
- (id)init
{
    if(self=[super init])
    {
        _cardModels = [[NSMutableArray alloc] init];
    }
    
    return self;
}


//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_cardModels release];
    _cardModels = nil;
    
    [_centerLocation release];
    _centerLocation = nil;
    
    //////////////////////////////////////////////////

    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private Method

//================================================================================
//
//================================================================================
- (WCCardModel *)firstCardModel
{
    return [self.cardModels firstObject];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - MKAnnotation Method

//================================================================================
//
//================================================================================
- (CLLocationCoordinate2D)coordinate
{
    CLLocationCoordinate2D defaultCoordinate = CLLocationCoordinate2DMake(0, 0);
    
    if(self.centerLocation!=nil)
    {
        defaultCoordinate = self.centerLocation.coordinate;
    }
    
    return defaultCoordinate;
}


//================================================================================
//
//================================================================================
- (NSString *)title
{
    NSString *displayTitle = nil;
    
    do
    {
        WCCardModel *cardModel = [self firstCardModel];
        
        if(cardModel==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        displayTitle = cardModel.displayName;
        
        if([displayTitle length]<=0)
        {
            displayTitle = WCMV_MLS_NoName;
        }
    }
    while (0);
    
    return displayTitle;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

//================================================================================
//
//================================================================================
- (BOOL)sameCompare:(WCMapAnnotation *)mapAnnotation
{
    BOOL result = NO;
    
    do
    {
        if(mapAnnotation==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////

        if([self currentCardID]!=[mapAnnotation currentCardID])
        {
            break;
        }
        
        //////////////////////////////////////////////////

        if([[self cardModels] count]!=[[mapAnnotation cardModels] count])
        {
            break;
        }
        
        //////////////////////////////////////////////////

        if([self title]!=[mapAnnotation title])
        {
            break;
        }
        
        //////////////////////////////////////////////////

        if([self coordinate].latitude!=[mapAnnotation coordinate].latitude ||
           [self coordinate].longitude!=[mapAnnotation coordinate].longitude)
        {
            break;
        }
        
        //////////////////////////////////////////////////

        // cardModels 的順序不考慮, 
        result = YES;
    }
    while (0);
    
    return result;
}


//================================================================================
//
//================================================================================
- (void)updateContentWithAnnotaiton:(WCMapAnnotation *)mapAnnotation
{
    [self.cardModels removeAllObjects];
    [self.cardModels addObjectsFromArray:mapAnnotation.cardModels];
    
    self.centerLocation = mapAnnotation.centerLocation;
}




//================================================================================
//
//================================================================================
- (BOOL)multiCardIDs
{
    if([[self cardModels] count]>1)
    {
        return YES;
    }
    else
    {
        return NO;
    }
}


//================================================================================
//
//================================================================================
- (NSInteger)isCardIDExist:(NSString *)cardID
{
    NSInteger index = NSNotFound;
    
    do
    {
        if([cardID length]<=0)
        {
            break;
        }
        
        //////////////////////////////////////////////////

        for(WCCardModel *cardModel in self.cardModels)
        {
            if([cardModel.ID compare:cardID]==NSOrderedSame)
            {
                index = [self.cardModels indexOfObject:cardModel];
                
                break;
            }
        }
    }
    while (0);
    
    return index;
}


//================================================================================
//
//================================================================================
- (void)bringFirstWithCardID:(NSString *)cardID
{
    do
    {
        NSInteger index = [self isCardIDExist:cardID];
        
        if(index==NSNotFound)
        {
            break;
        }
        
        //////////////////////////////////////////////////

        [self.cardModels exchangeObjectAtIndex:0 withObjectAtIndex:index];
    }
    while (0);
}


//================================================================================
//
//================================================================================
- (NSString *)currentCardID
{
    WCCardModel *cardModel = [self firstCardModel];
    
    if(cardModel!=nil)
    {
        return cardModel.ID;
    }
    else
    {
        return nil;
    }
}


//================================================================================
//
//================================================================================
- (NSMutableDictionary *)displayTitlesDictionary
{
    NSMutableDictionary *displayTitlesDictionary = nil;
    
    do
    {
        displayTitlesDictionary = [NSMutableDictionary dictionary];
        
        if(displayTitlesDictionary==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////

        for(WCCardModel *cardModel in self.cardModels)
        {
            if(cardModel.displayName!=nil &&
               cardModel.ID!=nil)
            {
                [displayTitlesDictionary setValue:cardModel.displayName forKey:cardModel.ID];
            }
        }

    }
    while (0);
 
    return displayTitlesDictionary;
}
@end
