//
//  WCMapContactRowModel.h
//  
//
//  Created by Howard on 2016/1/5.
//
//

#import "PPRowModel.h"

#import <CoreLocation/CoreLocation.h>

// Define
#import "WCMapViewController+ParameterDefine.h"

// Model
#import "WCCardModel.h"


@interface WCMapContactRowModel : PPRowModel

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Property

@property (nonatomic,retain) NSNumber *kiloMeterDistance;
@property (nonatomic,copy) NSString *locationString;
@property (nonatomic,copy) NSString *companyText;
@property (nonatomic,copy) NSString *jobTitleText;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Class Method

+ (WCMapContactRowModel *)mapContactRowModelFromCardModel:(WCCardModel *)cardModel
                                           locationString:(NSString *)locationString
                                                 distance:(CGFloat)distance;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

- (NSComparisonResult)displayDistanceSortWithMapContactRowModel:(WCMapContactRowModel *)rowModel;

- (NSString *)distanceTextFormatForMapViewControllerDistanceStyle:(WCMapViewControllerDistanceStyle)mapViewControllerDistanceStyle;
@end
