//
//  WCMapViewController+MKMapViewDelegate.m
//
//
//  Created by Howard on 2015/12/30.
//
//

#import "WCMapViewController+MKMapViewDelegate.h"
#import <MapKit/MapKit.h>

// Define
#import "WCMapViewController+ResourceDefine.h"

// Controller
#import "PPLogController.h"
#import "PPLocationController.h"

// View
#import "WCMapPinAnnotationView.h"
#import "WCMapAnnotation.h"

// Model
#import "WCCacheModel.h"

@implementation WCMapViewController (MKMapViewDelegate)

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - MKMapViewDelegate methods

//================================================================================
//
//================================================================================
- (void)mapView:(MKMapView *)mapView didUpdateUserLocation:(MKUserLocation *)userLocation
{
    PPLogFunctionIn();

    if([PPLocationController meterDistanceBetweenLocation1:self.myLocation location2:userLocation.location]>self.mapCenterDistanceKiloMeterThreshold)
    {
        self.myLocation = userLocation.location;
        
        //////////////////////////////////////////////////
        
        __block typeof(self) blockself = self;
        
        dispatch_async(dispatch_get_main_queue(), ^{
            
            [blockself moveMapToLocation:userLocation.location];
            
            //////////////////////////////////////////////////

            [blockself updateDistanceContactList];
        });

    }
    
    PPLogFunctionOut();
}


//================================================================================
//
//================================================================================
- (void)mapView:(MKMapView *)mapView didFailToLocateUserWithError:(NSError *)error
{
    PPLogFunctionIn();
    PPLogFunctionOut();
}


//================================================================================
//
//================================================================================
- (MKAnnotationView*)mapView:(MKMapView *)mapView viewForAnnotation:(id <MKAnnotation>)annotation
{
    PPLogFunctionIn();
    
    // 本機位置顯示
    if([annotation isKindOfClass:[MKUserLocation class]])
    {
        MKAnnotationView *annotationView = [mapView dequeueReusableAnnotationViewWithIdentifier:NSStringFromClass([MKPinAnnotationView class])];
        
        if(annotationView==nil)
        {
            annotationView = [[[MKAnnotationView alloc] initWithAnnotation:annotation
                                                           reuseIdentifier:NSStringFromClass([MKAnnotationView class])] autorelease];
        }
        
        if(annotationView!=nil)
        {
            UIImage *image = [[WCCacheModel defaultCache] thumbImageWithCardID:ImageNameForWCMapViewControllerButtonSelf];
            
            if(image==nil)
            {
                image = [UIImage imageWithName:ImageNameForWCMapViewControllerButtonSelf forState:UIControlStateNormal];
                
                [[WCCacheModel defaultCache] addThumbImage:image withCardID:ImageNameForWCMapViewControllerButtonSelf];
            }
            
            if(image!=nil)
            {
                image = [image imageScalingMaxLength:image.size.width/2];
            }
            
            annotationView.image = image;
        }
        
        return annotationView;
    }
    
    //////////////////////////////////////////////////

    WCMapPinAnnotationView *mapPinAnnotationView = (WCMapPinAnnotationView *)[mapView dequeueReusableAnnotationViewWithIdentifier:NSStringFromClass([WCMapPinAnnotationView class])];
    
    if(mapPinAnnotationView==nil)
    {
        mapPinAnnotationView = [[[WCMapPinAnnotationView alloc] initWithAnnotation:annotation
                                                                   reuseIdentifier:NSStringFromClass([WCMapPinAnnotationView class])] autorelease];
        
        if(mapPinAnnotationView!=nil)
        {
            mapPinAnnotationView.delegate = self;
            
            //////////////////////////////////////////////////
            
            UIImage *image = [[WCCacheModel defaultCache] thumbImageWithCardID:ImageNameForWCMapViewControllerButtonOther];
            
            if(image==nil)
            {
                image = [UIImage imageWithName:ImageNameForWCMapViewControllerButtonOther forState:UIControlStateNormal];
                
                [[WCCacheModel defaultCache] addThumbImage:image withCardID:ImageNameForWCMapViewControllerButtonOther];
            }
            
            if(image!=nil)
            {
                image = [image imageScalingMaxLength:image.size.width/2];
            }
            
            mapPinAnnotationView.image = image;
        }
    }
    else
    {
        mapPinAnnotationView.annotation = annotation;
        [mapPinAnnotationView reuseForAnnotationView];
    }

    //////////////////////////////////////////////////

    if([annotation isKindOfClass:[WCMapAnnotation class]]==YES)
    {
        WCMapAnnotation *mapAnnotation = annotation;
        
        if([[mapAnnotation currentCardID] compare:self.focusCardID]==NSOrderedSame)
        {
            self.focusMapPinAnnotationView = mapPinAnnotationView;
  
            [mapPinAnnotationView setActive:YES];
            
            [mapPinAnnotationView fetchDataWithProtocol:self];
        }
        else
        {
            [mapPinAnnotationView setActive:NO];
        }
    }

    //////////////////////////////////////////////////

    PPLogFunctionOut();
    
    //////////////////////////////////////////////////

    return mapPinAnnotationView;
}


//================================================================================
//
//================================================================================
- (void)mapView:(MKMapView *)mapView regionDidChangeAnimated:(BOOL)animated
{
    PPLogFunctionIn();
    
    //配合地圖大小改變，改變 annotation數量
    __block typeof(self) blockself = self;
    
    dispatch_async(dispatch_get_main_queue(), ^{
        
        double scale = mapView.visibleMapRect.size.width/mapView.bounds.size.width;

        [blockself mapViewDidZoomWithinMapRect:mapView.visibleMapRect
                                 withZoomScale:scale];
    });
    
    PPLogFunctionOut();
}


//================================================================================
//
//================================================================================
- (void)mapView:(MKMapView *)mapView didAddAnnotationViews:(NSArray *)views
{
    PPLogFunctionIn();

    __block typeof(self) blockself = self;
    
    dispatch_async(dispatch_get_main_queue(), ^{
        [blockself.focusMapPinAnnotationView.superview bringSubviewToFront:blockself.focusMapPinAnnotationView];
    });
    
    PPLogFunctionOut();
}


//================================================================================
//
//================================================================================
- (void)mapView:(MKMapView *)mapView didSelectAnnotationView:(MKAnnotationView *)view
{
    PPLogFunctionIn();

    NSString *selectedCardID = nil;
    
    if([view.annotation respondsToSelector:@selector(currentCardID)]==YES)
    {
        selectedCardID = [view.annotation performSelector:@selector(currentCardID)];
    }
    
    //////////////////////////////////////////////////

    if([selectedCardID compare:self.focusCardID]!=NSOrderedSame &&
       [view isKindOfClass:[WCMapPinAnnotationView class]]==YES)
    {
        WCMapPinAnnotationView *annotationView = (WCMapPinAnnotationView *)view;
        
        [annotationView setActive:YES];
        
        [annotationView fetchDataWithProtocol:self];

        //////////////////////////////////////////////////

        if(self.focusMapPinAnnotationView!=nil)
        {
            [self.focusMapPinAnnotationView setActive:NO];
        }

        self.focusMapPinAnnotationView = annotationView;
        
        //////////////////////////////////////////////////
        
        [self moveToDistanceContactListFocusCardID:selectedCardID];
    }
    PPLogFunctionOut();
}

@end
