//
//  WCImportFlowController.m
//
//
//  Created by Howard on 2015/8/6.
//
//

#import "WCImportFlowController.h"
#import <Contacts/Contacts.h>

// Define
#import "WCImportFlowController+ParameterDefine.h"
#import "WCImportFlowController+ResouceDefine.h"
#import "WCImportFlowController+SettingKey.h"
#import "PPStorageSpaceSelectViewController+ResourceDefine.h"
#import "PPStorageFileSelectViewController+ResourceDefine.h"
#import "WCCloudFileDefine.h"

// Model
#import "PPProgressModel.h"

// View
#import "PPAlertView.h"
#import "PPBusyView.h"

// Controller
#import "GroupViewController.h"
#import "PPBackgroundTaskController.h"
#import "PPStorageFileSelectViewController.h"
#import "PPStorageSpaceSelectViewController.h"
#import "PPStorageFileFetch_iTune.h"
#import "PPSettingsController.h"
#import "PPNavigationController.h"
#import "WCABItemSelectFlowController.h"
#import "WCXFDataController.h"
#import "WCVCFDataController.h"
#import "WCToolController.h"

// Category
#import "UIApplication+Idle.h"
#import "NSError+Custom.h"
#import "NSObject+PPBusyView.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Define Function Pointer

typedef void (^VoidCallBack)(void);

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Interface

@interface WCImportFlowController()
<
PPCloudDelegate_CreateFolder,
PPCloudDelegate_LoadFile,
GroupViewControllerDatasource,
GroupViewControllerDelegate,
PPStorageSpaceSelectViewControllerDelegate,
PPStorageFielSelectViewControllerDatasource,
PPStorageFileSelectViewControllerDelegate,
UIAlertViewDelegate,
WCABItemSelectFlowControllerDelegate,
WCXFDataControllerDelegate
>

@property (nonatomic,retain) PPStorageSpaceSelectViewController *storageSpaceSelectViewController;
@property (nonatomic,retain) PPStorageFileSelectViewController  *storageFileSelectViewController;
@property (nonatomic,retain) GroupViewController *groupViewController;
@property (nonatomic,retain) UIViewController    *superViewController;
@property (nonatomic,retain) WCXFDataController  *wcxfDataController;
@property (nonatomic,retain) PPBusyView          *busyView;
@property (nonatomic,retain) NSOperationQueue    *workOperatinQueue;
@property (nonatomic,retain) WCCardModel         *cardModel;
@property (nonatomic,retain) PPProgressModel     *progressModel;
@property (nonatomic,retain) UIImage             *idPhotoImage;
@property (nonatomic,retain) UIImage             *frontCardImage;
@property (nonatomic,retain) UIImage             *rearCardImage;
@property (nonatomic,retain) NSError             *lastError;
@property (nonatomic,assign) float               updateProgress;
@property (nonatomic,copy)   VoidCallBack        alertComplete;
@property (nonatomic,retain) NSArray             *selectedResultList;
@property (nonatomic,assign) NSInteger           importedGroupID;
@end

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Implementation

@implementation WCImportFlowController

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Dellocating Object

//================================================================================
//
//================================================================================
- (id)init
{
    if(self=[super init])
    {
        _progressModel = [[PPProgressModel alloc] init];
        
        //////////////////////////////////////////////////
        
        _wcxfDataController = [[WCXFDataController alloc] initWithDelegate:self];
        
        //////////////////////////////////////////////////
        
        _workOperatinQueue = [[NSOperationQueue alloc] init];
        
        if(_workOperatinQueue!=nil)
        {
            [_workOperatinQueue setMaxConcurrentOperationCount:1];
        }
    }
    
    return self;
}


//================================================================================
//
//================================================================================
- (void)dealloc
{
    _importFlowDatasource = nil;
    _importFlowDelegate = nil;
    
    self.storageSpaceSelectViewController = nil;
    self.storageFileSelectViewController = nil;
    self.superViewController = nil;
    self.wcxfDataController = nil;
    self.groupViewController = nil;
    
    self.alertComplete = nil;
    
    [self.busyView removeFromSuperview];
    self.busyView = nil;
    
    [_workOperatinQueue cancelAllOperations];
    [_workOperatinQueue release];
    _workOperatinQueue = nil;
    
    [_lastError release];
    _lastError = nil;
    
    [_cardModel release];
    _cardModel = nil;
    
    [_progressModel release];
    _progressModel = nil;
    
    [_frontCardImage release];
    _frontCardImage = nil;
    
    [_rearCardImage release];
    _rearCardImage = nil;
    
    [_idPhotoImage release];
    _idPhotoImage = nil;
    
    [_selectedResultList release];
    _selectedResultList = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}




////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPCloudDelegate_LoadFile Method

//================================================================================
//
//================================================================================
- (void)ppCloud:(PPCloud *)ppCloud loadedFile:(NSString *)destPath userInfo:(id)userInfo
{
    PPLogFunction(@"%s, loadedFile:%@",__func__,destPath);
    
    __block typeof(self) blockSelf = self;
    
    dispatch_async(dispatch_get_main_queue(), ^{
        
        [[UIApplication sharedApplication] enableIdle:YES];
        
        //////////////////////////////////////////////////
        
        [blockSelf showBusyView:NO];
        
        //////////////////////////////////////////////////
        
        blockSelf.selectedResultList = @[destPath];
        
        //////////////////////////////////////////////////
        
        [blockSelf importProgressWithSelectedFilePathArray:blockSelf.selectedResultList];
    });
}


//================================================================================
//
//================================================================================
- (void)ppCloud:(PPCloud *)ppCloud loadFileFailedWithError:(NSError *)error userInfo:(id)userInfo
{
    PPLogFunction(@"%s, error:%@",__func__,error);
    __block typeof(self) blockSelf = self;
    
    dispatch_async(dispatch_get_main_queue(), ^{
            
        [[UIApplication sharedApplication] enableIdle:YES];
        
        //////////////////////////////////////////////////
        
        [blockSelf showBusyView:NO];
        
        //////////////////////////////////////////////////
                
        [blockSelf showAlertWithError:error title:WCIFC_MLS_FailedToDownload completion:^{
            
            [blockSelf.groupViewController dismissViewControllerAnimated:YES completion:^{
                if([blockSelf.importFlowDelegate respondsToSelector:@selector(importFlowDidFinishWithError:)]==YES)
                {
                    blockSelf.groupViewController = nil;
                    blockSelf.storageFileSelectViewController = nil;
                    blockSelf.storageSpaceSelectViewController = nil;
                    
                    //////////////////////////////////////////////////
                    
                    [blockSelf.importFlowDelegate importFlowDidFinishWithError:error];
                }
            }];
        }];
    });

}


//================================================================================
//
//================================================================================
- (void)ppCloud:(PPCloud *)ppCloud loadProgress:(CGFloat)progress forFile:(NSString *)destPath userInfo:(id)userInfo
{
    PPLogFunction(@"%s, forFile:%@, loadProgress:%f",__func__,destPath,progress);
    
    dispatch_async(dispatch_get_main_queue(), ^{
        [PPBusyView postMessage:[NSString stringWithFormat:@"%@, %d%%",WCIFC_MLS_Downloading,(int)(progress*100)]];
    });
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPCloudDelegate_Create Method

//================================================================================
//
//================================================================================
- (void)ppCloud:(PPCloud *)ppCloud createdFolder:(PPCloudMetadata *)folder userInfo:(id)userInfo
{
    // do nothing
}


//================================================================================
//
//================================================================================
- (void)ppCloud:(PPCloud *)ppCloud createFolderFailedWithError:(NSError *)error userInfo:(id)userInfo
{
    // do nothing
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPStorageFileSelectViewControllerDelegate Method

//================================================================================
//
//================================================================================
- (void)storageFileSelectViewController:(PPStorageFileSelectViewController *)storageFileSelectViewController
                   didSelectedFileArray:(NSArray<PPStorageFielSelectRowModel *> *)selectedFileArray
{
    // MARK: 檔案選擇完，進入選擇匯入類別
    PPLogFunction(@"%s, didSelectedFileInfoArray:%@",__func__,selectedFileArray);
    
    //////////////////////////////////////////////////
    
    // 已是單選，選WCXF,VCard 要選擇類別
    
    PPStorageFielSelectRowModel *rowModel = [selectedFileArray lastObject];
    
    GroupViewControllerMode mode = NSUIntegerMax;
    
    if([[rowModel.object pathExtension] compare:@"vcf"]==NSOrderedSame)
    {
        mode = GroupViewControllerMode_VCF;
    }
    else if([[rowModel.object pathExtension] compare:@"wcxf"]==NSOrderedSame)
    {
        mode = GroupViewControllerMode_WCXF;
    }
    
    //////////////////////////////////////////////////
    
    if(mode==GroupViewControllerMode_VCF ||
       mode==GroupViewControllerMode_WCXF)
    {
        // TODO: 如果
        self.selectedResultList = selectedFileArray;
        
        //////////////////////////////////////////////////
        
        GroupViewController *groupViewController = [[GroupViewController alloc] init];
        
        if(groupViewController!=nil)
        {
            groupViewController.datasource = self;
            groupViewController.delegate = self;
            groupViewController.groupViewControllerMode = mode;
            
            [storageFileSelectViewController.navigationController pushViewController:groupViewController animated:YES];
        }
        
        self.groupViewController = groupViewController;
        
        [groupViewController release];
    }
    else
    {
        self.importedGroupID = WC_GID_Unverified;
        
        //////////////////////////////////////////////////
        
        NSMutableArray *paths = [NSMutableArray array];
        
        for(PPStorageFielSelectRowModel *rowModel in selectedFileArray)
        {
            [paths addObject:rowModel.object];
        }
        
        [self importProgressWithSelectedFilePathArray:paths];
    }
}


//================================================================================
//
//================================================================================
- (void)storageFileSelectViewControllerDidCancel:(PPStorageFileSelectViewController *)storageFileSelectViewController
{
    //    self.storageSpaceSelectViewController.needFetchSpaceInformation = YES;
    
    //////////////////////////////////////////////////
    
    [storageFileSelectViewController goBackAnimated:YES];
}


//================================================================================
//
//================================================================================
- (void)storageFileSelectViewControllerDidDismissBusyView:(PPStorageFileSelectViewController *)storageFileSelectViewController
{
    // 取消匯入，可能還要修正，因為wcxf轉換時，無法取消
    self.lastError = PPErrorOperationCancel(self.lastError);
}


//================================================================================
//
//================================================================================
- (BOOL)storageFileSelectViewControllerShouldShowAlertError:(NSError *)error
{
    BOOL result = YES;
    
    if([self.importFlowDelegate respondsToSelector:@selector(importFlowRequestShowError:)]==YES)
    {
        result = [self.importFlowDelegate importFlowRequestShowError:error];
    }
    
    return result;
}


//================================================================================
//
//================================================================================
- (NSString *)storageFileSelectViewControllerRequestMessageWithError:(NSError *)error
{
    NSString *requestMessage = nil;
    
    // 特殊做法， folder not found 同路徑下沒檔案
    if(error.code==406 && [error.domain compare:@"PPDropboxOperation_LoadMetadata"]==NSOrderedSame)
    {
        // 特殊做法, dropbox api 限制，同目錄下只能有10000個檔案
        
        NSString *message = WCIFC_MLS_ExceedDropboxFolderFileLimitAndClear;
        
        //換路徑
        requestMessage = [message stringByReplacingOccurrencesOfString:@"@1" withString:self.storageFileSelectViewController.defaultRootFilePath];
    }
    else if([self.importFlowDelegate respondsToSelector:@selector(importFlowRequestMessageWithError:)]==YES)
    {
        requestMessage = [self.importFlowDelegate importFlowRequestMessageWithError:error];
    }
    
    return requestMessage;
}


//==============================================================================
//
//==============================================================================
- (NSUInteger)storageFileSelectViewControllerRequestCardCountFromFilePath:(NSString *)filePath
{
    WCXFRootInfoModel *rootInfoModel = [self.wcxfDataController rootInfoOfFile:filePath error:nil];
    if(rootInfoModel!=nil)
        return rootInfoModel.cardCount;

    return 0;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPStorageSpaceSelectViewController Delegate


//==============================================================================
//
//==============================================================================
- (NSString *)specificStringWithStorageSpaceSelectViewController:(PPStorageSpaceSelectViewController*)storageSpaceSelectViewController
{
    if ([self.importFlowDelegate respondsToSelector:@selector(specificStringWithimportFlowController:)])
    {
        return [self.importFlowDelegate specificStringWithimportFlowController:self];
    }
    return nil;
}


//================================================================================
//
//================================================================================
- (void)storageSpaceSelectViewController:(PPStorageSpaceSelectViewController *)storageSpaceSelectViewController
didLoginSuccessWithStorageSpaceSelectControllerSpaceType:(PPStorageSpaceSelectControllerSpaceType)storageSpaceSelectControllerSpaceType
{
    [self autoCreateFolderWithStorageSpaceSelectControllerSpaceType:storageSpaceSelectControllerSpaceType];
    
    //////////////////////////////////////////////////
    
    [self showStorageFileSelectViewControllerFromSuperViewController:storageSpaceSelectViewController
                               storageSpaceSelectControllerSpaceType:storageSpaceSelectControllerSpaceType];
}


//================================================================================
//
//================================================================================
- (void)storageSpaceSelectViewController:(PPStorageSpaceSelectViewController *)storageSpaceSelectViewController didStorageSpaceSelectControllerSpaceType:(PPStorageSpaceSelectControllerSpaceType)storageSpaceSelectControllerSpaceType
{
    if(storageSpaceSelectControllerSpaceType==PPStorageSpaceSelectControllerSpaceType_Specific)
    {
        __block typeof(self) blockself = self;
        
        [storageSpaceSelectViewController dismissAnimated:YES
                                               completion:^{
                                                   
                                                   if([blockself.importFlowDelegate respondsToSelector:@selector(importFlowRequestDidSelectStorageSpaceSelectControllerSpaceType:)]==YES)
                                                   {
                                                       [blockself.importFlowDelegate importFlowRequestDidSelectStorageSpaceSelectControllerSpaceType:storageSpaceSelectControllerSpaceType];
                                                   }
                                                   
                                                   //////////////////////////////////////////////////
                                                   
                                                   if([blockself.importFlowDelegate respondsToSelector:@selector(importFlowDidFinishWithError:)]==YES)
                                                   {
                                                       [blockself.importFlowDelegate importFlowDidFinishWithError:nil];
                                                   }
                                                   
                                               }];
    }
    else
    {
        [self autoCreateFolderWithStorageSpaceSelectControllerSpaceType:storageSpaceSelectControllerSpaceType];
        
        //////////////////////////////////////////////////
        
        [self showStorageFileSelectViewControllerFromSuperViewController:storageSpaceSelectViewController
                                   storageSpaceSelectControllerSpaceType:storageSpaceSelectControllerSpaceType];
    }
}


//================================================================================
//
//================================================================================
- (void)storageSpaceSelectViewControllerDidCancel:(PPStorageSpaceSelectViewController *)storageSpaceSelectViewController
{
    __block typeof(self) blockself = self;
    
    [storageSpaceSelectViewController dismissViewControllerAnimated:YES completion:^{
        
        if([blockself.importFlowDelegate respondsToSelector:@selector(importFlowDidFinishWithError:)]==YES)
        {
            [blockself.importFlowDelegate importFlowDidFinishWithError:nil];
        }
    }];
}


//================================================================================
//
//================================================================================
- (BOOL)storageSpaceSelectViewControllerShowAlertWithError:(NSError *)error
{
    BOOL result = YES;
    
    if([self.importFlowDelegate respondsToSelector:@selector(importFlowRequestShowError:)]==YES)
    {
        result = [self.importFlowDelegate importFlowRequestShowError:error];
    }
    
    return result;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - UIAlertView Delegate Method

//================================================================================
//
//================================================================================
- (void)alertView:(UIAlertView *)alertView didDismissWithButtonIndex:(NSInteger)buttonIndex
{
    if(alertView.tag==WCImportFlowControllerAlertViewTag_ImportSuccess)
    {
        //刪除本機匯入檔案
        for(id object in self.selectedResultList)
        {
            //若為匯入系統連絡人，則不用進行本機端檔案刪除
            if([object isKindOfClass:[PPStorageFielSelectRowModel class]]==NO)
            {
                break;
            }
            
            //////////////////////////////////////////////////
            
            PPStorageFielSelectRowModel *rowModel = (PPStorageFielSelectRowModel *)object;
            
            NSString *filePath = [rowModel object];
            
            if([[NSFileManager defaultManager] fileExistsAtPath:filePath]==YES)
            {
                [[NSFileManager defaultManager] removeItemAtPath:filePath error:nil];
            }
        }
        
        //////////////////////////////////////////////////
        
        __block typeof(self) blockself = self;
        
        [self.superViewController dismissAnimated:NO completion:^{
            
            if([blockself.importFlowDelegate respondsToSelector:@selector(importFlowDidFinishWithError:)]==YES)
            {
                [blockself.importFlowDelegate importFlowDidFinishWithError:nil];
            }
            
        }];
    }
    else if(alertView.tag==WCImportFlowControllerAlertViewTag_NetworkDisconnect)
    {
        [self.groupViewController.navigationController popToViewController:self.storageSpaceSelectViewController animated:YES];
    }
    else
    {
        self.alertComplete();
        self.alertComplete = nil;
    }
}






////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - WCABItemSelectFlowController Delegate Method

//================================================================================
//
//================================================================================
- (void)abSelectFlowController:(WCABItemSelectFlowController *)abSelectFlowController
            fromViewController:(UIViewController *)fromViewController
         didSelectABGroupModel:(WCABGroupModel *)abGroupModel

{
    // 不做匯出
}


//================================================================================
//
//================================================================================
- (void)abSelectFlowController:(WCABItemSelectFlowController *)abSelectFlowController
            fromViewController:(UIViewController *)fromViewController
         didSelectABCardModels:(NSArray *)abCardModels
{
    // MARK: 連絡人選完之後
    
    self.selectedResultList = abCardModels;
    
    //////////////////////////////////////////////////
    
    GroupViewController *groupViewController = [[GroupViewController alloc] init];
    
    if(groupViewController!=nil)
    {
        groupViewController.datasource = self;
        groupViewController.delegate = self;
        groupViewController.groupViewControllerMode = GroupViewControllerMode_ABPeople;
        
        //////////////////////////////////////////////////
        
        [fromViewController.navigationController pushViewController:groupViewController animated:YES];
    }
    
    self.groupViewController = groupViewController;
    
    [groupViewController release];
}


//================================================================================
//
//================================================================================
- (void)abSelectFlowControllerFailWithError:(NSError *)error
{
    [self showAlertWithError:error
                       title:@""
                  completion:^{
                  }];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - WCXFDataController Delegate Method

//================================================================================
//
//================================================================================
- (void)wcxfDataContrller:(WCXFDataController *)wcxfDataController
            readCardModel:(WCCardModel *)cardModel
{
    PPLogFunction(@" %s",__func__);
    
    //////////////////////////////////////////////////
    
    self.cardModel = cardModel;
}

//================================================================================
//
//================================================================================
- (void)wcxfDataContrller:(WCXFDataController *)wcxfDataController
            readImageData:(NSData *)imageData
                imageType:(WC_ImageType)imageType
                   cardID:(NSString *)cardID
{
    PPLogFunction(@" %s",__func__);
    
    do
    {
        if(imageData==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        switch (imageType)
        {
            case WC_IT_BackSide:
            {
                self.rearCardImage = [UIImage imageWithData:imageData];
                break;
            }
            case WC_IT_FrontSide:
            {
                self.frontCardImage = [UIImage imageWithData:imageData];
                break;
            }
            case WC_IT_IDPhoto:
            {
                self.idPhotoImage = [UIImage imageWithData:imageData];
                break;
            }
            case WC_IT_None:
            default:
            {
                break;
            }
        }
    }
    while (0);
}


//================================================================================
//
//================================================================================
- (WC_GroupID)wcxfDataContrller:(WCXFDataController *)wcxfDataController
       groupIDWithReadGroupName:(NSString *)groupName
                          error:(NSError **)error
{
    PPLogFunction(@" %s",__func__);
    
    WC_GroupID groupID = WC_GID_None;
    
    //使用者不指定類別，才要詢問類別ID
    if(self.importedGroupID==WC_GID_None &&
       [self.importFlowDelegate respondsToSelector:@selector(importFlowRequestGroupIDWithGroupName:error:)]==YES)
    {
        NSError *returnError = nil;
        
        groupID = [self.importFlowDelegate importFlowRequestGroupIDWithGroupName:groupName
                                                                    error:&returnError];
        
        if(error!=NULL)
        {
            *error = returnError;
        }
        
        self.lastError = returnError;
    }
    
    return groupID;
}


//================================================================================
//
//================================================================================
- (BOOL)wcxfDataContrller:(WCXFDataController *)wcxfDataController shouldReadCardWithIndex:(NSInteger)index totalCount:(NSInteger)totalCount
{
    if(self.lastError!=nil)
    {
        return NO;
    }
    else
    {
        return YES;
    }
}


//================================================================================
//
//================================================================================
- (void)wcxfDataContrller:(WCXFDataController *)wcxfDataController
     didReadCardWithIndex:(NSInteger)index
               totalCount:(NSInteger)totalCount
{
    PPLogFunction(@" %s, %td/%td",__func__,index,totalCount);
    
    if(self.lastError!=nil)
    {
        return;
    }
    
    //////////////////////////////////////////////////
    
    // !! 告知進度，總量要連 vCard 都算進來所以不是直接拿 totalCount, 而是拿 self.taskCount
    if([self.importFlowDelegate respondsToSelector:@selector(importFlowImportTaskAtIndex:totalCount:)]==YES)
    {
        [self.importFlowDelegate importFlowImportTaskAtIndex:index totalCount:self.progressModel.denominator];
    }
    
    //////////////////////////////////////////////////
    
    NSError *error = nil;
    
    //////////////////////////////////////////////////
    
    if([self.importFlowDelegate respondsToSelector:@selector(importFlowRequestImportWithWCCardModel:idPhotoImage:frontSideImage:backSideImage:error:)]==YES)
    {
        // MARK 代表匯入時有指定類別
        if(self.importedGroupID!=WC_GID_None)
        {
            [self.cardModel setGroupIDArray:@[[NSString stringWithFormat:@"%td",self.importedGroupID]] isInitCard:YES];
        }
        
        //////////////////////////////////////////////////
        
        if([self.importFlowDelegate importFlowRequestImportWithWCCardModel:self.cardModel
                                                              idPhotoImage:self.idPhotoImage
                                                            frontSideImage:self.frontCardImage
                                                             backSideImage:self.rearCardImage
                                                                     error:&error]==NO)
        {
            self.lastError = error;
        }
        
        
        //////////////////////////////////////////////////
        
        self.idPhotoImage = nil;
        self.frontCardImage = nil;
        self.rearCardImage = nil;
    }
    
    //////////////////////////////////////////////////
    
    if(self.progressModel!=nil)
    {
        self.progressModel.numerator = index+1;
        
        //////////////////////////////////////////////////
        
        //不要每次一直丟
        if([self.progressModel progress]>(self.updateProgress+0.01) || self.progressModel.progress==1)
        {
            self.updateProgress = [self.progressModel progress];
            
            [PPBusyView postMessage:[NSString stringWithFormat:@"%@ %d%%",WCIFC_MLS_ParsingData,(int)(self.progressModel.progress*100)]];
        }
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - GroupViewControllerDatasource

//================================================================================
//
//================================================================================
- (NSMutableArray *)groupViewControllerWithAllGroupModelsWithCardID:(NSString *)cardID
{
    NSMutableArray *allGroups = nil;
    
    do
    {
        if([self.importFlowDatasource respondsToSelector:@selector(importFlowWithAllGroupModelsWithCardID:)]==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        allGroups = [self.importFlowDatasource importFlowWithAllGroupModelsWithCardID:cardID];
    }
    while (0);
    
    return allGroups;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - GroupViewControllerDelegate

//================================================================================
//
//================================================================================
- (void)groupViewController:(GroupViewController *)groupViewController didSelectGroupID:(NSInteger)groupID
{
    // MARK: 選擇群組完之後
    
    self.importedGroupID = groupID;
    
    //////////////////////////////////////////////////
    
    if(groupViewController.groupViewControllerMode==GroupViewControllerMode_ABPeople)
    {
        [self importABPeoplesFromABCardModels:self.selectedResultList];
    }
    else
    {
        switch (self.storageFileSelectViewController.storageFileSelectViewControllerSpaceType)
        {
                // network
            case PPStorageFileSelectViewControllerSpaceType_Dropbox:
            case PPStorageFileSelectViewControllerSpaceType_GoogleDrive:
            case PPStorageFileSelectViewControllerSpaceType_OneDrive:
            case PPStorageFileSelectViewControllerSpaceType_Huawei:
            case PPStorageFileSelectViewControllerSpaceType_Baidu:
            case PPStorageFileSelectViewControllerSpaceType_iCloud:
            {
                [self showBusyView:YES];
                
                //////////////////////////////////////////////////
                
                PPStorageFielSelectRowModel *rowModel = [self.selectedResultList firstObject];
                NSString *filePath = [rowModel object];
                
                //////////////////////////////////////////////////
                
                [PPBusyView postMessage:[NSString stringWithFormat:@"%@, 0%%",WCIFC_MLS_Downloading]];
                
                //////////////////////////////////////////////////
                
                //背景處理
                [PPBackgroundTaskController addTaskWithKey:NSStringFromClass([self class]) terminate:nil];
                
                //////////////////////////////////////////////////
                
                BOOL isLink = NO;
                
                //////////////////////////////////////////////////
                
                NSString *intoPath = [[WCToolController tempFolderPath] stringByAppendingString:[NSString stringWithFormat:@"/%@",[filePath lastPathComponent]]];
                
                if(self.storageFileSelectViewController.storageFileSelectViewControllerSpaceType==PPStorageFileSelectViewControllerSpaceType_Dropbox)
                {
                    isLink = [PPCloudController loadFileFromPath:filePath
                                                        orFileID:nil
                                                        intoPath:intoPath
                                                        delegate:self
                                                        userInfo:nil
                                                      cloudClass:[PPCloud_Dropbox class]];
                }
                else if(self.storageFileSelectViewController.storageFileSelectViewControllerSpaceType==PPStorageFileSelectViewControllerSpaceType_GoogleDrive)
                {
                    isLink = [PPCloudController loadFileFromPath:filePath
                                                        orFileID:rowModel.fileID
                                                        intoPath:intoPath
                                                        delegate:self
                                                        userInfo:nil
                                                      cloudClass:[PPCloud_GoogleDrive class]];
                }
                else if(self.storageFileSelectViewController.storageFileSelectViewControllerSpaceType==PPStorageFileSelectViewControllerSpaceType_OneDrive)
                {
                    isLink = [PPCloudController loadFileFromPath:filePath
                                                        orFileID:rowModel.fileID
                                                        intoPath:intoPath
                                                        delegate:self
                                                        userInfo:nil
                                                      cloudClass:[PPCloud_OneDrive class]];
                }
//                else if(self.storageFileSelectViewController.storageFileSelectViewControllerSpaceType==PPStorageFileSelectViewControllerSpaceType_Huawei)
//                {
//                    isLink = [PPCloudController loadFileFromPath:filePath
//                                                        orFileID:nil
//                                                        intoPath:intoPath
//                                                        delegate:self
//                                                        userInfo:nil
//                                                      cloudClass:[PPCloud_Huawei class]];
//                }
                else if(self.storageFileSelectViewController.storageFileSelectViewControllerSpaceType==PPStorageFileSelectViewControllerSpaceType_iCloud)
                {
                    isLink = [PPCloudController loadFileFromPath:filePath
                                                        orFileID:nil
                                                        intoPath:intoPath
                                                        delegate:self
                                                        userInfo:nil
                                                      cloudClass:[PPCloud_iCloud class]];
                }
                
                //////////////////////////////////////////////////
                
                //連線失敗
                if(isLink==NO)
                {
                    [self showBusyView:NO];
                    
                    //////////////////////////////////////////////////
                    
                    [PPAlertView showWithStyle:UIAlertViewStyleDefault
                                         title:@""
                                       message:PSSSVC_MLS_ErrorNetworkReachableNone
                                      delegate:self
                                           tag:WCImportFlowControllerAlertViewTag_NetworkDisconnect
                             cancelButtonTitle:WCIFC_MLS_OK otherButtonTitles:nil];
                }
                else
                {
                    [[UIApplication sharedApplication] enableIdle:NO];
                }
                
                //////////////////////////////////////////////////
                
                [PPBackgroundTaskController removeTaskWithKey:NSStringFromClass([self class])];
                
                break;
            }
                //local
            default:
            {
                NSMutableArray *paths = [NSMutableArray array];
                
                // 從WCM匯入
                if([[self.selectedResultList firstObject] isKindOfClass:[NSString class]]==YES)
                {
                    
                    for(NSString *path in self.selectedResultList)
                    {
                        [paths addObject:path];
                    }
                    
                }
                else
                {
                    for(PPStorageFielSelectRowModel *rowModel in self.selectedResultList)
                    {
                        [paths addObject:rowModel.object];
                    }
                }
                
                //////////////////////////////////////////////////
                
                
                [self importProgressWithSelectedFilePathArray:paths];
                
                break;
            }
        }
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private MainThread Send Delegate Method

//================================================================================
//
//================================================================================
- (void)mainthreadSendFininishedWithError:(NSError *)error message:(NSString *)message
{
    if(error==nil)
    {
        PPAlertView *alertView = [[PPAlertView alloc] initWithTitle:@""
                                                            message:message
                                                           delegate:self
                                                  cancelButtonTitle:WCIFC_MLS_OK
                                                  otherButtonTitles:nil];
        
        if(alertView!=nil)
        {
            [alertView show];
        }
        
        [alertView release];
    }
    else
    {
        __block typeof(self) blockself = self;
        
        [self showAlertWithError:error title:WCIFC_MLS_FailedToDecrypt completion:^{
            
            [blockself.groupViewController dismissViewControllerAnimated:YES completion:^{
                if([blockself.importFlowDelegate respondsToSelector:@selector(importFlowDidFinishWithError:)]==YES)
                {
                    blockself.groupViewController = nil;
                    blockself.storageFileSelectViewController = nil;
                    blockself.storageSpaceSelectViewController = nil;
                    
                    //////////////////////////////////////////////////
                    
                    [blockself.importFlowDelegate importFlowDidFinishWithError:error];
                }
            }];
        }];
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private Alert Method

//================================================================================
//
//================================================================================
- (void)showAlertWithError:(NSError *)error title:(NSString *)title completion:(VoidCallBack)completion
{
    if(error!= nil)
    {
        self.alertComplete = completion;
        
        //////////////////////////////////////////////////
        
        NSString *message = nil;
        BOOL showError = NO;
        
        if([self.importFlowDelegate respondsToSelector:@selector(importFlowRequestShowError:)])
        {
            showError = [self.importFlowDelegate importFlowRequestShowError:error];
        }

        if(showError)
        {
            // 先跟外部詢問有沒有特別的解釋
            if([self.importFlowDelegate respondsToSelector:@selector(importFlowRequestMessageWithError:)])
            {
                message = [self.importFlowDelegate importFlowRequestMessageWithError:error];
            }
            
            // 沒有的話就直接使用error code敘述
            if([message length] == 0)
            {
                message = [error alertMessage];
            }
            
            //////////////////////////////////////////////////
            
            // show alert
            PPAlertView *alertView = [[PPAlertView alloc] initWithTitle:title
                                                                message:message
                                                               delegate:self
                                                      cancelButtonTitle:WCIFC_MLS_OK
                                                      otherButtonTitles:nil];
            
            alertView.tag = WCImportFlowControllerAlertViewTag_ImportFail;
            
            [alertView show];
            [alertView release];
        }
        else
        {
            self.alertComplete ();
            self.alertComplete = nil;
        }
    }
}






////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private busyVie method

//================================================================================
//
//================================================================================
- (void)showBusyView:(BOOL)showBusyView
{
    [self setBusy:@(showBusyView) withView:[UIApplication sharedApplication].keyWindow];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private Method

//================================================================================
//
//================================================================================
- (void)showStorageFileSelectViewControllerFromSuperViewController:(UIViewController *)superViewController storageSpaceSelectControllerSpaceType:(PPStorageSpaceSelectControllerSpaceType)storageSpaceSelectControllerSpaceType
{
    do
    {
        if(superViewController==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        switch (storageSpaceSelectControllerSpaceType)
        {
            case PPStorageSpaceSelectControllerSpaceType_Baidu:
            {
                break;
            }
            case PPStorageSpaceSelectControllerSpaceType_iCloud:
            case PPStorageSpaceSelectControllerSpaceType_GoogleDrive:
            case PPStorageSpaceSelectControllerSpaceType_OneDrive:
            case PPStorageSpaceSelectControllerSpaceType_Huawei:
            case PPStorageSpaceSelectControllerSpaceType_Dropbox:
            case PPStorageSpaceSelectControllerSpaceType_iTune:
            {
                PPStorageFileSelectViewController *storageFileSelectViewController = [[PPStorageFileSelectViewController alloc] init];
                
                if(storageFileSelectViewController!=nil)
                {
                    storageFileSelectViewController.navigationViewButtonNormalTitleColor = WCIFC_PPStorageFileSelectNavigationViewButtonTitleNormalColor;
                    
                    storageFileSelectViewController.navigationViewButtonHighlightedTitleColor = WCIFC_PPStorageFielSelectNavigationViewButtonTitleHighlightedColor;
                    
                    storageFileSelectViewController.navigationViewButtonHighlightedBackgroundColor = WCIFC_PPStorageFielSelectNavigationViewButtonHighlightedBackgroundColor;
                    
                    //////////////////////////////////////////////////
                    
                    storageFileSelectViewController.tableViewCellNormalTextColor = WCIFC_PPTableViewCellTextNormalColor;
                    storageFileSelectViewController.tableViewCellNormalDetailTextColor = WCIFC_PPTableViewCellDetailTextNormalColor;
                    storageFileSelectViewController.tableViewSeperatorColor = WCIFC_PPTableViewSeparatorColor;
                    storageFileSelectViewController.tableViewCellHighlightedBackgroundColor = WCIFC_PPTableViewCellHighlightedBackgroundColor;
                    
                    //////////////////////////////////////////////////
                    
                    storageFileSelectViewController.navigationViewButtonImageEdgeInsets = WCIFC_PPStorageFileSelectViewControllerButtonImageEdgeInsets;
                    
                    //////////////////////////////////////////////////
                    
                    if(storageSpaceSelectControllerSpaceType==PPStorageFileSelectViewControllerSpaceType_Dropbox)
                    {
                        storageFileSelectViewController.autoDownload         = NO;
                        storageFileSelectViewController.controllerTitle      = PSSSVC_MLS_Dropbox;
                        storageFileSelectViewController.storageFileSelectViewControllerSpaceType = PPStorageFileSelectViewControllerSpaceType_Dropbox;
                        
                        //////////////////////////////////////////////////
                        
                        NSString *rootFolderPath = [PPSettingsController stringValueWithKey:WCImportFlowControllerImportRootPath_Dropbox];
                        
                        if(rootFolderPath==nil)
                        {
                            rootFolderPath = WCCloudFileDefine_ExchangeDirPath;
                        }
                        
                        storageFileSelectViewController.defaultRootFilePath = rootFolderPath;
                    }
                    else if(storageSpaceSelectControllerSpaceType==PPStorageFileSelectViewControllerSpaceType_Huawei)
                    {
                        storageFileSelectViewController.autoDownload         = NO;
                        storageFileSelectViewController.controllerTitle      = PSSSVC_MLS_Huawei;
                        storageFileSelectViewController.storageFileSelectViewControllerSpaceType = PPStorageFileSelectViewControllerSpaceType_Huawei;
                        
                        //////////////////////////////////////////////////
                        
                        NSString *rootFolderPath = [PPSettingsController stringValueWithKey:WCImportFlowControllerImportRootPath_Hwawei];
                        
                        if(rootFolderPath==nil)
                        {
                            NSMutableArray *components = [NSMutableArray arrayWithArray:[WCCloudFileDefine_ExchangeDirPath pathComponents]];
                            
                            [components removeObjectAtIndex:1];
                            
                            rootFolderPath = [NSString pathWithComponents:components];
                        }
                        
                        storageFileSelectViewController.defaultRootFilePath = rootFolderPath;
                    }
                    else if(storageSpaceSelectControllerSpaceType==PPStorageFileSelectViewControllerSpaceType_GoogleDrive)
                    {
                        storageFileSelectViewController.autoDownload         = NO;
                        storageFileSelectViewController.controllerTitle      = PSSSVC_MLS_GoogleDrive;
                        storageFileSelectViewController.storageFileSelectViewControllerSpaceType = PPStorageFileSelectViewControllerSpaceType_GoogleDrive;
                        
                        //////////////////////////////////////////////////
                        
                        NSString *rootFolderPath = [PPSettingsController stringValueWithKey:WCImportFlowControllerImportRootPath_GoogleDrive];
                        
                        if(rootFolderPath==nil)
                        {
                            rootFolderPath = WCCloudFileDefine_ExchangeDirPath;
                        }
                        
                        storageFileSelectViewController.defaultRootFilePath = rootFolderPath;
                    }
                    else if(storageSpaceSelectControllerSpaceType==PPStorageFileSelectViewControllerSpaceType_OneDrive)
                    {
                        storageFileSelectViewController.autoDownload         = NO;
                        storageFileSelectViewController.controllerTitle      = PSSSVC_MLS_OneDrive;
                        storageFileSelectViewController.storageFileSelectViewControllerSpaceType = PPStorageFileSelectViewControllerSpaceType_OneDrive;
                        
                        //////////////////////////////////////////////////
                        
                        NSString *rootFolderPath = [PPSettingsController stringValueWithKey:WCImportFlowControllerImportRootPath_OneDrive];
                        
                        if(rootFolderPath==nil)
                        {
                            rootFolderPath = WCCloudFileDefine_ExchangeDirPath;
                        }
                        
                        storageFileSelectViewController.defaultRootFilePath = rootFolderPath;
                    }
                    else if(storageSpaceSelectControllerSpaceType==PPStorageFileSelectViewControllerSpaceType_iCloud)
                    {
                        storageFileSelectViewController.autoDownload         = NO;
                        storageFileSelectViewController.controllerTitle      = PSSSVC_MLS_iCloud;
                        storageFileSelectViewController.storageFileSelectViewControllerSpaceType = PPStorageFileSelectViewControllerSpaceType_iCloud;
                        
                        //////////////////////////////////////////////////
                        
                        NSString *rootFolderPath = [PPSettingsController stringValueWithKey:WCImportFlowControllerImportRootPath_iCloud];
                        
                        if(rootFolderPath==nil)
                        {
                            rootFolderPath = WCCloudFileDefine_ExchangeDirPath;
                        }
                        
                        storageFileSelectViewController.defaultRootFilePath = rootFolderPath;
                        
                    }
                    else
                    {
                        storageFileSelectViewController.controllerTitle      = PSSSVC_MLS_iTune;
                        storageFileSelectViewController.storageFileSelectViewControllerSpaceType = PPStorageFileSelectViewControllerSpaceType_iTune;
                        
                        //////////////////////////////////////////////////
                        
                        NSString *rootFolderPath = [PPSettingsController stringValueWithKey:WCImportFlowControllerImportRootPath_iTune];
                        
                        if(rootFolderPath==nil)
                        {
                            rootFolderPath = WCCloudFileDefine_FileSharingDirPath;
                        }
                        
                        storageFileSelectViewController.defaultRootFilePath = rootFolderPath;
                    }
                    
                    storageFileSelectViewController.headerTitleLabelText = WCIFC_MLS_SelectImportContactData;
                    
                    storageFileSelectViewController.delegate = self;
                    storageFileSelectViewController.datasource = self;
                    
                    storageFileSelectViewController.extensionFileNameArray = @[@"wcxf",@"vcf"];
                    storageFileSelectViewController.sectionTitleDictionary = @{@"wcxf":PPSFSV_MLS_WCXFSectionTitle,
                                                                               @"vcf":PPSFSV_MLS_VCardSectionTitle};
                    
                    storageFileSelectViewController.tableViewCellHeight    = WCIFC_PPStorageFileSelectTableViewCellHeight;
                    
                    [superViewController.navigationController pushViewController:storageFileSelectViewController animated:YES];
                }
                
                self.storageFileSelectViewController = storageFileSelectViewController;
                
                [storageFileSelectViewController release];
                
                break;
            }
            case PPStorageSpaceSelectControllerSpaceType_AddressBook:
            {
                if([self.importFlowDatasource respondsToSelector:@selector(importFlowControllerEastDisplayNameOrder)]==YES)
                {
                    [WCABItemSelectFlowController sharedInstance].eastDisplayNameOrder = [self.importFlowDatasource importFlowControllerEastDisplayNameOrder];
                }
                else
                {
                    [WCABItemSelectFlowController sharedInstance].eastDisplayNameOrder = WCDisplayNameOrder_FirstLast;
                }
                
                //////////////////////////////////////////////////
                
                if([self.importFlowDatasource respondsToSelector:@selector(importFlowControllerWestDisplayNameOrder)]==YES)
                {
                    [WCABItemSelectFlowController sharedInstance].westDisplayNameOrder = [self.importFlowDatasource importFlowControllerWestDisplayNameOrder];
                }
                else
                {
                    [WCABItemSelectFlowController sharedInstance].westDisplayNameOrder = WCDisplayNameOrder_LastFirst;
                }
                
                //////////////////////////////////////////////////
                
                [WCABItemSelectFlowController showGroupViewControllerWithABSelectFlowControllerMode:WCABItemSelectFlowControllerMode_SystemContactToAp
                                                                     abSelectFlowControllerDelegate:self
                                                                                    syncAccountName:nil
                                                                            fromSuperViewController:superViewController];
                
                
                break;
            }
            default:
            {
                break;
            }
        }
    }
    while (0);
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private Create Folder Progress Method

//================================================================================
//
//================================================================================
- (void)autoCreateFolderWithStorageSpaceSelectControllerSpaceType:(PPStorageSpaceSelectControllerSpaceType)storageSpaceSelectControllerSpaceType
{
    switch (storageSpaceSelectControllerSpaceType)
    {
        case PPStorageSpaceSelectControllerSpaceType_Baidu:
        {
            
            break;
        }
        case PPStorageSpaceSelectControllerSpaceType_AddressBook:
        {
            break;
        }
        case PPStorageSpaceSelectControllerSpaceType_Dropbox:
        {
            [PPCloudController createFolder:WCCloudFileDefine_ExchangeDirPath
                                   delegate:self
                                   userInfo:nil
                                 cloudClass:[PPCloud_Dropbox class]];
            break;
        }
        case PPStorageSpaceSelectControllerSpaceType_GoogleDrive:
        {
            [PPCloudController createFolder:WCCloudFileDefine_ExchangeDirPath
                                   delegate:self
                                   userInfo:nil
                                 cloudClass:[PPCloud_GoogleDrive class]];
            break;
        }
        case PPStorageSpaceSelectControllerSpaceType_OneDrive:
        {
            [PPCloudController createFolder:WCCloudFileDefine_ExchangeDirPath
                                   delegate:self
                                   userInfo:nil
                                 cloudClass:[PPCloud_OneDrive class]];
            break;
        }
//        case PPStorageSpaceSelectControllerSpaceType_Huawei:
//        {
//            [PPCloudController createFolder:WCCloudFileDefine_ExchangeDirPath
//                                   delegate:self
//                                   userInfo:nil
//                                 cloudClass:[PPCloud_Huawei class]];
//            break;
//        }
        case PPStorageSpaceSelectControllerSpaceType_iCloud:
        {
            [PPCloudController createFolder:WCCloudFileDefine_ExchangeDirPath
                                   delegate:self
                                   userInfo:nil
                                 cloudClass:[PPCloud_iCloud class]];
            
            break;
        }
        case PPStorageSpaceSelectControllerSpaceType_iTune:
        {
            // do nothing
            break;
        }
        case PPStorageSpaceSelectControllerSpaceType_Specific:
        {
            // do nothing
            break;
        }
        default:
        {
            break;
        }
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private Import File Progress Method

//================================================================================
//
//================================================================================
- (void)importProgressWithSelectedFilePathArray:(NSArray <NSString *> *)selectedFileArray
{
    // MARK: 匯入檔案流程
    [self showBusyView:YES];
    
    //////////////////////////////////////////////////
    
    __block NSError *error = nil;
    __block typeof(self) blockself = self;
    
    __block NSBlockOperation *blockOperation = [NSBlockOperation blockOperationWithBlock:^{
        do
        {
            NSMutableArray *wcxfArray = [NSMutableArray array];
            
            if(wcxfArray==nil)
            {
                break;
            }
            
            //////////////////////////////////////////////////
            
            NSMutableArray *vcfArray = [NSMutableArray array];
            
            if(vcfArray==nil)
            {
                break;
            }
            
            //////////////////////////////////////////////////
            
            blockself.progressModel.denominator = 0;
            
            //////////////////////////////////////////////////
            
            //清除上次錯誤
            blockself.lastError = nil;
            
            //////////////////////////////////////////////////
            
            for(NSString *filePath in selectedFileArray)
            {
                if([[NSFileManager defaultManager] fileExistsAtPath:filePath]==NO)
                {
                    // 正常操作不會進來
                    error = PPErrorMake(WCImportFlowControllerErrorCode_FileNotFound, @"File Not Found", error);
                    break;
                }
                
                //////////////////////////////////////////////////
                
                NSString *extentionFile = [filePath pathExtension];
                
                //wcxf card
                if([extentionFile compare:@"wcxf"]==NSOrderedSame)
                {
                    [wcxfArray addObject:filePath];
                    
                    //////////////////////////////////////////////////
                    
                    WCXFRootInfoModel *rootInfoModel = [blockself.wcxfDataController rootInfoOfFile:filePath error:&error];
                    
                    if(rootInfoModel!=nil)
                    {
                        blockself.progressModel.denominator+=rootInfoModel.cardCount;
                    }
                    else
                    {
                        // MARK: wcxf讀檔失敗
                        break;
                    }
                }
                // vCard
                else if([extentionFile compare:@"vcf"]==NSOrderedSame)
                {
                    [WCVCFDataController checkAccessPermissionWithCompletion:^(BOOL authorized) {
                    }];
                    
                    while ([CNContactStore authorizationStatusForEntityType:CNEntityTypeContacts]==CNAuthorizationStatusNotDetermined)
                    {
                        [NSThread sleepForTimeInterval:0.01];
                    }
                    
                    //////////////////////////////////////////////////
                    WCVCFDataController *vcfDataController = [[WCVCFDataController alloc] initWithError:&error];
                    
                    if(vcfDataController==nil)
                    {
                        break;
                    }
                    
                    //////////////////////////////////////////////////
                    
                    // TODO: 日文版要產生發音
                    WCCardModel *cardModel = [vcfDataController readFileWithPath:filePath generateHiragana:YES error:&error];
                    
                    [vcfDataController release];
                    
                    if(cardModel!=nil)
                    {
                        [vcfArray addObject:cardModel];
                        blockself.progressModel.denominator++;
                    }
                    else
                    {
                        // TODO: vCard轉換失敗
                        break;
                    }
                }
                
                //////////////////////////////////////////////////
                
                if(blockOperation.cancelled==YES)
                {
                    error = PPErrorOperationCancel(error);
                    break;
                }
                
                // for loop end
            }
            
            //////////////////////////////////////////////////
            
            if(error!=nil)
            {
                // avoid dispatch_asncy error release
                [error retain];
                break;
            }
            
            //////////////////////////////////////////////////
            
            [PPBusyView postMessage:[NSString stringWithFormat:@"%@ 0%%",WCIFC_MLS_ParsingData]];
            
            blockself.updateProgress = 0;
            blockself.progressModel.numerator = 0;
            
            //////////////////////////////////////////////////
            
            //從 vcf 開始丟
            
            for(WCCardModel *vcfCardModel in vcfArray)
            {
                if([blockself.importFlowDelegate respondsToSelector:@selector(importFlowRequestImportWithWCCardModel:idPhotoImage:frontSideImage:backSideImage:error:)]==YES)
                {
                    //加入群組選擇
                    [vcfCardModel addGroupID:blockself.importedGroupID];
                    
                    //////////////////////////////////////////////////
                    
                    if([blockself.importFlowDelegate importFlowRequestImportWithWCCardModel:vcfCardModel
                                                                               idPhotoImage:nil
                                                                             frontSideImage:nil
                                                                              backSideImage:nil
                                                                                      error:&error]==NO)
                    {
                        break;
                    }
                }
                
                //////////////////////////////////////////////////
                
                //告知進度
                if([blockself.importFlowDelegate respondsToSelector:@selector(importFlowImportTaskAtIndex:totalCount:)]==YES)
                {
                    [blockself.importFlowDelegate importFlowImportTaskAtIndex:[vcfArray indexOfObject:vcfCardModel] totalCount:blockself.progressModel.denominator];
                }
                
                //////////////////////////////////////////////////
                
                if(blockself.progressModel!=nil)
                {
                    blockself.progressModel.numerator++;
                    
                    //不要每次一直丟
                    if([blockself.progressModel progress]>(blockself.updateProgress+0.01) ||blockself.progressModel.progress==1)
                    {
                        blockself.updateProgress = [blockself.progressModel progress];
                        
                        [PPBusyView postMessage:[NSString stringWithFormat:@"%@ %d%%",WCIFC_MLS_ParsingData,(int)(self.progressModel.progress*100)]];
                    }
                }
            };
            
            //////////////////////////////////////////////////
            
            // 從wcxf 開始丟
            for(NSString *wcxfFilePath in wcxfArray)
            {
                if([self.wcxfDataController readFileWithPath:wcxfFilePath error:&error]==NO)
                {
                    break;
                }
                else if(blockOperation.isCancelled==YES)
                {
                    error = PPErrorOperationCancel(error);
                    
                    break;
                }
                else if(self.lastError!=nil)
                {
                    error = self.lastError;
                    
                    break;
                }
            }
            
            //////////////////////////////////////////////////
            
            if(error!=nil)
            {
                [error retain];
                break;
            }
            
            //////////////////////////////////////////////////
            
            blockself.cardModel = nil;
            blockself.idPhotoImage = nil;
            blockself.frontCardImage = nil;
            blockself.rearCardImage = nil;
            
            //////////////////////////////////////////////////
            
            // while loop end
        }
        while (0);
        
        //////////////////////////////////////////////////
        
        dispatch_async(dispatch_get_main_queue(), ^{
            
            [blockself showBusyView:NO];
            
            //////////////////////////////////////////////////
            
            [[UIApplication sharedApplication] enableIdle:YES];
            
            //////////////////////////////////////////////////
            
            [blockself mainthreadSendFininishedWithError:error message:WCIFC_MLS_ImportFileSuccess];
            
            //////////////////////////////////////////////////
            
            [error release];
        });
        
        
    }];
    
    //////////////////////////////////////////////////
    
    if(blockOperation!=nil)
    {
        [[UIApplication sharedApplication] enableIdle:NO];
        
        //////////////////////////////////////////////////
        
        [self.workOperatinQueue cancelAllOperations];
        [self.workOperatinQueue addOperation:blockOperation];
    }
    else
    {
        error = PPErrorParameterInvalidity(error);
        
        [self mainthreadSendFininishedWithError:error message:nil];
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private Import ABPeople Method

//================================================================================
//
//================================================================================
- (void)importABPeoplesFromABCardModels:(NSArray *)abCardModels
{
    // MARK: 匯入連絡人流程
    [self showBusyView:YES];
    
    //////////////////////////////////////////////////
    
    __block NSError *error = nil;
    __block typeof(self) blockself = self;
    
    __block NSBlockOperation *blockOperation = [NSBlockOperation blockOperationWithBlock:^{
        do
        {
            self.progressModel.denominator = abCardModels.count;
            
            //////////////////////////////////////////////////
            
            //清除上次錯誤
            self.lastError = nil;
            
            //////////////////////////////////////////////////
            
            [PPBusyView postMessage:[NSString stringWithFormat:@"%@ 0%%",WCIFC_MLS_ParsingData]];
            
            blockself.updateProgress = 0;
            blockself.progressModel.numerator = 0;
            
            //////////////////////////////////////////////////
            
            if([blockself.importFlowDelegate respondsToSelector:@selector(importFlowRequestImportWithWCABCardModel:error:)]==YES)
            {
                for(id object in abCardModels)
                {
                    @autoreleasepool
                    {
                        [object addGroupID:self.importedGroupID];
                        
                        //////////////////////////////////////////////////
                        
                        if([blockself.importFlowDelegate respondsToSelector:@selector(importFlowImportTaskAtIndex:totalCount:)]==YES)
                        {
                            [blockself.importFlowDelegate importFlowImportTaskAtIndex:[abCardModels indexOfObject:object]
                                                                           totalCount:abCardModels.count];
                        }
                        
                        //////////////////////////////////////////////////
                        
                        if([blockself.importFlowDelegate importFlowRequestImportWithWCABCardModel:object  error:&error]==NO)
                        {
                            [error retain];
                            
                            break;
                        }
                        
                        //////////////////////////////////////////////////
                        
                        if(blockself.progressModel!=nil)
                        {
                            blockself.progressModel.numerator++;
                            
                            //不要每次一直丟
                            if([blockself.progressModel progress]>(blockself.updateProgress+0.01) ||blockself.progressModel.progress==1)
                            {
                                blockself.updateProgress = [blockself.progressModel progress];
                                
                                [PPBusyView postMessage:[NSString stringWithFormat:@"%@ %d%%",WCIFC_MLS_ParsingData,(int)(self.progressModel.progress*100)]];
                            }
                        }
                        // auto releasepool end
                    }
                }
            }
            // while loop end
        }
        while (0);
        
        //////////////////////////////////////////////////
        
        dispatch_async(dispatch_get_main_queue(), ^{
            
            [blockself showBusyView:NO];
            
            //////////////////////////////////////////////////
            
            [[UIApplication sharedApplication] enableIdle:YES];
            
            //////////////////////////////////////////////////
            
            [blockself mainthreadSendFininishedWithError:[error autorelease]
                                                 message:WCIFC_MLS_ImportContactSuccess];
            
        });
    }];
    
    //////////////////////////////////////////////////
    
    if(blockOperation!=nil)
    {
        [[UIApplication sharedApplication] enableIdle:NO];
        
        //////////////////////////////////////////////////
        
        [self.workOperatinQueue cancelAllOperations];
        [self.workOperatinQueue addOperation:blockOperation];
    }
    else
    {
        [blockself showBusyView:NO];
        
        //////////////////////////////////////////////////
        
        error = PPErrorParameterInvalidity(error);
        
        //////////////////////////////////////////////////
        
        [self mainthreadSendFininishedWithError:error message:nil];
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

//================================================================================
//
//================================================================================
- (BOOL)showStorageSpaceViewControllerWithCloudKeyDictionary:(NSDictionary *)cloudKeyDictionary
                                              spaceTypeArray:(NSArray *)spaceTypeArray
                                         superViewController:(UIViewController *)superViewController
{
    BOOL result = NO;
    
    do
    {
        if(superViewController==nil ||
           cloudKeyDictionary==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        PPStorageSpaceSelectViewController *storageSpaceSelectViewController = [[PPStorageSpaceSelectViewController alloc] init];
        
        if(storageSpaceSelectViewController==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        self.superViewController = superViewController;
        
        //////////////////////////////////////////////////
        
        storageSpaceSelectViewController.delegate = self;
        storageSpaceSelectViewController.cloudKeyDictionary = cloudKeyDictionary;
        storageSpaceSelectViewController.spaceTypeSelectArray = spaceTypeArray;
        storageSpaceSelectViewController.tableViewcellHeight  = WCIFC_PPStorageSpaceSelectTableViewCellHeight;
        storageSpaceSelectViewController.navigationViewButtonHighlightedBackgroundColor = WCIFC_PPStorageSpaceSelectImportButtonBackgroundHighlightedColor;
        
        storageSpaceSelectViewController.tableViewCellHighlightedBackgroundColor = WCIFC_PPTableViewCellHighlightedBackgroundColor;
        
        storageSpaceSelectViewController.tableViewCellNormalTextColor = WCIFC_PPTableViewCellTextNormalColor;
        storageSpaceSelectViewController.tableViewCellNormalDetailTextColor = WCIFC_PPTableViewCellDetailTextNormalColor;
        storageSpaceSelectViewController.tableViewSeperatorColor = WCIFC_PPTableViewSeparatorColor;
        
        storageSpaceSelectViewController.navigationBarButtonImageInsets = WCIFC_PPStorageSpaceSelectImportButtonImageEdgeInsets;
        
        //////////////////////////////////////////////////
        
        PPNavigationController *navigationController = [[PPNavigationController alloc] initWithRootViewController:storageSpaceSelectViewController];
        
        self.storageSpaceSelectViewController = storageSpaceSelectViewController;
        [storageSpaceSelectViewController release];
        
        if(navigationController==nil)
        {
            break;
        }
        
        [superViewController presentViewController:navigationController
                                          animated:YES
                                        completion:nil];
        
        [navigationController release];
        
        //////////////////////////////////////////////////
        
        result = YES;
    }
    while (0);
    
    return result;
}


//================================================================================
//
//================================================================================
- (BOOL)showGroupViewControllerWithSuperViewController:(UIViewController *)superViewController fileListArray:(NSArray <NSString *> *)fileListArray
{
    BOOL result = NO;
    
    do
    {
        // MARK: 檔案選擇完，進入選擇匯入類別
        PPLogFunction(@"%s, didSelectedFileInfoArray:%@",__func__,fileListArray);
        
        //////////////////////////////////////////////////
        
        // 已是單選，選WCXF,VCard 要選擇類別
        
        NSString *filePath = [fileListArray lastObject];
        
        GroupViewControllerMode mode = NSUIntegerMax;
        
        if([[filePath pathExtension] compare:@"vcf"]==NSOrderedSame)
        {
            mode = GroupViewControllerMode_VCF;
        }
        else if([[filePath pathExtension] compare:@"wcxf"]==NSOrderedSame)
        {
            mode = GroupViewControllerMode_WCXF;
        }
        
        //////////////////////////////////////////////////
        
        self.superViewController = superViewController;
        
        //////////////////////////////////////////////////
        
        if(mode==GroupViewControllerMode_VCF ||
           mode==GroupViewControllerMode_WCXF)
        {
            self.selectedResultList = fileListArray;
            
            //////////////////////////////////////////////////
            
            GroupViewController *groupViewController = [[GroupViewController alloc] init];
            
            if(groupViewController==nil)
            {
                break;
            }
            
            //////////////////////////////////////////////////
            
            groupViewController.datasource = self;
            groupViewController.delegate = self;
            groupViewController.groupViewControllerMode = mode;
            
            if(superViewController.navigationController!=nil)
            {
                [superViewController.navigationController pushViewController:groupViewController animated:YES];
            }
            else
            {
                PPNavigationController *navigationController = [[PPNavigationController alloc] initWithRootViewController:groupViewController];
                
                if(navigationController!=nil)
                {
                    [superViewController presentViewController:navigationController
                                                      animated:YES
                                                    completion:nil];
                }
                
                [navigationController release];
            }
            
            //////////////////////////////////////////////////
            
            self.groupViewController = groupViewController;
            
            [groupViewController release];
        }
        else
        {
            self.importedGroupID = WC_GID_Unverified;
            
            //////////////////////////////////////////////////
            
            [self importProgressWithSelectedFilePathArray:fileListArray];
        }
        
        //////////////////////////////////////////////////
        
        result = YES;
    }
    while (0);
    
    return result;
}
@end
