//
//  GroupViewController.m
//  
//
//  Created by Howard on 2015/9/15.
//
//

#import "GroupViewController.h"

// Define
#import "WCAppearanceDefine.h"
#import "WCGroupDefine.h"

// Model
#import "WCGroupModel.h"

// View
#import "PPButton+Factory.h"
#import "PPTableView.h"
#import "PPNavigationBarView.h"
#import "WCGroupView.h"

// Controller
#import "PPSectionController.h"

// Category
#import "GroupViewController+ResourceDefine.h"
#import "UIViewController+ShareApplication.h"
#import "NSObject+PPBusyView.h"



////////////////////////////////////////////////////////////////////////////////////////////////////
typedef NS_ENUM(NSInteger, GroupViewControllerImportMethodsID)
{
    GroupViewControllerImportMethodsID_KeepOriginal = 0,
    GroupViewControllerImportMethodsID_AssignCategory,
};

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Interface

@interface GroupViewController () <PPButtonDelegate, WCGroupViewDelegate, WCGroupViewDataSource>


@property (nonatomic,retain) NSArray             *layoutConstraints;
@property (nonatomic,retain) PPSectionController *groupSectionController;
@property (nonatomic,retain) PPNavigationBarView *navigationBarView;
@property (nonatomic,retain) PPButton            *backButton;
@property (nonatomic,retain) PPButton            *importButton;
@property (nonatomic,retain) WCGroupView         *importMethodsTableView;
@property (nonatomic,retain) WCGroupView         *groupTableView;
@property (nonatomic,retain) UILabel             *groupTableHeaderView;
@property (nonatomic,retain) UILabel             *importMethodsTableHeaderView;
@property (nonatomic,retain) NSMutableArray      *importMethodsData;
@property (nonatomic,retain) NSMutableArray      *categoryData;
@property (nonatomic,assign) BOOL                showCategory;
@property (nonatomic,retain) WCGroupModel        *lastSelectedImportMethod;
@property (nonatomic,retain) WCGroupModel        *lastSelectedCategoryModel;
@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation GroupViewController

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Dellocating Object

//================================================================================
//
//================================================================================
- (id)init
{
    if(self=[super init])
    {
        _groupSectionController = [[PPSectionController alloc] init];
        
        _importMethodsData = [[NSMutableArray alloc] init];
        _categoryData = [[NSMutableArray alloc] init];
    }
    
    return self;
}


//================================================================================
//
//================================================================================
- (void)dealloc
{
    _datasource = nil;
    _delegate = nil;

    [_groupSectionController release];
    _groupSectionController = nil;
    
    [_layoutConstraints release];
    _layoutConstraints = nil;

    [self removeMainUI];

    [_importMethodsData release];
    _importMethodsData = nil;
    
    [_categoryData release];
    _categoryData = nil;
    
    [_lastSelectedImportMethod release];
    _lastSelectedImportMethod = nil;
    
    [_lastSelectedCategoryModel release];
    _lastSelectedCategoryModel = nil;
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Respoinding to View's Event

//================================================================================
//
//================================================================================
- (void)viewWillAppear:(BOOL)animated
{
    [super viewWillAppear:animated];

    self.backgroundImageView.image = [UIImage imageWithColor:[UIColor whiteColor]];
    //////////////////////////////////////////////////
    [self prepareMainUI];
    
    //////////////////////////////////////////////////
    [self loadSectionModels];
    
    if(self.groupViewControllerMode==GroupViewControllerMode_VCF ||
       self.groupViewControllerMode==GroupViewControllerMode_ABPeople)
    {
        self.lastSelectedImportMethod = [self.importMethodsData firstObject];
    }
    else
    {
        self.lastSelectedCategoryModel = [self.categoryData firstObject];
    }


}


//================================================================================
//
//================================================================================
- (void)viewDidDisappear:(BOOL)animated
{
    [self removeMainUI];
    //////////////////////////////////////////////////
    
    [super viewDidDisappear:animated];
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Private prepare UI


//==============================================================================
//
//==============================================================================
- (void)prepareMainUI
{
    //////////////////////////////////////////////////
    self.importMethodsTableHeaderView = [self tableHeaderViewWithTitle:[@" " stringByAppendingString:WCIFC_MLS_SelectImportMethod]];
    [self.view addSubview: self.importMethodsTableHeaderView];
    
    self.groupTableHeaderView = [self tableHeaderViewWithTitle:[@" " stringByAppendingString:WCIFC_MLS_SelectImportClass]];
    [self.view addSubview: self.groupTableHeaderView];
    
    //////////////////////////////////////////////////
    self.importMethodsTableView = [[[WCGroupView alloc] initWithFrame:self.view.bounds] autorelease];
    
    if(self.importMethodsTableView!=nil)
    {
        self.importMethodsTableView.tag = GroupViewControllerTableViewTag_Method;
        self.importMethodsTableView.dataSource = self;
        self.importMethodsTableView.delegate = self;
        self.importMethodsTableView.allowMultiSelection = NO;
        
        [self.importMethodsTableView setSrollEnabled:NO];
        [self.importMethodsTableView setTranslatesAutoresizingMaskIntoConstraints:NO];
        [self.importMethodsTableView setStyle:WCGroupViewStyle_NameWithCheckBox];
        [self.importMethodsTableView setBackgroundColor:[UIColor whiteColor]];
        
//        [self.importMethodsTableView setEditing:YES];
//        [self.importMethodsTableView.treeView setAllowsSelectionDuringEditing:YES];
//        [self.importMethodsTableView.treeView setAllowsMultipleSelectionDuringEditing:NO];
//
        [self.importMethodsTableView.treeView setSeparatorColor:WCAppearanceDefine_SeparatorColor];
        [self.view addSubview:self.importMethodsTableView];
    }
    
    self.groupTableView = [[[WCGroupView alloc] initWithFrame:self.view.bounds] autorelease];
    
    if(self.groupTableView!=nil)
    {
        self.groupTableView.tag = GroupViewControllerTableViewTag_Category;
        self.groupTableView.dataSource = self;
        self.groupTableView.delegate = self;
        self.groupTableView.allowMultiSelection = NO;

        [self.groupTableView setTranslatesAutoresizingMaskIntoConstraints:NO];
        [self.groupTableView setStyle:WCGroupViewStyle_NameWithCheckBox];
        [self.groupTableView setBackgroundColor:[UIColor whiteColor]];
        
//        [self.groupTableView setEditing:YES];
//        [self.groupTableView.treeView setAllowsSelectionDuringEditing:YES];
//        [self.groupTableView.treeView setAllowsMultipleSelectionDuringEditing:NO];

        [self.groupTableView.treeView setSeparatorColor:WCAppearanceDefine_SeparatorColor];
        
        [self.view addSubview:self.groupTableView];
    }
    
    //////////////////////////////////////////////////
    
    self.backButton = [PPButton ppButtonWithSystemBackImitation];
    
    if(self.backButton!=nil)
    {
        self.backButton.delegate = self;
        [self.backButton addControlEvents:UIControlEventTouchUpInside];
        
        //////////////////////////////////////////////////
        
        self.backButton.imageEdgeInsets = WCAppearanceDefine_ButtonImageEdgeInset;
        [self.backButton setBackgroundImage:[UIImage imageWithColor:WCAppearanceDefine_ButtonBackgroundColor] forState:UIControlStateHighlighted];
        
        //////////////////////////////////////////////////
        
        if(self.navigationController.childViewControllers.count<=1)
        {
            self.backButton.hidden = YES;
        }
    }
    
    //////////////////////////////////////////////////
    
    self.importButton = [PPButton ppButtonWithIconImageName:ImageNameGroupViewControllerButtonImport
                                                        tag:GroupViewControllerButtonTag_Import
                                                   delegate:self
                                      normalBackgroundColor:nil
                                 highlightedBackgroundColor:WCAppearanceDefine_ButtonBackgroundColor
                                            imageEdgeInsets:WCAppearanceDefine_ButtonImageEdgeInset];
    
    //////////////////////////////////////////////////
    
    self.navigationBarView = [[[PPNavigationBarView alloc] initWithFrame:self.navigationController.navigationBar.bounds] autorelease];
    
    if(self.navigationBarView!=nil)
    {
        self.navigationBarView.titleLabel.text = WCIFC_MLS_ImportClass;
        
        self.navigationBarView.style = PPBarViewStyle_CenteredAbsolute;
        
        //////////////////////////////////////////////////
        
        PPBarViewItemModel *backItemModel = [PPBarViewItemModel ppBarViewItemModelWithView:self.backButton];
        
        if(backItemModel!=nil)
        {
            backItemModel.edgeInsetsForNormalBar = UIEdgeInsetsZero;
            [self.navigationBarView setItemModels:@[backItemModel] forBlockType:PPBarViewBlockType_Left];
        }
        
        //////////////////////////////////////////////////
        
        PPBarViewItemModel *importItemModel = [PPBarViewItemModel ppBarViewItemModelWithView:self.importButton];
        
        if(importItemModel!=nil)
        {
            importItemModel.edgeInsetsForNormalBar = UIEdgeInsetsZero;
            [self.navigationBarView setItemModels:@[importItemModel] forBlockType:PPBarViewBlockType_Right];
        }
        
        //////////////////////////////////////////////////
        
        self.navigationItem.leftBarButtonItem = [[[UIBarButtonItem alloc] initWithCustomView:self.navigationBarView] autorelease];
    }
    
    //////////////////////////////////////////////////
    
    if(self.groupViewControllerMode==GroupViewControllerMode_VCF ||
       self.groupViewControllerMode==GroupViewControllerMode_ABPeople)
    {
        // 只要顯示類別列表就好
        self.showCategory = YES;
        [self importMethodsTableViewHidden:YES];
        [self groupTableViewHidden:!self.showCategory];
    }
    else
    {
        self.showCategory = NO;
        [self importMethodsTableViewHidden:NO];
        [self groupTableViewHidden:!self.showCategory];
    }
    
    //////////////////////////////////////////////////
    [self resetLayoutConstraints];
}


//==============================================================================
//
//==============================================================================
- (void)removeMainUI
{
    self.importMethodsTableView.dataSource = nil;
    self.importMethodsTableView.delegate = nil;
    [self.importMethodsTableView removeFromSuperview];
    self.importMethodsTableView = nil;
    
    self.groupTableView.dataSource = nil;
    self.groupTableView.delegate = nil;
    [self.groupTableView removeFromSuperview];
    self.groupTableView = nil;
    
    [self.importMethodsTableHeaderView removeFromSuperview];
    self.importMethodsTableHeaderView = nil;
    
    [self.groupTableHeaderView removeFromSuperview];
    self.groupTableHeaderView = nil;
    
    
    //////////////////////////////////////////////////
    self.navigationItem.leftBarButtonItem = nil;
    self.navigationBarView = nil;
    self.importButton = nil;
    self.backButton = nil;

}



//==============================================================================
//
//==============================================================================
- (UILabel *)tableHeaderViewWithTitle:(NSString *)title
{
    UILabel *headerView = [[UILabel alloc] initWithFrame:CGRectMake(0, 0, self.view.bounds.size.width, PPBarViewDefaultHeightForNavigationBarNormal)];
    [headerView setTranslatesAutoresizingMaskIntoConstraints:NO];
    [headerView setFont:[UIFont systemFontOfSize:WCAppearanceDefine_SectionHeaderFontSize]];
    [headerView setTextColor:WCAppearanceDefine_SectionHeaderTitleColor];
    [headerView setBackgroundColor:WCAppearanceDefine_SectionHeaderBGColor];
    headerView.text = title;

    return [headerView autorelease];
}


//==============================================================================
//
//==============================================================================
- (void)importMethodsTableViewHidden:(BOOL)hidden
{
    self.importMethodsTableView.hidden = hidden;
    self.importMethodsTableHeaderView.hidden = hidden;
}


//==============================================================================
//
//==============================================================================
- (void)groupTableViewHidden:(BOOL)hidden
{
    self.groupTableView.hidden = hidden;
    self.groupTableHeaderView.hidden = hidden;
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - layout constraints


//==============================================================================
//
//==============================================================================
- (void)resetLayoutConstraints
{
    if(self.importMethodsTableView==nil||
       self.groupTableView==nil||
       self.importMethodsTableHeaderView==nil||
       self.groupTableHeaderView==nil)
    {
        return;
    }
    
    [self removeLayoutConstraints];
    //////////////////////////////////////////////////
    NSDictionary *views = @{@"importMethodsTableView":self.importMethodsTableView,
                            @"groupTableView":self.groupTableView,
                            @"importMethodsTableHeaderView":self.importMethodsTableHeaderView,
                            @"groupTableHeaderView":self.groupTableHeaderView
                            };
    
    NSInteger importMathodsTableViewHeight = PPBarViewDefaultHeightForNavigationBarNormal*2;
    NSDictionary *metrics = @{@"TableHeaderViewHeight":@(PPBarViewDefaultHeightForNavigationBarNormal),
                              @"ImportMathodsTableViewHeight":@(importMathodsTableViewHeight)
                              };
    
    NSMutableArray *layoutConstraints = [NSMutableArray array];
    

    NSMutableString *vertFormat = [NSMutableString string];
    
    if ([self.importMethodsTableView isHidden]==NO)
    {
        [layoutConstraints addObjectsFromArray:[NSLayoutConstraint constraintsWithVisualFormat:@"H:|[importMethodsTableView]|"
                                                                                       options:NSLayoutFormatDirectionLeftToRight
                                                                                       metrics:metrics
                                                                                         views:views]];

        [layoutConstraints addObjectsFromArray:[NSLayoutConstraint constraintsWithVisualFormat:@"H:|[importMethodsTableHeaderView]|"
                                                                                       options:NSLayoutFormatDirectionLeftToRight
                                                                                       metrics:metrics
                                                                                         views:views]];
        
        //  如果不用顯示類別，就不用限制高度
        if (self.showCategory==NO)
        {
            [vertFormat appendString:@"[importMethodsTableHeaderView(TableHeaderViewHeight)][importMethodsTableView]"];
        }
        else
        {
            [vertFormat appendString:@"[importMethodsTableHeaderView(TableHeaderViewHeight)][importMethodsTableView(ImportMathodsTableViewHeight)]"];
        }
    }

    // 如果沒有選擇匯入方式的group, 就一定要秀類別樹
    if(self.showCategory)
    {
        [layoutConstraints addObjectsFromArray:[NSLayoutConstraint constraintsWithVisualFormat:@"H:|[groupTableHeaderView]|"
                                                                                       options:NSLayoutFormatDirectionLeftToRight
                                                                                       metrics:metrics
                                                                                         views:views]];
        [layoutConstraints addObjectsFromArray:[NSLayoutConstraint constraintsWithVisualFormat:@"H:|[groupTableView]|"
                                                                                       options:NSLayoutFormatDirectionLeftToRight
                                                                                       metrics:metrics
                                                                                         views:views]];
        
        [vertFormat appendString:@"[groupTableHeaderView(TableHeaderViewHeight)][groupTableView]"];
    }
    
    NSLog(@"vertFormat:%@", vertFormat);
    
    if ([vertFormat length]>0)
    {
        [layoutConstraints addObjectsFromArray:[NSLayoutConstraint constraintsWithVisualFormat:[NSString stringWithFormat:@"V:|%@|", vertFormat]
                                                                                       options:NSLayoutFormatDirectionLeadingToTrailing
                                                                                       metrics:metrics
                                                                                         views:views]];
    }
    
    //////////////////////////////////////////////////
    if ([layoutConstraints count])
    {
        self.layoutConstraints = [NSArray arrayWithArray:layoutConstraints];
        [self.view addConstraints:self.layoutConstraints];
        [self.view layoutIfNeeded];
    }
}


//==============================================================================
//
//==============================================================================
- (void)removeLayoutConstraints
{
    if (self.layoutConstraints)
    {
        [self.view removeConstraints:self.layoutConstraints];
        self.layoutConstraints = nil;
    }
}





//////////////////////////////////////////////////////////////////////////////////////////////////////
//
//#pragma mark - Layout of subview
//
////================================================================================
////
////================================================================================
//- (void)layoutSubviews
//{
//    [super layoutSubviews];
//
//    //////////////////////////////////////////////////
//
//    self.groupTableView.frame = [self layoutFrame];
//}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private Method

//================================================================================
//
//================================================================================
- (void)loadSectionModels
{
    do
    {
        
        if ([self.datasource respondsToSelector:@selector(groupViewControllerWithAllGroupModelsWithCardID:)]==NO)
        {
            break;
        }
        
        __block typeof(self) blockSelf = self;
        [self setBusy:@(YES)];
        
        dispatch_async(dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_DEFAULT, 0), ^{
            
            NSMutableArray *groupModels = nil;
            NSMutableArray *importMethodsModels = nil;
            if(blockSelf.groupViewControllerMode==GroupViewControllerMode_VCF ||
               blockSelf.groupViewControllerMode==GroupViewControllerMode_ABPeople)
            {
                groupModels = [blockSelf.datasource groupViewControllerWithAllGroupModelsWithCardID:nil];
            }
            else
            {
                // 建立選擇匯入方式
                // 因為選項不會變，所以只建立一次
                if([blockSelf.importMethodsData count]==0)
                {
                    importMethodsModels = [NSMutableArray array];
                    WCGroupModel *groupModel = [[WCGroupModel alloc] init];
                    groupModel.ID = GroupViewControllerImportMethodsID_KeepOriginal;
                    groupModel.name = WCIFC_MLS_KeepClass;
                    [importMethodsModels addObject:groupModel];
                    [groupModel release];
                    
                    groupModel = [[WCGroupModel alloc] init];
                    groupModel.ID = GroupViewControllerImportMethodsID_AssignCategory;
                    groupModel.name = WCIFC_MLS_AssignTargetClass;
                    [importMethodsModels addObject:groupModel];
                    [groupModel release];
                }

                //////////////////////////////////////////////////
                groupModels = [blockSelf.datasource groupViewControllerWithAllGroupModelsWithCardID:nil];
            }

            
            //////////////////////////////////////////////////
            dispatch_async(dispatch_get_main_queue(), ^{
                
                //////////////////////////////////////////////////
                if([importMethodsModels count]>0)
                {
                    [blockSelf.importMethodsData removeAllObjects];
                    [blockSelf.importMethodsData addObjectsFromArray:importMethodsModels];
                    [blockSelf.importMethodsTableView reloadData];
                }
                
                //////////////////////////////////////////////////
                
                [blockSelf.categoryData removeAllObjects];
                [blockSelf.categoryData addObjectsFromArray:groupModels];
                
                [blockSelf.groupTableView reloadData];
                
                //////////////////////////////////////////////////
                if(blockSelf.groupViewControllerMode==GroupViewControllerMode_VCF ||
                   blockSelf.groupViewControllerMode==GroupViewControllerMode_ABPeople)
                {
                    // 只要顯示類別列表就好
                    [blockSelf importMethodsTableViewHidden:YES];
                    [blockSelf groupTableViewHidden:NO];
                }
                else
                {
                    [blockSelf importMethodsTableViewHidden:NO];
                    [blockSelf groupTableViewHidden:!self.showCategory];
                }
                
                [blockSelf setBusy:@(NO)];
            });
        });


    }
    while (0);
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPButtonDelegate 

//================================================================================
//
//================================================================================
- (void)ppButton:(PPButton *)ppButton controlEvent:(UIControlEvents)controlEvent
{
    switch (ppButton.tag)
    {
        case GroupViewControllerButtonTag_Back:
        {
            [self goBackAnimated:YES];
            break;
        }
        case GroupViewControllerButtonTag_Import:
        {
            do
            {
                //////////////////////////////////////////////////
                NSInteger groupID = WC_GID_None;
                WCGroupModel *groupModel = nil;;
                
                if (self.groupViewControllerMode==GroupViewControllerMode_WCXF)
                {
                    // !! 只有WCXF會有保留原本類別的流程
                    // 如果是GroupViewControllerImportMethodsID_KeepOriginal，groupID回傳WC_GID_None
                    if (self.lastSelectedImportMethod.ID==GroupViewControllerImportMethodsID_AssignCategory)
                    {
                        groupModel = self.lastSelectedCategoryModel;
                        
                        groupID = [groupModel ID];
                    }
                }
                else
                {
                    groupModel = self.lastSelectedCategoryModel;
                    
                    groupID = [groupModel ID];
                }

                
                //////////////////////////////////////////////////
                
                if([self.delegate respondsToSelector:@selector(groupViewController:didSelectGroupID:)]==YES)
                {
                    [self.delegate groupViewController:self didSelectGroupID:groupID];
                }
            }
            while (0);
            
            break;
        }
        default:
        {
            break;
        }
    }
}






////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - WCGroupViewDataSource


//==============================================================================
//
//==============================================================================
- (NSInteger)groupView:(nonnull WCGroupView *)groupView numberOfChildrenOfItem:(nullable id)item
{
    if (groupView.tag==GroupViewControllerTableViewTag_Method)
    {
        if (item==nil)
        {
            return [self.importMethodsData count];
        }
        else
        {
            return [[(WCGroupModel *)item subGroups] count];
        }
    }
    else
    {
        if (item==nil)
        {
            return [self.categoryData count];
        }
        else
        {
            return [[(WCGroupModel *)item subGroups] count];
        }
    }

}


//==============================================================================
//
//==============================================================================
- (nonnull id)groupView:(nonnull WCGroupView *)groupView child:(NSInteger)index ofItem:(nullable id)item
{
    if (groupView.tag==GroupViewControllerTableViewTag_Method)
    {
        if (item==nil)
        {
            return [self.importMethodsData objectAtIndex:index];
        }
        else
        {
            return [[(WCGroupModel *)item subGroups] objectAtIndex:index];
        }
    }
    else
    {
        if (item==nil)
        {
            return [self.categoryData objectAtIndex:index];
        }
        else
        {
            return [[(WCGroupModel *)item subGroups] objectAtIndex:index];
        }
    }

}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - WCGroupViewDelegate


//==============================================================================
//
//==============================================================================
- (void)didReloadDataWithGroupView:(nonnull WCGroupView *)groupView
{
    // !!設定預設值
    if (groupView.tag==GroupViewControllerTableViewTag_Method)
    {
        if (self.lastSelectedImportMethod==nil)
        {
            self.lastSelectedImportMethod = [self.importMethodsData firstObject];
        }
        
        if (self.lastSelectedImportMethod)
        {
            [groupView checkCellWithItem:self.lastSelectedImportMethod];
        }
    }
    else
    {
        // 預設勾選第一個
        if(self.lastSelectedCategoryModel==nil)
        {
            self.lastSelectedCategoryModel = [self.categoryData firstObject];
        }

        if(self.lastSelectedCategoryModel)
        {
            [groupView checkCellWithItem:self.lastSelectedCategoryModel];
        }
    }
}


//==============================================================================
//
//==============================================================================
- (void)groupView:(nonnull WCGroupView *)groupView didClickCell:(nonnull WCGroupTableViewCell *)cell
{
    if (groupView.tag==GroupViewControllerTableViewTag_Method)
    {
        self.lastSelectedImportMethod = [groupView.treeView itemForCell:cell];
        // TODO: 選到指定類別時要顯示類別樹
        self.showCategory = ([cell.nameLabel.text isEqualToString:WCIFC_MLS_AssignTargetClass]);

        if ([cell.nameLabel.text isEqualToString:WCIFC_MLS_AssignTargetClass])
        {
            self.lastSelectedCategoryModel = nil;
        }
        
        __block typeof(self) blockSelf = self;
        
        dispatch_async(dispatch_get_main_queue(), ^{
            
            blockSelf.groupTableHeaderView.alpha = (blockSelf.showCategory==NO)?0.0:1.0;
            blockSelf.groupTableView.alpha = (blockSelf.showCategory==NO)?0.0:1.0;

            [blockSelf resetLayoutConstraints];
            [blockSelf loadSectionModels];
        });
    }
    else
    {
        self.lastSelectedCategoryModel = [groupView.treeView itemForCell:cell];
    }
}




@end
