//
//  WCAddGroupViewController.m
//  Pods
//
//  Created by sanhue on 2016/9/14.
//
//

#import "WCAddOrEditGroupViewController.h"

//define
#import "WCAppearanceDefine.h"

//category
#import "NSString+Additions.h"
#import "PPButton+Factory.h"

//view
#import "PPTableView.h"
#import "PPNavigationBarView.h"
#import "PPTextFieldTableViewCell.h"
#import "WCToastController.h"
#import "PPSectionHeaderView.h"

NSString *const WCAddOrEditGroupViewControllerCellIdentifier = @"Cell";
NSInteger const WCAddOrEditGroupViewConrtollerSectionHeaderHeight = PPBarViewDefaultHeightForTabBar;
NSString *const WCAddOrEditGroupViewControllerButtonName_Done = @"GroupDone";

#define WCSLGVC @"WCSingleLayerGroupViewController"

// WCAddGroupViewController
#define WCAddOrEditGroupViewControllerString_PleaseInputGroupName [@"MLS_PleaseInputGroupName" localizedFromTable:WCSLGVC]
#define WCAddOrEditGroupViewControllerString_PlaceholderForAdd [@"MLS_PlaceHolderForAdd" localizedFromTable:WCSLGVC]
#define WCAddOrEditGroupViewControllerString_ExistSameGroupName [@"MLS_ExistSameGroupName" localizedFromTable:WCSLGVC]
#define WCAddOrEditGroupViewControllerString_MaxGroupLength [@"MLS_MaxGroupLength" localizedFromTable:WCSLGVC]
#define WCAddOrEditGroupViewControllerString_DefaultMessage @" "

// guide
#define WCAddOrEditGroupViewControllerString_AddGroupTitle [@"MLS_Title_AddGroup" localizedFromTable:WCSLGVC]
#define WCAddOrEditGroupViewControllerString_EditGroupTitle [@"MLS_Title_EditGroup" localizedFromTable:WCSLGVC]


typedef NS_ENUM(NSInteger, WCAddOrEditGroupViewControllerButtonTag)
{
    WCAddOrEditGroupViewControllerButtonTag_Back = 0,
    WCAddOrEditGroupViewControllerButtonTag_Add,
};

////////////////////////////////////////////////////////////////////////////////////////////////////
@interface WCAddOrEditGroupViewController () <PPButtonDelegate, PPTextFieldTableViewCellDelegate, UITableViewDataSource, UITableViewDelegate>

@property (nonatomic, retain) PPNavigationBarView *ppNavigationBarView;
@property (nonatomic, retain) PPButton *ppButtonBack;
@property (nonatomic, retain) PPButton *ppButtonDone;

@property (nonatomic, copy) GroupNameValidator groupNameValidator;
@property (nonatomic, copy) CompleteHandler completeHandler;
@property (nonatomic, assign) NSInteger maxLength;
@property (nonatomic, retain) NSString *currentGroupName;

@end

@implementation WCAddOrEditGroupViewController





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark
#pragma mark - init/dealloc methods


//==============================================================================
//
//==============================================================================
- (instancetype)init
{
    self = [super init];
    if (self)
    {
        self.maxLength = 10;
    }
    return self;
}


//==============================================================================
//
//==============================================================================
- (void)dealloc
{
    self.groupNameValidator = nil;
    self.completeHandler = nil;
    self.currentGroupName = nil;

    [self removeMainUI];
    //////////////////////////////////////////////////
    [super dealloc];
}








////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark
#pragma mark - view controller life cycle


//==============================================================================
//
//==============================================================================
- (void)viewWillAppear:(BOOL)animated
{
    [super viewWillAppear:animated];
    
    //////////////////////////////////////////////////
    
    [self prepareMainUI];
}


//==============================================================================
//
//==============================================================================
- (void)viewDidAppear:(BOOL)animated
{
    [super viewDidAppear:animated];
    
    //////////////////////////////////////////////////
}


//==============================================================================
//
//==============================================================================
- (void)viewWillDisappear:(BOOL)animated
{
    [[self inputField] resignFirstResponder];
    
    //////////////////////////////////////////////////
    
    [super viewWillDisappear:animated];
}


//==============================================================================
//
//==============================================================================
- (void)viewDidDisappear:(BOOL)animated
{
    [self removeMainUI];
    //////////////////////////////////////////////////
    
    [super viewDidDisappear:animated];
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark
#pragma mark - prepare ui


//==============================================================================
//
//==============================================================================
- (void)prepareMainUI
{
    if(self.ppButtonBack==nil)
    {
        self.ppButtonBack = [PPButton ppButtonWithIconImageName:ImageNamePPButtonIconForSystemBackImitation
                                                            tag:WCAddOrEditGroupViewControllerButtonTag_Back
                                                       delegate:self
                                          normalBackgroundColor:nil
                                     highlightedBackgroundColor:WCAppearanceDefine_ButtonBackgroundColor
                                                imageEdgeInsets:WCAppearanceDefine_ButtonImageEdgeInset];
    }
    
    if(self.ppButtonDone==nil)
    {
        self.ppButtonDone = [PPButton ppButtonWithIconImageName:WCAddOrEditGroupViewControllerButtonName_Done
                                                            tag:WCAddOrEditGroupViewControllerButtonTag_Add
                                                       delegate:self
                                          normalBackgroundColor:nil
                                     highlightedBackgroundColor:WCAppearanceDefine_ButtonBackgroundColor
                                                imageEdgeInsets:WCAppearanceDefine_ButtonImageEdgeInset];
    }
    //////////////////////////////////////////////////
    if(_ppNavigationBarView==nil)
    {
        _ppNavigationBarView = [[PPNavigationBarView alloc] initWithFrame:self.navigationController.navigationBar.bounds];
    }
    
    if (self.ppNavigationBarView)
    {
        
        [self.ppNavigationBarView setStyle:PPBarViewStyle_CenteredAbsolute];
        
        if([self.currentGroupName length]>0)
        {
            [self.ppNavigationBarView.titleLabel setText:WCAddOrEditGroupViewControllerString_EditGroupTitle];
        }
        else
        {
            [self.ppNavigationBarView.titleLabel setText:WCAddOrEditGroupViewControllerString_AddGroupTitle];
        }
        //////////////////////////////////////////////////
        if (self.ppButtonBack)
        {
            PPBarViewItemModel * itemModel = [PPBarViewItemModel ppBarViewItemModelWithView:self.ppButtonBack];
            itemModel.edgeInsetsForNormalBar = UIEdgeInsetsZero;
            
            [self.ppNavigationBarView  setItemModels:@[itemModel] forBlockType:PPBarViewBlockType_Left];
        }
        
        //////////////////////////////////////////////////
        if (self.ppButtonDone)
        {
            PPBarViewItemModel * itemModel = [PPBarViewItemModel ppBarViewItemModelWithView:self.ppButtonDone];
            itemModel.edgeInsetsForNormalBar = UIEdgeInsetsZero;
            
            [self.ppNavigationBarView  setItemModels:@[itemModel] forBlockType:PPBarViewBlockType_Right];
        }
        //////////////////////////////////////////////////
        if (self.navigationController!=nil)
        {
            self.navigationItem.leftBarButtonItem = [[[UIBarButtonItem alloc] initWithCustomView:self.ppNavigationBarView] autorelease];
        }
    }
    
    //////////////////////////////////////////////////
    if(self.ppTableView)
    {
        [self.ppTableView setTranslatesAutoresizingMaskIntoConstraints:NO];
        self.ppTableView.dataSource = self;
        self.ppTableView.delegate = self;
        
        [self.ppTableView setBackgroundColor:WCAppearanceDefine_SectionHeaderBGColor];
        [self.ppTableView setScrollEnabled:NO];
        self.ppTableView.separatorStyle = UITableViewCellSeparatorStyleNone;
        [self.ppTableView setSeparatorColor:WCAppearanceDefine_SeparatorColor];
        
        self.ppTableView.tableFooterView = [[[UIView alloc] init] autorelease];
        [self.ppTableView.tableFooterView setBackgroundColor:[UIColor clearColor]];
    }
}


//==============================================================================
//
//==============================================================================
- (void)removeMainUI
{
   
    //////////////////////////////////////////////////
    self.navigationItem.leftBarButtonItem = nil;
    
    self.ppNavigationBarView = nil;
    self.ppButtonBack = nil;
    self.ppButtonDone = nil;
    
}






////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Private


//==============================================================================
//
//==============================================================================
- (UITextField *)inputField
{
    return [(PPTextFieldTableViewCell *)[self.ppTableView cellForRowAtIndexPath:[NSIndexPath indexPathForRow:0 inSection:0]] textField];
}







////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Button action


//==============================================================================
//
//==============================================================================
- (void)onClickDone
{
    NSString *errorMessage = nil;
    
    do {
        NSString *groupName = [[self inputField] text];
        
        // 移掉後面的空白
        groupName = [groupName stringByTrimmingCharactersInSet:[NSCharacterSet whitespaceAndNewlineCharacterSet]];
        
        if([groupName length]>0)
        {
           
            //////////////////////////////////////////////////
            // !! 檢查群組名稱長度
            if (self.maxLength!=0 && self.maxLength<[groupName length])
            {
                errorMessage = [NSString stringWithFormat:WCAddOrEditGroupViewControllerString_MaxGroupLength, self.maxLength];
                break;
            }
            
            //////////////////////////////////////////////////
            // !!檢查是否重復
            if (self.groupNameValidator)
            {
                // !!如果名稱沒有改變，要當成合法名稱
                if([groupName isEqualToString:self.currentGroupName]==NO && self.groupNameValidator(groupName)==NO)
                {
                    errorMessage = WCAddOrEditGroupViewControllerString_ExistSameGroupName;
                    break;
                }
                else
                {
                    // 是合法名稱
                    if (self.completeHandler)
                    {
                        self.completeHandler(groupName);
                    }
                    
                    [self goBackAnimated:YES];
                }
            }
        }
        else
        {
            // !!groupName不能是空的
            errorMessage = WCAddOrEditGroupViewControllerString_PleaseInputGroupName;
            break;
        }

    } while (0);
    
    if([errorMessage length]>0)
    {
        [WCToastController showMessageToastFromSuperView:self.ppTableView
                                             withMessage:errorMessage
                                                position:PPToastPositionCenter];
    }
}







////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - PPButtonDelegate


//==============================================================================
//
//==============================================================================
- (void)ppButton:(PPButton *)ppButton controlEvent:(UIControlEvents)controlEvent
{
    switch (ppButton.tag)
    {
        case WCAddOrEditGroupViewControllerButtonTag_Back:
        {
            [self goBackAnimated:YES];
            break;
        }
        case WCAddOrEditGroupViewControllerButtonTag_Add:
        {
            [self onClickDone];
            break;
        }
        default:
            break;
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - UITableViewDataSource


//==============================================================================
//
//==============================================================================
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return 1;
}


//==============================================================================
//
//==============================================================================
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    PPTextFieldTableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:WCAddOrEditGroupViewControllerCellIdentifier];
    
    if (cell==nil)
    {
        cell = [[[PPTextFieldTableViewCell alloc] initCustomStyleWithReuseIdentifier:WCAddOrEditGroupViewControllerCellIdentifier] autorelease];
    }
    cell.delegate = self;
    cell.textField.placeholder = WCAddOrEditGroupViewControllerString_PlaceholderForAdd;
    [cell.textField becomeFirstResponder];
    
    if (self.currentGroupName)
    {
        [cell.textField setText:self.currentGroupName];
    }
    return cell;
}


//==============================================================================
//
//==============================================================================
- (NSString *)tableView:(UITableView *)tableView titleForHeaderInSection:(NSInteger)section
{
    return WCAddOrEditGroupViewControllerString_PlaceholderForAdd;
}


//==============================================================================
//
//==============================================================================
- (nullable UIView *)tableView:(UITableView *)tableView viewForHeaderInSection:(NSInteger)section
{
    PPSectionHeaderView *sectionHeaderView = [[[PPSectionHeaderView alloc] init] autorelease];
    sectionHeaderView.gap = 15;
    [sectionHeaderView setBackgroundColor:WCAppearanceDefine_SectionHeaderBGColor];
    sectionHeaderView.textLabel.text = WCAddOrEditGroupViewControllerString_PleaseInputGroupName;
    [sectionHeaderView.textLabel setTextColor:WCAppearanceDefine_SectionHeaderTitleColor];
    [sectionHeaderView.textLabel setFont:[UIFont systemFontOfSize:16]];
    
    return sectionHeaderView;
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - UITableViewDelegate


//==============================================================================
//
//==============================================================================
- (CGFloat)tableView:(UITableView *)tableView heightForHeaderInSection:(NSInteger)section
{
    return WCAddOrEditGroupViewConrtollerSectionHeaderHeight;
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - PPTextFieldTableViewCellDelegate



//==============================================================================
//
//==============================================================================
- (BOOL)ppTextFieldTableViewCellShouldReturn:(PPTextFieldTableViewCell *)textFieldTableViewCell
{
    [self onClickDone];
    return NO;
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - usage methods


//==============================================================================
//
//==============================================================================
+ (void)showAddGroupFromViewController:(UIViewController *)viewController
                         withMaxLength:(NSInteger)maxLength
                          currentGroup:(NSString *)currentGroup
                    groupNameValidator:(GroupNameValidator)groupNameValidator
                       completeHandler:(CompleteHandler)completeHandler
{
    WCAddOrEditGroupViewController *addGroupViewController = [[WCAddOrEditGroupViewController alloc] init];
    addGroupViewController.groupNameValidator = groupNameValidator;
    addGroupViewController.completeHandler = completeHandler;
    addGroupViewController.maxLength = maxLength;
    addGroupViewController.currentGroupName = currentGroup;
    
    /// !! 有編輯所以要強制不能下拉關閉
    if(@available(iOS 13, *))
    {
        [addGroupViewController setModalInPresentation:YES];
    }
    [viewController.navigationController pushViewController:addGroupViewController animated:YES];
    [addGroupViewController release];
}


@end
