//
//  WCFormatCheckController.h
//  Pods
//
//  Created by Howard on 2017/1/3.
//
//

#import <Foundation/Foundation.h>

@interface WCFormatCheckController : NSObject


////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Class Method

/**
 檢查 mail 格式正不正確
 
 @param email 來源字串
 @return YES, 合法
 */
+ (BOOL)legalEmail:(NSString *)email;


/**
 合法的整數 15 digit ^-?[1-9]{1}+[0-9]{0,14}
 
 @param integerString 來源字串
 @return YES, 合法
 */
+ (BOOL)legalInteger:(NSString *)integerString;


/**
 合法的浮點數 12 + 3  ^-?[0-9]{1,12}+\\.?+[0-9]{1,3}
 
 @param floatString 來源字串
 @return YES, 合法
 */
+ (BOOL)legalFloatValue:(NSString *)floatString;


/**
 合法的日期字串

 @param dateString 日期字串
 @param format 格式
 @return YES, 合法
 */
+ (BOOL)legalDateString:(NSString *)dateString format:(NSString *)format;


@end
