//
//  WCFileTypeSelectView.m
//  Pods
//
//  Created by Andrew on 2015/7/30.
//
//

#import "WCFileTypeSelectView.h"

#import "WCAppearanceDefine.h"

// Model
#import "WCFileTypeSelectView_ResourceDefine.h"
#import "UIColor+HexString.h"
#import "FTSVFileTypeModel.h"
#import "FTSVTextInfoModel.h"

// View
#import "PPTableView.h"
#import "FTSVCheckBoxTableViewCell.h"
#import "FTSVDetailCommentTableViewCell.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

static NSUInteger WCFileTypeSelectViewSectionTitleFontSize = 16;
static NSUInteger WCFileTypeSelectViewCellTotalMargin      = 12;
static NSUInteger WCFileTypeSelectViewCellDefaultHeight    = 44;

#define WCFileTypeSelectViewSectionTitleEdgeInset UIEdgeInsetsMake(5, 10, 5, 10)

////////////////////////////////////////////////////////////////////////////////////////////////////

typedef NS_ENUM(NSUInteger, WCFileTypeSelectView_TableViewSection)
{
    WCFileTypeSelectView_TableViewSection_ContactFileType  = 0,
    WCFileTypeSelectView_TableViewSection_FileTypeTextInfo
};

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - WCFileTypeSelectView Extension

@interface WCFileTypeSelectView () <UITableViewDataSource, UITableViewDelegate>

@property (nonatomic, retain) NSArray     *supportTextInfos;

@property (nonatomic, assign) NSUInteger   textInfoSelectCount;

@property (nonatomic, retain) NSArray     *fileTypeStringArray;
@property (nonatomic, retain) NSArray     *textInfoModelArray;

@property (nonatomic, retain) PPTableView *selectTypeTableView;

@end





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - WCFileTypeSelectView Implementation

@implementation WCFileTypeSelectView





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
//
//================================================================================
- (id)initWithFrame:(CGRect)frame
{
    if ((self=[super initWithFrame:frame]))
    {
        _contactFileTypeSelected  = WCFileTypeSelectView_ContactFileType_None;
        _fileTypeTextInfoSelected = WCFileTypeSelectView_FileTypeTextInfo_All;
        _supportFileTypes         = [[NSArray arrayWithObjects:@(WCFileTypeSelectView_ContactFileType_WCXF),
                                                               @(WCFileTypeSelectView_ContactFileType_CSV_Gmail),
                                                               @(WCFileTypeSelectView_ContactFileType_VCF),
                                                               @(WCFileTypeSelectView_ContactFileType_Image), nil] retain];
        _supportTextInfos         = [[NSArray arrayWithObjects:@(WCFileTypeSelectView_FileTypeTextInfo_Name),
                                                              @(WCFileTypeSelectView_FileTypeTextInfo_CompanyInfo),
                                                              @(WCFileTypeSelectView_FileTypeTextInfo_Phone),
                                                              @(WCFileTypeSelectView_FileTypeTextInfo_Address),
                                                              @(WCFileTypeSelectView_FileTypeTextInfo_Email),
                                                              @(WCFileTypeSelectView_FileTypeTextInfo_URL),
                                                              @(WCFileTypeSelectView_FileTypeTextInfo_IM), nil] retain];
        //////////////////////////////////////////////////
        //!! 需確定設定supportFileTypes後才可設定fileTypeStringArray內容
        
        _fileTypeStringArray = [[self prepareFileTypeStringArray] retain];
        _tableSectionColor   = [[UIColor lightGrayColor] retain];
        
        //////////////////////////////////////////////////
        // 介面初始化
        
        _selectTypeTableView = [[PPTableView alloc] init];
        if (self.selectTypeTableView!=nil)
        {
            if ([[[UIDevice currentDevice] systemVersion] floatValue]>=9.0)
            {
                //!! 取消內縮，使iPad在iOS 9上顯示正常
                self.selectTypeTableView.cellLayoutMarginsFollowReadableWidth = NO;
            }

            self.selectTypeTableView.backgroundColor = [UIColor whiteColor];
            self.selectTypeTableView.dataSource      = self;
            self.selectTypeTableView.delegate        = self;
            
            [self addSubview:self.selectTypeTableView];
            [self.selectTypeTableView setEditing:YES];
            [self.selectTypeTableView setAllowsSelectionDuringEditing:YES];
        }
    }
    
    return self;
}


//================================================================================
//
//================================================================================
- (void)dealloc
{
    _delegate = nil;
    
    [_supportTextInfos release];
    _supportTextInfos = nil;
    
    [_supportFileTypes release];
    _supportFileTypes = nil;
    
    [_textInfoModelArray release];
    _textInfoModelArray = nil;
    
    [_fileTypeStringArray release];
    _fileTypeStringArray = nil;
    
    [_fileTypeSelectorTitle release];
    _fileTypeSelectorTitle = nil;
    
    [_textInfoCheckBoxTitle release];
    _textInfoCheckBoxTitle = nil;
    
    [_selectTypeTableView removeFromSuperview];
    _selectTypeTableView.dataSource = nil;
    _selectTypeTableView.delegate = nil;
    [_selectTypeTableView release];
    _selectTypeTableView = nil;
    
    [_selectFooterView release];
    _selectFooterView = nil;
    
    [_tableSectionColor release];
    _tableSectionColor = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Method

//================================================================================
//
//================================================================================
- (void)layoutSubviews
{
    [super layoutSubviews];
    
    //////////////////////////////////////////////////
    
    self.selectTypeTableView.frame = self.bounds;
    
    //////////////////////////////////////////////////
    // 跳出下方checkBoxGroup
    
    if (self.contactFileTypeSelected==WCFileTypeSelectView_ContactFileType_Text)
    {
        [self selectFileTypeWithFileType:WCFileTypeSelectView_ContactFileType_Text];
    }
}


//================================================================================
//
//================================================================================
- (void)setSupportFileTypes:(NSArray *)supportFileTypes
{
    [_supportFileTypes release];
    _supportFileTypes = [supportFileTypes retain];
    
    //////////////////////////////////////////////////
    
    self.fileTypeStringArray = [self prepareFileTypeStringArray];
}


//================================================================================
// 初始化並更新以選擇的檔案格式(避免初始化錯誤,單選)
//================================================================================
- (void)setContactFileTypeSelected:(WCFileTypeSelectView_ContactFileType)contactFileTypeSelected
{
    WCFileTypeSelectView_ContactFileType fileTypeSelected = WCFileTypeSelectView_ContactFileType_None;
    
    //////////////////////////////////////////////////
    
    for (NSInteger index=0; index<[self.supportFileTypes count]; index++)
    {
        NSNumber *fileTypeNumber = [self.supportFileTypes objectAtIndex:index];
        WCFileTypeSelectView_ContactFileType fileType = [fileTypeNumber unsignedIntegerValue];
        
        if ((fileType&contactFileTypeSelected)==fileType)
        {
            [self.selectTypeTableView selectRowAtIndexPath:[NSIndexPath indexPathForRow:index inSection:WCFileTypeSelectView_TableViewSection_ContactFileType] animated:NO scrollPosition:UITableViewScrollPositionNone];
            
            fileTypeSelected|=fileType;
            break;
        }
        else
        {
            [self.selectTypeTableView deselectRowAtIndexPath:[NSIndexPath indexPathForRow:index inSection:WCFileTypeSelectView_TableViewSection_ContactFileType] animated:NO];
        }
    }
    
    _contactFileTypeSelected = fileTypeSelected;
}


//================================================================================
//
//================================================================================
- (void)setFileTypeTextInfoSelected:(WCFileTypeSelectView_FileTypeTextInfo)fileTypeTextInfoSelected
{
    WCFileTypeSelectView_FileTypeTextInfo textInfoSelected = WCFileTypeSelectView_FileTypeTextInfo_None;
    self.textInfoSelectCount = 0;
    
    //////////////////////////////////////////////////
    
    for (NSInteger index=0; index<[self.supportTextInfos count]; index++)
    {
        NSNumber *textInfoNumber = [self.supportTextInfos objectAtIndex:index];
        WCFileTypeSelectView_FileTypeTextInfo textInfo = [textInfoNumber unsignedIntegerValue];
        
        if ((textInfo&fileTypeTextInfoSelected)==textInfo)
        {
            textInfoSelected|=textInfo;
            
            self.textInfoSelectCount++;
        }
    }
    
    _fileTypeTextInfoSelected = textInfoSelected;
}


//================================================================================
//
//================================================================================
- (void)setSelectFooterView:(UIView *)selectFooterView
{
    [_selectFooterView release];
    _selectFooterView = [selectFooterView retain];
    
    //////////////////////////////////////////////////
    
    self.selectTypeTableView.tableFooterView = self.selectFooterView;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private Method

//================================================================================
// 
//================================================================================
- (NSArray *)prepareTextInfoModelArray
{
    return [NSArray arrayWithObjects:[FTSVTextInfoModel textInfoModelWithString:WCFTSV_MLS_TextNameInformation isSelected:(self.fileTypeTextInfoSelected&WCFileTypeSelectView_FileTypeTextInfo_Name)?YES:NO],
                                     [FTSVTextInfoModel textInfoModelWithString:WCFTSV_MLS_TextCompanyInformation isSelected:(self.fileTypeTextInfoSelected&WCFileTypeSelectView_FileTypeTextInfo_CompanyInfo)?YES:NO],
                                     [FTSVTextInfoModel textInfoModelWithString:WCFTSV_MLS_Phone isSelected:(self.fileTypeTextInfoSelected&WCFileTypeSelectView_FileTypeTextInfo_Phone)?YES:NO],
                                     [FTSVTextInfoModel textInfoModelWithString:WCFTSV_MLS_Address isSelected:(self.fileTypeTextInfoSelected&WCFileTypeSelectView_FileTypeTextInfo_Address)?YES:NO],
                                     [FTSVTextInfoModel textInfoModelWithString:WCFTSV_MLS_Email isSelected:(self.fileTypeTextInfoSelected&WCFileTypeSelectView_FileTypeTextInfo_Email)?YES:NO],
                                     [FTSVTextInfoModel textInfoModelWithString:WCFTSV_MLS_URL isSelected:(self.fileTypeTextInfoSelected&WCFileTypeSelectView_FileTypeTextInfo_URL)?YES:NO],
                                     [FTSVTextInfoModel textInfoModelWithString:WCFTSV_MLS_TextIMInformation isSelected:(self.fileTypeTextInfoSelected&WCFileTypeSelectView_FileTypeTextInfo_IM)?YES:NO], nil];
}


//================================================================================
//
//================================================================================
- (NSArray *)prepareFileTypeStringArray
{
    self.textInfoModelArray = nil;
    
    //////////////////////////////////////////////////
    
    NSMutableArray *typeStringArray = [NSMutableArray array];
    
    for (NSNumber *fileTypeNumber in self.supportFileTypes)
    {
        switch ([fileTypeNumber unsignedIntegerValue])
        {
            case WCFileTypeSelectView_ContactFileType_XLSX:
            {
                [typeStringArray addObject:[FTSVFileTypeModel fileTypeModelWithAbbreviation:WCFileTypeSelectView_fileTypeAbbreviation_XLSX
                                                                                   fullName:WCFTSV_MLS_FullNameXLSX
                                                                            fullNameComment:WCFTSV_MLS_XLSXComment]];
                break;
            }
            case WCFileTypeSelectView_ContactFileType_CSV_iWorks:
            {
                [typeStringArray addObject:[FTSVFileTypeModel fileTypeModelWithAbbreviation:WCFileTypeSelectView_fileTypeAbbreviation_CSV
                                                                                   fullName:WCFTSV_MLS_FullNameiWorks
                                                                            fullNameComment:WCFTSV_MLS_iWorksComment]];
                break;
            }
            case WCFileTypeSelectView_ContactFileType_WCXF:
            {
                [typeStringArray addObject:[FTSVFileTypeModel fileTypeModelWithAbbreviation:WCFileTypeSelectView_fileTypeAbbreviation_WCXF
                                                                                   fullName:WCFTSV_MLS_FullNameWCXF
                                                                            fullNameComment:nil]];
                break;
            }
            case WCFileTypeSelectView_ContactFileType_CSV_Gmail:
            {
                [typeStringArray addObject:[FTSVFileTypeModel fileTypeModelWithAbbreviation:WCFileTypeSelectView_fileTypeAbbreviation_CSV
                                                                                   fullName:WCFTSV_MLS_FullNameCSV
                                                                            fullNameComment:WCFTSV_MLS_CSVCommentGmail]];
                break;
            }
            case WCFileTypeSelectView_ContactFileType_CSV_Outlook:
            {
                [typeStringArray addObject:[FTSVFileTypeModel fileTypeModelWithAbbreviation:WCFileTypeSelectView_fileTypeAbbreviation_CSV
                                                                                   fullName:WCFTSV_MLS_FullNameCSV
                                                                            fullNameComment:WCFTSV_MLS_CSVCommentOutlook]];
                break;
            }
            case WCFileTypeSelectView_ContactFileType_VCF:
            {
                [typeStringArray addObject:[FTSVFileTypeModel fileTypeModelWithAbbreviation:WCFileTypeSelectView_fileTypeAbbreviation_VCF
                                                                                   fullName:WCFTSV_MLS_FullNameVCF
                                                                            fullNameComment:WCFTSV_MLS_VCFComment]];
                break;
            }
            case WCFileTypeSelectView_ContactFileType_Image:
            {
                [typeStringArray addObject:[FTSVFileTypeModel fileTypeModelWithAbbreviation:WCFileTypeSelectView_fileTypeAbbreviation_Image
                                                                                   fullName:WCFTSV_MLS_FullNameImage
                                                                            fullNameComment:nil]];
                break;
            }
            case WCFileTypeSelectView_ContactFileType_Text:
            {
                [typeStringArray addObject:[FTSVFileTypeModel fileTypeModelWithAbbreviation:WCFileTypeSelectView_fileTypeAbbreviation_Text
                                                                                   fullName:WCFTSV_MLS_FullNameText
                                                                            fullNameComment:nil]];
                
                break;
            }
            default:
                break;
        }
    }
    
    return typeStringArray;
}


//================================================================================
//
//================================================================================
- (void)deselectFileTypeWithFileType:(WCFileTypeSelectView_ContactFileType)fileType
{
    self.contactFileTypeSelected^=fileType;
}


//================================================================================
//
//================================================================================
- (void)selectFileTypeWithFileType:(WCFileTypeSelectView_ContactFileType)fileType
{
    self.contactFileTypeSelected|=fileType;
    
    //////////////////////////////////////////////////
    
    if (fileType==WCFileTypeSelectView_ContactFileType_Text)
    {
        self.textInfoModelArray = [self prepareTextInfoModelArray];
        [self.selectTypeTableView reloadData];
        
        //!! 因為reloadData會取消所有選取，所以需重新Assign進行選取
        self.contactFileTypeSelected  = self.contactFileTypeSelected;
        self.fileTypeTextInfoSelected = self.fileTypeTextInfoSelected;
        [self selectTextInfoWithTextInfo:self.fileTypeTextInfoSelected];
        [self.selectTypeTableView scrollToRowAtIndexPath:[NSIndexPath indexPathForRow:WCFileTypeSelectView_FileTypeTextInfo_Name inSection:WCFileTypeSelectView_TableViewSection_FileTypeTextInfo] atScrollPosition:UITableViewScrollPositionTop animated:YES];
    }
    else
    {
        self.textInfoModelArray = nil;
        [self.selectTypeTableView reloadData];
        
        //!! 因為reloadData會取消所有選取，所以需重新Assign進行選取
        self.contactFileTypeSelected = self.contactFileTypeSelected;
//        self.fileTypeTextInfoSelected = WCFileTypeSelectView_FileTypeTextInfo_None;
    }
}


//================================================================================
//
//================================================================================
- (void)deselectTextInfoWithTextInfo:(WCFileTypeSelectView_FileTypeTextInfo)textInfo
{
    self.fileTypeTextInfoSelected^=textInfo;
}


//================================================================================
//
//================================================================================
- (void)selectTextInfoWithTextInfo:(WCFileTypeSelectView_FileTypeTextInfo)textInfo
{
    self.fileTypeTextInfoSelected|=textInfo;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - UITableViewDataSource

//================================================================================
//
//================================================================================
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView
{
    if (self.textInfoModelArray!=nil)
    {
        return 2;
    }
    
    return 1;
}


//================================================================================
//
//================================================================================
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    if (section==WCFileTypeSelectView_TableViewSection_FileTypeTextInfo)
    {
        return [self.textInfoModelArray count];
    }
    
    return [self.fileTypeStringArray count];
}


//================================================================================
//
//================================================================================
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    if (indexPath.section==WCFileTypeSelectView_TableViewSection_FileTypeTextInfo)
    {
        static NSString *CheckCellIdenttifier = @"CheckCellIdenttifier";
        FTSVCheckBoxTableViewCell *cell = (FTSVCheckBoxTableViewCell *)[tableView dequeueReusableCellWithIdentifier:[CheckCellIdenttifier  stringByAppendingString:[NSString stringWithFormat:@"%td",indexPath.section]]];
        if (cell == nil)
        {
            cell = [[[FTSVCheckBoxTableViewCell alloc] initWithStyle:UITableViewCellStyleDefault reuseIdentifier:[CheckCellIdenttifier  stringByAppendingString:[NSString stringWithFormat:@"%td",indexPath.section]]] autorelease];
        }
        
        //////////////////////////////////////////////////
        //!! 當滾動時，若該Cell有被選取，會自動呼叫Cell的setSelected，所以只需於setSelected覆寫要呈現的樣式即可
        
        cell.selectionStyle = UITableViewCellSelectionStyleNone;
        
        //////////////////////////////////////////////////
        
        FTSVTextInfoModel *textInfoModel = [self.textInfoModelArray objectAtIndex:indexPath.row];
        cell.textLabel.textAlignment     = NSTextAlignmentLeft;
        cell.textLabel.font              = [UIFont systemFontOfSize:WCFileTypeSelectView_fileTypeAbbreviationFontSize];
        cell.textLabel.textColor         = [UIColor colorWithHexString:@"#4C4C4C"];
        cell.textLabel.text              = textInfoModel.textInfoString;
        
        [cell setCheckBoxViewStatus:textInfoModel.isSelected];
        
        return cell;
    }
    
    //////////////////////////////////////////////////
    
    static NSString *SelectCellIdenttifier = @"SelectCellIdenttifier";
    FTSVDetailCommentTableViewCell *cell = (FTSVDetailCommentTableViewCell *)[tableView dequeueReusableCellWithIdentifier:[SelectCellIdenttifier  stringByAppendingString:[NSString stringWithFormat:@"%td",indexPath.section]]];
    if (cell == nil)
    {
        cell = [[[FTSVDetailCommentTableViewCell alloc] initCustomStyleWithReuseIdentifier:[SelectCellIdenttifier  stringByAppendingString:[NSString stringWithFormat:@"%td",indexPath.section]]] autorelease];
    }
    
    //////////////////////////////////////////////////
    //!! 設定成None無法顯示左邊藍色勾勾選取符號
    //!! 當滾動時，若該Cell有被選取，會自動呼叫Cell的setSelected，所以只需於setSelected覆寫要呈現的樣式即可
    
    cell.selectionStyle = UITableViewCellSelectionStyleDefault;
    
    //////////////////////////////////////////////////
    
    FTSVFileTypeModel *typeModel = [self.fileTypeStringArray objectAtIndex:indexPath.row];
    cell.textLabel.textAlignment = NSTextAlignmentLeft;
    cell.textLabel.font          = [UIFont systemFontOfSize:WCFileTypeSelectView_fileTypeAbbreviationFontSize];
    cell.textLabel.textColor     = [UIColor colorWithHexString:@"#4C4C4C"];
    cell.textLabel.text          = typeModel.abbreviation;
    
    cell.detailTextLabel.adjustsFontSizeToFitWidth = YES;
    cell.detailTextLabel.text       = typeModel.fullName;
    cell.detailTextLabel.font       = [UIFont systemFontOfSize:WCFileTypeSelectView_fileTypeFullNameFontSize];
    cell.detailTextLabel.textColor  = [UIColor colorWithHexString:@"#787878"];
    
    cell.detailCommentTextLabel.text       = typeModel.fullNameComment;
    cell.detailCommentTextLabel.font       = [UIFont systemFontOfSize:WCFileTypeSelectView_fileTypeFullNameCommentFontSize];
    cell.detailCommentTextLabel.textColor  = [UIColor blackColor];

    return cell;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - UITableViewDelegate

//================================================================================
// 計算呈現所需的sectiion高度
//================================================================================
- (CGFloat)tableView:(UITableView *)tableView heightForHeaderInSection:(NSInteger)section
{
    CGFloat sectionHeight = 0.0;

    if (section==WCFileTypeSelectView_TableViewSection_FileTypeTextInfo)
    {
        UILabel *fileTypeTextLabel = [[UILabel alloc] initWithFrame:CGRectMake(0, 0, self.bounds.size.width-WCFileTypeSelectViewSectionTitleEdgeInset.left-WCFileTypeSelectViewSectionTitleEdgeInset.right, 0)];
        if (fileTypeTextLabel!=nil)
        {
            fileTypeTextLabel.numberOfLines = 0;
            fileTypeTextLabel.lineBreakMode = NSLineBreakByWordWrapping;
            fileTypeTextLabel.text = self.textInfoCheckBoxTitle;
            fileTypeTextLabel.font = [UIFont boldSystemFontOfSize:WCFileTypeSelectViewSectionTitleFontSize];

            [fileTypeTextLabel sizeToFit];

            sectionHeight = fileTypeTextLabel.bounds.size.height+WCFileTypeSelectViewSectionTitleEdgeInset.top+WCFileTypeSelectViewSectionTitleEdgeInset.bottom;
            [fileTypeTextLabel release];
        }
    }

    if (section==WCFileTypeSelectView_TableViewSection_ContactFileType)
    {
        UILabel *contactFileTypeLabel = [[UILabel alloc] initWithFrame:CGRectMake(0, 0, self.bounds.size.width-WCFileTypeSelectViewSectionTitleEdgeInset.left-WCFileTypeSelectViewSectionTitleEdgeInset.right, 0)];
        if (contactFileTypeLabel!=nil)
        {
            contactFileTypeLabel.numberOfLines = 0;
            contactFileTypeLabel.lineBreakMode = NSLineBreakByWordWrapping;
            contactFileTypeLabel.text = self.fileTypeSelectorTitle;
            contactFileTypeLabel.font = [UIFont boldSystemFontOfSize:WCFileTypeSelectViewSectionTitleFontSize];

            [contactFileTypeLabel sizeToFit];

            sectionHeight = contactFileTypeLabel.bounds.size.height+WCFileTypeSelectViewSectionTitleEdgeInset.top+WCFileTypeSelectViewSectionTitleEdgeInset.bottom;
            [contactFileTypeLabel release];
        }
    }

    return sectionHeight;
}


//================================================================================
//
//================================================================================
- (UIView *)tableView:(UITableView *)tableView viewForHeaderInSection:(NSInteger)section
{
    UIView *sectionView = nil;
    
    if (section==WCFileTypeSelectView_TableViewSection_FileTypeTextInfo)
    {
        UILabel *fileTypeTextLabel = [[UILabel alloc] initWithFrame:CGRectMake(WCFileTypeSelectViewSectionTitleEdgeInset.left,
                                                                               WCFileTypeSelectViewSectionTitleEdgeInset.top,
                                                                               self.bounds.size.width-WCFileTypeSelectViewSectionTitleEdgeInset.left-WCFileTypeSelectViewSectionTitleEdgeInset.right,
                                                                               0)];
        if (fileTypeTextLabel!=nil)
        {
            fileTypeTextLabel.backgroundColor = self.tableSectionColor;
            fileTypeTextLabel.numberOfLines   = 0;
            fileTypeTextLabel.lineBreakMode   = NSLineBreakByWordWrapping;
            fileTypeTextLabel.text = self.textInfoCheckBoxTitle;
            fileTypeTextLabel.font = [UIFont boldSystemFontOfSize:WCFileTypeSelectViewSectionTitleFontSize];
            fileTypeTextLabel.textColor = WCAppearanceDefine_SectionHeaderTitleColor;
            
            [fileTypeTextLabel sizeToFit];
            
            //////////////////////////////////////////////////
            
            sectionView = [[UIView alloc] initWithFrame:CGRectMake(0, 0, self.bounds.size.width, fileTypeTextLabel.bounds.size.height+WCFileTypeSelectViewSectionTitleEdgeInset.top+WCFileTypeSelectViewSectionTitleEdgeInset.bottom)];
            if (sectionView!=nil)
            {
                [sectionView addSubview:fileTypeTextLabel];
            }
            
            [fileTypeTextLabel release];
        }
    }
    if (section==WCFileTypeSelectView_TableViewSection_ContactFileType)
    {
        UILabel *contactFileTypeLabel = [[UILabel alloc] initWithFrame:CGRectMake(WCFileTypeSelectViewSectionTitleEdgeInset.left,
                                                                                  WCFileTypeSelectViewSectionTitleEdgeInset.top,
                                                                                  self.bounds.size.width-WCFileTypeSelectViewSectionTitleEdgeInset.left-WCFileTypeSelectViewSectionTitleEdgeInset.right,
                                                                                  0)];
        if (contactFileTypeLabel!=nil)
        {
            contactFileTypeLabel.backgroundColor = self.tableSectionColor;
            contactFileTypeLabel.numberOfLines   = 0;
            contactFileTypeLabel.lineBreakMode   = NSLineBreakByWordWrapping;
            contactFileTypeLabel.text = self.fileTypeSelectorTitle;
            contactFileTypeLabel.font = [UIFont boldSystemFontOfSize:WCFileTypeSelectViewSectionTitleFontSize];
            contactFileTypeLabel.textColor = WCAppearanceDefine_SectionHeaderTitleColor;

            [contactFileTypeLabel sizeToFit];
            
            //////////////////////////////////////////////////
            
            sectionView = [[UIView alloc] initWithFrame:CGRectMake(0, 0, self.bounds.size.width, contactFileTypeLabel.bounds.size.height+WCFileTypeSelectViewSectionTitleEdgeInset.top+WCFileTypeSelectViewSectionTitleEdgeInset.bottom)];
            if (sectionView!=nil)
            {
                [sectionView addSubview:contactFileTypeLabel];
            }
            
            [contactFileTypeLabel release];
        }
    }
    
    sectionView.backgroundColor = self.tableSectionColor;
    
    return [sectionView autorelease];
}


//================================================================================
//
//================================================================================
- (BOOL)tableView:(UITableView *)tableView shouldIndentWhileEditingRowAtIndexPath:(NSIndexPath *)indexPath
{
    switch (indexPath.section)
    {
        case WCFileTypeSelectView_TableViewSection_ContactFileType:
        {
            return YES;
        }
        case WCFileTypeSelectView_TableViewSection_FileTypeTextInfo:
        {
            return NO;
        }
        default:
            return NO;
    }
}


//================================================================================
// 呈現空白圈圈(Add+Delete)，可進行選取狀態紀錄
//================================================================================
- (UITableViewCellEditingStyle)tableView:(UITableView *)tableView editingStyleForRowAtIndexPath:(NSIndexPath *)indexPath
{
    switch (indexPath.section)
    {
        case WCFileTypeSelectView_TableViewSection_ContactFileType:
        {
            return UITableViewCellEditingStyleDelete+UITableViewCellEditingStyleInsert;
        }
        case WCFileTypeSelectView_TableViewSection_FileTypeTextInfo:
        {
            return UITableViewCellEditingStyleNone;
        }
        default:
            return UITableViewCellEditingStyleNone;
    }
}


//================================================================================
// 若為單選，需取消其他已被選取的檔案格式
//================================================================================
- (NSIndexPath *)tableView:(UITableView *)tableView willSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    if (indexPath.section==WCFileTypeSelectView_TableViewSection_ContactFileType)
    {
        NSArray *selectArray=[self.selectTypeTableView indexPathsForSelectedRows];
        
        for (NSIndexPath *deselectIndexPath in selectArray)
        {
            if (deselectIndexPath.section==WCFileTypeSelectView_TableViewSection_ContactFileType)
            {
                NSNumber *fileTypeNumber = [self.supportFileTypes objectAtIndex:deselectIndexPath.row];
                WCFileTypeSelectView_ContactFileType fileType = [fileTypeNumber unsignedIntegerValue];
                
                [self deselectFileTypeWithFileType:fileType];
            }
            
        }
    }
    
    return indexPath;
}


//================================================================================
//!! 因為在didDeselectRowAtIndexPath判斷會來不及，當下Cell的Selected狀態已經變更！
//!! 不可無選擇任何檔案格式 和 連路人欄位資訊
//================================================================================
- (NSIndexPath *)tableView:(UITableView *)tableView willDeselectRowAtIndexPath:(NSIndexPath *)indexPath
{
    if (indexPath.section==WCFileTypeSelectView_TableViewSection_ContactFileType)
    {
        return nil;
    }
    
    return indexPath;
}


//================================================================================
//
//================================================================================
- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    switch (indexPath.section)
    {
        case WCFileTypeSelectView_TableViewSection_ContactFileType:
        {
            NSNumber *fileTypeNumber = [self.supportFileTypes objectAtIndex:indexPath.row];
            WCFileTypeSelectView_ContactFileType fileType = [fileTypeNumber unsignedIntegerValue];
            
            [self selectFileTypeWithFileType:fileType];
            
            //////////////////////////////////////////////////
            //!! 因為indexPathsForSelectedRows是判斷tableView內該indexPath是否為選取狀態(純粹設定Cell的Selected無法抓取準確數量)
            //!! 需透過selectRowAtIndexPath和deselectRowAtIndexPath來進行選擇
            //!! 使用selectRowAtIndexPath和deselectRowAtIndexPath來進行選擇時，會反應cell的setSelected:animated:
            //!! 並且將selected設定為tableView內該indexPath的選取狀態
            
            if (self.delegate!=nil && [self.delegate respondsToSelector:@selector(fileTypeSelectView:didSelectContactFileType:)]==YES)
            {
                [self.delegate fileTypeSelectView:self didSelectContactFileType:fileType];
            }
            
            break;
        }
        case WCFileTypeSelectView_TableViewSection_FileTypeTextInfo:
        {
            FTSVTextInfoModel *infoModel = [self.textInfoModelArray objectAtIndex:indexPath.row];
            NSNumber *textInfoNumber     = [self.supportTextInfos objectAtIndex:indexPath.row];
            WCFileTypeSelectView_FileTypeTextInfo textInfo = [textInfoNumber unsignedIntegerValue];
            
            if (infoModel.isSelected==YES)
            {
                if (self.textInfoSelectCount>1)
                {
                    infoModel.isSelected = NO;
                    
                    [self deselectTextInfoWithTextInfo:textInfo];
                    
                    if (self.delegate!=nil && [self.delegate respondsToSelector:@selector(fileTypeSelectView:didDeselectFileTypeTextInfo:)]==YES)
                    {
                        [self.delegate fileTypeSelectView:self didDeselectFileTypeTextInfo:textInfo];
                    }
                }
            }
            else
            {
                infoModel.isSelected = YES;
                
                [self selectTextInfoWithTextInfo:textInfo];
                
                if (self.delegate!=nil && [self.delegate respondsToSelector:@selector(fileTypeSelectView:didSelectFileTypeTextInfo:)]==YES)
                {
                    [self.delegate fileTypeSelectView:self didSelectFileTypeTextInfo:textInfo];
                }
            }
            
            //////////////////////////////////////////////////

            [self.selectTypeTableView deselectRowAtIndexPath:indexPath animated:NO];
            [self.selectTypeTableView reloadRowsAtIndexPaths:[NSArray arrayWithObject:indexPath] withRowAnimation:UITableViewRowAnimationFade];
            
            break;
        }
        default:
            break;
    }
}


//================================================================================
//
//================================================================================
- (void)tableView:(UITableView *)tableView didDeselectRowAtIndexPath:(NSIndexPath *)indexPath
{
    switch (indexPath.section)
    {
        case WCFileTypeSelectView_TableViewSection_ContactFileType:
        {
            NSNumber *fileTypeNumber = [self.supportFileTypes objectAtIndex:indexPath.row];
            WCFileTypeSelectView_ContactFileType fileType = [fileTypeNumber unsignedIntegerValue];
            
            [self deselectFileTypeWithFileType:fileType];
            
            //////////////////////////////////////////////////
            
            if (self.delegate!=nil && [self.delegate respondsToSelector:@selector(fileTypeSelectView:didDeselectContactFileType:)]==YES)
            {
                [self.delegate fileTypeSelectView:self didDeselectContactFileType:fileType];
            }
            
            break;
        }
        default:
            break;
    }
}


//================================================================================
//
//================================================================================
- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    CGFloat rowHeight = 0.0;
    NSString *calculateHeighString = @"lg";

    if (indexPath.section==WCFileTypeSelectView_TableViewSection_ContactFileType)
    {
        UILabel *fileTypeFullNameLabel = [[UILabel alloc] initWithFrame:CGRectZero];
        if (fileTypeFullNameLabel!=nil)
        { 
            fileTypeFullNameLabel.text = calculateHeighString;
            fileTypeFullNameLabel.font = [UIFont systemFontOfSize:WCFileTypeSelectView_fileTypeFullNameFontSize];
            
            [fileTypeFullNameLabel sizeToFit];
            
            rowHeight+=fileTypeFullNameLabel.frame.size.height;
            
            [fileTypeFullNameLabel release];
        }
        
        
        CGFloat labelWidth = self.frame.size.width-FTSVDetailCommentTableViewCell_TextLabelWidth-50; //50是測試出來系統前面選取圖示的寬度
        UILabel *fileTypeFullNameCommentLabel = [[UILabel alloc] initWithFrame:CGRectMake(0, 0, labelWidth, 0)];
        if (fileTypeFullNameCommentLabel!=nil)
        {
            fileTypeFullNameCommentLabel.numberOfLines = 0;
            fileTypeFullNameCommentLabel.lineBreakMode = NSLineBreakByWordWrapping;
            
            FTSVFileTypeModel *typeModel = [self.fileTypeStringArray objectAtIndex:indexPath.row];
            fileTypeFullNameCommentLabel.text = typeModel.fullNameComment;
            fileTypeFullNameCommentLabel.font = [UIFont systemFontOfSize:WCFileTypeSelectView_fileTypeFullNameCommentFontSize];
            
            [fileTypeFullNameCommentLabel sizeToFit];
            
            rowHeight+=fileTypeFullNameCommentLabel.frame.size.height;
            
            [fileTypeFullNameCommentLabel release];
        }
        
        return rowHeight+PPTableViewCellDefaultVerticalGap+WCFileTypeSelectViewCellTotalMargin;
    }
    else
    {
        return WCFileTypeSelectViewCellDefaultHeight;
    }
}

@end
