//
//  FTSVDetailCommentTableViewCell.m
//  Pods
//
//  Created by AndrewLai on 2016/1/6.
//
//

#import "FTSVDetailCommentTableViewCell.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - FTSVDetailCommentTableViewCell Implementation

@implementation FTSVDetailCommentTableViewCell





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
//
//================================================================================
- (instancetype)initCustomStyleWithReuseIdentifier:(NSString *)reuseIdentifier
{
    if ((self=[super initWithStyle:UITableViewCellStyleValue1 reuseIdentifier:reuseIdentifier]))
    {
        do
        {
            self.ignoreCustomLabelFrame = YES;
            
            //////////////////////////////////////////////////
            
            _detailCommentTextLabel = [[UILabel alloc] initWithFrame:CGRectZero];
            if (self.detailCommentTextLabel==nil)
            {
                self = nil;
                break;
            }
            
            self.detailCommentTextLabel.numberOfLines = 0;
            self.detailCommentTextLabel.lineBreakMode = NSLineBreakByWordWrapping;
            [self.contentView addSubview:self.detailCommentTextLabel];
        } while (0);
        
    }
    
    return self;
}


//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_detailCommentTextLabel release];
    _detailCommentTextLabel = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Method

//================================================================================
//
//================================================================================
- (void)layoutSubviews
{
    [super layoutSubviews];
    
    //////////////////////////////////////////////////
    CGRect  layoutRegion = self.contentView.bounds;
    
    CGRect titleLabelFrame = self.textLabel.frame;
    titleLabelFrame.size.width = FTSVDetailCommentTableViewCell_TextLabelWidth;
    self.textLabel.frame = titleLabelFrame;
    
    //////////////////////////////////////////////////
    CGRect detailLabelFrame    = self.detailTextLabel.frame;
    detailLabelFrame.origin.x  = titleLabelFrame.origin.x+titleLabelFrame.size.width;
    detailLabelFrame.origin.y  = PPTableViewCellDefaultVerticalGap;
    self.detailTextLabel.frame = detailLabelFrame;
    
    //////////////////////////////////////////////////
    if (self.detailCommentTextLabel.text!=nil)
    {
        [self.detailCommentTextLabel sizeToFit];
        
        CGRect detailCommentFrame     = self.detailCommentTextLabel.frame;
        detailCommentFrame.origin.y   = detailLabelFrame.origin.y+detailLabelFrame.size.height+PPTableViewCellDefaultVerticalGap;
        detailCommentFrame.origin.x   = detailLabelFrame.origin.x;
        detailCommentFrame.size.width = layoutRegion.size.width-detailCommentFrame.origin.x;
        self.detailCommentTextLabel.frame = detailCommentFrame;
    }
}

@end
