//
//  WCDuplicateCompareModel.m
//  WorldCardMobile
//
//  Created by  Eddie on 12/7/19.
//  Copyright (c) 2012年 __MyCompanyName__. All rights reserved.
//

#import "WCDuplicateCompareModel.h"

#import "PPMutableDictionary+NSInteger.h"
#import "WCFieldModel+DisplayName.h"


@implementation WCDuplicateCompareModel
@synthesize nameArray = nameArray_;
@synthesize restFieldDict = restFieldDict_;


//===============================================================================
//
//===============================================================================
- (id)init
{
    if((self = [super init]))
    {
        nameArray_ = [[NSMutableArray alloc] init];
        restFieldDict_ = [[NSMutableDictionary alloc] init];
    }

    return self;
}


//===============================================================================
//
//===============================================================================
- (void)dealloc
{
    [nameArray_ release];
    [restFieldDict_ release];
    [super dealloc];
}


//===============================================================================
//
//===============================================================================
- (BOOL)hasSameCardID:(NSString *)cardID
{
    return ([restFieldDict_ objectForKey:cardID] != nil);
}

/*
//===============================================================================
//
//===============================================================================
- (NSMutableArray *)copyDuplicateCardIDArrayWithCardModel:(WCCardModel *)cardModel
{
    NSMutableArray *checkNameArray = [[NSMutableArray alloc] init];
    NSMutableDictionary *checkFieldValueSetDict = [[NSMutableDictionary alloc] init];
    NSMutableArray *duplicateCardIDArray = nil;


    //----------------------------------
    // 由CardModel取得比對所需資料
    //----------------------------------
    WCDuplicateCheckNameModel *nameModel = nil;
    WCFieldModel *subType2FieldModel;
    NSMutableSet *fieldValueSet = nil;
    NSString *fieldValue;
    NSArray *fieldArray = nil;


    ///////////////////////////////////
    // prepare name data
    //
    fieldArray = [cardModel fieldArrayWithType:WC_FT_Name];

    for(WCFieldModel *fieldModel in fieldArray)
    {
        fieldValue = [fieldModel stringDisplayName];

        if([fieldValue length])
        {
            nameModel = [WCDuplicateCheckNameModel copyNameModelWithCardID:cardModel.ID name:fieldValue];
            [checkNameArray addObject:nameModel];
            [nameModel release];
        }
    }

    ///////////////////////////////////
    // prepare company data
    //
    fieldArray = [cardModel fieldArrayWithType:WC_FT_Company];
    fieldValueSet = [[NSMutableSet alloc] init];

    for(WCFieldModel *fieldModel in fieldArray)
    {
        subType2FieldModel = [fieldModel fieldWithSubType2:WC_FST2_Company_Name];
        fieldValue = subType2FieldModel.value;

        if([fieldValue length])
            [fieldValueSet addObject:fieldValue];
    }

    if([fieldValueSet count])
        [checkFieldValueSetDict setObject:fieldValueSet forIntKey:WC_FT_Company];

    [fieldValueSet release];

    ///////////////////////////////////
    // prepare email data
    //
    fieldArray = [cardModel fieldArrayWithType:WC_FT_Email];
    fieldValueSet = [[NSMutableSet alloc] init];

    for(WCFieldModel *fieldModel in fieldArray)
    {
        fieldValue = fieldModel.value;

        if([fieldValue length])
            [fieldValueSet addObject:fieldValue];
    }

    if([fieldValueSet count])
        [checkFieldValueSetDict setObject:fieldValueSet forIntKey:WC_FT_Email];

    [fieldValueSet release];


    //----------------------------------
    // 取得所有重複資料的cardID
    //----------------------------------
    for(nameModel in checkNameArray)
    {
        NSMutableArray *cardIDArray = [self copyDuplicateCardIDArrayWithCheckNameModel:nameModel
                                                                checkFieldValueSetDict:checkFieldValueSetDict
                                                                        findStartIndex:YES];

        if([cardIDArray count])
        {
            if(!duplicateCardIDArray)
                duplicateCardIDArray = [[NSMutableArray alloc] init];

            [duplicateCardIDArray addObjectsFromArray:cardIDArray];
        }

        [cardIDArray release];
    }

    return duplicateCardIDArray;
}
*/


//===============================================================================
// 取得同名
// NOTE: 資料已排序過
//===============================================================================
- (NSMutableArray *)copySameNameCardIDArrayWithCheckNameModel:(WCDuplicateCheckNameModel *)checkNameModel
                                        checkFieldValueSetDict:(NSMutableDictionary *)checkFieldValueSetDict
                                                findStartIndex:(BOOL)findStartIndex

{
    NSMutableArray      *duplicateCardIDArray = [[NSMutableArray alloc] init];
    BOOL                hasDuplicateValue;
    
    WCDuplicateCheckNameModel *curNameModel = nil;
    NSMutableDictionary *fieldValueSetDictForCheck = nil;
    NSMutableDictionary *fieldValueSetDictForCurrent = nil;
    NSSet               *curValueSet = nil;
    NSSet               *checkValueSet = nil;
    NSInteger           startIndex = 0;
    
    
    if(findStartIndex)
        startIndex = [self indexWithFirstSameName:checkNameModel];
    
    // get check value set dict
    if(checkFieldValueSetDict)
        fieldValueSetDictForCheck = checkFieldValueSetDict;
    else fieldValueSetDictForCheck = [self.restFieldDict objectForKey:checkNameModel.cardID];
    
    
    // 因為姓名有排序過，直接往下找即可。一但有不一樣的就結束
    for(NSUInteger i=startIndex; i<[self.nameArray count]; i++)
    {
        curNameModel = [self.nameArray objectAtIndex:i];
        
        // get current value set dict
        fieldValueSetDictForCurrent = [self.restFieldDict objectForKey:curNameModel.cardID];
        
        //////////////////////////////////////////////////
        // !! 比對姓名是否相同的規則
        // curNameModel的所有姓名被checkNameModel的所有姓名包含
        
        // get check value set for name
        checkValueSet = [fieldValueSetDictForCheck objectForIntKey:WC_FT_Name];
        
        // get current value set for name
        curValueSet = [fieldValueSetDictForCurrent objectForIntKey:WC_FT_Name];
        
        if(![curNameModel.cardID isEqualToString:checkNameModel.cardID] &&
           [curNameModel.name compare:checkNameModel.name options:NSCaseInsensitiveSearch]==NSOrderedSame)
        {
            // 如果curValueSet不是checkValueSet的subset, 就不是重複
            if([checkNameModel.name length]!=0 &&
               [curValueSet isSubsetOfSet:checkValueSet]==NO)
            {
                continue ;
            }
            
            // 姓名有重復，
            hasDuplicateValue = YES;

            //////////////////////////////////////////////////
            // 比對完畢，寫入結果，
            if(hasDuplicateValue)
            {
                // !! 如果沒有才要加
                if([duplicateCardIDArray containsObject:checkNameModel.cardID]==NO)
                {
                    [duplicateCardIDArray addObject:checkNameModel.cardID];
                }
                [duplicateCardIDArray addObject:curNameModel.cardID];
                [self removeDataWithCardID:curNameModel.cardID];
                i--;
            }
        }
        else break;
    }
    
    
    return duplicateCardIDArray;
}


//===============================================================================
// 取得所有包含相同資料的cardID array
// NOTE: 資料已排序過
//===============================================================================
- (NSMutableArray *)copyDuplicateCardIDArrayWithCheckNameModel:(WCDuplicateCheckNameModel *)checkNameModel
                                      checkFieldValueSetDict:(NSMutableDictionary *)checkFieldValueSetDict
                                              findStartIndex:(BOOL)findStartIndex

{
    NSMutableArray      *duplicateCardIDArray = [[NSMutableArray alloc] init];
    BOOL                isEmailEmpty = NO;
    BOOL                isPhoneEmpty = NO;
    BOOL                hasDuplicateValue;

    WCDuplicateCheckNameModel *curNameModel = nil;
    NSMutableDictionary *fieldValueSetDictForCheck = nil;
    NSMutableDictionary *fieldValueSetDictForCurrent = nil;
    NSSet               *curValueSet = nil;
    NSSet               *checkValueSet = nil;
    NSInteger           startIndex = 0;


    if(findStartIndex)
        startIndex = [self indexWithFirstSameName:checkNameModel];

    // get check value set dict
    if(checkFieldValueSetDict)
        fieldValueSetDictForCheck = checkFieldValueSetDict;
    else fieldValueSetDictForCheck = [self.restFieldDict objectForKey:checkNameModel.cardID];
    
    
    // 因為姓名有排序過，直接往下找即可。一但有不一樣的就結束
    for(NSUInteger i=startIndex; i<[self.nameArray count]; i++)
    {
        curNameModel = [self.nameArray objectAtIndex:i];

        // get current value set dict
        fieldValueSetDictForCurrent = [self.restFieldDict objectForKey:curNameModel.cardID];
        
        //////////////////////////////////////////////////
        // !! 比對姓名是否相同的規則
        // curNameModel的所有姓名被checkNameModel的所有姓名包含
        
        // get check value set for name
        checkValueSet = [fieldValueSetDictForCheck objectForIntKey:WC_FT_Name];
        
        // get current value set for name
        curValueSet = [fieldValueSetDictForCurrent objectForIntKey:WC_FT_Name];
        
        if(![curNameModel.cardID isEqualToString:checkNameModel.cardID] &&
           [curNameModel.name compare:checkNameModel.name options:NSCaseInsensitiveSearch]==NSOrderedSame)
        {
            // 如果curValueSet不是checkValueSet的subset, 就不是重複
            if([checkNameModel.name length]!=0 &&
               [curValueSet isSubsetOfSet:checkValueSet]==NO)
            {
                continue ;
            }
            
            // 姓名有重復，
            isEmailEmpty = NO;
            isPhoneEmpty = NO;
            hasDuplicateValue = NO;

            //////////////////////////////////////////////////
            //檢查email是否有相同的
            // 兩筆都有email且有相同的email才算相同，不同則算不同，不用再做電話公司的比對
            // 任一筆沒有email, 則做電話，公司的比對
            // get check value set for mail
            checkValueSet = [fieldValueSetDictForCheck objectForIntKey:WC_FT_Email];

            // get current value set for mail
            curValueSet = [fieldValueSetDictForCurrent objectForIntKey:WC_FT_Email];

            if ([checkValueSet count] && [curValueSet count])
            {
                hasDuplicateValue = [checkValueSet intersectsSet:curValueSet];
            }
            else
            {
                // 都沒有email,
                if (![checkValueSet count] && ![curValueSet count])
                {
                    isEmailEmpty = YES;
                }
                
                // 任一筆沒有email
                
                //////////////////////////////////////////////////
                // email不相同，檢查phone是否有相同的
                if(!hasDuplicateValue)
                {
                    // get check value set for phone
                    checkValueSet = [fieldValueSetDictForCheck objectForIntKey:WC_FT_Phone];
                    
                    // get current value set for phone
                    curValueSet = [fieldValueSetDictForCurrent objectForIntKey:WC_FT_Phone];
                    
                    if ([checkValueSet count] && [curValueSet count])
                    {
                        hasDuplicateValue = [checkValueSet intersectsSet:curValueSet];
                    }
                    else if (![checkValueSet count] && ![curValueSet count])
                    {
                        hasDuplicateValue = NO;
                        isPhoneEmpty = YES;
                    }
                    else
                    {
                        hasDuplicateValue = NO;
                    }
                }
                
                //////////////////////////////////////////////////
                // phone不相同，檢查company是否有相同的
                if(!hasDuplicateValue)
                {
                    // get check value set for company
                    checkValueSet = [fieldValueSetDictForCheck objectForIntKey:WC_FT_Company];
                    
                    // get current value set for company
                    curValueSet = [fieldValueSetDictForCurrent objectForIntKey:WC_FT_Company];
                    
                    if ([checkValueSet count] && [curValueSet count])
                    {
                        hasDuplicateValue = [checkValueSet intersectsSet:curValueSet];
                    }
                    else if (![checkValueSet count] && ![curValueSet count])
                    {
                        // !! special case :
                        //    1. 當有姓名時，company, phone和email都是空的，當作是一樣的資料。
                        //    2. 當沒有姓名時，company, phone和email都是空的，另外處理，不會在這邊比
                        if([curNameModel.name length])
                        {
                            hasDuplicateValue = (isEmailEmpty&isPhoneEmpty);
                        }
                        else
                        {
                            hasDuplicateValue = NO;
                        }
                    }
                    else
                    {
                        hasDuplicateValue = NO;
                    }
                }
            }
            
            //////////////////////////////////////////////////
            // 比對完畢，寫入結果，
            if(hasDuplicateValue)
            {
                // !! 如果沒有才要加
                if([duplicateCardIDArray containsObject:checkNameModel.cardID]==NO)
                {
                    [duplicateCardIDArray addObject:checkNameModel.cardID];
                }
                [duplicateCardIDArray addObject:curNameModel.cardID];
                [self removeDataWithCardID:curNameModel.cardID];
                i--;
            }
        }
        else break;
    }


    return duplicateCardIDArray;
}


//===============================================================================
// copy data for filter duplicate
//===============================================================================
- (void)getDuplicateCheckNameArray:(NSMutableArray *)checkNameArray
            checkFieldValueSetDict:(NSMutableDictionary *)checkFieldValueSetDict
                     fromCardModel:(WCCardModel *)cardModel
{
    WCDuplicateCheckNameModel *checkFieldModel = nil;
    WCFieldModel *subType2FieldModel;
    NSMutableSet *fieldValueSet = nil;
    NSString *fieldValue;
    NSArray *fieldArray = nil;


    [checkNameArray removeAllObjects];
    [checkFieldValueSetDict removeAllObjects];

    //----------------------------------
    // prepare name data
    //----------------------------------
    fieldArray = [cardModel fieldArrayWithType:WC_FT_Name];

    for(WCFieldModel *fieldModel in fieldArray)
    {
        fieldValue = [fieldModel stringDisplayName];

        if([fieldValue length])
        {
            checkFieldModel = [WCDuplicateCheckNameModel copyNameModelWithCardID:cardModel.ID name:fieldValue];
            [checkNameArray addObject:checkFieldModel];
            [checkFieldModel release];
        }
    }


    //----------------------------------
    // prepare company data
    //----------------------------------
    fieldArray = [cardModel fieldArrayWithType:WC_FT_Company];
    fieldValueSet = [[NSMutableSet alloc] init];

    for(WCFieldModel *fieldModel in fieldArray)
    {
        subType2FieldModel = [fieldModel fieldWithSubType2:WC_FST2_Company_Name];
        fieldValue = subType2FieldModel.value;

        if([fieldValue length])
            [fieldValueSet addObject:fieldValue];
    }

    if([fieldValueSet count])
        [checkFieldValueSetDict setObject:fieldValueSet forIntKey:WC_FT_Company];

    [fieldValueSet release];


    //----------------------------------
    // prepare email data
    //----------------------------------
    fieldArray = [cardModel fieldArrayWithType:WC_FT_Email];
    fieldValueSet = [[NSMutableSet alloc] init];

    for(WCFieldModel *fieldModel in fieldArray)
    {
        fieldValue = fieldModel.value;

        if([fieldValue length])
            [fieldValueSet addObject:fieldValue];
    }

    if([fieldValueSet count])
        [checkFieldValueSetDict setObject:fieldValueSet forIntKey:WC_FT_Email];

    [fieldValueSet release];
}


//===============================================================================
//
//===============================================================================
- (NSInteger)indexWithFirstSameName:(WCDuplicateCheckNameModel *)nameModel
{
    if(![nameArray_ count])
        return 0;

    NSInteger index = [nameArray_ indexOfObject:nameModel
                                  inSortedRange:NSMakeRange(0, [nameArray_ count])
                                        options:NSBinarySearchingFirstEqual
                                usingComparator:^(WCDuplicateCheckNameModel *a, WCDuplicateCheckNameModel *b)
                  {
                      return [a.name compare:b.name];
                  }];

    if(index > [nameArray_ count]-1)
        index = [nameArray_ count];

    //test
//    NSLog(@"index:%d", index);

    return index;
}


//===============================================================================
//
//===============================================================================
- (void)removeDataWithCardID:(NSString *)cardID
{
    for(int i=0; i<[nameArray_ count]; i++)
    {
        WCDuplicateCheckNameModel *nameModel = [nameArray_ objectAtIndex:i];

        if([nameModel.cardID isEqualToString:cardID])
        {
            [nameArray_ removeObjectAtIndex:i];
            i--;
        }
    }

    [restFieldDict_ removeObjectForKey:cardID];
}



//===============================================================================
// compare modified time, first object is lastest (private)
//===============================================================================
int CompareName(WCDuplicateCheckNameModel *model1, WCDuplicateCheckNameModel *model2, void *param)
{
        return ([model1.name compare:model2.name]);
}


//===============================================================================
//
//===============================================================================
- (void)addDataWithNameArray:(NSArray *)nameArray fieldValueSetDict:(NSMutableDictionary *)fieldValueSetDict
{
    if(![nameArray count])
        return;

    NSInteger index;

    for(WCDuplicateCheckNameModel *nameModel in nameArray)
    {
        index = [nameArray_ indexOfObject:nameModel
                            inSortedRange:NSMakeRange(0, [nameArray_ count])
                                  options:NSBinarySearchingInsertionIndex
                          usingComparator:^(WCDuplicateCheckNameModel *a, WCDuplicateCheckNameModel *b)
                 {
                     return [a.name compare:b.name];
                 }];

        [nameArray_ insertObject:nameModel atIndex:index];
    }

    //test
//    NSLog(@"nameArray_: \n%@", nameArray_);

    if(fieldValueSetDict)
    {
        WCDuplicateCheckNameModel *nameModel = [nameArray objectAtIndex:0];
        [restFieldDict_ setObject:fieldValueSetDict forKey:nameModel.cardID];
    }
}



//==============================================================================
//
//==============================================================================
- (BOOL)isRestFieldEmpty:(NSString *)cardID
{
    NSMutableDictionary *fieldValueSetDict = [self.restFieldDict objectForKey:cardID];
    
    NSSet *emailSet = [fieldValueSetDict objectForIntKey:WC_FT_Email];
    NSSet *companySet = [fieldValueSetDict objectForIntKey:WC_FT_Company];
    NSSet *phoneSet = [fieldValueSetDict objectForIntKey:WC_FT_Phone];

    return ([emailSet count]==0 && [companySet count]==0 && [phoneSet count]==0);
}

@end



////////////////////////////////////////////////////////////////////////////////////////////////////



@implementation WCDuplicateCheckNameModel


//===============================================================================
//
//===============================================================================
- (void)dealloc
{
    self.cardID = nil;
    self.name = nil;
    self.allFieldValueString = nil;
    
    //////////////////////////////////////////////////
    [super dealloc];
}


//===============================================================================
//
//===============================================================================
- (NSString *)description
{
    NSMutableString *msg = [NSMutableString string];

    [msg appendFormat:@"cardID:%@ ", self.cardID];
    [msg appendFormat:@"name:%@ ", self.name];
    [msg appendFormat:@"allFieldValueString:%@", self.allFieldValueString];

    return msg;
}


//===============================================================================
//
//===============================================================================
+ (id)copyNameModelWithCardID:(NSString *)cardID name:(NSString *)name
{
    WCDuplicateCheckNameModel *nameModel = [[WCDuplicateCheckNameModel alloc] init];
    nameModel.cardID = cardID;
    nameModel.name = name ? name : @"";

    return nameModel;
}


@end
