//
//  WCFieldModel.m
//  WorldCard series
//
//  Created by  Eddie on 2012/3/22.
//  Copyright 2011 Penpower. All rights reserved.
//


#import "NSString+Additions.h"
#import "PPCountryCodeConvert.h"
#import "PPMutableDictionary+NSInteger.h"
#import "WCFieldModel.h"
#import "PPWorldcardAddressController.h"
#import "WCUserDefinedFieldValueModel.h"

#if TARGET_OS_IPHONE

#import "PPURLController.h"

#elif TARGET_OS_MAC

// MAC OS不用判斷navicon
#endif

/////////////////////////////////////////////
//
// WCFieldModel
//
@implementation WCFieldModel


@synthesize ID = ID_;
@synthesize order = order_;
@synthesize source = source_;
@synthesize type = type_;
@synthesize subType1 = subType1_;
@synthesize subType2 = subType2_;
@synthesize value = value_;
@synthesize recogRect = recogRect_;
@synthesize isCJKStringValue = isCJKStringValue_;


////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Life cycle methods

//===============================================================================
//
//===============================================================================
- (id)init
{
    if ((self = [super init]))
    {
        self.ID = WC_InvalidRecordID;
        self.order = 0;
        self.source = WC_FS_UserCreate;
        self.type = WC_FT_None;
        self.subType1 = WC_FST1_None;
        self.subType2 = WC_FST2_None;
        self.value = nil;
        self.recogRect = CGRectZero;
        self.isCJKStringValue = NO;
    }

    return self;
}


//===============================================================================
//
//===============================================================================
- (void)dealloc
{
    self.value = nil;
    
    //////////////////////////////////////////////////
    // WCT
    self.guid = nil;
    self.customFieldInfoGuid = nil;
    //////////////////////////////////////////////////
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Overwrite methods

//===============================================================================
//
//===============================================================================
//- (id)copy
//{
//    WCFieldModel *fieldModel = [[WCFieldModel alloc] init];
//
//    fieldModel.ID = self.ID;
//    fieldModel.order = self.order;
//    fieldModel.source = self.source;
//    fieldModel.type = self.type;
//    fieldModel.subType1 = self.subType1;
//    fieldModel.subType2 = self.subType2;
//    fieldModel.recogRect = self.recogRect;
//    fieldModel.isCJKStringValue = self.isCJKStringValue;
//
//    if([self.value isKindOfClass:[NSDictionary class]])
//    {
//        NSMutableDictionary *srcDict = (NSMutableDictionary *)self.value;
//        NSMutableDictionary *dstDict = [[NSMutableDictionary alloc] init];
//        NSArray *allKeys = [srcDict allKeys];
//
//        for(NSString *key in allKeys)
//        {
//            WCFieldModel *srcSubField = [srcDict objectForKey:key];
//            WCFieldModel *dstSubField = [srcSubField copy];
//
//            [dstDict setObject:dstSubField forKey:key];
//            [dstSubField release];
//        }
//
//        fieldModel.value = dstDict;
//        [dstDict release];
//    }
//    else
//    {
//        id copyValue = [self.value copy];
//        fieldModel.value = copyValue;
//        [copyValue release];
//    }
//
//    return fieldModel;
//}


//===============================================================================
//
//===============================================================================
- (id)copyWithZone:(NSZone *)zone
{
    WCFieldModel *fieldModel = [[[self class] allocWithZone:zone] init];
    
    if(fieldModel!=nil)
    {
        fieldModel.ID = self.ID;
        fieldModel.order = self.order;
        fieldModel.source = self.source;
        fieldModel.type = self.type;
        fieldModel.subType1 = self.subType1;
        fieldModel.subType2 = self.subType2;
        fieldModel.recogRect = self.recogRect;
        fieldModel.isCJKStringValue = self.isCJKStringValue;

        //////////////////////////////////////////////////
        // WCT 用
        fieldModel.guid  = [[self.guid copyWithZone:zone] autorelease];
        fieldModel.customFieldInfoGuid  = [[self.customFieldInfoGuid copyWithZone:zone] autorelease];
        fieldModel.customFieldContentType = self.customFieldContentType;
        
        //////////////////////////////////////////////////
        if([self.value isKindOfClass:[NSDictionary class]])
        {
            NSMutableDictionary *srcDict = (NSMutableDictionary *)self.value;
            NSMutableDictionary *dstDict = [[NSMutableDictionary alloc] init];
            NSArray *allKeys = [srcDict allKeys];
            
            for(NSString *key in allKeys)
            {
                WCFieldModel *srcSubField = [srcDict objectForKey:key];
                WCFieldModel *dstSubField = [srcSubField copyWithZone:zone];
                
                [dstDict setObject:dstSubField forKey:key];
                [dstSubField release];
            }
            
            fieldModel.value = dstDict;
            [dstDict release];
        }
        else
        {
            fieldModel.value  = [[self.value copyWithZone:zone] autorelease];
        }
    }
    
    return fieldModel;
}


//===============================================================================
//
//===============================================================================
- (BOOL)isEqual:(id)object
{
    if(![object isKindOfClass:[WCFieldModel class]])
        return NO;
    
    WCFieldModel *dstFieldmodel = (WCFieldModel *)object;
    
    if(self.ID == dstFieldmodel.ID &&
       self.type == dstFieldmodel.type &&
       self.subType1 == dstFieldmodel.subType1 &&
       self.subType2 == dstFieldmodel.subType2 &&
       [self hasSameValue:dstFieldmodel])
    {
        return YES;
        
//        if([[self guid] length]<=0 &&
//           [[dstFieldmodel guid] length]<=0)
//        {
//            return YES;
//        }
//        else
//        {
//            if([[self guid] length]>0 &&
//               [[self guid] compare:[dstFieldmodel guid] options:NSCaseInsensitiveSearch]==NSOrderedSame)
//            {
//                return YES;
//            }
//            else
//            {
//                return NO;
//            }
//        }
    }
    
    return NO;
}


//===============================================================================
//
//===============================================================================
- (NSString *)description
{
    NSString *subSpace = @"";

    if(subType2_ != WC_FST2_None)
        subSpace = @"      ";

    NSMutableString *msg = [[NSMutableString alloc] initWithFormat:@"\r\n%@---------- WCFieldModel ----------", subSpace];

    //////////////////////////////////////////////////
    // WCT
    [msg appendFormat:@"\r\n%@ guid: %@", subSpace, self.guid];
    [msg appendFormat:@"\r\n%@ customFieldInfoGuid: %@", subSpace, self.customFieldInfoGuid];
    [msg appendFormat:@"\r\n%@ customFieldContentType: %ld", subSpace, (long)self.customFieldContentType];

    //////////////////////////////////////////////////
    
    [msg appendFormat:@"\r\n%@ ID:%d", subSpace, (int)ID_];
    [msg appendFormat:@"\r\n%@ order:%d", subSpace, (int)order_];
    [msg appendFormat:@"\r\n%@ source:%d", subSpace, (int)source_];
    
#if TARGET_OS_IPHONE
    [msg appendFormat:@"\r\n%@ recogRect:%@", subSpace, NSStringFromCGRect(recogRect_)];
#elif TARGET_OS_MAC
    [msg appendFormat:@"\r\n%@ recogRect:%@", subSpace, NSStringFromRect(recogRect_)];
#endif
    
    [msg appendFormat:@"\r\n%@ type:%d (%@)", subSpace, (int)type_, WCFieldTypeString(type_)];
    [msg appendFormat:@"\r\n%@ subType1:%d (%@)", subSpace, (int)subType1_, WCFieldTypeString(subType1_)];
    [msg appendFormat:@"\r\n%@ subType2:%d (%@)", subSpace, (int)subType2_, WCFieldTypeString(subType2_)];

    //////////////////////////////////////////////////
    
    if([value_ isKindOfClass:[NSMutableDictionary class]])
    {
        NSMutableDictionary *dataDict = value_;
        NSArray *allValues = [dataDict allValues];

        [msg appendString:@"\r\n"];

        for(WCFieldModel *fieldModel in allValues)
            [msg appendString:[fieldModel description]];
    }
    else
    {
        [msg appendFormat:@"\r\n%@ value:%@", subSpace, value_];
    }

    [msg appendString:@"\r\n"];

    return [msg autorelease];
}


//===============================================================================
//
//===============================================================================
- (void)setOrder:(NSInteger)order
{
    order_ = order;

    if([self.value isKindOfClass:[NSMutableDictionary class]])
    {
        NSArray *subType2FieldArray = [(NSMutableDictionary *)self.value allValues];

        for(WCFieldModel *subType2FieldModel in subType2FieldArray)
            subType2FieldModel.order = order_;
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Instance methods

//===============================================================================
//
//===============================================================================
- (BOOL)isEmpty
{
    return (self.value == nil);
}


#pragma mark ##### Generate display string #####

//===============================================================================
//
//===============================================================================
- (NSString *)stringDisplayCompany
{
    return [self valueWithSubType2:WC_FST2_Company_Name];
}


//===============================================================================
//
//===============================================================================
- (NSString *)stringDisplayCompanyPhonetic
{
    return [self valueWithSubType2:WC_FST2_Company_Phonetic];
}


//===============================================================================
//
//===============================================================================
- (NSString *)stringDisplayGPS
{
    NSMutableString *retString = [NSMutableString string];
    NSString *gps = [self valueWithSubType2:WC_FST2_Address_Location];
    
    if (gps.length)
        [retString appendFormat:@"%@", gps];
    
    return retString;
}


//===============================================================================
//
//===============================================================================
- (NSInteger)addressFormatWithBCRLanguage:(NSInteger)bcrLanguage
{
    NSInteger format = [[self valueWithSubType2:WC_FST2_Address_Format] integerValue];
    if(format!=0)
    {
        return format;
    }
    
    NSString *country = nil;
    NSString *countryCode = [self valueWithSubType2:WC_FST2_Address_CountryCode];
    NSString *street = [self valueWithSubType2:WC_FST2_Address_Street];
    NSString *state = [self valueWithSubType2:WC_FST2_Address_State];
    NSString *city = [self valueWithSubType2:WC_FST2_Address_City];
    NSString *zip = [self valueWithSubType2:WC_FST2_Address_ZIP];
    
    // 以country code為主
                
    if(countryCode==nil || countryCode.length<=0)
    {
        country = [self valueWithSubType2:WC_FST2_Address_Country];
    }
    else if(bcrLanguage==-1)
    {
        country = [PPCountryCodeConvert localizeStringFromCountryCode:countryCode];
    }
    else
    {
        country  = [PPCountryCodeConvert localizeStringFromCountryCode:countryCode
                                                      withLanguageCode:[PPCountryCodeConvert languageCodeWithRecogLang:bcrLanguage]];
    }
    
    NSMutableString *returnedCountry = [NSMutableString string];
    NSMutableString *returnedCountryCode = [NSMutableString string];
    
    // 有country code要設定到returnedCountryCode
    if ([countryCode length]>0)
    {
        [returnedCountryCode setString:countryCode];
    }
    
    // 有country code要設定到returnedCountry
    if ([country length]>0)
    {
        [returnedCountry setString:country];
    }
    
    // 沒有country code也沒有country，country code用default
    if([returnedCountry length]==0 && [returnedCountryCode length]==0)
    {
        [returnedCountryCode setString:[PPCountryCodeConvert defaultCountryCode]];
    }
    
    //////////////////////////////////////////////////
    return [PPWorldcardAddressController formatFromStreet:street
                                                     city:city
                                                 province:state
                                               postalCode:zip
                                              countryName:returnedCountry
                                                   format:-1
                                              countryCode:returnedCountryCode
                                              bcrLanguage:bcrLanguage
                                           systemLanguage:[PPWorldcardAddressController addressSystemLanguage]];
    
}


//==============================================================================
//
//==============================================================================
- (PPURLControllerType)addressURLTypeWithBCRLanguage:(NSInteger)bcrLanguage
{
    if(self.type!=WC_FT_Address)
    {
        return PPURLControllerType_None;
    }
    
    NSString *country = nil;
    NSString *countryCode = [self valueWithSubType2:WC_FST2_Address_CountryCode];
    NSString *street = [self valueWithSubType2:WC_FST2_Address_Street];
    NSString *state = [self valueWithSubType2:WC_FST2_Address_State];
    NSString *city = [self valueWithSubType2:WC_FST2_Address_City];
    NSString *zip = [self valueWithSubType2:WC_FST2_Address_ZIP];
    
    // 以country code為主
                
    if(countryCode==nil || countryCode.length<=0)
    {
        country = [self valueWithSubType2:WC_FST2_Address_Country];
    }
    else if(bcrLanguage==-1)
    {
        country = [PPCountryCodeConvert localizeStringFromCountryCode:countryCode];
    }
    else
    {
        country  = [PPCountryCodeConvert localizeStringFromCountryCode:countryCode
                                                      withLanguageCode:[PPCountryCodeConvert languageCodeWithRecogLang:bcrLanguage]];
    }
    
    NSMutableString *returnedCountry = [NSMutableString string];
    NSMutableString *returnedCountryCode = [NSMutableString string];
    
    // 有country code要設定到returnedCountryCode
    if ([countryCode length]>0)
    {
        [returnedCountryCode setString:countryCode];
    }
    
    // 有country code要設定到returnedCountry
    if ([country length]>0)
    {
        [returnedCountry setString:country];
    }
    
    // 沒有country code也沒有country，country code用default
    if([returnedCountry length]==0 && [returnedCountryCode length]==0)
    {
        [returnedCountryCode setString:[PPCountryCodeConvert defaultCountryCode]];
    }
    
    //////////////////////////////////////////////////
    [PPWorldcardAddressController formatFromStreet:street
                                              city:city
                                          province:state
                                        postalCode:zip
                                       countryName:returnedCountry
                                            format:-1
                                       countryCode:returnedCountryCode
                                       bcrLanguage:bcrLanguage
                                    systemLanguage:[PPWorldcardAddressController addressSystemLanguage]];
    
    
    //////////////////////////////////////////////////
    if([[returnedCountryCode lowercaseString] isEqualToString:@"cn"])
    {
        return PPURLControllerType_BaiduMap;
    }
    else if([[returnedCountryCode lowercaseString] isEqualToString:@"jp"])
    {
        if ([PPURLController canOpenURLWithType:PPURLControllerType_NaviCon])
        {
            return PPURLControllerType_NaviCon;
        }
        else
        {
            return PPURLControllerType_GoogleMap;
        }
    }
    else
    {
        return PPURLControllerType_GoogleMap;
    }

}


//===============================================================================
//
//===============================================================================
- (NSString *)stringDisplayCountryWithBCRLanguage:(NSInteger)bcrLanguage
{
    if(self.type!=WC_FT_Address)
    {
        return nil;
    }
    
    NSString *country = nil;
    NSString *countryCode = [self valueWithSubType2:WC_FST2_Address_CountryCode];
    NSString *street = [self valueWithSubType2:WC_FST2_Address_Street];
    NSString *state = [self valueWithSubType2:WC_FST2_Address_State];
    NSString *city = [self valueWithSubType2:WC_FST2_Address_City];
    NSString *zip = [self valueWithSubType2:WC_FST2_Address_ZIP];
    
    // 以country code為主
                
    if(countryCode==nil || countryCode.length<=0)
    {
        country = [self valueWithSubType2:WC_FST2_Address_Country];
    }
    else if(bcrLanguage==-1)
    {
        country = [PPCountryCodeConvert localizeStringFromCountryCode:countryCode];
    }
    else
    {
        country  = [PPCountryCodeConvert localizeStringFromCountryCode:countryCode
                                                      withLanguageCode:[PPCountryCodeConvert languageCodeWithRecogLang:bcrLanguage]];
    }
    
    
    NSMutableString *returnedCountry = [NSMutableString string];
    NSMutableString *returnedCountryCode = [NSMutableString string];
    
    // 有country code要設定到returnedCountryCode
    if ([countryCode length]>0)
    {
        [returnedCountryCode setString:countryCode];
    }
    
    // 有country code要設定到returnedCountry
    if ([country length]>0)
    {
        [returnedCountry setString:country];
    }
    
    // 沒有country code也沒有country，country code用default
    if([returnedCountry length]==0 && [returnedCountryCode length]==0)
    {
        [returnedCountryCode setString:[PPCountryCodeConvert defaultCountryCode]];
    }
    
    //////////////////////////////////////////////////
    [PPWorldcardAddressController formatFromStreet:street
                                              city:city
                                          province:state
                                        postalCode:zip
                                       countryName:returnedCountry
                                            format:-1
                                       countryCode:returnedCountryCode
                                       bcrLanguage:bcrLanguage
                                    systemLanguage:[PPWorldcardAddressController addressSystemLanguage]];
    
    return [NSString stringWithString:returnedCountry];
}


//===============================================================================
//
//===============================================================================
- (NSString *)stringDisplayAddressWithBCRLanguage:(NSInteger)bcrLanguage
{
    if(self.type!=WC_FT_Address)
    {
        return nil;
    }
    
    NSInteger format = 0;
    NSString *country = nil;
    NSString *countryCode = [self valueWithSubType2:WC_FST2_Address_CountryCode];
    NSString *street = [self valueWithSubType2:WC_FST2_Address_Street];
    NSString *state = [self valueWithSubType2:WC_FST2_Address_State];
    NSString *city = [self valueWithSubType2:WC_FST2_Address_City];
    NSString *zip = [self valueWithSubType2:WC_FST2_Address_ZIP];
    
    // 以country code為主
                
    if(countryCode==nil || countryCode.length<=0)
    {
        country = [self valueWithSubType2:WC_FST2_Address_Country];
    }
    else if(bcrLanguage==-1)
    {
        country = [PPCountryCodeConvert localizeStringFromCountryCode:countryCode];
    }
    else
    {
        country  = [PPCountryCodeConvert localizeStringFromCountryCode:countryCode
                                                      withLanguageCode:[PPCountryCodeConvert languageCodeWithRecogLang:bcrLanguage]];
    }
    
    
    NSMutableString *returnedCountry = [NSMutableString string];
    NSMutableString *returnedCountryCode = [NSMutableString string];
    
    // 有country code要設定到returnedCountryCode
    if ([countryCode length]>0)
    {
        [returnedCountryCode setString:countryCode];
    }
    
    // 有country code要設定到returnedCountry
    if ([country length]>0)
    {
        [returnedCountry setString:country];
    }
    
    // 沒有country code也沒有country，country code用default
    if([returnedCountry length]==0 && [returnedCountryCode length]==0)
    {
        [returnedCountryCode setString:[PPCountryCodeConvert defaultCountryCode]];
    }
    
    //////////////////////////////////////////////////
    format = [PPWorldcardAddressController formatFromStreet:street
                                                       city:city
                                                   province:state
                                                 postalCode:zip
                                                countryName:returnedCountry
                                                     format:-1
                                                countryCode:returnedCountryCode
                                                bcrLanguage:bcrLanguage
                                             systemLanguage:[PPWorldcardAddressController addressSystemLanguage]];
    
    //////////////////////////////////////////////////
    
    return [PPWorldcardAddressController addressFromStreet:street city:city province:state postalCode:zip countryName:returnedCountry format:format];
}


//==============================================================================
//
//==============================================================================
- (NSString *)stringGoogleAddressWithBCRLanguage:(NSInteger)bcrLanguage
{
    if(self.type!=WC_FT_Address)
    {
        return nil;
    }
    
    NSString *country = nil;
    NSString *countryCode = [self valueWithSubType2:WC_FST2_Address_CountryCode];
    NSString *street = [self valueWithSubType2:WC_FST2_Address_Street];
    NSString *state = [self valueWithSubType2:WC_FST2_Address_State];
    NSString *city = [self valueWithSubType2:WC_FST2_Address_City];
    NSString *zip = [self valueWithSubType2:WC_FST2_Address_ZIP];
    
    // 以country code為主
                
    if(countryCode==nil || countryCode.length<=0)
    {
        country = [self valueWithSubType2:WC_FST2_Address_Country];
    }
    else if(bcrLanguage==-1)
    {
        country = [PPCountryCodeConvert localizeStringFromCountryCode:countryCode];
    }
    else
    {
        country  = [PPCountryCodeConvert localizeStringFromCountryCode:countryCode
                                                      withLanguageCode:[PPCountryCodeConvert languageCodeWithRecogLang:bcrLanguage]];
    }
    
    
    NSMutableString *returnedCountry = [NSMutableString string];
    NSMutableString *returnedCountryCode = [NSMutableString string];
    
    // 有country code要設定到returnedCountryCode
    if ([countryCode length]>0)
    {
        [returnedCountryCode setString:countryCode];
    }
    
    // 有country code要設定到returnedCountry
    if ([country length]>0)
    {
        [returnedCountry setString:country];
    }
    
    // 沒有country code也沒有country，country code用default
    if([returnedCountry length]==0 && [returnedCountryCode length]==0)
    {
        [returnedCountryCode setString:[PPCountryCodeConvert defaultCountryCode]];
    }
    
    if(bcrLanguage==-1)
    {
        bcrLanguage = [PPWorldcardAddressController addressSystemLanguage];
    }
    
    //////////////////////////////////////////////////
    [PPWorldcardAddressController formatFromStreet:street
                                              city:city
                                          province:state
                                        postalCode:zip
                                       countryName:returnedCountry
                                            format:-1
                                       countryCode:returnedCountryCode
                                       bcrLanguage:bcrLanguage
                                    systemLanguage:[PPWorldcardAddressController addressSystemLanguage]];
    
    return [PPWorldcardAddressController googleMapAddressFromStreet:street city:city province:state postalCode:zip countryCode:returnedCountryCode];
}






#pragma mark ##### handle subType2 field #####

//===============================================================================
// only for dictionary value
//===============================================================================
- (void)setSubType2Field:(WCFieldModel *)fieldModel
{
    if(!fieldModel)
        return;

    fieldModel.type = self.type;
    fieldModel.subType1 = self.subType1;

    if(!self.value)
    {
        NSMutableDictionary *dict = [[NSMutableDictionary alloc] init];
        [dict setObject:fieldModel forIntKey:fieldModel.subType2];
        self.value = dict;
        [dict release];
    }
    else if([self.value isKindOfClass:[NSMutableDictionary class]])
    {
        NSMutableDictionary *dict = self.value;
        [dict setObject:fieldModel forIntKey:fieldModel.subType2];
    }
}


//===============================================================================
// only for dictionary value
//===============================================================================
- (void)setSubType2FieldWithValue:(id)value recogRect:(CGRect)recogRect subType2:(WC_FieldSubType2)fieldSubType2
{
    if(!value)
        return;

    if([value isKindOfClass:[NSString class]] && [(NSString *)value length]==0)
        return;

    WCFieldModel *subType2FieldModel = [self copy];

    subType2FieldModel.subType2 = fieldSubType2;
    subType2FieldModel.value = value;
    subType2FieldModel.recogRect =recogRect;

    [self setSubType2Field:subType2FieldModel];
    [subType2FieldModel release];
}


//===============================================================================
// only for dictionary value
//===============================================================================
- (WCFieldModel *)fieldWithSubType2:(WC_FieldSubType2)fieldSubType2
{
    WCFieldModel *fieldModel = nil;

    if([self.value isKindOfClass:[NSMutableDictionary class]])
    {
        NSMutableDictionary *valueDict = (NSMutableDictionary *)self.value;

        fieldModel = [valueDict objectForIntKey:fieldSubType2];
    }

    return fieldModel;
}


//===============================================================================
//
//===============================================================================
- (id)valueWithSubType2:(WC_FieldSubType2)fieldSubType2
{
    WCFieldModel *subType2FieldModel = [self fieldWithSubType2:fieldSubType2];
    return [subType2FieldModel value];
}



//===============================================================================
// only for dictionary value
//===============================================================================
- (BOOL)hasFieldWithSubType2:(WC_FieldSubType2)fieldSubType2
{
    if([self.value isKindOfClass:[NSMutableDictionary class]])
    {
        NSMutableDictionary *valueDict = (NSMutableDictionary *)self.value;
        WCFieldModel *fieldModel = [valueDict objectForIntKey:fieldSubType2];
        return (fieldModel != nil);
    }

    return NO;
}


//===============================================================================
// only for dictionary value
//===============================================================================
- (void)removeFieldWithWithSubType2:(WC_FieldSubType2)fieldSubType2
{
    if([self.value isKindOfClass:[NSMutableDictionary class]])
    {
        NSMutableDictionary *valueDict = (NSMutableDictionary *)self.value;
        [valueDict removeObjectForIntKey:fieldSubType2];
    }
}


//===============================================================================
// FUNCTION: getValueType
// DESCRIPTION: get value type
// PARAMETERS: <in> value object
// RETURNED: ValueType
//===============================================================================
- (WC_ValueType)valueTypeWithValue:(id)value
{
    if([value isKindOfClass:[NSDictionary class]])
        return WC_VT_Dictionary;
    else if([value isKindOfClass:[NSString class]])
        return WC_VT_String;
    else if([value isKindOfClass:[NSNumber class]])
        return WC_VT_Integer;
    else if([value isKindOfClass:[NSDate class]])
        return WC_VT_DateTime;
    else
        return WC_VT_None;
    
}


//===============================================================================
//
//===============================================================================
- (BOOL)hasSameValue:(WCFieldModel *)fieldModel
{
    WC_ValueType compareValueType = [self valueTypeWithValue:fieldModel.value];
    WC_ValueType selfValueType = [self valueTypeWithValue:self.value];


    if(compareValueType != selfValueType)
        return NO;

    switch (compareValueType)
    {
        case WC_VT_String:
        {
            return [fieldModel.value isEqualToString:self.value];
        }

        case WC_VT_Integer:
        {
            return [fieldModel.value intValue] == [self.value intValue];
        }

        case WC_VT_DateTime:
        {
            return [fieldModel.value isEqualToDate:self.value];
        }

        case WC_VT_Dictionary:
        {
            NSAutoreleasePool *pool = [[NSAutoreleasePool alloc] init];
            NSDictionary *srcSubFieldDict = self.value;
            NSDictionary *dstSubFieldDict = fieldModel.value;
            NSMutableArray *srcAllKeyArray = [NSMutableArray arrayWithArray:[[srcSubFieldDict allKeys] sortedArrayUsingSelector:@selector(caseInsensitiveCompare:)]];
            NSMutableArray *dstAllKeyArray = [NSMutableArray arrayWithArray:[[dstSubFieldDict allKeys] sortedArrayUsingSelector:@selector(caseInsensitiveCompare:)]];
            BOOL result = YES;

            // !! 特殊比對規則的欄位
            switch (fieldModel.type)
            {
                case WC_FT_Address:
                {
                    // 地址不用管以下欄位
                    [srcAllKeyArray removeObject:[NSString stringWithInteger:WC_FST2_SearchOnly]];
                    [srcAllKeyArray removeObject:[NSString stringWithInteger:WC_FST2_Address_Format]];
                    [srcAllKeyArray removeObject:[NSString stringWithInteger:WC_FST2_Address_Country]];
                    //                [srcAllKeyArray removeObject:[NSString stringWithInt:WC_FST2_Address_CountryCode]];

                    [dstAllKeyArray removeObject:[NSString stringWithInteger:WC_FST2_SearchOnly]];
                    [dstAllKeyArray removeObject:[NSString stringWithInteger:WC_FST2_Address_Format]];
                    [dstAllKeyArray removeObject:[NSString stringWithInteger:WC_FST2_Address_Country]];
                    //                [dstAllKeyArray removeObject:[NSString stringWithInt:WC_FST2_Address_CountryCode]];
                    break;
                }

                default:
                {
                    [srcAllKeyArray removeObject:[NSString stringWithInteger:WC_FST2_SearchOnly]];
                    [dstAllKeyArray removeObject:[NSString stringWithInteger:WC_FST2_SearchOnly]];
                    break;
                }
            }

            if([srcAllKeyArray isEqualToArray:dstAllKeyArray])
            {
                for(NSString *key in srcAllKeyArray)
                {
                    WCFieldModel *srcSubField = [srcSubFieldDict objectForKey:key];
                    WCFieldModel *dstSubField = [dstSubFieldDict objectForKey:key];

                    if(![srcSubField hasSameValue:dstSubField])
                    {
                        result = NO;
                        break;
                    }
                }
            }
            else
            {
                result = NO;
            }

            [pool release];
            return result;
        }
            
        case WC_VT_UserDefined:
        {
            WCUserDefinedFieldValueModel *srcValue = (WCUserDefinedFieldValueModel *)self.value;
            WCUserDefinedFieldValueModel *dstValue = (WCUserDefinedFieldValueModel *)fieldModel.value;
            
            return ([srcValue.label isEqualToString:dstValue.label] &&
                    [srcValue.value isEqualToString:dstValue.value]);
        }

        default:
            break;
    }

    return NO;

}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Class methods

//===============================================================================
// 建立欄位model
// return : WCFieldModel (release after using)
//===============================================================================
+ (instancetype)newFieldModel
{
    WCFieldModel *fieldModel = [[[self class] alloc] init];
    fieldModel.ID = WC_InvalidRecordID;
    
    return fieldModel;
}


@end
