//
//  WCCardSectionModel.m
//  WorldCard series
//
//  Created by  Eddie on 2012/3/22.
//  Copyright 2011 Penpower. All rights reserved.
//

#import "WCCardSectionModel.h"
#import "WCCardModel.h"

@implementation WCCardSectionModel


@synthesize title = title_;
@synthesize cardArray = cardArray_;
@synthesize needResortCard = needResortCard_;

#pragma mark - Life cycle methods


//===============================================================================
//
//===============================================================================
- (void)dealloc
{
	self.title = nil;
	self.cardArray = nil;
	[super dealloc];
}


//===============================================================================
//
//===============================================================================
- (id)copy
{
    WCCardSectionModel *cardSectionMode = [[WCCardSectionModel alloc] init];
    
    if([self.title length]!=0)
    {
        cardSectionMode.title = [NSString stringWithString:self.title];
    }
    cardSectionMode.needResortCard = self.needResortCard;
    cardSectionMode.cardArray = [NSMutableArray array];
    
    for(WCCardModel *cardModel in self.cardArray)
    {
        WCCardModel *newCardModel = [cardModel copy];
        [cardSectionMode.cardArray addObject:newCardModel];
        [newCardModel release];
    }
    
    return cardSectionMode;
}


//===============================================================================
// 
//===============================================================================
- (NSString *)description
{
    NSMutableString *msg = [NSMutableString string];
    
    [msg appendFormat:@"\n title : %@", self.title];
    [msg appendFormat:@"\n needResortCard : %d", self.needResortCard];
    [msg appendFormat:@"\n cardArray : (%lu)", (unsigned long)[self.cardArray count]];
    
    for(WCCardModel *cardModel in self.cardArray)
        [msg appendFormat:@"\n   cardID-%@", cardModel.ID];
//        [msg appendFormat:@"\n   cardID-%@, displayName-%@", cardModel.ID, cardModel.displayName];

    [msg appendString:@"\n"];
    
    return msg;
}


//===============================================================================
// 
//===============================================================================
- (BOOL)removeCardWithCardID:(NSString *)cardID
{
    for(int i=0; i<[cardArray_ count]; i++)
    {
        WCCardModel *cardModel = [cardArray_ objectAtIndex:i];
        
        if([cardModel.ID isEqualToString:cardID])
        {
            [cardArray_ removeObjectAtIndex:i];
            return YES;
        }
    }

    return NO;
}

@end
