//
//  PPRowModel+Contact.m
//
//  Created by Howard.Lin on 13/10/22.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "PPRowModel+Contact.h"
#import <objc/runtime.h>

@implementation PPRowModel (Contact)

////////////////////////////////////////////////////////////////////////////////////////////////////

static char const * const ppContactFieldSourceKey = "PPContactFieldSource";

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

//================================================================================
//
//================================================================================
- (PPContactRowObject *)ppContactRowObjectOfRowModel
{
    if(self.object!=nil && [self.object isKindOfClass:[PPContactRowObject class]]==YES)
    {
        return self.object;
    }
    else
    {
        return nil;
    }
}


//================================================================================
//
//================================================================================
- (PPContactFieldSource)ppContactFieldSource
{
    return [objc_getAssociatedObject(self, ppContactFieldSourceKey) unsignedIntegerValue];
}


//================================================================================
//
//================================================================================
- (void)setPPContactFieldSource:(PPContactFieldSource)contactFieldSource
{
    objc_setAssociatedObject(self, ppContactFieldSourceKey, @(contactFieldSource), OBJC_ASSOCIATION_RETAIN);
}


//================================================================================
//
//================================================================================
- (NSComparisonResult)labelTypeCompare:(PPRowModel *)rowModel
{
    if([self ppContactRowObjectOfRowModel].contactLabelType>[rowModel ppContactRowObjectOfRowModel].contactLabelType)
    {
        return NSOrderedDescending;
    }
    else if([self ppContactRowObjectOfRowModel].contactLabelType<[rowModel ppContactRowObjectOfRowModel].contactLabelType)
    {
        return NSOrderedAscending;
    }
    else
    {
        return NSOrderedSame;
    }
}
@end
