//
//  PPContactSectionModel.m
//
//  Created by Howard.Lin on 13/10/3.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "PPContactSectionModel.h"

// Define
#import "ContactApperanceDefine.h"

// Category
#import "NSString+Additions.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface PPContactSectionModel()
{
  @private
    PPContactMainType contactMainType_;
}
@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation PPContactSectionModel

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Synthesize

@synthesize
 contactMainType = contactMainType_;





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Class Method

//================================================================================
//
//================================================================================
+ (PPContactSectionModel *)ppContactSectionModelForPPContactMainType:(PPContactMainType)contactMainType
{
    PPContactSectionModel *contactSectionModel = [[PPContactSectionModel alloc] init];
    
    if(contactSectionModel!=nil)
    {
        contactSectionModel.contactMainType = contactMainType;
        
        //////////////////////////////////////////////////

        switch (contactMainType)
        {
            case PPContactMainType_Address:
            {
                contactSectionModel.title = WCCV_MLS_Address;
    
                break;
            }
            case PPContactMainType_Company:
            {
                contactSectionModel.title = WCCV_MLS_Company;
                break;
            }
            case PPContactMainType_BirthDay:
            {
                contactSectionModel.title = WCCV_MLS_Date_Birthday;
                break;
            }
            case PPContactMainType_Date:
            {
                contactSectionModel.title = WCCV_MLS_Date;
                break;
            }
            case PPContactMainType_Email:
            {
                contactSectionModel.title = WCCV_MLS_Email;
                break;
            }
            case PPContactMainType_InstantMessage:
            {
                contactSectionModel.title = WCCV_MLS_InstantMessage;
                break;
            }
            case PPContactMainType_Name:
            {
                contactSectionModel.title = WCCV_MLS_Name;
                break;
            }
            case PPContactMainType_Other:
            {
                contactSectionModel.title = WCCV_MLS_Other;
                break;
            }
            case PPContactMainType_Note:
            {
                contactSectionModel.title = WCCV_MLS_Note;
                break;
            }
            case PPContactMainType_PublicNote:
            {
                contactSectionModel.title = WCCV_MLS_PublicNote;
                break;
            }
            case PPContactMainType_Phone:
            {
                contactSectionModel.title = WCCV_MLS_Phone;
                break;
            }
            case PPContactMainType_URL:
            {
                contactSectionModel.title = WCCV_MLS_URL;
                break;
            }
            case PPContactMainType_HeadImage:
            {
                contactSectionModel.title = WCCV_MLS_Photo;
                break;
            }
            case PPContactMainType_Group:
            {
                contactSectionModel.title = WCCV_MLS_Category;
                break;
            }
            case PPContactMainType_SystemGroup:
            {
                contactSectionModel.title = WCCV_MLS_IPhone_Category;
                break;
            }
            case PPContactMainType_UserDefine:
            {
                contactSectionModel.title = WCCV_MLS_UserDefine;
                break;
            }
            case PPContactMaintype_VisibleAccount:
            {
                contactSectionModel.title = WCCV_MLS_VisibleUser;
                
                break;
            }
            case PPContactMainType_SocialNetwork:
            {
                contactSectionModel.title = WCCV_MLS_SocialNetwork;
                
                break;
            }
            case PPContactMainType_Salutation:
            {
                //不顯示標題列
//                contactSectionModel.title = WCCV_MLS_Salutation;
                break;
            }
            case PPContactMainType_Status:
            {
                contactSectionModel.title = WCCV_MLS_Other;
                break;
            }
            case PPContactMainType_SalesforceSaveAs:
            {
                contactSectionModel.title = WCCV_MLS_SaveAs;
                
                break;
            }
            default:
            {
                break;
            }
        }
    }
    
    return [contactSectionModel autorelease];
}

@end
