//
//  ContactDataExchangeModel.h
//
//  Created by Howard.Lin on 13/10/17.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "ContactDataExchangeProtocol.h"
#import "PPContactLabelTextDefine.h"
#import "PPContactFieldSourceDefine.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface ContactDataExchangeModel : NSObject


////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Property

@property (nonatomic,readonly) NSMutableDictionary  *imageRectDictionary;
@property (nonatomic,readonly) NSMutableDictionary  *propertyDictionary;
@property (nonatomic,copy)     NSString             *labelText;
@property (nonatomic,assign)   NSUInteger           labelType;
@property (nonatomic,assign)   PPContactFieldSource contactFieldSource;
@property (nonatomic,assign)   BOOL                 valid; // for Salesforce





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Class Method

+ (ContactDataExchangeModel *)contactDataExchangeModelCopyFromContactDataExchangeModel:(ContactDataExchangeModel *)contactDataExchangeModel;

@end
