//
//  PPContactMainTypeDefine.h
//
//  Created by Howard.Lin on 13/10/9.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#ifndef CloudEditViewControllerDemo_PPContactMainTypeDefine_h
#define CloudEditViewControllerDemo_PPContactMainTypeDefine_h

////////////////////////////////////////////////////////////////////////////////////////////////////

typedef NS_ENUM(NSUInteger,PPContactMainTypeMaxCount)
{
    PPContactMainTypeMaxCount_Address               = 6,
    PPContactMainTypeMaxCount_BirthDay              = 1,
    PPContactMainTypeMaxCount_Company               = 6,
    PPContactMainTypeMaxCount_Date                  = 4,
    PPContactMainTypeMaxCount_Email                 = 6,
    PPContactMainTypeMaxCount_InstantMessage        = 10,
    PPContactMainTypeMaxCount_Name                  = 4,
    PPContactMainTypeMaxCount_NickName              = 1,
    PPContactMainTypeMaxCount_Note                  = 1,
    PPContactMainTypeMaxCount_Phone                 = 16,
    PPContactMainTypeMaxCount_PublicNote            = 1,
    PPContactMainTypeMaxCount_UnifiedBusinessNumber = 1,
    PPContactMainTypeMaxCount_URL                   = 6,
    PPContactMainTypeMaxCount_HeadImage             = 1,
    PPContactMainTypeMaxCount_SocialNetwork         = 10,
    PPContactMainTypeMaxCount_Other                 = 3, // 統一編號+匿稱+ConstructTime
    PPContactMainTypeMaxCount_UserDefine            = NSUIntegerMax,
    PPContactMainTypeMaxCount_Salutation            = 1,
    PPContactMainTypeMaxCount_Status                = 1,
};

////////////////////////////////////////////////////////////////////////////////////////////////////

typedef NS_ENUM(NSUInteger,PPContactMainType)
{
    PPContactMainType_None,
    
    //圖片使用
    PPContactMainType_BackCardImage,
    PPContactMainType_FrontCardImage,
    PPContactMainType_HeadImage,
    
    //內部使用
    PPContactMainType_Name, // 4 : has value combined type
    PPContactMainType_Phone,
    PPContactMainType_Email,
    PPContactMainType_Company, // 7 : has value combined type
    PPContactMainType_Address, // 8 : has value combined type
    PPContactMainType_URL,
    PPContactMainType_InstantMessage,
    PPContactMainType_BirthDay,
    PPContactMainType_Date,
    PPContactMainType_UnifiedBusinessNumber,
    PPContactMainType_Group,
    PPContactMainType_SystemGroup,
    PPContactMaintype_VisibleAccount,
    PPContactMainType_NickName,
    PPContactMainType_UserDefine,
    PPContactMainType_PublicNote,
    PPContactMainType_Other,
    PPContactMainType_Note,
    PPContactMainType_SocialNetwork,
    PPContactMainType_ConstructTime,// DEPRECATED_ATTRIBUTE

    PPContactMainType_Salutation, // 稱謂 for salesforce
    PPContactMainType_Status, // lead status for salesforce
    PPContactMainType_SalesforceSaveAs,
    
    //!!以下為元件內部使用
    PPContactMainType_AddField,
    PPContactMainType_Phonetic,
};


#endif
