//
//  WCContactFootView.m
//  Pods
//
//  Created by Andrew on 2015/7/8.
//
//

#import "WCContactFootView.h"

@interface WCContactFootView ()
@property (nonatomic, retain) UIView *tableFootView;
@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation WCContactFootView

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Dellocating Objects

//================================================================================
//
//================================================================================
- (id)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    
    if (self)
    {
        _contactFootTableView = [[PPTableView alloc] initWithFrame:frame style:UITableViewStyleGrouped];
        if (self.contactFootTableView!=nil)
        {
            self.contactFootTableView.dataSource    = self;
            self.contactFootTableView.delegate      = self;
            self.contactFootTableView.scrollEnabled = NO;
            
            if([self.contactFootTableView respondsToSelector:@selector(setEstimatedRowHeight:)]==YES)
            {
                self.contactFootTableView.rowHeight = UITableViewAutomaticDimension;
                [self.contactFootTableView setEstimatedRowHeight:PPTableViewDefaultRowHeight];
            }
            [self addSubview:self.contactFootTableView];
        }
    }
    
    return self;
}


//================================================================================
//
//================================================================================
- (void)dealloc
{
    _dataSource = nil;
    _delegate   = nil;
    
    _contactFootTableView.dataSource = nil;
    _contactFootTableView.delegate = nil;
    [_contactFootTableView removeFromSuperview];
    [_contactFootTableView release];
    _contactFootTableView = nil;
    
    [_tableFootView release];
    _tableFootView = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Laying out Subviews

//================================================================================
//
//================================================================================
- (void)layoutSubviews
{
    [super layoutSubviews];
    
    //////////////////////////////////////////////////
    
    CGRect contactFootViewBounds = self.bounds;
    
    self.contactFootTableView.frame = CGRectMake(0, 0, contactFootViewBounds.size.width, contactFootViewBounds.size.height);
    
    //////////////////////////////////////////////////
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - UITableViewDataSource

//================================================================================
//
//================================================================================
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView
{
    NSInteger number = 0;
    
    do
    {
        if ([self.dataSource respondsToSelector:@selector(numberOfSectionsInWCContactFootView:)]==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        number = [self.dataSource numberOfSectionsInWCContactFootView:self];
    } while (0);
    
    return number;
}


//================================================================================
//
//================================================================================
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    NSInteger number = 0;
    
    do
    {
        if ([self.dataSource respondsToSelector:@selector(contactFootView:numberOfRowsInSection:)]==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        number = [self.dataSource contactFootView:self numberOfRowsInSection:section];
    } while (0);
    
    return number;
}


//================================================================================
//
//================================================================================
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    UITableViewCell *cell = nil;
    
    do
    {
        if ([self.dataSource respondsToSelector:@selector(contactFootView:cellForRowAtIndexPath:)]==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        cell = [self.dataSource contactFootView:self cellForRowAtIndexPath:indexPath];
        
    } while (0);
    
    //////////////////////////////////////////////////

    if(cell==nil)
    {
        cell = [[[UITableViewCell alloc] initWithStyle:UITableViewCellStyleDefault reuseIdentifier:NSStringFromClass([UITableViewCell class])] autorelease];
    }
    
    return cell;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - UITableViewDelegate

//================================================================================
//
//================================================================================
- (CGFloat)tableView:(UITableView *)tableView estimatedHeightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    if([self.delegate respondsToSelector:@selector(contactFootView:estimatedHeightForRowAtIndexPath:)]==YES)
    {
        return [self.delegate contactFootView:self estimatedHeightForRowAtIndexPath:indexPath];
    }
    else
    {
        return tableView.rowHeight;
    }
}


//================================================================================
//
//================================================================================
- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    if([self.delegate respondsToSelector:@selector(contactFootView:heightForRowAtIndexPath:)]==YES)
    {
        return [self.delegate contactFootView:self heightForRowAtIndexPath:indexPath];
    }
    else
    {
        return tableView.rowHeight;
    }
}


//================================================================================
//
//================================================================================
- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    UITableViewCell *cell = [tableView cellForRowAtIndexPath:indexPath];
    
    if(cell.selectionStyle!=UITableViewCellSelectionStyleNone)
    {
        if([self.delegate respondsToSelector:@selector(contactFootView:didSelectIndexPath:)]==YES)
        {
            [self.delegate contactFootView:self didSelectIndexPath:indexPath];
        }
    }
}

@end
