//
//  ContactKeyboardToolBarView.m
//
//
//  Created by Howard on 2015/7/2.
//
//

#import "ContactKeyboardToolBarView.h"

// Deinfe
#import "WCContactViewController+ResourceDefine.h"

// Category
#import "UIButton+Additions.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface ContactKeyboardToolBarView() <PPButtonDelegate>

@property (nonatomic,retain) PPButton *hiddenKeyboardButton;
@property (nonatomic,retain) PPButton *switchInputButton;
@property (nonatomic,retain) NSArray *landscapeConstraints;
@property (nonatomic,retain) NSArray *portraitConstraints;

@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation ContactKeyboardToolBarView

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Dellocating Object

//================================================================================
//
//================================================================================
- (id)init
{
    if(self=[super init])
    {
        self.backgroundColor = ContactKeyboardToolBarNormalBackgroundColor;
        
        //////////////////////////////////////////////////

        _hiddenKeyboardButton = [[PPButton alloc] init];
        
        if(_hiddenKeyboardButton!=nil)
        {
            _hiddenKeyboardButton.tag = ContactKeyboardToolBarViewButtonTag_HideKeyboard;
            [_hiddenKeyboardButton setDelegate:self];
            [_hiddenKeyboardButton setImageWithName:ImageNameContactViewControllerButtonHidekeyboard];
            [_hiddenKeyboardButton setTranslatesAutoresizingMaskIntoConstraints:NO];
            [_hiddenKeyboardButton addControlEvents:UIControlEventTouchDown];
            [_hiddenKeyboardButton addControlEvents:UIControlEventTouchUpInside];
            [_hiddenKeyboardButton setBackgroundColor:[UIColor clearColor]];
            [self addSubview:_hiddenKeyboardButton];
        }
        
        //////////////////////////////////////////////////
        
        _switchInputButton = [[PPButton alloc] init];
        
        if(_switchInputButton!=nil)
        {
            // TODO: Howard 切換大頭照圖片要換圖
            _switchInputButton.tag = ContactKeyboardToolBarViewButtonTag_SwitchInput;
            [_switchInputButton setDelegate:self];
            [_switchInputButton setImageWithName:@"WCContactInfoViewControllerCellContactName"];
            [_switchInputButton setTranslatesAutoresizingMaskIntoConstraints:NO];
            [_switchInputButton addControlEvents:UIControlEventTouchDown];
            [_switchInputButton addControlEvents:UIControlEventTouchUpInside];
            [_switchInputButton setBackgroundColor:[UIColor clearColor]];
            _switchInputButton.hidden = YES;
            
            [self addSubview:_switchInputButton];
        }
        
        //////////////////////////////////////////////////
    
        _portraitConstraints = [[self ourPortraitConstraints] retain];
        _landscapeConstraints = [[self ourLandscapeConstraints] retain];
        
        //////////////////////////////////////////////////

        [self updatePortraitConstraints];

    }
    
    return self;
}


//================================================================================
//
//================================================================================
- (void)dealloc
{
    _contactKeyboardToolBarViewDelegate = nil;
    
    [_hiddenKeyboardButton setDelegate:nil];
    [_hiddenKeyboardButton removeControlEvents:UIControlEventTouchUpInside];
    [_hiddenKeyboardButton removeFromSuperview];
    [_hiddenKeyboardButton release];
    _hiddenKeyboardButton = nil;
    
    [_switchInputButton setDelegate:nil];
    [_switchInputButton removeControlEvents:UIControlEventTouchUpInside];
    [_switchInputButton removeFromSuperview];
    [_switchInputButton release];
    _switchInputButton = nil;
    
    [_portraitConstraints release];
    _portraitConstraints = nil;
    
    [_landscapeConstraints release];
    _landscapeConstraints = nil;

    //////////////////////////////////////////////////

    [super dealloc];
}


//================================================================================
//
//================================================================================
- (UIView *)hitTest:(CGPoint)point withEvent:(UIEvent *)event
{
    [self brintSubViewToFront];
    
    UIView *view = [super hitTest:point withEvent:event];
    
    return view;
}


////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark -  Private Method

//================================================================================
//
//================================================================================
- (NSMutableArray *)ourPortraitConstraints
{
    NSMutableArray *constraints = nil;
    
    do
    {
        constraints = [NSMutableArray array];
        
        if(constraints==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        NSDictionary *viewsDictionary = @{@"HiddenKeyboardButton":self.hiddenKeyboardButton,
                                          @"SwitchInputButton":self.switchInputButton};
        
        if(viewsDictionary==nil || viewsDictionary.count<=0)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        NSDictionary *edgeInsetDictionary = @{@"Left":@(2.5),
                                              @"Right":@(2.5),
                                              @"Center":@(2.5)};
        
        //////////////////////////////////////////////////
        
        //row
        [constraints addObjectsFromArray:[NSLayoutConstraint constraintsWithVisualFormat:@"|-(Left)-[HiddenKeyboardButton]-(Right)-|"
                                                                                 options:0
                                                                                 metrics:edgeInsetDictionary
                                                                                   views:viewsDictionary]];
        
        //////////////////////////////////////////////////
        
        // column
        
        [constraints addObjectsFromArray:[NSLayoutConstraint constraintsWithVisualFormat:@"V:|[HiddenKeyboardButton]|"
                                                                                 options:0
                                                                                 metrics:nil
                                                                                   views:viewsDictionary]];
        
    }
    while (0);
    
    return constraints;
}


//================================================================================
//
//================================================================================
- (NSMutableArray *)ourLandscapeConstraints
{
    NSMutableArray *constraints = nil;
    
    do
    {
        constraints = [NSMutableArray array];
        
        if(constraints==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        NSDictionary *viewsDictionary = @{@"HiddenKeyboardButton":self.hiddenKeyboardButton,
                                          @"SwitchInputButton":self.switchInputButton};
        
        if(viewsDictionary==nil || viewsDictionary.count<=0)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        NSDictionary *edgeInsetDictionary = @{@"Left":@(2.5),
                                              @"Right":@(2.5),
                                              @"Center":@(2.5)};
        
        //////////////////////////////////////////////////
        
        //row
        [constraints addObjectsFromArray:[NSLayoutConstraint constraintsWithVisualFormat:@"|-(Left)-[SwitchInputButton]-(Center)-[HiddenKeyboardButton(==SwitchInputButton)]-(Right)-|"
                                                                                 options:0
                                                                                 metrics:edgeInsetDictionary
                                                                                   views:viewsDictionary]];
       
        //////////////////////////////////////////////////
        
        // column
        
        [constraints addObjectsFromArray:[NSLayoutConstraint constraintsWithVisualFormat:@"V:|[SwitchInputButton]|"
                                                                                 options:0
                                                                                 metrics:nil
                                                                                   views:viewsDictionary]];
        
        //////////////////////////////////////////////////
        
        [constraints addObjectsFromArray:[NSLayoutConstraint constraintsWithVisualFormat:@"V:|[HiddenKeyboardButton]|"
                                                                                 options:0
                                                                                 metrics:nil
                                                                                   views:viewsDictionary]];
    }
    while (0);
    
    return constraints;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPButton Delegate Method

//================================================================================
//
//================================================================================
- (void)ppButton:(PPButton *)ppButton controlEvent:(UIControlEvents)controlEvent
{
    do
    {
        if(self.contactKeyboardToolBarViewDelegate==nil ||
           [self.contactKeyboardToolBarViewDelegate respondsToSelector:@selector(contactEditKeyboardToolBarView:ppButton:controlEvent:)]==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////

        if(controlEvent==UIControlEventTouchDown)
        {
            self.backgroundColor = ContactKeyboardToolBarHighlightedBackgroundColor;
        }
        else
        {
            self.backgroundColor = ContactKeyboardToolBarNormalBackgroundColor;

            //////////////////////////////////////////////////

            [self.contactKeyboardToolBarViewDelegate contactEditKeyboardToolBarView:self
                                                                           ppButton:ppButton
                                                                       controlEvent:controlEvent];
        }

    }
    while (0);
}







////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance LayoutConstraint Method

//================================================================================
//
//================================================================================
- (void)updateLandscapeConstraints
{
    if(self.portraitConstraints.count>0)
    {
        [self removeConstraints:self.portraitConstraints];
    }
   
    //////////////////////////////////////////////////
    
    if(self.landscapeConstraints.count>0)
    {
        [self removeConstraints:self.landscapeConstraints];
    }
   
    self.landscapeConstraints = [self ourLandscapeConstraints];
    [self addConstraints:self.landscapeConstraints];
}


//================================================================================
//
//================================================================================
- (void)updatePortraitConstraints
{
    [self removeConstraints:self.landscapeConstraints];
    
    //////////////////////////////////////////////////
    
    [self removeConstraints:self.portraitConstraints];
    self.portraitConstraints = [self ourPortraitConstraints];
    [self addConstraints:self.portraitConstraints];
}


//================================================================================
//
//================================================================================
- (void)brintSubViewToFront
{
    [self bringSubviewToFront:self.hiddenKeyboardButton];
    [self bringSubviewToFront:self.switchInputButton];
}
@end
