//
//  ContactTool.m
//
//  Created by Howard.Lin on 13/11/4.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "ContactTool.h"
#import "ContactApperanceDefine.h"
#import "PPContactMainTypeDefine.h"
#import "PPCountrySelectorViewController.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

static NSUInteger contactSystemLanguage_EN = 3; // 英文
static NSUInteger contactSystemLanguage_SC = 2; // 簡中
static NSUInteger contactSystemLanguage_TC = 0; // 繁中
static NSUInteger contactSystemLanguage_JP = 15; // 日
static NSUInteger contactSystemLanguage_KS = 16; // 韓
static NSUInteger contactSystemLanguage_FR = 5; // 法
static NSUInteger contactSystemLanguage_GE = 4; // 德
static NSUInteger contactSystemLanguage_NL = 12; // 荷蘭
static NSUInteger contactSystemLanguage_IT = 6; // 義大利
static NSUInteger contactSystemLanguage_ES = 7; // 西班牙
static NSUInteger contactSystemLanguage_PT = 19; // 葡萄牙

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation ContactTool

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Class Method

//================================================================================
//
//================================================================================
+ (NSUInteger)defaultSysmtemLanguage
{
    NSUserDefaults* defs = [NSUserDefaults standardUserDefaults];
	NSArray* languages   = [defs objectForKey:@"AppleLanguages"];
	NSString* systemLang = [languages objectAtIndex:0];
	
	if([systemLang isEqualToString:@"en"])
    {
		return contactSystemLanguage_EN;
    }
	else if([systemLang isEqualToString:@"zh-Hant"])
    {
		return contactSystemLanguage_TC;
    }
	else if([systemLang isEqualToString:@"zh-Hans"])
    {
		return contactSystemLanguage_SC;
    }
	else if([systemLang isEqualToString:@"ja"])
    {
		return contactSystemLanguage_JP;
    }
	else if([systemLang isEqualToString:@"ko"])
    {
		return contactSystemLanguage_KS;
    }
	else if([systemLang isEqualToString:@"fr"])
    {
		return contactSystemLanguage_FR;
    }
	else if([systemLang isEqualToString:@"de"])
    {
		return contactSystemLanguage_GE;
    }
	else if([systemLang isEqualToString:@"nl"])
    {
		return contactSystemLanguage_NL;
    }
	else if([systemLang isEqualToString:@"it"])
    {
		return contactSystemLanguage_IT;
    }
	else if([systemLang isEqualToString:@"es"])
    {
		return contactSystemLanguage_ES;
    }
	else if([systemLang hasPrefix:@"pt"]) // pt-PT
    {
		return contactSystemLanguage_PT;
	}
    else
    {
        return contactSystemLanguage_EN;
    }
}

@end
