//
//  PPSectionController+Contact.m
//
//  Created by Howard.Lin on 14/1/7.
//  Copyright (c) 2014年 Penpower. All rights reserved.
//

#import "PPSectionController+Contact.h"
#import "PPContactSectionModel.h"
#import "PPContactRowObject.h"
#import "PPRowModel+Contact.h"
#import "ContactDataExchangeModel.h"

@implementation PPSectionController (Contact)

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

//================================================================================
//
//================================================================================
- (NSInteger)sectionForPPContactMainType:(PPContactMainType)contactMainType forSearching:(BOOL)searching
{
    NSInteger section = NSNotFound;
    
    do
    {
        NSMutableArray *targetArray = [self sectionModelsForSearching:NO];
        
        if(contactMainType==PPContactMainType_None || targetArray==nil || targetArray.count<=0)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        NSUInteger totalNumber  = targetArray.count;
        NSUInteger sectionIndex = 0;
        
        for( ; sectionIndex < totalNumber ; sectionIndex++)
        {
            PPContactSectionModel *contactSectionModel = [targetArray objectAtIndex:sectionIndex];
            
            
            if(contactSectionModel!=nil && contactSectionModel.contactMainType==contactMainType)
            {
                section = sectionIndex;
                break;
            }
        }
        
    } while (0);
    
    return section;
}



//================================================================================
//
//================================================================================
- (NSMutableDictionary *)fieldDictionaryFromSectionModelForSearching:(BOOL)searching
{
    NSMutableDictionary *fieldsdictionary = [NSMutableDictionary dictionary];
    
    do
    {
        if([self sectionModelsForSearching:searching].count<=0)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        for (PPContactSectionModel *sectionModel in [self sectionModelsForSearching:searching])
        {
            NSMutableArray *fieldArray = [[NSMutableArray alloc] init];
            
            if(fieldArray!=nil)
            {
                for (PPRowModel *rowModel in sectionModel.rowModels)
                {
                    PPContactRowObject *contactRowObject = [rowModel ppContactRowObjectOfRowModel];
                    
                    //自訂欄位就算沒有值也要寫回
                    if(contactRowObject!=nil &&
                       (contactRowObject.contactMainType==PPContactMainType_UserDefine ||
                        [contactRowObject checkInputValueDictionaryKeyHasValidValue]==YES))
                    {
                        ContactDataExchangeModel *contactDataExchangeModel = [[ContactDataExchangeModel alloc] init];
                        
                        //////////////////////////////////////////////////
                        
                        for (id key in contactRowObject.imageRectDictionary.allKeys)
                        {
                            [contactDataExchangeModel.imageRectDictionary setObject:[contactRowObject.imageRectDictionary objectForKey:key] forKey:key];
                        }
                        
                        //////////////////////////////////////////////////
                        
                        for (id key in contactRowObject.inputValueDictionary.allKeys)
                        {
                            [contactDataExchangeModel.propertyDictionary setObject:[contactRowObject.inputValueDictionary objectForKey:key] forKey:key];
                        }
                        
                        //////////////////////////////////////////////////
                        
                        contactDataExchangeModel.labelType = contactRowObject.contactLabelType;
                        contactDataExchangeModel.labelText = rowModel.text;
                        contactDataExchangeModel.contactFieldSource = [rowModel ppContactFieldSource];
                        contactDataExchangeModel.valid = contactRowObject.selected;
                        
                        [fieldArray addObject:contactDataExchangeModel];
                        [contactDataExchangeModel release];
                    }
                }
                
                
                //////////////////////////////////////////////////
                
                if(fieldArray.count>0)
                {
                    [fieldsdictionary setObject:fieldArray forKey:[NSNumber numberWithUnsignedInteger:sectionModel.contactMainType]];
                }
                
            }
            
            [fieldArray release];
        }
    
    } while (0);
    
    return fieldsdictionary;
}

@end
