//
//  ContactMultipleTextFieldButtonTableViewCell.m
//
//  Created by Howard.Lin on 13/10/22.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "ContactMultipleTextFieldButtonTableViewCell.h"

// Deine
#import "ContactApperanceDefine.h"
#import "WCContactViewController+ResourceDefine.h"
#import "WCContactViewController+PrivateParameterDefine.h"

// View
#import "PPTableViewCellLineView.h"

// Category
#import "UIColor+Contact.h"


////////////////////////////////////////////////////////////////////////////////////////////////////

@interface ContactMultipleTextFieldButtonTableViewCell()

@property (nonatomic,retain) PPTableViewCellLineView        *contactTableViewCellLineView;

@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation ContactMultipleTextFieldButtonTableViewCell

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Dellocating Object

//================================================================================
//
//================================================================================
- (id)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier
{
    self = [super initWithStyle:style reuseIdentifier:reuseIdentifier];
    
    if(self!=nil)
    {
        _contactTableViewCellLineView = [[PPTableViewCellLineView alloc] init];
        
        if(_contactTableViewCellLineView!=nil)
        {
            _contactTableViewCellLineView.drawHorizontalLine = YES;
            _contactTableViewCellLineView.drawVerticalLine   = NO;
            _contactTableViewCellLineView.lineColor = WCContactEditViewControllerTableViewInnerSeparatorColor;
        }
        
        //////////////////////////////////////////////////
        
        [self.textLabel setAdjustsFontSizeToFitWidth:YES];
        
    }
    
    return self;
}


//================================================================================
//
//================================================================================
- (void)dealloc
{
    _contactKeyboardToolBarViewDelegate = nil;
    
    [_contactTableViewCellLineView removeFromSuperview];
    [_contactTableViewCellLineView release];
    _contactTableViewCellLineView = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Layout Of View

//================================================================================
//
//================================================================================
- (void)layoutSubviews
{
    [super layoutSubviews];
    
    //////////////////////////////////////////////////
    
    if(self.textLabel.text!=nil &&
       self.textLabel.text.length>0)
    {
        CGRect textLabelFrame = self.textLabel.frame;
        
        textLabelFrame.size.width = ContactTableViewCellLabelWidth;
        
        self.textLabel.frame = textLabelFrame;
        
        //////////////////////////////////////////////////
        
        self.contactTableViewCellLineView.frame = self.contentView.bounds;
        self.contactTableViewCellLineView.leftMargin = textLabelFrame.origin.x + textLabelFrame.size.width + ContactTableViewCellContentEdgeInset.left;
        [self.contactTableViewCellLineView performSelectorOnMainThread:@selector(setNeedsDisplay) withObject:nil waitUntilDone:NO];
        
        //////////////////////////////////////////////////
        
        CGRect textFieldButtonViewFrame = CGRectZero;
        
        for (PPTextFieldButtonView *textFieldButtonView in self.textFieldButtonViews)
        {
            [textFieldButtonView.textField setTextColor:[UIColor contactEditViewInputFieldTextColor]];
      
            //////////////////////////////////////////////////
            
            textFieldButtonViewFrame  = textFieldButtonView.frame;
            textFieldButtonViewFrame.origin.x   = self.contactTableViewCellLineView.leftMargin + ContactTableViewCellContentEdgeInset.left;
            textFieldButtonViewFrame.size.width = self.contentView.bounds.size.width - ContactTableViewCellContentEdgeInset.right - textFieldButtonViewFrame.origin.x;
            textFieldButtonView.frame = textFieldButtonViewFrame;
        }
    }
    else
    {
        self.contactTableViewCellLineView.frame = self.contentView.bounds;
        self.contactTableViewCellLineView.leftMargin = 0;
        [self.contactTableViewCellLineView performSelectorOnMainThread:@selector(setNeedsDisplay) withObject:nil waitUntilDone:NO];
        
        //////////////////////////////////////////////////
        
        CGRect textFieldButtonViewFrame = CGRectZero;
        
        for (PPTextFieldButtonView *textFieldButtonView in self.textFieldButtonViews)
        {
            [textFieldButtonView.textField setTextColor:[UIColor contactEditViewInputFieldTextColor]];
            
            //////////////////////////////////////////////////
            
            textFieldButtonViewFrame  = textFieldButtonView.frame;
            textFieldButtonViewFrame.origin.x   = self.contactTableViewCellLineView.leftMargin + ContactTableViewCellContentEdgeInset.left;
            textFieldButtonViewFrame.size.width = self.contentView.bounds.size.width - ContactTableViewCellContentEdgeInset.right - textFieldButtonViewFrame.origin.x;
            textFieldButtonView.frame = textFieldButtonViewFrame;
        }
    }
}






////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Method

//================================================================================
//
//================================================================================
- (void)customTextFieldsWithPlacehoders:(NSArray *)placeholders
{
    [super customTextFieldsWithPlacehoders:placeholders];
    
    //////////////////////////////////////////////////

    for(PPTextFieldButtonView *textFieldButtonView in self.textFieldButtonViews)
    {
        ContactKeyboardToolBarView *toolBarView = [[ContactKeyboardToolBarView alloc] init];
        
        if(toolBarView!=nil)
        {
            textFieldButtonView.textField.inputAccessoryView   = toolBarView;
            
            //////////////////////////////////////////////////

            toolBarView.contactKeyboardToolBarViewDelegate = self.contactKeyboardToolBarViewDelegate;
        }
        
        [toolBarView release];
    }
    
    //////////////////////////////////////////////////
    
    //!將ContactMultipleTextFieldButtonTableViewCell保持在視圖最上層，防止textField數量增加時，被蓋掉
    [self.contentView addSubview:self.contactTableViewCellLineView];
    [self.contentView sendSubviewToBack:_contactTableViewCellLineView];
    
    //////////////////////////////////////////////////

    //!重新layout
    [self performSelectorOnMainThread:@selector(setNeedsLayout) withObject:nil waitUntilDone:NO];
    
    //!通知格線view重繪
    [self.contactTableViewCellLineView performSelectorOnMainThread:@selector(setNeedsDisplay) withObject:nil waitUntilDone:NO];
}






////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - CurrentInputViewProtocol Method

//================================================================================
//
//================================================================================
- (UITextField *)currentFocusTextField
{
    UITextField *textField = nil;
    
    for (PPTextFieldButtonView *textFieldButtonView in self.textFieldButtonViews)
    {
        if([textFieldButtonView.textField isFirstResponder]==YES)
        {
            textField = textFieldButtonView.textField;
            break;
        }
    }
    
    return textField;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Ovveride Method

//================================================================================
//
//================================================================================
- (BOOL)ppTextFieldButtonView:(PPTextFieldButtonView *)textFieldButtonView shouldChangeCharactersInRange:(NSRange)range replacementString:(NSString *)string
{
    BOOL result = YES;
    
    if(textFieldButtonView.textField.text.length+string.length>textFieldButtonView.maxLength)
    {
        // 新增文字，或取代文字
        if(range.length<=string.length &&
           [string length]>0)
        {
            result = NO;
            
            //////////////////////////////////////////////////
            
            [[NSNotificationCenter defaultCenter] postNotificationName:WCCV_InputTextFieldArriveMaxLengthNotification object:@(textFieldButtonView.maxLength)];
        }
    }
    
    return result;
}


@end
