//
//  ContactEditView.h
//
//  Created by Howard.Lin on 13/9/27.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import <UIKit/UIKit.h>

// Define
#import "ContactEditViewDataSource.h"
#import "ContactEditViewDelegate.h"

// View
#import "PPTableView.h"
#import "PPPhoneTextFieldTableViewCell.h"
#import "PPTextFieldTableViewCell.h"
#import "PPTextViewTableViewCell.h"
#import "PPMultipleTextFieldButtonTableViewCell.h"
#import "PPHeadImageNameTabelViewCell.h"
#import "ContactKeyboardToolBarView.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - ContactEditView

@interface ContactEditView : UIView <ContactKeyboardToolBarViewDelegate,PPHeadImageNameTableViewCellDelegate,PPMultipleTextFieldButtonTableViewCellDelegate,PPPhoneTextFieldTableViewCellDelegate,PPTextFieldTableViewCellDelegate,PPTextViewTableViewCellDelegate,UITableViewDataSource,UITableViewDelegate>

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Property

@property (nonatomic,assign)   id<ContactEditViewDataSource> dataSource;
@property (nonatomic,assign)   id<ContactEditViewDelegate>   delegate;
@property (nonatomic,readonly) PPTableView                   *contactEditTableView;
@property (nonatomic,retain)   NSMutableDictionary *sectionHeaders;
@end
