//
//  ContactEditDataModel.h
//
//  Created by Howard.Lin on 13/10/3.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "PPContactSectionModel.h"

// Define
#import "PPContactMainTypeDefine.h"
#import "PPContactSubTypeDefine.h"
#import "PPContactTableViewCellStyleDefine.h"
#import "ContactApperanceDefine.h"

// Model
#import "PPContactRowObject.h"
#import "ContactDataExchangeModel.h"

// Category
#import "NSString+Additions.h"
#import "PPRowModel+Contact.h"

// Other
#import "PPCountryCodeConvert.h"


@interface ContactEditDataModel : NSObject

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Class Method

+ (PPContactSectionModel *)ppContactSectionModelForPPContactMainType:(PPContactMainType)contactMainType
                                                       itemTextArray:(NSArray *)itemTextArray
                                           tableViewCellEditingStyle:(UITableViewCellEditingStyle)editingStyle
                                                ppContactFieldSource:(PPContactFieldSource)contactFieldSource;


/**
 * To get the placeholderArray for contactMainType and subType
 * @param contactMainType PPContactMainType
 * @param contactSubTypeArray PPContactSubType array
 * @return: The placeholderArray object is for contactMainType and subType
 */
+ (NSMutableArray *)customSectionPlaceholderArrayForPPContactMainType:(PPContactMainType)contactMainType
                                                ppContactSubTypeArray:(NSArray *)contactSubTypeArray;

/**
 * To get the default titleArray for contactMainType
 * @param contactMainType PPContactMainType
 * @return: The titleArray object is for contactMainType
 */
+ (NSMutableArray *)defaultTitleArrayForPPContactMainType:(PPContactMainType)contactMainType;

/**
 *  獲得地址欄位的 placeholder
 *
 *  @param countryCode 國碼
 *
 *  @return 地址欄位的 placeholder
 */
+ (NSArray *)addressPlaceholderArrayWithCountryCode:(NSString *)countryCode;

/**
 * To get the titleArray for contactMainType
 * @param contactMainType PPContactMainType
 * @return: The titleArray object is for contactMainType
 */
+ (NSMutableArray *)totalTitleArrayForPPContactMainType:(PPContactMainType)contactMainType;


/**
 * To get maxmum number of row for contactMainType
 * @param contactMainType PPContactMainType
 * @return: The maxmum number of row for contactMainType
 */
+ (NSUInteger)maxNumberOfRowForPPContactMainType:(PPContactMainType)contactMainType;


/*
 * To creating ppContactSectionModel by fields and contactMainType
 * @param fields: The field is [NSArray arrayWithObjects: ContactDataExchangeModel,ContactDataExchangeModel,nil]
 * @param contactMainType: The contactMainType for creating ppContactSectionModel
 * @param showPhonetic: To show phonetic or not
 * @return: The ppContactSectionModel is created by fields and contactMainType
 */
+ (PPContactSectionModel *)ppContactSectionModelForParsingFields:(NSArray *)fields
                                               ppContactMainType:(PPContactMainType)contactMainType
                                                    showPhonetic:(BOOL)showPhonetic;


/**
 * To get the PPContactSectionModel object for contactMainType
 * @param contactMainType PPContactMainType
 * @return: The PPContactSectionModel object is for contactMainType
 */
+ (PPContactSectionModel *)ppContactSectionModelForPPContactMainType:(PPContactMainType)contactMainType;


/**
 * To get the contactTableViewCellStyle for contactMainType
 * @param contactMainType PPContactMainType
 * @return: The contactTableViewCellStyle is for contactMainType
 */
+ (PPContactTableViewCellStyle)contactTableViewCellStyleForContactMainType:(PPContactMainType)contactMainType;

@end
