//
//  WCContactEditViewController+DoubleSideLayout.m
//  
//
//  Created by Howard on 2015/12/10.
//
//

#import "WCContactEditViewController+DoubleSideLayout.h"

// Category

#import "UIViewController+ShareApplication.h"

@implementation WCContactEditViewController (DoubleSideLayout)

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

//================================================================================
//
//================================================================================
- (void)doubleSideLayoutSubView
{
    CGRect visibleFrame = [self layoutFrame];
  
    //////////////////////////////////////////////////

    self.contactEditDoubleSideView.focusMode = NO;
    
    //////////////////////////////////////////////////

    if(UI_USER_INTERFACE_IDIOM()==UIUserInterfaceIdiomPad)
    {
        self.contactEditDoubleSideView.frame = CGRectMake(visibleFrame.origin.x,
                                                          visibleFrame.origin.y,
                                                          visibleFrame.size.width/2,
                                                          visibleFrame.size.height);
        
        [self.contactEditDoubleSideView layoutSubviews];
        
        //////////////////////////////////////////////////
        
        self.contactEditView.frame = CGRectMake(self.contactEditDoubleSideView.frame.origin.x+self.contactEditDoubleSideView.frame.size.width,
                                                self.contactEditDoubleSideView.frame.origin.y,
                                                visibleFrame.size.width/2,
                                                visibleFrame.size.height);
    }
    else
    {
        self.contactEditView.frame = visibleFrame;
    }
    
    self.contactEditHeaderView.frame = CGRectZero;
    
}


//================================================================================
//
//================================================================================
- (void)doubleSideKeyboardWillShowLayoutSubViewWithKeyboardSize:(CGSize)keyboardSize
{
    CGRect visibleFrame = [self layoutFrame];
    
    //////////////////////////////////////////////////

    self.contactEditDoubleSideView.focusMode = YES;

    if(UI_USER_INTERFACE_IDIOM()==UIUserInterfaceIdiomPad)
    {
        
        self.contactEditDoubleSideView.keyboardHeight = keyboardSize.height;
        
        self.contactEditDoubleSideView.frame = CGRectMake(visibleFrame.origin.x,
                                                          visibleFrame.origin.y,
                                                          visibleFrame.size.width/2,
                                                          visibleFrame.size.height);
        
        [self.contactEditDoubleSideView layoutSubviews];
    }
}

@end
