//
//  ContactEditFieldView.m
//
//  Created by Howard.Lin on 13/10/1.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "PPTableView.h"
#import "ContactEditFieldView.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface ContactEditFieldView()
{
   @private
    id<ContactEditFieldViewDataSource> dataSource_;
    id<ContactEditFieldViewDelegate>   delegate_;
    PPTableView                        *editFieldTableView_;
    
}

@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation ContactEditFieldView

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Synthesize

@synthesize
 dataSource               = dataSource_,
 delegate                 = delegate_,
 editFieldTableView       = editFieldTableView_;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Dellocating Objects

//================================================================================
//
//================================================================================
- (id)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    
    if (self)
    {
        // Initialization code
        
        editFieldTableView_ = [[PPTableView alloc] initWithFrame:frame style:UITableViewStyleGrouped];
        
        if(editFieldTableView_!=nil)
        {
            editFieldTableView_.dataSource = self;
            editFieldTableView_.delegate   = self;
            
            [self addSubview:editFieldTableView_];
        }
    }
    return self;
}


//================================================================================
//
//================================================================================
- (void)dealloc
{
    dataSource_ = nil;
    delegate_   = nil;
    
    editFieldTableView_.dataSource = nil;
    editFieldTableView_.delegate = nil;
    [editFieldTableView_ removeFromSuperview];
    [editFieldTableView_ release];
    editFieldTableView_ = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Laying out Subviews

//================================================================================
//
//================================================================================
- (void)layoutSubviews
{
    [super layoutSubviews];
    
    //////////////////////////////////////////////////
    
    self.editFieldTableView.frame = self.bounds;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPTextFieldTableViewCellDelegate Method

//================================================================================
//
//================================================================================
- (void)ppTextFieldTableViewCellDidChanged:(PPTextFieldTableViewCell *)textFieldTableViewCell
{
    if([self.delegate respondsToSelector:@selector(contactEditFieldView:ppTextFieldTableViewCellDidChanged:atIndexPath:)]==YES)
    {
        NSIndexPath *tableViewCellIndexPath = [[NSIndexPath indexPathForRow:[self.editFieldTableView indexPathForCell:textFieldTableViewCell].row
                                                                  inSection:[self.editFieldTableView  indexPathForCell:textFieldTableViewCell].section] retain];
        
        [self.delegate contactEditFieldView:self
         ppTextFieldTableViewCellDidChanged:textFieldTableViewCell
                                atIndexPath:tableViewCellIndexPath];
        
        
        [tableViewCellIndexPath release];
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - UITableViewDataSource Method

//================================================================================
//
//================================================================================
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView
{
    NSInteger numberOfSections = 0;
    
    do
    {
        if([self.dataSource respondsToSelector:@selector(numberOfSectionsInContactEditFieldView:)]==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        numberOfSections = [self.dataSource numberOfSectionsInContactEditFieldView:self];
        
    } while (0);
    
    return numberOfSections;
}


//================================================================================
//
//================================================================================
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    NSInteger numberOfRows = 0;
    
    do
    {
        if([self.dataSource respondsToSelector:@selector(contactEditFieldView:numberOfRowsInSection:)]==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        numberOfRows = [self.dataSource contactEditFieldView:self
                                                   numberOfRowsInSection:section];
        
    } while (0);
    
    return numberOfRows;
}


//================================================================================
//
//================================================================================
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    UITableViewCell *cell = nil;
    
    do
    {
        if([self.dataSource respondsToSelector:@selector(contactEditFieldView:cellForRowAtIndexPath:)]==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        cell = [self.dataSource contactEditFieldView:self
                                cellForRowAtIndexPath:indexPath];
        
    } while (0);
    
    //////////////////////////////////////////////////
    
    if(cell==nil)
    {
        cell = [[[UITableViewCell alloc] initWithStyle:UITableViewCellStyleDefault
                                       reuseIdentifier:NSStringFromClass([UITableViewCell class])] autorelease];
    }
    
    return cell;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - UITableViewDelegate Method

//================================================================================
//
//================================================================================
- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    if([self.delegate respondsToSelector:@selector(contactEditFieldView:didSelectRowAtIndexPath:)]==YES)
    {
        [self.delegate contactEditFieldView:self
                     didSelectRowAtIndexPath:indexPath];
    }
}


@end
