//
//  WCContactEditFieldViewController.m
//
//  Created by Howard.Lin on 13/10/1.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "WCContactEditFieldViewController.h"
#import "ContactTextFieldTableViewCell.h"
#import "ContactApperanceDefine.h"
#import "NSString+Additions.h"
#import "PPContactRowObject.h"
#import "PPContactSectionModel.h"
#import "PPRowModel+Contact.h"
#import "PPTableViewCell.h"
#import "UIViewController+ShareApplication.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface WCContactEditFieldViewController ()

@property (nonatomic,retain) ContactEditFieldNavigationBarView *contactEditFieldNavigationBarView;
@property (nonatomic,retain) ContactEditFieldView              *contactEditFieldView;
@property (nonatomic,assign) BOOL                              avoidDoubleSendResult;

@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation WCContactEditFieldViewController
////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Dellocating Objects

//================================================================================
//
//================================================================================
- (id)init
{
    if(self = [super init])
    {
        _contactEditFieldSectionController = [[WCContactEditFieldSectionController alloc] init];
        
        _showDoneButton = NO;
    }
    
    //////////////////////////////////////////////////
    
    return self;
}


//================================================================================
//
//================================================================================
- (void)dealloc
{
    _delegate = nil;
    
    [_contactEditFieldSectionController release];
    _contactEditFieldSectionController = nil;
    
    [_currentSelectedTitle release];
    _currentSelectedTitle = nil;
    
    [_contactEditFieldView release];
    _contactEditFieldView = nil;
    
    [_contactEditFieldNavigationBarView release];
    _contactEditFieldNavigationBarView = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Responding to View Events

//================================================================================
//
//================================================================================
- (void)viewWillAppear:(BOOL)animated
{
    [super viewWillAppear:animated];
    
    //////////////////////////////////////////////////
    
    if(self.contactEditFieldView==nil)
    {
        _contactEditFieldView = [[ContactEditFieldView alloc] initWithFrame:CGRectZero];
    }
    
    if(self.contactEditFieldView!=nil)
    {
        self.contactEditFieldView.dataSource = self;
        self.contactEditFieldView.delegate   = self;
        
        [self.view addSubview:self.contactEditFieldView];
    }
    
    //////////////////////////////////////////////////

    if(self.navigationController!=nil)
    {
        if(self.contactEditFieldNavigationBarView==nil)
        {
            _contactEditFieldNavigationBarView = [[ContactEditFieldNavigationBarView alloc] initWithFrame:self.navigationController.navigationBar.bounds];
        }
        
        if(self.contactEditFieldNavigationBarView!=nil)
        {
            self.contactEditFieldNavigationBarView.delegate = self;
            
            //////////////////////////////////////////////////
            
            self.contactEditFieldNavigationBarView.doneButton.hidden = (!self.showDoneButton);
            
            //////////////////////////////////////////////////
            
            UIBarButtonItem *leftButtonItem = [[UIBarButtonItem alloc] initWithCustomView:self.contactEditFieldNavigationBarView];
            
            if(leftButtonItem!=nil)
            {
                self.navigationItem.leftBarButtonItem = leftButtonItem;
            }

            [leftButtonItem release];
        }
    }
}


//================================================================================
//
//================================================================================
- (void)layoutSubviews
{
    [super layoutSubviews];
    
    //////////////////////////////////////////////////
    
    self.contactEditFieldView.frame = [self layoutFrame];
}


//================================================================================
//
//================================================================================
- (void)viewDidDisappear:(BOOL)animated
{
    [self.contactEditFieldNavigationBarView removeFromSuperview];
    self.contactEditFieldNavigationBarView = nil;
    
    [self.contactEditFieldView removeFromSuperview];
    self.contactEditFieldView = nil;
 
    //////////////////////////////////////////////////
    
    self.navigationItem.rightBarButtonItem = nil;
    
    //////////////////////////////////////////////////
    
    self.showDoneButton = NO;
    
    //////////////////////////////////////////////////
    
    [super viewDidDisappear:animated];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - ContactEditFieldViewDataSource

//================================================================================
//
//================================================================================
- (NSInteger)numberOfSectionsInContactEditFieldView:(ContactEditFieldView *)contactEditFieldView
{
    return [self.contactEditFieldSectionController  numberOfSectionsForSearching:NO];
}


//================================================================================
//
//================================================================================
- (NSInteger)contactEditFieldView:(ContactEditFieldView *)contactEditFieldView
             numberOfRowsInSection:(NSInteger)section
{
    return [self.contactEditFieldSectionController  numberOfRowsInSection:section forSearching:NO];
}


//================================================================================
//
//================================================================================
- (UITableViewCell *)contactEditFieldView:(ContactEditFieldView *)contactEditFieldView
                    cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    UITableViewCell *cell = nil;
    
    PPRowModel *rowModel = [self.contactEditFieldSectionController  rowModelAtIndexPath:indexPath forSearching:NO];
    PPContactRowObject *contactRowObject = [rowModel ppContactRowObjectOfRowModel];

    switch (contactRowObject.tableViewCellStyle)
    {
        case PPContactTableViewCellStyle_TextField:
        {
            cell = [contactEditFieldView.editFieldTableView dequeueReusableCellWithIdentifier:TextFieldTableViewCell];
            
            //////////////////////////////////////////////////
            
            if(cell==nil)
            {
                cell = [[[ContactTextFieldTableViewCell alloc] initWithStyle:UITableViewCellStyleValue1 reuseIdentifier:TextFieldTableViewCell] autorelease];
            }
            
            //////////////////////////////////////////////////
            
            ContactTextFieldTableViewCell *contactTextFeildTableViewCell = (ContactTextFieldTableViewCell*)cell;
            
            contactTextFeildTableViewCell.delegate = self.contactEditFieldView;
            
            contactTextFeildTableViewCell.showTitleLabel = NO;
            
            contactTextFeildTableViewCell.textField.placeholder = WCCV_MLS_UserDefine;
            
            //////////////////////////////////////////////////
            
            if(contactRowObject.inputValueDictionary.count>0)
            {
                contactTextFeildTableViewCell.textField.text = [contactRowObject.inputValueDictionary objectForKey:[[contactRowObject.inputValueDictionary allKeys] objectAtIndex:0]];
            }
            
            break;
        }
        case PPContactTableViewCellStyle_Default:
        default:
        {
            cell = [contactEditFieldView.editFieldTableView dequeueReusableCellWithIdentifier:DefaultCellIdentifier];
            
            //////////////////////////////////////////////////
            
            if(cell==nil)
            {
                cell = [[[PPTableViewCell alloc] initWithStyle:UITableViewCellStyleDefault reuseIdentifier:DefaultCellIdentifier] autorelease];
            }
            
            //////////////////////////////////////////////////
            
            cell.textLabel.text = rowModel.text;
            
            if([rowModel.text isEqualToString:self.currentSelectedTitle]==YES)
            {
                cell.accessoryType = UITableViewCellAccessoryCheckmark;
            }
            else
            {
                cell.accessoryType = UITableViewCellAccessoryNone;
            }
            
            break;
        }
    }

    return cell;
}


//================================================================================
//
//================================================================================
- (void)contactEditFieldView:(ContactEditFieldView *)contactEditFieldView ppTextFieldTableViewCellDidChanged:(PPTextFieldTableViewCell *)textFieldTableViewCell atIndexPath:(NSIndexPath *)indexPath
{
    if(textFieldTableViewCell.textField!=nil && indexPath!=nil)
    {
        PPRowModel *rowModel = [self.contactEditFieldSectionController rowModelAtIndexPath:indexPath forSearching:NO];
        PPContactRowObject *contactRowObject = [rowModel ppContactRowObjectOfRowModel];
        
        
        
        if(rowModel!=nil && contactRowObject!=nil)
        {
            if(textFieldTableViewCell.textField.text!=nil && textFieldTableViewCell.textField.text.length>0)
            {
                [contactRowObject.inputValueDictionary setObject:textFieldTableViewCell.textField.text forKey:[[contactRowObject.inputValueDictionary allKeys]objectAtIndex:0]];
                
                self.currentSelectedTitle = textFieldTableViewCell.textField.text;
            }
            else
            {
                //!!文字長度歸零
                [contactRowObject.inputValueDictionary setObject:@""
                                                          forKey:[[contactRowObject.inputValueDictionary allKeys]objectAtIndex:0]];
                
                self.currentSelectedTitle = WCCV_MLS_UserDefine;
            }
            
        }
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - ContactEditFieldViewDataSource

//================================================================================
//
//================================================================================
 - (void)contactEditFieldView:(ContactEditFieldView *)contactEditFieldView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    do
    {
        if(self.avoidDoubleSendResult==YES)
        {
            break;
        }
        
        //////////////////////////////////////////////////

        self.avoidDoubleSendResult = YES;
        
        if(self.contactEditFieldViewControllerMode==WCContactEditFieldViewControllerMode_AddField)
        {
            PPRowModel *rowModel = [self.contactEditFieldSectionController  rowModelAtIndexPath:indexPath forSearching:NO];
            
            if(rowModel!=nil)
            {
                self.currentSelectedTitle = rowModel.text;
            }
        }
        else
        {
            NSIndexPath *prevIndexPath = [self.contactEditFieldSectionController indexPathForTitle:self.currentSelectedTitle forSearching:NO];
            
            
            //!!防止連續點擊一樣的title。
            if(prevIndexPath!=nil &&
               (prevIndexPath.section!=indexPath.section ||
               prevIndexPath.row!=indexPath.row))
            {
                UITableViewCell *prevSelectedCell = [contactEditFieldView.editFieldTableView cellForRowAtIndexPath:prevIndexPath];
                
                if(prevSelectedCell!=nil)
                {
                    prevSelectedCell.accessoryType = UITableViewCellAccessoryNone;
                }
                
                //////////////////////////////////////////////////
                
                UITableViewCell *nextSelectedCell = [contactEditFieldView.editFieldTableView cellForRowAtIndexPath:indexPath];
                
                if(nextSelectedCell!=nil)
                {
                    nextSelectedCell.accessoryType = UITableViewCellAccessoryCheckmark;
                }
                
                //////////////////////////////////////////////////
                
                PPRowModel *rowModel = [self.contactEditFieldSectionController  rowModelAtIndexPath:indexPath forSearching:NO];
                
                if(rowModel!=nil)
                {
                    self.currentSelectedTitle = rowModel.text;
                }
                
                //////////////////////////////////////////////////
                
                if(nextSelectedCell!=nil && nextSelectedCell.selectionStyle!=UITableViewCellSelectionStyleNone)
                {
                    [contactEditFieldView.editFieldTableView deselectRowAtIndexPath:indexPath animated:YES];
                }
            }
            else
            {
                //讓上層直接跳出
                self.currentSelectedTitle = nil;
            }
        }
        
        //////////////////////////////////////////////////
        
        if(self.avoidDoubleSendResult==YES
           && [self.delegate respondsToSelector:@selector(contactEditFieldViewController:didSelectTitle:forPPContactMainType:)]==YES)
        {
   
            if(self.contactEditFieldSectionController.sectionModelsForDefault.count>indexPath.section)
            {
                PPContactSectionModel *sectionModel = [[self.contactEditFieldSectionController sectionModelsForDefault] objectAtIndex:indexPath.section];
                
                if([sectionModel isKindOfClass:[PPContactSectionModel class]]==YES)
                {
                    [self.delegate contactEditFieldViewController:self
                                                   didSelectTitle:self.currentSelectedTitle
                                             forPPContactMainType:sectionModel.contactMainType];
                }
                
            }

            //////////////////////////////////////////////////

            self.avoidDoubleSendResult = NO;
        }
    }
    while(0);
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPButtonDelegate Method

//================================================================================
//
//================================================================================
- (void)contactEditFieldSelectionNavigationBarView:(ContactEditFieldNavigationBarView *)contactEditFieldSelectionNavigationBarView
                                     responderView:(UIView *)responderView
                                      controlEvent:(UIControlEvents)controlEvent
{
    
    switch (responderView.tag)
    {
        case ContactEditFieldNavigationBarViewButtonTag_Back:
        {
            [self goBackAnimated:YES];
            
            break;
        }
        case ContactEditFieldNavigationBarViewButtonTag_Done:
        {
            if([self.delegate respondsToSelector:@selector(contactEditFieldViewController:didSelectTitle:forPPContactMainType:)]==YES)
            {
                if(self.contactEditFieldSectionController.sectionModelsForDefault.count>0)
                {
                    PPContactSectionModel *sectionModel = [[self.contactEditFieldSectionController sectionModelsForDefault]objectAtIndex:0];
                    
                    if([sectionModel isKindOfClass:[PPContactSectionModel class]]==YES)
                    {
                        [self.delegate contactEditFieldViewController:self
                                                       didSelectTitle:self.currentSelectedTitle
                                                 forPPContactMainType:sectionModel.contactMainType];
                    }
                    
                }
            }

            break;
        }
        default:
        {
            break;
        }
    }
}

@end
