//
//  WCContactFlowController.m
//  WorldCardMobile7
//
//  Created by sanhue on 2015/7/8.
//  Copyright (c) 2015年 penpower. All rights reserved.
//

#import "WCContactAccessFlowController.h"


//define
#import "namecard_define.h"
#import "PPContactLabelTypeDefine.h"
#import "WCContactAccessFlowController+SettingKeys.h"
#import "WCContactAccessFlowResourceDefine.h"
#import "WCContactEditViewController+SettingKey.h"
#import "WCModelDefine.h"
#import "WCSettingsKey.h"
#import "WCDataControllerProtocol.h"
#import "WCFieldDefine.h"
#import "WCContactViewController+PublicParameterDefine.h"

// categories
#import "NSDate+Format.h"
#import "PPSectionController+Contact.h"
#import "PPURLController+iOS.h"
#import "WCGroupModel+Tree.h"
#import "WCGroupModel+Sort.h"
#import "WCContactAccessFlowController+Common.h"

// model
#import "WCKernelRecogLangModel.h"
#import "WCKernelRecogTypeModel.h"
#import "WCCustomFieldInfo.h"
#import "WCUserDefinedFieldValueModel.h"
#import "WCFieldLabelString.h"
// view
#import "PPAlertView.h"
#import "PPBusyView.h"

// view controllers
#import "NoteViewController.h"
#import "PPSplitViewController.h"
#import "PPWebViewController.h"
#import "WCClipImageViewController.h"
#import "WCIDPhotoClipViewController.h"

// controllers
#import "PPCountryCodeConvert.h"
#import "PPMakeVirtualCardController.h"
#import "PPNavigationController.h"
#import "PPNetworkReachabilityController.h"
#import "PPSettingsController.h"
#import "PPSystemInfoController.h"
#import "PPWorldcardAddressController.h"
#import "UIViewController+PPSplitViewController.h"
#import "WCCardImageFlowController.h"
#import "WCExportFlowController.h"
#import "WCFieldTypeConverter.h"
#import "WCImagePickerController.h"
#import "WCReRecognitionFlowController.h"
#import "WCShareFlowController.h"
#import "WCSocialSearchFlowController.h"
#import "WCToastController.h"
#import "WCABItemSelectFlowController.h"
#import "WCGroupAccessFlowController.h"
#import "PPAlertController.h"

// for WCT
#if defined (PRODUCTLINE_WCT)

#import "WCTAccountSelectViewController.h"
#import "WCTAccountRelationModel.h"
#import "WCTFieldLengthDefine.h"
#import "WCTAccountDataController.h"
#import "WCTMatomoController.h"

#elif defined (PRODUCTLINE_WCSF)
#import "WCContactAccessFlowController+ForSalesforce.h"
#import "PPSelectItemViewController.h"
#import "WCSFMatomoController.h"
#import "WCCardModel+SalesforceAccessHelper.h"

#elif defined (PRODUCTLINE_WCO365)
#import "WCContactAccessFlowController+ForOffice365.h"

#elif defined (PRODUCTLINE_WCE)

#import "WCEFieldModel.h"

#endif

//////////////////////////////////////////////////


static BOOL g_ShouldShowNamePhonetic = NO;
static BOOL g_ShouldShowCompanyPhonetic = NO;
static BOOL g_ShouldShowPhoneticSelection = NO;
static BOOL g_ChineseEdtingFormat = NO;


typedef NS_ENUM(NSInteger, WCCAFC_AlertTag)
{
    WCCAFC_AlertTag_Info_Delete=0,
    WCCAFC_AlertTag_CardImage_Delete,
};

typedef NS_ENUM(NSInteger, WCCAFC_ButtonTag)
{
    WCCAFC_ButtonTag_SaveAsBack = 0,
};

////////////////////////////////////////////////////////////////////////////////////////////////////
@interface WCContactAccessFlowController ()
<
ContactDataExchangeProtocol,
WCContactInfoScrollViewControllerDataExchangeProtocol,
WCContactInfoScrollViewControllerDataSource,
WCContactInfoScrollViewControllerDelegate,
NoteViewControllerDelegate,
UIAlertViewDelegate,
WCABItemSelectFlowControllerDelegate,
WCCardImageFlowControllerDelegate,
WCContactEditViewControllerDataSource,
WCContactEditViewControllerDelegate,
WCExportFlowControllerDelegate,
WCGroupAccessFlowControllerDelegate,
WCShareFlowControllerDelegate,
// for WCT
#if defined(PRODUCTLINE_WCT)
WCTAccountSelectViewControllerDelegate,
#endif
#if defined (PRODUCTLINE_WCSF)
PPButtonDelegate,
PPSelectItemViewControllerDelegate,
#endif
PPWebViewControllerDelegate
>

//@property (nonatomic, retain) WCDataController *dataController;
@property (nonatomic, retain, readwrite) WCContactInfoScrollViewController *contactInfoScrollViewController;
@property (nonatomic, retain, readwrite) WCContactEditViewController *contactEditViewController;

#if defined (PRODUCTLINE_WCSF)
@property (nonatomic, retain) PPSelectItemViewController *saveAsItemSelectViewController;
#endif

@property (nonatomic, retain) PPBusyView *ppBusyView;

#pragma mark - flow controller
@property (nonatomic, retain) WCCardImageFlowController *cardImageFlowController;
@property (nonatomic, retain) WCShareFlowController *shareFlowController;
@property (nonatomic, retain) WCExportFlowController *exportFlowController;

#pragma mark - data
@property (nonatomic, retain) NSString *cardIDForDelete;
@property (nonatomic, retain) NSString *cardIDForNote;
@property (nonatomic, retain) WCCardModel *currentEditingCardModel;

@property (nonatomic, retain) NSString *translateFromLanguage;
@property (nonatomic, retain) NSString *translateToLanguage;

// 儲存到系統聯絡人
@property (nonatomic, retain) NSString *defaultSourceID;
@property (nonatomic, retain) NSString *defaultGroupID;
@property (nonatomic, retain) NSString *defaultPersonID;

// google同步帳號
@property (nonatomic, retain) NSString *googleSyncAccount;

// 記錄自已的guid
@property (nonatomic, retain) NSString *selfAccountGuid;

@property (nonatomic, retain) NSString *bossAccountGuid;
@property (atomic, assign) BOOL isDeallocing;
@property (atomic, assign) BOOL isEditFinishedComplete;

@end

////////////////////////////////////////////////////////////////////////////////////////////////////
@implementation WCContactAccessFlowController





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - init/dealloc methods


//==============================================================================
//
//==============================================================================
- (instancetype)init
{
    self = [super init];
    if (self)
    {
        self.isEditNeedShowGroup = YES;
        self.isInfoNeedShowGroup = YES;
        
        if (UI_USER_INTERFACE_IDIOM()==UIUserInterfaceIdiomPad)
        {
            [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(recvDisplayDataChanged:) name:WCDC_NOTIFY_DisplayDataChanged object:nil];
        }
    }
    return self;
}


//==============================================================================
//
//==============================================================================
- (void)dealloc
{
    if (UI_USER_INTERFACE_IDIOM()==UIUserInterfaceIdiomPad)
    {
        [[NSNotificationCenter defaultCenter] removeObserver:self name:WCDC_NOTIFY_DisplayDataChanged object:nil];
    }
    
    self.isDeallocing = YES;
    self.delegate = nil;
    
    //////////////////////////////////////////////////
    
    [self dismissContactEditViewControllerAnimated:NO];
    [self dismissContactInfoViewControllerAnimated:NO];
    
#if defined (PRODUCTLINE_WCSF)
    self.saveAsItemSelectViewController = nil;
    self.saveAsArray = nil;
#endif
    
    [self.ppBusyView removeFromSuperview];
    self.ppBusyView = nil;
    
    self.cardImageFlowController = nil;
    self.shareFlowController = nil;
    self.exportFlowController = nil;
    
    self.cardIDForNote = nil;
    self.cardIDForDelete = nil;
    self.currentEditingCardModel = nil;
    
    self.translateFromLanguage = nil;
    self.translateToLanguage = nil;
    
    self.googleSyncAccount = nil;
    
    self.selfAccountGuid = nil;
    self.bossAccountGuid = nil;
    
    self.defaultSourceID = nil;
    self.defaultGroupID = nil;
    self.defaultPersonID = nil;
    
    [_userInfo release];
    _userInfo = nil;
    
    //////////////////////////////////////////////////
    [super dealloc];
}


//==============================================================================
//
//==============================================================================
- (void)resetData
{
    self.cardIDForDelete = nil;
    //    self.currentCardModel = nil;
}


//==============================================================================
//
//==============================================================================
- (BOOL)isEditing
{
    return (self.contactEditViewController)?YES:NO;
}




////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - (Private) WCM custom methods

//==============================================================================
// WCM的自訂欄位，
//==============================================================================
- (NSArray*)prepareWCMCustomFieldWithCardModel:(WCCardModel *)cardModel
{
    NSMutableArray *dataArray = [[NSMutableArray alloc] init];
    //////////////////////////////////////////////////
    NSArray *fieldArray = [cardModel fieldArrayWithType:WC_FT_UserDefine];
    
    for (WCFieldModel *fieldModel in fieldArray)
    {
        if ([fieldModel.value isKindOfClass:[WCUserDefinedFieldValueModel class]]==YES)
        {
            WCUserDefinedFieldValueModel *userDefinedFieldModel = fieldModel.value;
            
            ContactDataExchangeModel *dataModel = [[ContactDataExchangeModel alloc] init];
            
            dataModel.contactFieldSource = PPContactFieldSource_UserCreate;
            dataModel.labelType = PPContactLabelType_UserDefine;
            dataModel.labelText = userDefinedFieldModel.label;
            
            [dataModel.propertyDictionary setObject:[userDefinedFieldModel.value length]==0?@"":userDefinedFieldModel.value
                                             forKey:@(PPContactSubType_UserDefine_Text)];
            
            //////////////////////////////////////////////////
            [dataArray addObject:dataModel];
            [dataModel release];
        }
        
    }
    
    //////////////////////////////////////////////////
    NSArray *resultArray = [NSArray arrayWithArray:dataArray];
    [dataArray release];
    
    return resultArray;
}



////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - (Private) WCT Custom methods



//==============================================================================
// WCT的自訂欄位，這邊要傳入所有自訂欄位，沒有值就不用填，PPContactSubType_UserDefine_Text，PPContactSubType_UserDefine_ID
//==============================================================================
- (NSArray*)prepareWCTCustomFieldWithCardModel:(WCCardModel *)cardModel
{
    NSMutableArray *dataArray = [[NSMutableArray alloc] init];
    
    // !! 先取得所有自訂欄位資訊
    NSArray *allCustomFieldInfos = nil;
    if([self.delegate respondsToSelector:@selector(contactAccessFlowControllerRequestCustomFieldInfos:)])
    {
        allCustomFieldInfos = [self.delegate contactAccessFlowControllerRequestCustomFieldInfos:self];
    }
    
    NSArray *fieldArray = [cardModel fieldArrayWithType:WC_FT_UserDefine];
    
    for (WCCustomFieldInfo *customFieldInfo in allCustomFieldInfos)
    {
        ContactDataExchangeModel *dataModel = [[ContactDataExchangeModel alloc] init];
        
        dataModel.contactFieldSource = PPContactFieldSource_UserCreate;
        dataModel.labelType = PPContactLabelType_UserDefine;
        dataModel.labelText = customFieldInfo.name;
        
        // 產生預設的guid
        [dataModel.propertyDictionary setObject:[NSString GUID]
                                         forKey:@(PPContactSubType_UserDefine_ID)];
        
        NSMutableDictionary *userInfo = [NSMutableDictionary dictionary];
        [userInfo setObject:customFieldInfo.guid forKey:WCContactAccessFlowControllerCustomFieldKey_FieldInfoGuid];
        [userInfo setObject:@(customFieldInfo.contentType) forKey:WCContactAccessFlowControllerCustomFieldKey_ContentType];
        
        if(customFieldInfo.picklistItems)
        {
            [userInfo setObject:customFieldInfo.picklistItems forKey:WCContactAccessFlowControllerCustomFieldKey_ListItems];
        }
        
        [dataModel.propertyDictionary setObject:userInfo
                                         forKey:@(PPContactSubType_UserDefine_UserInfo)];
        
        
        // 設定自訂欄位內容值
        PPContactSubType contactSubType = PPContactSubType_UserDefine_Text;
        
        if(customFieldInfo.contentType==WCCustomFieldContentType_Text)
        {
            contactSubType = PPContactSubType_UserDefine_Text;
        }
        if(customFieldInfo.contentType==WCCustomFieldContentType_URL)
        {
            contactSubType = PPContactSubType_UserDefine_URL;
        }
        else if(customFieldInfo.contentType==WCCustomFieldContentType_Integer)
        {
            contactSubType = PPContactSubType_UserDefine_Integer;
        }
        else if(customFieldInfo.contentType==WCCustomFieldContentType_Float)
        {
            contactSubType = PPContactSubType_UserDefine_Float;
        }
        else if(customFieldInfo.contentType==WCCustomFieldContentType_Email)
        {
            contactSubType = PPContactSubType_UserDefine_Email;
        }
        else if(customFieldInfo.contentType==WCCustomFieldContentType_Date)
        {
            contactSubType = PPContactSubType_UserDefine_Date;
        }
        else if(customFieldInfo.contentType==WCCustomFieldContentType_DateTime)
        {
            contactSubType = PPContactSubType_UserDefine_DateAndTime;
        }
        else if(customFieldInfo.contentType==WCCustomFieldContentType_Picklist)
        {
            contactSubType = PPContactSubType_UserDefine_ListValue;
            
            // !! 要傳入選單值, 且選項要手動加入@""
            NSMutableArray *itemMenu = [NSMutableArray arrayWithObject:WCVC_EditViewControllerSelectEmptyValue];
            for (WCCustomFieldListItem *listItem in customFieldInfo.picklistItems)
            {
                [itemMenu addObject:listItem.itemText];
            }
            
            [dataModel.propertyDictionary setObject:itemMenu
                                             forKey:@(PPContactSubType_UserDefine_ItemMenu)];
            
        }
        
        [dataModel.propertyDictionary setObject:@""
                                         forKey:@(contactSubType)];
        
        ///////////////////////////////////////////////////
        // 如果這個自訂欄位已有值，要把值塞進去
        
        for (WCFieldModel *fieldModel in fieldArray)
        {
            if ([fieldModel.customFieldInfoGuid isEqualToString:customFieldInfo.guid])
            {
                [dataModel.propertyDictionary setObject:fieldModel.guid
                                                 forKey:@(PPContactSubType_UserDefine_ID)];
                
                
                // item guid要轉為item text
                if(customFieldInfo.contentType==WCCustomFieldContentType_Picklist)
                {
                    NSString *currentItemText = [self itemTextFromListItems:customFieldInfo.picklistItems guid:fieldModel.value];
                    
                    [dataModel.propertyDictionary setObject:[currentItemText length]==0?@"":currentItemText
                                                     forKey:@(contactSubType)];
                    
                }
                else
                {
                    [dataModel.propertyDictionary setObject:[fieldModel.value length]==0?@"":fieldModel.value
                                                     forKey:@(contactSubType)];
                }
                
                break;
            }
        }
        //////////////////////////////////////////////////
        [dataArray addObject:dataModel];
        [dataModel release];
    }
    
    //////////////////////////////////////////////////
    NSArray *resultArray = [NSArray arrayWithArray:dataArray];
    [dataArray release];
    
    return resultArray;
}




//==============================================================================
//
//==============================================================================
- (NSArray *)prepareSharedAccountWithCardModel:(WCCardModel *)cardModel
{
#if defined (PRODUCTLINE_WCT)
    NSMutableArray *groupArray=[[NSMutableArray alloc] init];
    
    //////////////////////////////////////////////////
    //  建立shared account選項
    ContactDataExchangeModel *contactDataExchangeModel = [[ContactDataExchangeModel alloc] init];
    if(contactDataExchangeModel!=nil)
    {
        contactDataExchangeModel.labelType = PPContactLabelType_VisibleAccount_Info;
        
        //////////////////////////////////////////////////
        if(contactDataExchangeModel.propertyDictionary!=nil)
        {
            NSString *accountNames = nil;
            
            BOOL isShareToCompany = [PPSettingsController integerValueWithKey:WCContactAccessFlowController_SettingsKey_ShareToCompany];
            
            if (isShareToCompany)
            {
                accountNames = WCCAFC_ShareToCompany;
            }
            else
            {
                accountNames = [WCTAccountDataController displayStringForVisibleAccountGuids:cardModel.sharedAccountGUIDArray ownerGuid:cardModel.owner];
            }
            
            [contactDataExchangeModel.propertyDictionary setObject:accountNames
                                                            forKey:@(PPContactSubType_VisibleAccount)];
            //////////////////////////////////////////////////
            if(cardModel.sharedAccountGUIDArray)
            {
                [contactDataExchangeModel.propertyDictionary setObject:cardModel.sharedAccountGUIDArray
                                                                forKey:@(PPContactSubType_VisibleAccountID)];
            }
            //////////////////////////////////////////////////
            [groupArray addObject:contactDataExchangeModel];
        }
        
        [contactDataExchangeModel release];
    }
    
    //////////////////////////////////////////////////
    NSArray *resultArray = [NSArray arrayWithArray:groupArray];
    [groupArray release];
    
    return resultArray;
#else
    return nil;
#endif
    
}



////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - (Private) WCM, WCT group access methods


//==============================================================================
// WCT用
//==============================================================================
- (NSString *)itemTextFromListItems:(NSArray *)listItems guid:(NSString *)guid
{
    for (WCCustomFieldListItem *listItem in listItems)
    {
        if([listItem.guid isEqualToString:guid])
        {
            return listItem.itemText;
        }
    }
    
    return nil;
}


//==============================================================================
// MARK: WCM, WCT的群組列表
//==============================================================================
- (NSMutableArray *)allGroupModels
{
    NSMutableArray *allGroups = nil;
    
    if ([self.delegate respondsToSelector:@selector(contactAccessFlowController:allGroupModelsWithCardID:)])
    {
        allGroups = [self.delegate contactAccessFlowController:self allGroupModelsWithCardID:nil];
    }
    
    // 移除all, 未校正
    for(int i=0;i<[allGroups count];i++)
    {
        if(((WCGroupModel*)[allGroups objectAtIndex:i]).ID == WC_GID_All ||
           ((WCGroupModel*)[allGroups objectAtIndex:i]).ID == WC_GID_Unverified)
        {
            [allGroups removeObjectAtIndex:i];
            i--;
        }
    }
    
    return allGroups;
}


//==============================================================================
// MARK: WCM, WCT預設勾選的群組列表
//==============================================================================
- (NSMutableArray *)selectedGroupModelsWithCardID:(NSString *)cardID
{
    if (self.contactEditViewController)
    {
        // 如果是未分類，回傳nil就好
        if ([[self.currentEditingCardModel.groupIDArray firstObject] integerValue]==WC_GID_Unfiled)
        {
            return nil;
        }
        
        NSMutableArray *allGroups = nil;
        NSMutableArray *currentGroupModels = [NSMutableArray array];
        
        if ([self.delegate respondsToSelector:@selector(contactAccessFlowController:allGroupModelsWithCardID:)])
        {
            allGroups = [self.delegate contactAccessFlowController:self allGroupModelsWithCardID:nil];
        }
        
        // 回傳的類別是不包含All的第一層
        // 所以這邊要先建一個temp用的，方便找資料
        WCGroupModel *rootModel = [[[WCGroupModel alloc] init] autorelease];
        rootModel.ID = WC_GID_All;
        [rootModel.subGroups addObjectsFromArray:allGroups];
        
        for (NSString *groupIDString in self.currentEditingCardModel.groupIDArray)
        {
            WCGroupModel *groupModel = [rootModel groupInTreeWithID:[groupIDString integerValue] sourceID:0];
            if  (groupModel)
            {
                [currentGroupModels addObject:groupModel];
            }
        }
        
        return currentGroupModels;
    }
    else
    {
        NSMutableArray *allGroups = nil;
        
        if ([self.delegate respondsToSelector:@selector(contactAccessFlowController:allGroupModelsWithCardID:)])
        {
            allGroups = [self.delegate contactAccessFlowController:self allGroupModelsWithCardID:cardID];
        }
        return allGroups;
    }
}


//==============================================================================
// MARK: WCM, WCT group選取完成
//==============================================================================
- (void)groupDidSelectedArray:(NSArray *)groupArray infoCardID:(NSString *)cardID
{
    NSMutableArray *groupIDArray = [NSMutableArray array];
    for (WCGroupModel *groupModel in groupArray)
    {
        // 檢查群組是否存在
        NSString *groupIDString = [NSString stringWithFormat:@"%ld",(long)groupModel.ID];
        NSString *fullGroupPath = [self.delegate contactAccessFlowController:self groupNamesWithGroupIDArray:@[groupIDString]];
        if ([self.delegate contactAccessFlowController:self isExistGroupNamed:fullGroupPath])
        {
            [groupIDArray addObject:groupIDString];
        }
    }
    
    // 都沒有group就是未分類
    if([groupIDArray count]<1)
    {
        [groupIDArray addObject:[NSString stringWithFormat:@"%ld",(long)WC_GID_Unfiled]];;
    }
    
    // 如果有編輯頁面，這邊就是直接寫到編輯
    if (self.contactEditViewController)
    {
        [self.currentEditingCardModel setGroupIDArray:groupIDArray isInitCard:NO];
        
        // 轉換為contactEditViewController的格式，更新回去
        NSMutableDictionary *dictionary = [NSMutableDictionary dictionary];
        NSArray *newGroupArray=[self prepareGroupArrayWithCardModel:self.currentEditingCardModel];
        [dictionary setObject:newGroupArray forKey:@(PPContactMainType_Group)];
        [self.contactEditViewController clearAndUpdateGroupDataFromFieldDictioanry:dictionary];
    }
    else
    {
        // 如果聯絡人不存在，不處理
        if ([self checkExistAndShowToastIfNeededFromViewController:self.contactInfoScrollViewController withCardID:cardID])
        {
            // 如果不是編輯頁就是從info進來的，直接寫到資料庫
            if ([self.delegate respondsToSelector:@selector(contactAccessFlowController:updateCard:withGroupIDArray:)])
            {
                [self.delegate contactAccessFlowController:self updateCard:cardID withGroupIDArray:groupIDArray];
            }
            
            // !! 如果是從info進來，要reload
            [self.contactInfoScrollViewController clearContactInformationInCurrentPage];
        }
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - (Private) WCM, WCT data access methods


//==============================================================================
//
//==============================================================================
- (NSMutableArray *)wcOtherDataArrayWithCardModel:(WCCardModel*)cardModel forEdit:(BOOL)forEdit
{
    //////////////////////////////////////////////////
    
    BOOL isForWCTMode = NO;
    
#if defined(PRODUCTLINE_WCT)
    
    isForWCTMode = YES;
#endif

    //////////////////////////////////////////////////
    
    NSMutableArray *mainTypeDataArray= [[NSMutableArray alloc] init];
    NSArray *fieldArray = nil;
    ContactDataExchangeModel *dataModel = nil;
    //////////////////////////////////////////////////
    // 建立統一編號
    fieldArray = [cardModel fieldArrayWithType:WC_FT_UnifiedBusinessNo];
    for (WCFieldModel *fieldModel in fieldArray)
    {
        dataModel=[[ContactDataExchangeModel alloc] init];
        [dataModel.propertyDictionary setObject:fieldModel.value
                                         forKey:@(PPContactSubType_None)];
        //////////////////////////////////////////////////
        dataModel.labelType = PPContactLabelType_Other_UnifiedBusinessNumber;
        dataModel.labelText = PPContactLabelText_Other_UnifiedBuinessNumber;
        
        [mainTypeDataArray addObject:dataModel];
        [dataModel release];
    }
    
    //////////////////////////////////////////////////
    // 建立暱稱
    fieldArray = [cardModel fieldArrayWithType:WC_FT_Nickname];
    for (WCFieldModel *fieldModel in fieldArray)
    {
        dataModel=[[ContactDataExchangeModel alloc] init];
        [dataModel.propertyDictionary setObject:fieldModel.value
                                         forKey:@(PPContactSubType_None)];
        //////////////////////////////////////////////////
        dataModel.labelType = PPContactLabelType_Other_NickName;
        dataModel.labelText = PPContactLabelText_Other_NickName;
        
        [mainTypeDataArray addObject:dataModel];
        [dataModel release];
    }
    
    //////////////////////////////////////////////////
    // 建立時間
    if (forEdit==NO &&
        cardModel.createdTime!=nil)
    {
        NSString * createTime =  [cardModel.createdTime stringWithFormat:NSDateFormat_Second];
        
        if (isForWCTMode)
        {
            // for WCT 如果有creator的話，要加到時間後
            if ([cardModel.creator length]>0)
            {
                if ([self.delegate respondsToSelector:@selector(contactAccessFlowController:requestAccountNameWithGuid:)])
                {
                    NSString *displayName = [self.delegate contactAccessFlowController:self requestAccountNameWithGuid:cardModel.creator];
                    createTime = [createTime stringByAppendingFormat:@" by %@", displayName];
                }
            }
        }
        
        dataModel=[[ContactDataExchangeModel alloc] init];
        [dataModel.propertyDictionary setObject:createTime
                                         forKey:@(PPContactSubType_None)];
        //////////////////////////////////////////////////
        dataModel.labelType = PPContactLabelType_Other_ConstructTime;
        dataModel.labelText = PPContactLabelText_Other_ConstructTime;
        
        [mainTypeDataArray addObject:dataModel];
        [dataModel release];
    }
    
    //////////////////////////////////////////////////
    // 修改時間
    if (isForWCTMode)
    {
        if (forEdit==NO &&
            cardModel.modifiedTime!=nil)
        {
            NSString * modifiedTime =  [cardModel.modifiedTime stringWithFormat:NSDateFormat_Second];
            
            // for WCT 如果有editor的話，要加到時間後
            if ([cardModel.editor length]>0)
            {
                if ([self.delegate respondsToSelector:@selector(contactAccessFlowController:requestAccountNameWithGuid:)])
                {
                    NSString *displayName = [self.delegate contactAccessFlowController:self requestAccountNameWithGuid:cardModel.editor];
                    modifiedTime = [modifiedTime stringByAppendingFormat:@" by %@", displayName];
                }
            }
            
            dataModel=[[ContactDataExchangeModel alloc] init];
            [dataModel.propertyDictionary setObject:modifiedTime
                                             forKey:@(PPContactSubType_None)];
            //////////////////////////////////////////////////
            dataModel.labelType = PPContactLabelType_Other_ModifyTime;
            dataModel.labelText = PPContactLabelText_Other_ModifyTime;
            
            [mainTypeDataArray addObject:dataModel];
            [dataModel release];
        }
    }
    
    return [mainTypeDataArray autorelease];
}









////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - (Private) detail card data handler



//==============================================================================
//
//==============================================================================
- (NSMutableArray *)prepareWCMainTypeArrayForEdit:(BOOL)edit
                                isShowCustomField:(BOOL)isShowCustomField
                                      isShowGroup:(BOOL)isShowGroup
                              isShowSharedAccount:(BOOL)isShowSharedAccount

{
    BOOL isForWCTMode = NO;
    
#if defined(PRODUCTLINE_WCT)
    isForWCTMode = YES;
#endif
    
    //////////////////////////////////////////////////
    
    BOOL isForWCEMode = NO;
    
#if defined(PRODUCTLINE_WCE)
    isForWCEMode = YES;
#endif
    
    //////////////////////////////////////////////////
    
    BOOL isForWCMMode = NO;
    
#if defined(PRODUCTLINE_WCM)
    isForWCMMode = YES;
#endif
    
    //////////////////////////////////////////////////
    if (edit)
    {
        NSMutableArray *mainTypeArray = [[[NSMutableArray alloc] initWithArray:@[@(PPContactMainType_HeadImage),
                                                                                 @(PPContactMainType_Name),
                                                                                 @(PPContactMainType_Phone),
                                                                                 @(PPContactMainType_Email),
                                                                                 @(PPContactMainType_Company),
                                                                                 @(PPContactMainType_Address),
                                                                                 @(PPContactMainType_URL),
                                                                                 @(PPContactMainType_InstantMessage),
                                                                                 @(PPContactMainType_SocialNetwork),
                                                                                 @(PPContactMainType_BirthDay),
                                                                                 @(PPContactMainType_Date)]] autorelease];
        
        if (self.isEditNeedShowGroup)
        {
            if(isShowGroup)
            {
                [mainTypeArray addObject:@(PPContactMainType_Group)];
                
                if (isForWCEMode==NO)
                {
                    [mainTypeArray addObject:@(PPContactMainType_SystemGroup)];
                }
            }
            
            // WCT 要顯示可檢視用戶
            if (isForWCTMode)
            {
                if(isShowSharedAccount)
                {
                    [mainTypeArray addObject:@(PPContactMaintype_VisibleAccount)];
                }
            }
        }
        
        [mainTypeArray addObject:@(PPContactMainType_Other)];
        
        //!! WCT的自訂欄位放在other後
        if (isForWCTMode)
        {
            if(isShowCustomField)
            {
                [mainTypeArray addObject:@(PPContactMainType_UserDefine)];
            }
        }
        [mainTypeArray addObject:@(PPContactMainType_Note)];
        
        return mainTypeArray;
    }
    else
    {
        NSMutableArray *mainTypeArray = [[[NSMutableArray alloc] initWithArray:@[@(PPContactMainType_Name),
                                                                                 @(PPContactMainType_Phone),
                                                                                 @(PPContactMainType_Email),
                                                                                 @(PPContactMainType_Company),
                                                                                 @(PPContactMainType_Address),
                                                                                 @(PPContactMainType_URL),
                                                                                 @(PPContactMainType_InstantMessage),
                                                                                 @(PPContactMainType_SocialNetwork),
                                                                                 @(PPContactMainType_BirthDay),
                                                                                 @(PPContactMainType_Date)]] autorelease];
        
        // WCM的自訂欄位放在資料最後面
        if (isForWCMMode)
        {
            if(isShowCustomField)
            {
                [mainTypeArray addObject:@(PPContactMainType_UserDefine)];
            }
        }
        
        if (self.isInfoNeedShowGroup)
        {
            if (isShowGroup)
            {
                [mainTypeArray addObject:@(PPContactMainType_Group)];
            }
        }
        
        // WCT 要顯示可檢視用戶
        if (isForWCTMode)
        {
            if (isShowSharedAccount)
            {
                [mainTypeArray addObject:@(PPContactMaintype_VisibleAccount)];
            }
        }
        [mainTypeArray addObject:@(PPContactMainType_Other)];
        
        //!! WCT的自訂欄位放在other後
        if (isForWCTMode)
        {
            if(isShowCustomField)
            {
                [mainTypeArray addObject:@(PPContactMainType_UserDefine)];
            }
        }
        
        
        return mainTypeArray;
    }
}


//==============================================================================
//
//==============================================================================
- (NSMutableArray *)prepareMainTypeArrayForEdit:(BOOL)edit
{
#if defined (PRODUCTLINE_WCSF)
    return [self prepareWCSFMainTypeArrayForEdit:YES saveAs:self.saveAs];
#elif defined (PRODUCTLINE_WCO365)
    return [self prepareWCO365MainTypeArrayForEdit:edit];
#else
    BOOL isEditingMyCard = (self.contactEditViewController.contactEditViewControllerLayout==WCContactEditViewControllerLayout_MyCard);
    BOOL isHelpScan = (self.contactEditViewController.contactEditViewControllerLayout==WCContactEditViewControllerLayout_HelpScan);

    return [self prepareWCMainTypeArrayForEdit:edit
                             isShowCustomField:!isEditingMyCard
                                   isShowGroup:(!isEditingMyCard&&!isHelpScan)
                           isShowSharedAccount:(!isEditingMyCard&&!isHelpScan)];
#endif
}

//==============================================================================
//
//==============================================================================
- (NSMutableArray *)prepareHiddenSectionArray
{
    //    return nil;
    return [[[NSMutableArray alloc] initWithArray:@[@(PPContactMainType_UnifiedBusinessNumber),
                                                    @(PPContactMainType_NickName),
                                                    @(PPContactMainType_ConstructTime)]] autorelease];
    
}



//==============================================================================
//
//==============================================================================
- (NSArray *)prepareGroupArrayWithCardModel:(WCCardModel *)cardModel
{
    // TODO: WCE, CardModel 取類別方法不一樣 CategoryGuid
    
    NSMutableArray *groupArray=[[NSMutableArray alloc] init];
    
    //////////////////////////////////////////////////
    //  建立local group選項
    ContactDataExchangeModel *worldCardGroup = [[ContactDataExchangeModel alloc] init];
    if (worldCardGroup)
    {
        worldCardGroup.labelText = PPContactLabelText_Group;
        worldCardGroup.labelType = PPContactLabelType_Group_Info;
        
        // 取得群組名稱
        if(cardModel.sourceID!=WC_SID_Unverified)
        {
            NSString *worldCardGroupName = nil;
            
            if ([self.delegate respondsToSelector:@selector(contactAccessFlowController:groupNamesWithGroupIDArray:)])
            {
                worldCardGroupName = [self.delegate contactAccessFlowController:self groupNamesWithGroupIDArray:cardModel.groupIDArray];
            }
            
            if (worldCardGroupName)
            {
                [worldCardGroup.propertyDictionary setObject:worldCardGroupName forKey:@(PPContactSubType_Group)];
            }
        }
        
        // 取得群組id
        NSArray *worldCardGroupIDArray = [NSArray arrayWithArray:cardModel.groupIDArray];
        if (worldCardGroupIDArray)
        {
            [worldCardGroup.propertyDictionary setObject:worldCardGroupIDArray forKey:@(PPContactSubType_GroupID)];
        }
        
        [groupArray addObject:worldCardGroup];
        
        [worldCardGroup release];
    }
    
    //////////////////////////////////////////////////
    NSArray *resultArray = [NSArray arrayWithArray:groupArray];
    [groupArray release];
    
    return resultArray;
}



//==============================================================================
//
//==============================================================================
- (NSArray *)prepareSystemGroupArrayWithCardModel:(WCCardModel *)cardModel
{
    NSMutableArray *groupArray=[[NSMutableArray alloc] init];
    
    //////////////////////////////////////////////////
    //  建立local group選項
    BOOL enableSaveToiPhone = [PPSettingsController integerValueWithKey:WCContactViewController_SettingsKey_EnableSystemContactCategory];
    
    ContactDataExchangeModel *systemGroup = [[ContactDataExchangeModel alloc] init];
    if (systemGroup)
    {
        systemGroup.labelText = PPContactLabelText_SystemGroup;
        systemGroup.labelType = PPContactLabelType_SystemGroup_Info;
        
        NSString *defaultGroupName = nil;
        
        if(enableSaveToiPhone)
        {
            WCABDataController *abDataController = [[WCABDataController alloc] initWithError:nil];
            if(abDataController)
            {
                // !! 這邊變成可能一開啟沒開儲存到系統聯絡人，所以沒有值
                // 但在編輯介面打開後，要重新檢查一次
                if([abDataController isSourceExist:self.defaultSourceID]==NO ||
                   self.defaultSourceID==nil)
                {
                    self.defaultSourceID = [abDataController defaultSourceIDWithExcludedGmailAccount:self.googleSyncAccount];
                    
                    if(self.defaultSourceID)
                    {
                        [PPSettingsController setStringValue:self.defaultSourceID withKey:WCSC_SV_kSaveToiPhoneSourceID];
                        [PPSettingsController removeValueWithKey:WCSC_SV_kSaveToiPhoneGroupID];
                    }
                    else
                    {
                        [PPSettingsController setIntegerValue:0 withKey:WCSC_IV_kEnableSaveToiPhone];
                        
                        [PPSettingsController removeValueWithKey:WCSC_SV_kSaveToiPhoneSourceID];
                        [PPSettingsController removeValueWithKey:WCSC_SV_kSaveToiPhoneGroupID];
                    }
                }
                defaultGroupName = [abDataController displayNameWithSourceID:self.defaultSourceID groupID:self.defaultGroupID];
            }
            [abDataController release];
        }
        
        if ([defaultGroupName length]==0)
        {
            defaultGroupName = @"";
        }
        [systemGroup.propertyDictionary setObject:defaultGroupName
                                           forKey:@(PPContactSubType_SystemGroup)];
        //////////////////////////////////////////////////
        
        if (self.defaultGroupID)
        {
            [systemGroup.propertyDictionary setObject:self.defaultGroupID
                                               forKey:@(PPContactSubType_SystemGroupID)];
        }
        
        [groupArray addObject:systemGroup];
        
        [systemGroup release];
    }
    
    //////////////////////////////////////////////////
    NSArray *resultArray = [NSArray arrayWithArray:groupArray];
    [groupArray release];
    
    return resultArray;
}



//================================================================================
//
//================================================================================
//- (NSMutableDictionary *)prepareFieldDictionaryWithCardModel:(WCCardModel *)cardModel forPPContactMainTypeArray:(NSArray *)contactMainTypeArray forEdit:(BOOL)forEdit
//{
//#if defined(PRODUCTLINE_WCSF)
//#else
//    [self prepareWCFieldDictionaryWithCardModel:cardModel forPPContactMainTypeArray:contactMainTypeArray forEdit:forEdit];
//#endif
//}


//==============================================================================
// help scan的編輯欄位
//==============================================================================
- (NSMutableDictionary *)prepareFieldDictionaryWithCardModel:(WCCardModel *)cardModel
                                   forPPContactMainTypeArray:(NSArray *)contactMainTypeArray
                                                     forEdit:(BOOL)forEdit
                                                  isHelpScan:(BOOL)isHelpScan
{
    return [self prepareFieldDictionaryWithCardModel:cardModel
                           forPPContactMainTypeArray:contactMainTypeArray
                                             forEdit:forEdit
                                   isShowCustomField:YES
                                   isShowGroup:!isHelpScan
                                 isShowSharedAccount:!isHelpScan];
}


//================================================================================
//
//================================================================================
- (NSMutableDictionary *)prepareFieldDictionaryWithCardModel:(WCCardModel *)cardModel
                                   forPPContactMainTypeArray:(NSArray *)contactMainTypeArray
                                                     forEdit:(BOOL)forEdit
                                           isShowCustomField:(BOOL)isShowCustomField
                                           isShowGroup:(BOOL)isShowGroup
                                         isShowSharedAccount:(BOOL)isShowSharedAccount
{
    if (cardModel == nil)
    {
        return nil;
    }
    
    //////////////////////////////////////////////////
    
    BOOL isForWCTMode = NO;
    
#if defined(PRODUCTLINE_WCT)

    isForWCTMode = YES;
#endif
    
    //////////////////////////////////////////////////
    
    BOOL isForWCMMode = NO;
    
#if defined(PRODUCTLINE_WCM)
    isForWCMMode = YES;
#endif
    
    //////////////////////////////////////////////////
    
    BOOL isForWCSFMode = NO;
    
#if defined(PRODUCTLINE_WCSF)
    isForWCSFMode = YES;
#endif
    
    //////////////////////////////////////////////////
    
    BOOL isForWCO365Mode = NO;
    
#if defined(PRODUCTLINE_WCO365)
    isForWCO365Mode = YES;
#endif
    
   //////////////////////////////////////////////////
    
    NSMutableDictionary *fieldDictionary = [NSMutableDictionary dictionary];
    
    
    for (NSNumber *mainTypeNumber in contactMainTypeArray)
    {
        // other的處理與其他不同
        if ([mainTypeNumber integerValue]==PPContactMainType_Other)
        {
            NSMutableArray *mainTypeDataArray = nil;
#if defined (PRODUCTLINE_WCO365)
            mainTypeDataArray = [self wco365OtherDataArrayWithCardModel:cardModel];
#else
            mainTypeDataArray = [self wcOtherDataArrayWithCardModel:cardModel forEdit:forEdit];
#endif
            //////////////////////////////////////////////////
            if ([mainTypeDataArray count]>0)
            {
                [fieldDictionary setObject:mainTypeDataArray forKey:mainTypeNumber];
            }
            
            continue;
        } // end of if PPContactMainType_Other
#if defined (PRODUCTLINE_WCSF)
        else if([mainTypeNumber integerValue]==PPContactMainType_SalesforceSaveAs)
        {
            NSMutableArray *mainTypeDataArray= [self wcsfSavaAsDataArrayWithCardModel:cardModel];
            
            //////////////////////////////////////////////////
            if ([mainTypeDataArray count]>0)
            {
                [fieldDictionary setObject:mainTypeDataArray forKey:mainTypeNumber];
            }
            
            continue;
        }
        else if([mainTypeNumber integerValue]==PPContactMainType_Salutation)
        {
            NSMutableArray *mainTypeDataArray= [self wcsfSalutationDataArrayWithCardModel:cardModel];
            
            //////////////////////////////////////////////////
            if ([mainTypeDataArray count]>0)
            {
                [fieldDictionary setObject:mainTypeDataArray forKey:mainTypeNumber];
            }
            
             continue;
        } // end of if PPContactMainType_Salutation
#endif
        //////////////////////////////////////////////////
        
        WC_FieldType type = [WCFieldTypeConverter fieldTypeFromPPContactMainType:[mainTypeNumber integerValue]];
        NSArray *fieldArray = [cardModel fieldArrayWithType:type];
        
        NSMutableArray *mainTypeDataArray= [[NSMutableArray alloc] init];
        NSMutableArray *birthDayTypeDataArray= [[NSMutableArray alloc] init];
        
        //////////////////////////////////////////////////
        // 產生main type data
        for (WCFieldModel *fieldModel in fieldArray)
        {
            switch (type)
            {
                case WC_FT_Name:
                {
                    ContactDataExchangeModel *dataModel=[[ContactDataExchangeModel alloc] init];
                    
                    for (NSInteger subType2 = WC_FST2_Name_First; subType2 <=WC_FST2_Name_Suffix; subType2++)
                    {
#if defined (PRODUCTLINE_WCSF)
                        // 只處理姓，名
                        if (subType2!=WC_FST2_Name_First&&subType2!=WC_FST2_Name_Last)
                        {
                            continue;
                        }
#elif defined (PRODUCTLINE_WCO365)
                        // office 不支援prefix
                        if (subType2==WC_FST2_Name_Prefix)
                        {
                            continue;
                        }
#endif
                        //////////////////////////////////////////////////
                        if ([fieldModel hasFieldWithSubType2:(WC_FieldSubType2)subType2])
                        {
                            WCFieldModel *subFieldModel = [fieldModel fieldWithSubType2:(WC_FieldSubType2)subType2];
                            NSNumber *dictKey = @([WCFieldTypeConverter contactSubTypeFromFieldSubType2:(WC_FieldSubType2)subType2]);
                            
                            NSString *valueString = subFieldModel.value;
                            
                            [dataModel.propertyDictionary setObject:valueString forKey:dictKey];
                            
                            NSString *rectString=NSStringFromCGRect(subFieldModel.recogRect);
                            [dataModel.imageRectDictionary setObject:rectString forKey:dictKey];
                            
                            dataModel.contactFieldSource = [WCFieldTypeConverter contactFieldSourceFromFieldSource:fieldModel.source];
                        }
                    }
                    
                    dataModel.labelText = [WCFieldTypeConverter subTypeStringWithFieldType:type associateType:fieldModel.subType1];
                    dataModel.labelType = [WCFieldTypeConverter contactLabelTypeFromFieldSubType1:fieldModel.subType1];

                    [mainTypeDataArray addObject:dataModel];
                    [dataModel release];
                    
                    break;
                }
                case WC_FT_Company:
                {
                 
#if defined (PRODUCTLINE_WCSF)
                    NSMutableArray *tempCompanyDataArray = [self wcsfCompanyDataArrayWithFieldModel:fieldModel];
                    
                    if([tempCompanyDataArray count]>0)
                    {
                        [mainTypeDataArray addObjectsFromArray:tempCompanyDataArray];
                    }
#else
                    ContactDataExchangeModel *dataModel=[[ContactDataExchangeModel alloc] init];
                    for (NSInteger subType2 = WC_FST2_Company_Name; subType2 <=WC_FST2_Company_JobTitle; subType2++)
                    {
                        if ([fieldModel hasFieldWithSubType2:(WC_FieldSubType2)subType2])
                        {
                            WCFieldModel *subFieldModel = [fieldModel fieldWithSubType2:(WC_FieldSubType2)subType2];
                            NSNumber *dictKey = @([WCFieldTypeConverter contactSubTypeFromFieldSubType2:(WC_FieldSubType2)subType2]);
                            NSString *valueString = subFieldModel.value;
                            
                            [dataModel.propertyDictionary setObject:valueString forKey:dictKey];
                            NSString *rectString=NSStringFromCGRect(subFieldModel.recogRect);
                            [dataModel.imageRectDictionary setObject:rectString forKey:dictKey];
                            
                            dataModel.contactFieldSource = [WCFieldTypeConverter contactFieldSourceFromFieldSource:fieldModel.source];
                        }
                    }
                    
                    dataModel.labelText = [WCFieldTypeConverter subTypeStringWithFieldType:type associateType:fieldModel.subType1];
                    dataModel.labelType = [WCFieldTypeConverter contactLabelTypeFromFieldSubType1:fieldModel.subType1];
                    
                    [mainTypeDataArray addObject:dataModel];
                    [dataModel release];
#endif
                    break;
                }
                case WC_FT_Address:
                {
                    BOOL isCountryCodeSet = NO;
                    
                    ContactDataExchangeModel *dataModel=[[ContactDataExchangeModel alloc] init];
                    
                    for (NSInteger subType2 = WC_FST2_Address_Street; subType2 <=WC_FST2_Address_Location; subType2++)
                    {
                        // !!編輯後的location要清除
                        if (subType2!=WC_FST2_Address_Location && [fieldModel hasFieldWithSubType2:(WC_FieldSubType2)subType2])
                        {
                            WCFieldModel *subFieldModel = [fieldModel fieldWithSubType2:(WC_FieldSubType2)subType2];
                            NSNumber *dictKey = @([WCFieldTypeConverter contactSubTypeFromFieldSubType2:(WC_FieldSubType2)subType2]);
                            // !! WC_FST2_Address_Format要特殊處理
                            if (subType2==WC_FST2_Address_Format)
                            {
                                NSString *format = subFieldModel.value;
                                NSNumber *formatNumber = @([format integerValue]);
                                [dataModel.propertyDictionary setObject:formatNumber forKey:dictKey];
                            }
                            else
                            {
                                NSString *valueString = subFieldModel.value;
                                
                                [dataModel.propertyDictionary setObject:valueString forKey:dictKey];
                                
                                if (subType2==WC_FST2_Address_CountryCode)
                                {
                                    isCountryCodeSet = YES;
                                }
                            }
                            NSString *rectString=NSStringFromCGRect(subFieldModel.recogRect);
                            [dataModel.imageRectDictionary setObject:rectString forKey:dictKey];
                            
                            dataModel.contactFieldSource = [WCFieldTypeConverter contactFieldSourceFromFieldSource:fieldModel.source];
                        }
                    }
                    
                    //////////////////////////////////////////////////
                    // 一定要有country code, 沒有的話要補上default country code
                    if (isCountryCodeSet==NO)
                    {
                        NSNumber *dictKey = @([WCFieldTypeConverter contactSubTypeFromFieldSubType2:(WC_FieldSubType2)WC_FST2_Address_CountryCode]);
                        
                        NSString *valueString = [PPCountryCodeConvert defaultCountryCode];
                        [dataModel.propertyDictionary setObject:valueString forKey:dictKey];
                        
                        dataModel.contactFieldSource = [WCFieldTypeConverter contactFieldSourceFromFieldSource:fieldModel.source];
                    }
                    
                    //////////////////////////////////////////////////
                    // 加入辨識語系，國家選取畫面才會正常
                    
                    NSNumber *recognitionLanguage;
                    
                    if(dataModel.contactFieldSource==PPContactFieldSource_BackSide)
                    {
                        recognitionLanguage = @(cardModel.backRecogLang);
                    }
                    else
                    {
                        recognitionLanguage = @(cardModel.frontRecogLang);
                    }
                    
                    [dataModel.propertyDictionary setObject:recognitionLanguage forKey:@(PPContactSubType_Address_RecognitionLanguageCode)];
                    
                    dataModel.labelText = [WCFieldTypeConverter subTypeStringWithFieldType:type associateType:fieldModel.subType1];
                    dataModel.labelType = [WCFieldTypeConverter contactLabelTypeFromFieldSubType1:fieldModel.subType1];
                    
                    [mainTypeDataArray addObject:dataModel];
                    [dataModel release];
                    
                    break;
                }
                case WC_FT_Date:
                {
                    ContactDataExchangeModel *dataModel=[[ContactDataExchangeModel alloc] init];
                    NSString *rectString=NSStringFromCGRect(fieldModel.recogRect);
                    
                    NSString *dateString = [(NSDate*)fieldModel.value stringWithFormat:NSDateFormat_Day timeZone:[NSTimeZone timeZoneForSecondsFromGMT:0]];
                    
                    NSNumber *dictKey = @([WCFieldTypeConverter contactSubTypeFromFieldSubType2:(WC_FieldSubType2)fieldModel.subType2]);
                    
                    dataModel.labelText = [WCFieldTypeConverter subTypeStringWithFieldType:type associateType:fieldModel.subType1];
                    dataModel.labelType = [WCFieldTypeConverter contactLabelTypeFromFieldSubType1:fieldModel.subType1];
                    dataModel.contactFieldSource = [WCFieldTypeConverter contactFieldSourceFromFieldSource:fieldModel.source];
                    
                    [dataModel.imageRectDictionary setObject:rectString forKey:dictKey];
                    [dataModel.propertyDictionary setObject:dateString forKey:dictKey];
                    
                    if(fieldModel.subType1==WC_FST1_Date_Birthday)
                    {
                        [birthDayTypeDataArray addObject:dataModel];
                    }
                    else
                    {
                        [mainTypeDataArray addObject:dataModel];
                    }
                    
                    [dataModel release];
                    
                    break;
                }
                case WC_FT_SalesforceData:
                {
                    // !! 在|prepareSFStatusFieldWithCardModel:|中處理
                    break;
                }
                case WC_FT_Phone:
                case WC_FT_Email:
                case WC_FT_URL:
                case WC_FT_InstantMessage:
                case WC_FT_SocialNetwork:
                case WC_FT_Note:
                {
//                    for (NSInteger index = 0; index<2; index++)
                    {
                        ContactDataExchangeModel *dataModel = [[ContactDataExchangeModel alloc] init];
                        NSString *rectString = NSStringFromCGRect(fieldModel.recogRect);
                        //                    NSNumber *dictKey = mainTypeNumber;
                        NSNumber *dictKey = @([WCFieldTypeConverter contactSubTypeFromFieldSubType2:(WC_FieldSubType2)fieldModel.subType2]);
                        
                        [dataModel.imageRectDictionary setObject:rectString forKey:dictKey];
                        [dataModel.propertyDictionary setObject:fieldModel.value forKey:dictKey];
                        dataModel.labelText = [WCFieldTypeConverter subTypeStringWithFieldType:type associateType:fieldModel.subType1];
                        dataModel.labelType = [WCFieldTypeConverter contactLabelTypeFromFieldSubType1:fieldModel.subType1];
                        dataModel.contactFieldSource = [WCFieldTypeConverter contactFieldSourceFromFieldSource:fieldModel.source];
                        
                        [mainTypeDataArray addObject:dataModel];
                        [dataModel release];
                    }
                    break;
                }
                case WC_FT_Nickname:
                case WC_FT_UnifiedBusinessNo:
                default:
                    break;
            } // end of switch
        } // end of for in fieldarray
        
        //////////////////////////////////////////////////
        // 加入fieldDictioanry
        switch (type)
        {
            case WC_FT_Name:
            case WC_FT_Company:
            case WC_FT_Address:
            case WC_FT_Phone:
            case WC_FT_Email:
            case WC_FT_URL:
            case WC_FT_InstantMessage:
            case WC_FT_SocialNetwork:
            case WC_FT_Note:
            {
                if([mainTypeDataArray count]>0)
                {
                    [fieldDictionary setObject:mainTypeDataArray forKey:mainTypeNumber];
                }
                break;
            }
            case WC_FT_Date:
            {
                if([mainTypeDataArray count]>0)
                {
                    [fieldDictionary setObject:mainTypeDataArray forKey:@(PPContactMainType_Date)];
                }
                if([birthDayTypeDataArray count]>0)
                {
                    [fieldDictionary setObject:birthDayTypeDataArray forKey:@(PPContactMainType_BirthDay)];
                }
                
                break;
            }
            case WC_FT_Nickname:
            case WC_FT_UnifiedBusinessNo:
            default:
                break;
        } // end of switch type
        
        
        [mainTypeDataArray release];
        [birthDayTypeDataArray release];
        
    } // end of for in contactMainTypeArray
    
    //////////////////////////////////////////////////
    // 加入自訂欄位
    NSArray *customFieldArray = nil;
    
    if (isForWCTMode)
    {
        if (isShowCustomField)
        {
            customFieldArray = [self prepareWCTCustomFieldWithCardModel:cardModel];
        }
    }
    else if (isForWCMMode)
    {
        if (isShowCustomField)
        {
            customFieldArray = [self prepareWCMCustomFieldWithCardModel:cardModel];
        }
    }
    
    if([customFieldArray count]>0)
    {
        [fieldDictionary setObject:customFieldArray forKey:@(PPContactMainType_UserDefine)];
    }
    
    //////////////////////////////////////////////////
    // !! 加入salesforce的status, rating, industry, leadsource
#if defined (PRODUCTLINE_WCSF)
    if (cardModel)
    {
        NSArray *statusArray =[self prepareSFStatusFieldWithCardModel:cardModel];
        [fieldDictionary setObject:statusArray forKey:@(PPContactMainType_Status)];
    }
#endif
    //////////////////////////////////////////////////
    // !!不是WCSF 才要加group, system group
    // !! 幫同事掃描沒有儲存到系統聯絡人
    if (isForWCSFMode==NO&&isForWCO365Mode==NO)
    {
        if(isShowGroup)
        {
            NSArray *groupArray = [self prepareGroupArrayWithCardModel:cardModel];
            [fieldDictionary setObject:groupArray forKey:@(PPContactMainType_Group)];
            
            NSArray *systemGroupArray = [self prepareSystemGroupArrayWithCardModel:cardModel];
            [fieldDictionary setObject:systemGroupArray forKey:@(PPContactMainType_SystemGroup)];
        }
    }
    
    
    if(isForWCTMode)
    {
        if(isShowSharedAccount)
        {
            NSArray *sharedAccountArray = [self prepareSharedAccountWithCardModel:cardModel];
            if([sharedAccountArray count]>0)
            {
                [fieldDictionary setObject:sharedAccountArray forKey:@(PPContactMaintype_VisibleAccount)];
            }
        }
    }
    //////////////////////////////////////////////////
#if defined (PRODUCTLINE_WCSF)
    // 編輯才要補欄位
    if (forEdit==YES)
    {
        [self fillUpFieldsWithSourceFieldDictionary:fieldDictionary
                             defaultFieldDictionary:[self defaultFieldDictioanryForEdit:forEdit saveAs:self.saveAs]];
    }
#elif defined (PRODUCTLINE_WCO365)
    // 編輯才要補欄位
    if (forEdit==YES)
    {
        [self fillUpFieldsWithSourceFieldDictionary:fieldDictionary
                             defaultFieldDictionary:[self defaultFieldDictioanryForEdit:forEdit]];
    }
#endif
    //    [cardModel release];
    
    
    return fieldDictionary;
}


//==============================================================================
//
//==============================================================================
- (UIImage *)prepareCardImageWithCardID:(NSString *)cardID imageType:(WC_ImageType)imageType
{
    if (!cardID)
    {
        return nil;
    }
    
    
    if ([self.delegate respondsToSelector:@selector(contactAccessFlowController:cardImageWithCardID:imageType:)])
    {
        return [self.delegate contactAccessFlowController:self cardImageWithCardID:cardID imageType:imageType];
    }
    
    return nil;
}






////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - update cardmodel with new field data


//===============================================================================
//
//===============================================================================
-(void)updateCardModel:(WCCardModel *)cardModel withFieldDictionary:(NSDictionary *)fieldDictionary
{
    if (cardModel==nil)
    {
        return ;
    }
    
#if defined (PRODUCTLINE_WCSF)
    BOOL hasSalutation = NO;
#endif
    //////////////////////////////////////////////////
    for (NSNumber *mainTypeKey in [self prepareMainTypeArrayForEdit:YES])
    {
        PPContactMainType type = (PPContactMainType)[mainTypeKey unsignedIntegerValue];
        WC_FieldType fieldMainType = [WCFieldTypeConverter fieldTypeFromPPContactMainType:type];
        
        
        //////////////////////////////////////////////////
        switch (type)
        {
            case PPContactMainType_Name:
            case PPContactMainType_Company:
            case PPContactMainType_Address:
            case PPContactMainType_Phone:
            case PPContactMainType_Email:
            case PPContactMainType_URL:
            case PPContactMainType_InstantMessage:
            case PPContactMainType_SocialNetwork:
            case PPContactMainType_Note:
            {
#if defined (PRODUCTLINE_WCSF)
                // !! salesforce 的公司要特殊處理
                if (type==PPContactMainType_Company)
                {
                    [self wcsfCustomFieldHandlerWithCardModel:cardModel
                                          fromFieldDictionary:fieldDictionary
                                                     mainType:type
                                                hasSalutation:&hasSalutation];
                }
                else
#endif
                {
                    NSArray *mainTypeDataArray = [fieldDictionary objectForKey:mainTypeKey];
                    NSArray *fieldModelArray = [cardModel fieldArrayWithType:fieldMainType];
                    
                    NSInteger mainTypeArrayCount = [mainTypeDataArray count];
                    NSInteger fieldArrayCount = [fieldModelArray count];
                    
                    // 刪除舊的資料欄位
                    for(NSInteger i=fieldArrayCount-1;i>=0;i--)
                    {
                        [cardModel removeFieldWithType:fieldMainType index:i];
                    }
                    
                    // 將mainTypeDataArray中的資料寫到cardModel中
                    for(int i=0;i<mainTypeArrayCount;i++)
                    {
                        ContactDataExchangeModel *dataModel = [mainTypeDataArray objectAtIndex:i];
                        
                        // 新增資料欄位
                        WC_FieldModel *fieldModel = [WC_FieldModel newFieldModel];
                        
                        [WCContactAccessFlowController complexFieldModelWithFieldModel:fieldModel dataExchangeModel:dataModel contactMainType:type];
                        
                        if (fieldModel.type==WC_FT_Address)
                        {
                            // !!如果地址沒有國家要補上去
                            if([fieldModel hasFieldWithSubType2:WC_FST2_Address_Country]==NO &&
                               [fieldModel hasFieldWithSubType2:WC_FST2_Address_CountryCode]==YES)
                            {
                                NSString *country = nil;
                                
                                NSInteger languageCode = [cardModel recognitionlanguageWithFieldSource:fieldModel.source];
                                
                                NSString *countryCode = [fieldModel fieldWithSubType2:WC_FST2_Address_CountryCode].value;
                                
                                if(countryCode==nil && countryCode.length>0)
                                {
                                    countryCode = [PPCountryCodeConvert defaultCountryCode];
                                }
                                
                                if(languageCode==-1)
                                {
                                    country = [PPCountryCodeConvert localizeStringFromCountryCode:countryCode
                                                                                 withLanguageCode:[PPCountryCodeConvert languageCodeWithRecogLang:[PPCountryCodeConvert defaultRecogLangWithCountryCode:countryCode]]];
                                }
                                else
                                {
                                    country = [PPCountryCodeConvert localizeStringFromCountryCode:countryCode
                                                                                 withLanguageCode:[PPCountryCodeConvert languageCodeWithRecogLang:languageCode]];
                                }
                                
                                [fieldModel setSubType2FieldWithValue:country recogRect:CGRectZero subType2:WC_FST2_Address_Country];
                            }
                        }
                        [cardModel addField:fieldModel];
                        [fieldModel release];
                    }
                }
                break;
            }
#if defined (PRODUCTLINE_WCSF)
            case PPContactMainType_Salutation:
            case PPContactMainType_SalesforceSaveAs:
            case PPContactMainType_Status:
            {
                [self wcsfCustomFieldHandlerWithCardModel:cardModel
                                      fromFieldDictionary:fieldDictionary
                                                 mainType:type
                                            hasSalutation:&hasSalutation];
                break;
            }
#endif
            case PPContactMainType_UserDefine:
            {
#if defined (PRODUCTLINE_WCT)
                NSArray *mainTypeDataArray=[fieldDictionary objectForKey:mainTypeKey];
                NSArray *fieldModelArray=[cardModel fieldArrayWithType:fieldMainType];
                
                NSInteger mainTypeArrayCount=[mainTypeDataArray count];
                NSInteger fieldArrayCount=[fieldModelArray count];
                
                // 刪除舊的資料欄位
                for(NSInteger i=fieldArrayCount-1;i>=0;i--)
                {
                    [cardModel removeFieldWithType:fieldMainType index:i];
                }
                
                // 將mainTypeDataArray中的資料寫到cardModel中
                // 自訂欄位，不管有沒有值都會回傳，所以要另外判斷有沒有值
                for(int i=0;i<mainTypeArrayCount;i++)
                {
                    ContactDataExchangeModel *dataModel = [mainTypeDataArray objectAtIndex:i];
                    
                    NSString *textValue = [[dataModel propertyDictionary] objectForKey:@(PPContactSubType_UserDefine_Text)];
                    NSString *intValue = [[dataModel propertyDictionary] objectForKey:@(PPContactSubType_UserDefine_Integer)];
                    NSString *floatValue = [[dataModel propertyDictionary] objectForKey:@(PPContactSubType_UserDefine_Float)];
                    NSString *emailValue = [[dataModel propertyDictionary] objectForKey:@(PPContactSubType_UserDefine_Email)];
                    NSString *picklistValue = [[dataModel propertyDictionary] objectForKey:@(PPContactSubType_UserDefine_ListValue)];
                    NSString *dateValue = [[dataModel propertyDictionary] objectForKey:@(PPContactSubType_UserDefine_Date)];
                    NSString *dateTimeValue = [[dataModel propertyDictionary] objectForKey:@(PPContactSubType_UserDefine_DateAndTime)];
                    NSString *urlValue = [[dataModel propertyDictionary] objectForKey:@(PPContactSubType_UserDefine_URL)];

                    if([textValue length]!=0 ||
                       [intValue length]!=0 ||
                       [floatValue length]!=0 ||
                       [emailValue length]!=0 ||
                       [urlValue length]!=0 ||
                       [picklistValue length]!=0||
                       [dateValue length]!=0||
                       [dateTimeValue length]!=0)
                    {
                        // 新增資料欄位
                        WC_FieldModel *fieldModel = [WC_FieldModel newFieldModel];
                        
                        [WCContactAccessFlowController complexFieldModelWithFieldModel:fieldModel dataExchangeModel:dataModel contactMainType:type];
                        [cardModel addField:fieldModel];
                        [fieldModel release];
                    }
                }
#elif defined (PRODUCTLINE_WCM)
                // !! WCM目前沒有編輯，所以這邊先不用處理
#endif
                break;
            }
            case PPContactMainType_Date:
            case PPContactMainType_BirthDay:
            {
                
                //date要和生日一起處理
                
                NSNumber *dateTypeKey=@(PPContactMainType_Date);
                NSNumber *birthdayTypeKey=@(PPContactMainType_BirthDay);
                
                NSArray *mainTypeDataArray=[fieldDictionary objectForKey:dateTypeKey];
                NSArray *birthdayDataArray=[fieldDictionary objectForKey:birthdayTypeKey];
                
                NSArray *fieldModelArray=[cardModel fieldArrayWithType:fieldMainType];
                
                NSMutableArray *allDateArray=[[NSMutableArray alloc] init];
                [allDateArray addObjectsFromArray:mainTypeDataArray];
                [allDateArray addObjectsFromArray:birthdayDataArray];
                
                NSInteger allDateArrayCount=[allDateArray count];
                NSInteger fieldArrayCount=[fieldModelArray count];
                
                if(fieldArrayCount>allDateArrayCount)
                {
                    for(NSInteger i=allDateArrayCount;i<fieldArrayCount;i++)
                    {
                        [cardModel removeFieldWithType:fieldMainType index:allDateArrayCount];
                    }
                }
                
                for(NSInteger i=0;i<[allDateArray count];i++)
                {
                    ContactDataExchangeModel *dataModel = [allDateArray objectAtIndex:i];
                    
                    if(i<[fieldModelArray count])
                    {
                        WCFieldModel *fieldModel = [fieldModelArray objectAtIndex:i];
                        [WCContactAccessFlowController dateFieldModelWithFieldModel:fieldModel dataExchangeModel:dataModel contactMainType:type];
                    }
                    else
                    {
                        // 新增資料欄位
                        WC_FieldModel *fieldModel = [WC_FieldModel newFieldModel];
                        
                        [WCContactAccessFlowController dateFieldModelWithFieldModel:fieldModel dataExchangeModel:dataModel contactMainType:type];
                        [cardModel addField:fieldModel];
                        [fieldModel release];
                    }
                }
                [allDateArray release];
                break;
            }
            case PPContactMainType_Other:
            {
#if defined (PRODUCTLINE_WCO365)
                [self wco365CustomFieldHandlerWithCardModel:cardModel
                                        fromFieldDictionary:fieldDictionary
                                                   mainType:type];
#else
                NSArray *mainTypeDataArray = [fieldDictionary objectForKey:mainTypeKey];
                NSInteger mainTypeArrayCount = [mainTypeDataArray count];
                
                // 只處理統編與暱稱
                // 刪除舊的資料欄位
                NSArray *nicknameArray = [cardModel fieldArrayWithType:WC_FT_Nickname];
                for(NSInteger i=[nicknameArray count]-1;i>=0;i--)
                {
                    [cardModel removeFieldWithType:WC_FT_Nickname index:i];
                }
                
                NSArray *businessNoArray = [cardModel fieldArrayWithType:WC_FT_UnifiedBusinessNo];
                for(NSInteger i=[businessNoArray count]-1;i>=0;i--)
                {
                    [cardModel removeFieldWithType:WC_FT_UnifiedBusinessNo index:i];
                }
                
                //////////////////////////////////////////////////
                for(int i=0;i<mainTypeArrayCount;i++)
                {
                    
                    ContactDataExchangeModel *dataModel = [mainTypeDataArray objectAtIndex:i];
                    // 建立時間不用儲存
                    if ([dataModel.labelText isEqualToString:PPContactLabelText_Other_ConstructTime])
                    {
                        continue;
                    }
                    //////////////////////////////////////////////////
                    
                    // 新增資料欄位
                    WC_FieldModel *fieldModel = [WC_FieldModel newFieldModel];
                    
                    if ([dataModel.labelText isEqualToString:PPContactLabelText_Other_UnifiedBuinessNumber])
                    {
                        fieldModel.type = WC_FT_UnifiedBusinessNo;
                    }
                    else if ([dataModel.labelText isEqualToString:PPContactLabelText_Other_NickName])
                    {
                        fieldModel.type = WC_FT_Nickname;
                    }
                    
                    if (fieldModel.type!=WC_FT_None)
                    {
                        fieldModel.value = [dataModel.propertyDictionary objectForKey:@(PPContactSubType_None)];
                        [cardModel addField:fieldModel];
                    }
                    [fieldModel release];
                }
#endif
                break;
            }
                //////////////////////////////////////////////////
                // 以下欄位沒有用到
            case PPContactMainType_PublicNote:
            case PPContactMainType_Group:
            default:
                break;
        }
        // 因為加入調整順序，所以這邊不用重換
        //        [cardModel sortPhoneFields];
    }
    
    //////////////////////////////////////////////////
    // !! PPContactMainType_Salutation, 如果不是disable, 且前面沒處理，表示是空值，要補一個上來
#if defined (PRODUCTLINE_WCSF)
    if(hasSalutation==NO)
    {
        [self fillSalutaionWithCardModel:cardModel];
    }
#endif
}






////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - field to string



//===============================================================================
//
//===============================================================================
-(NSString *)stringGoogleDisplayAddressWithDataModel:(ContactDataExchangeModel *)dataModel
{
    NSString *street	= [dataModel.propertyDictionary objectForKey:@(PPContactSubType_Address_Street)];
    NSString *state		= [dataModel.propertyDictionary objectForKey:@(PPContactSubType_Address_State)];
    NSString *city		= [dataModel.propertyDictionary objectForKey:@(PPContactSubType_Address_City)];
    NSString *zip		= [dataModel.propertyDictionary objectForKey:@(PPContactSubType_Address_Zip)];
    NSString *countryCode	= [dataModel.propertyDictionary objectForKey:@(PPContactSubType_Address_CountryCode)];
    
    return [PPWorldcardAddressController googleMapAddressFromStreet:street city:city province:state postalCode:zip countryCode:countryCode];
    
}






////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - (Private) clip recognize


//==============================================================================
//
//==============================================================================
- (PPContactMainType)contactMainTypeFromTypeCode:(NSInteger)typeCode
{
    switch (typeCode)
    {
        case ID_BCR_NAME:
        case ID_BCR_ENG_NAME:
        {
            return PPContactMainType_Name;
        }
        case ID_BCR_COMPANY:
        case ID_BCR_ENG_COMPANY:
        case ID_BCR_DEPARTMENT:
        case ID_BCR_ENG_DEPARTMENT:
        case ID_BCR_POSITION:
        case ID_BCR_ENG_POSITION:
        {
            return PPContactMainType_Company;
        }
            
        case ID_BCR_PHONE:
        case ID_BCR_MOBILE:
        case ID_BCR_FAX:
        {
            return PPContactMainType_Phone;
        }
        case ID_BCR_EMAIL:
        {
            return PPContactMainType_Email;
        }
        case ID_BCR_HOMEPAGE:
        {
            return PPContactMainType_URL;
        }
        case ID_BCR_IDPHOTO:
        {
            return PPContactMainType_HeadImage;
        }
            
        case ID_BCR_ADDRESS:
        case ID_BCR_ENG_ADDRESS:
        {
            return PPContactMainType_Address;
        }
            
        default:
            return PPContactMainType_None;
    }
    
}


//================================================================================
//
//================================================================================
- (PPContactSubType)contactSubTypeFromTypeCode:(NSInteger)typeCode
{
    PPContactSubType contactSubType = PPContactSubType_None;
    switch (typeCode)
    {
        case ID_BCR_COMPANY:
        case ID_BCR_ENG_COMPANY:
        {
            contactSubType = PPContactSubType_Company_Name;
            break;
        }
        case ID_BCR_DEPARTMENT:
        case ID_BCR_ENG_DEPARTMENT:
        {
            contactSubType = PPContactSubType_Company_Department;
            break;
        }
        case ID_BCR_POSITION:
        case ID_BCR_ENG_POSITION:
        {
            contactSubType = PPContactSubType_Company_JobTitle;
            break;
        }
        case ID_BCR_NAME:
        case ID_BCR_ENG_NAME:
        case ID_BCR_PHONE:
        case ID_BCR_MOBILE:
        case ID_BCR_FAX:
        case ID_BCR_EMAIL:
        case ID_BCR_HOMEPAGE:
        case ID_BCR_IDPHOTO:
        case ID_BCR_ADDRESS:
        case ID_BCR_ENG_ADDRESS:
        default:
        {
            break;
        }
    }
    
    return contactSubType;
}





//==============================================================================
// 將已經滿的欄位去掉
//==============================================================================
- (NSArray *)recogTypeModelsByCheckMaxCountWithRecogTypeModels:(NSArray *)originRecogTypeModels
{
    NSMutableIndexSet *removeSets = [NSMutableIndexSet indexSet];
    NSMutableArray *tempRecogTypeModels = [NSMutableArray arrayWithArray:originRecogTypeModels];
    
    NSUInteger typeIndex = 0;
    for (WCKernelRecogTypeModel *recogTypeModel in tempRecogTypeModels)
    {
        PPContactMainType mainType =[self contactMainTypeFromTypeCode:recogTypeModel.typeCode];
        PPContactSubType subType = [self contactSubTypeFromTypeCode:recogTypeModel.typeCode];
        
        if ([self.contactEditViewController arriveMaximumCoutForContactMainType:mainType contactSubType:subType]==YES)
        {
            [removeSets addIndex:typeIndex];
        }
        
        typeIndex ++;
    }
    
    [tempRecogTypeModels removeObjectsAtIndexes:removeSets];
    
    if ([tempRecogTypeModels count]>0)
    {
        return [NSArray arrayWithArray:tempRecogTypeModels];
    }
    return nil;
}


//==============================================================================
//
//==============================================================================
- (void)showClipRecognizeFromContactViewController:(WCContactEditViewController *)contactEditViewController showBackCardImage:(BOOL)showBackCardImage
{
    // 取得要處理的影像
    UIImage *frontCardImage = nil;
    UIImage *backCardImage = nil;
    
    frontCardImage = [contactEditViewController imageForPPContactMainType:PPContactMainType_FrontCardImage ppContactSubType:PPContactSubType_FrontCardImage_Original];
    backCardImage = [contactEditViewController imageForPPContactMainType:PPContactMainType_BackCardImage ppContactSubType:PPContactSubType_BackCardImage_Original];
    
    // !! 正反都沒有就不做
    if (frontCardImage==nil && backCardImage== nil)
    {
        NSLog(@"都沒有應該跳toast, 不應該進來");
        return;
    }
    
    //////////////////////////////////////////////////
    // 取得支援的辨識語系與欄位
    NSArray *recogLanguages = nil;
    NSArray *recogFields = nil;
    // 預設進入為正面
    if ([self.delegate respondsToSelector:@selector(supportRecognizeLangugaesForContactAccessFlowController:)])
    {
        recogLanguages = [self.delegate supportRecognizeLangugaesForContactAccessFlowController:self];
    }
    
    if ([self.delegate respondsToSelector:@selector(supportRecognizeFieldTypesForContactAccessFlowController:)])
    {
        recogFields = [self.delegate supportRecognizeFieldTypesForContactAccessFlowController:self];
        if ([recogFields count]>0)
        {
            recogFields = [self recogTypeModelsByCheckMaxCountWithRecogTypeModels:recogFields];
        }
    }
    
    // 如果都沒有可辨識欄位，不進入手刮畫面
    if ([recogFields count]==0)
    {
        [WCToastController showMessageToastFromSuperView:contactEditViewController.view withMessage:WCCAFC_ReachMaxFieldCount position:PPToastPositionCenter];
        return ;
    }
    
    //////////////////////////////////////////////////
    //  顯示手刮頁面
    // 預設使用名片辨識語系
    NSInteger frontLanguageID = self.currentEditingCardModel.frontRecogLang;
    NSInteger backLanguageID = self.currentEditingCardModel.backRecogLang;
    
    
    // 如果沒有名片辨識語系，使用上次辨識語系
    if (frontLanguageID==-1)
    {
        if ([self.delegate respondsToSelector:@selector(contactAccessFlowControllerRequestFrontRecogLang:)])
        {
            frontLanguageID = [self.delegate contactAccessFlowControllerRequestFrontRecogLang:self];
        }
    }
    if (backLanguageID==-1)
    {
        if ([self.delegate respondsToSelector:@selector(contactAccessFlowControllerRequestBackRecogLang:)])
        {
            backLanguageID = [self.delegate contactAccessFlowControllerRequestBackRecogLang:self];
        }
    }
    
    if ([self checkExistAndShowToastIfNeededFromViewController:contactEditViewController withCardID:self.currentEditingCardModel.ID]==NO)
    {
        return ;
    }
    
    [WCClipImageViewController showClipRecognizeFromViewController:contactEditViewController
                                                    frontCardImage:frontCardImage
                                                     backCardImage:backCardImage
                                                  frontRecogLangID:frontLanguageID
                                                   backRecogLangID:backLanguageID
                                                    recogLanguages:recogLanguages
                                                       recogFields:recogFields
                                                 showBackCardImage:showBackCardImage
                                                        completion:^(CGRect clipedRect, NSInteger recogFiledID, NSInteger recogLanguageID, BOOL isBackSide)
     {
         if ([self.delegate respondsToSelector:@selector(contactAccessFlowController:clipRecogWithSourceModel:originalCardModel:error:)])
         {
             NSString *recogLanguageKey = nil;
             
             if (isBackSide)
             {
                 recogLanguageKey = WCContactAccessFlowController_SettingsKey_RearCardRecogLanguage;
             }
             else
             {
                 recogLanguageKey = WCContactAccessFlowController_SettingsKey_FrontCardRecogLanguage;
             }
             
             // 儲存最後還取的languageID
             if ([recogLanguageKey length]>0)
             {
                 [PPSettingsController setIntegerValue:recogLanguageID withKey:recogLanguageKey];
             }
             
             // 辨識
             NSError *error = nil;
             WCRecogSourceModel *recogSourceModel = [[WCRecogSourceModel alloc] init];
             if (recogSourceModel)
             {
                 recogSourceModel.cardID = @"";
                 recogSourceModel.imageType = (isBackSide?WC_IT_BackSide:WC_IT_FrontSide);
                 recogSourceModel.imageSource = isBackSide?backCardImage:frontCardImage;
                 recogSourceModel.recogLang = recogLanguageID;
                 recogSourceModel.hasRecogRect = YES;
                 recogSourceModel.dockMode = NO;
                 recogSourceModel.handClipRecogType = recogFiledID;
                 recogSourceModel.handClipRect = clipedRect;
                 // !!手括不支援255，且多是正的方向，所以都用0
                 recogSourceModel.rotateDegree = 0;
                 
                 if ([self.delegate respondsToSelector:@selector(contactAccessFlowControllerRequestOutputTranslate:)])
                 {
                     // -1表示不支援
                     NSInteger outputTranslate =  [self.delegate contactAccessFlowControllerRequestOutputTranslate:self];
                     if (outputTranslate!=-1)
                     {
                         recogSourceModel.outputTranslate = outputTranslate;
                     }
                 }
                 
                 WCCardModel *oneFieldCardModel = [self.delegate contactAccessFlowController:self
                                                                    clipRecogWithSourceModel:recogSourceModel
                                                                           originalCardModel:self.currentEditingCardModel
                                                                                       error:&error];
                 [recogSourceModel release];
                 
                 //////////////////////////////////////////////////
                 // 更新回contactEditViewController
                 if (oneFieldCardModel)
                 {
                     // 取得目前編輯界面的資料，再合併選取的聯絡人資料
                     NSDictionary *fieldDictionary = [self.contactEditViewController.contactEditSectionController fieldDictionaryFromSectionModelForSearching:NO];
                     [self updateCardModel:self.currentEditingCardModel withFieldDictionary:fieldDictionary];
                     
                     // 將新的欄位合併到 |self.currentEditingCardModel|
                     NSArray *allKeys = [[oneFieldCardModel fieldArrayDict] allKeys];
                     
                     for (NSString *fieldType in allKeys)
                     {
                         WCFieldModel *fieldModelNeedToInsert = nil;
                         NSArray *sourceFieldArray = [oneFieldCardModel fieldArrayWithType:[fieldType integerValue]];
                         NSArray *targetFieldArray = [self.currentEditingCardModel fieldArrayWithType:[fieldType integerValue]];
                         
                         // !! 手刮應該只會有一個field
                         for (WCFieldModel *fieldModel in sourceFieldArray)
                         {
                             // 公司欄位要特殊處理
                             if ([fieldType integerValue]==WC_FT_Company)
                             {
                                 NSArray *subFieldType2s = @[@(WC_FST2_Company_Name),
                                                             @(WC_FST2_Company_Phonetic),
                                                             @(WC_FST2_Company_Department),
                                                             @(WC_FST2_Company_JobTitle)];
                                 
                                 
                                 // 取得subFieldModel, 與self.currentEditingCardModel中的比對
                                 // 如果有空欄位，就塞進去補滿
                                 // 如果沒有空欄位，就建一個新的
                                 for (NSNumber *subFieldType2 in subFieldType2s)
                                 {
                                     WC_FieldSubType2 subType2 = [subFieldType2 integerValue];
                                     if ([fieldModel hasFieldWithSubType2:subType2])
                                     {
                                         BOOL inserted = NO;
                                         WCFieldModel *sourceSubFieldModel = [fieldModel fieldWithSubType2:subType2];
                                         
                                         // !! 比對 |subType2| 是否有在目前欄位中
                                         // 如果有，比下一個，如果沒有，就插入
                                         for (WCFieldModel *targetFieldModel in targetFieldArray)
                                         {
                                             if([targetFieldModel hasFieldWithSubType2:subType2]==NO)
                                             {
                                                 [targetFieldModel setSubType2Field:sourceSubFieldModel];
                                                 inserted = YES;
                                                 break;
                                             }
                                         }
                                         
                                         // 都沒有，直接新增
                                         if(inserted==NO)
                                         {
                                             fieldModelNeedToInsert = [fieldModel retain];
                                         }
                                         break;
                                     }
                                 }
                             }
                             else
                             {
                                 fieldModelNeedToInsert = [fieldModel retain];
                             }
                             
                             //////////////////////////////////////////////////
                             if(fieldModelNeedToInsert)
                             {
                                 [self.currentEditingCardModel addField:fieldModelNeedToInsert];
                                 [fieldModelNeedToInsert release];
                             }
                         }
                     }
                     
                     //////////////////////////////////////////////////
                     // 更新編輯介面
                     // helpscan不會進到這個流程，所以不考慮
                     BOOL isEditingMyCard = (contactEditViewController.contactEditViewControllerLayout==WCContactEditViewControllerLayout_MyCard);
                     NSMutableDictionary *dictionary = [self prepareFieldDictionaryWithCardModel:self.currentEditingCardModel
                                                                       forPPContactMainTypeArray:[self prepareMainTypeArrayForEdit:YES]
                                                                                         forEdit:YES
                                                                               isShowCustomField:!isEditingMyCard
                                                                               isShowGroup:!isEditingMyCard
                                                                             isShowSharedAccount:!isEditingMyCard];
                     [self.contactEditViewController clearAndUpdateContactMainTypeDataFromFieldDictioanry:dictionary];
                 }
             }
             
         }
         
     }];
    
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Toast method


//==============================================================================
//
//==============================================================================
- (BOOL)checkExistAndShowToastIfNeededFromViewController:(UIViewController *)viewController withCardID:(NSString *)cardID
{
    BOOL isCardExist = NO;
    if ([self.delegate respondsToSelector:@selector(contactAccessFlowController:isCardIDExist:)])
    {
        isCardExist = [self.delegate contactAccessFlowController:self isCardIDExist:cardID];
        
        if (isCardExist==NO)
        {
            if(viewController)
            {
                [WCToastController showMessageToastFromSuperView:viewController.view
                                                     withMessage:WCCAFC_FailedToLoadDataWithID
                                                        position:PPToastPositionCenter];
            }
        }
    }
    
    return isCardExist;
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - PPBusyView


//==============================================================================
//
//==============================================================================
- (void)setBusy:(NSNumber *)busy
{
    if ([busy boolValue])
    {
        UIWindow *window = [UIApplication sharedApplication].keyWindow;
        self.ppBusyView = [[[PPBusyView alloc] initWithSuperView:window] autorelease];
        self.ppBusyView.style = PPBusyViewStyle_Border;
    }
    else
    {
        [self.ppBusyView removeFromSuperview];
        self.ppBusyView = nil;
    }
}








////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - CONTACT INFO FLOW
#pragma mark (Private)translation methods

/*
 //==============================================================================
 //
 //==============================================================================
 - (NSMutableArray *)sourceLanguagesFromRecogLangModels:(NSArray *)recogLangModels
 {
 NSMutableArray *result = [NSMutableArray array];
 
 [result addObject:MLS_Auto];
 
 for (WCKernelRecogLangModel *recogSourceModel in recogLangModels)
 {
 NSString *languageID = nil;
 switch (recogSourceModel.langCode)
 {
 case B5_LANG: languageID = MLS_ChineseTraditional; break;
 case GB_LANG: languageID = MLS_ChineseSimplified; break;
 case HK_LANG: languageID = MLS_ChineseHongKong; break;
 case EN_LANG: languageID = MLS_English; break;
 case GE_LANG: languageID = MLS_German; break;
 case FR_LANG: languageID = MLS_French; break;
 case IT_LANG: languageID = MLS_Italian; break;
 case ES_LANG: languageID = MLS_Esperanto; break;
 case NO_LANG: languageID = MLS_Norwegian; break;
 case HU_LANG: languageID = MLS_Hungarian; break;
 case PL_LANG: languageID = MLS_Polish; break;
 case SE_LANG: languageID = MLS_Swedish; break;
 case NL_LANG: languageID = MLS_Dutch; break;
 case TR_LANG: languageID = MLS_Turkish; break;
 case RU_LANG: languageID = MLS_Russian; break;
 case JP_LANG: languageID = MLS_Japanese; break;
 case KS_LANG: languageID = MLS_Korean; break;
 case DK_LANG: languageID = MLS_Danish; break;
 case FI_LANG: languageID = MLS_Finnish; break;
 case PT_LANG: languageID = MLS_Portuguese; break;
 case GR_LANG: languageID = MLS_Greek; break;
 //            case BR_LANG: languageID = MLS_Portuguese; break;
 //            case MX_LANG: languageID = MLS_English; break;
 case CZ_LANG: languageID = MLS_Czech; break;
 case SK_LANG: languageID = MLS_Slovak; break;
 
 default:
 break;
 }
 
 if ([languageID length]>0)
 {
 [result addObject:languageID];
 }
 }
 return result;
 }
 
 
 //==============================================================================
 //
 //==============================================================================
 - (NSString *)toLanguageBySystemLanguage
 {
 switch ([PPSystemInfoController language])
 {
 case PPSystemInfoLanguage_ChineseTraditional:
 {
 return MLS_ChineseTraditional;
 }
 case PPSystemInfoLanguage_Korean:
 {
 return MLS_Korean;
 }
 case PPSystemInfoLanguage_Japanese:
 {
 return MLS_Japanese;
 }
 case PPSystemInfoLanguage_Spanish:
 {
 return MLS_Spanish;
 }
 case PPSystemInfoLanguage_German:
 {
 return MLS_German;
 }
 case PPSystemInfoLanguage_Portuguese:
 {
 return MLS_Portuguese;
 }
 case PPSystemInfoLanguage_Italian:
 {
 return MLS_Italian;
 }
 case PPSystemInfoLanguage_ChineseSimplified:
 {
 return MLS_ChineseSimplified;
 }
 case PPSystemInfoLanguage_Dutch:
 {
 return MLS_Dutch;
 }
 case PPSystemInfoLanguage_French:
 {
 return MLS_French;
 }
 case PPSystemInfoLanguage_Danish:
 {
 return MLS_Danish;
 }
 case PPSystemInfoLanguage_Finnish:
 {
 return MLS_Finnish;
 }
 case PPSystemInfoLanguage_Norwegian:
 {
 return MLS_Norwegian;
 }
 case PPSystemInfoLanguage_Swedish:
 {
 return MLS_Swedish;
 }
 case PPSystemInfoLanguage_Russian:
 {
 return MLS_Russian;
 }
 case PPSystemInfoLanguage_Polish:
 {
 return MLS_Polish;
 }
 case PPSystemInfoLanguage_Turkish:
 {
 return MLS_Turkish;
 }
 case PPSystemInfoLanguage_Ukrainian:
 {
 return MLS_Ukrainian;
 }
 case PPSystemInfoLanguage_Arabic:
 {
 return MLS_Arabic;
 }
 case PPSystemInfoLanguage_Croatian:
 {
 return MLS_Croatian;
 }
 case PPSystemInfoLanguage_Czech:
 {
 return MLS_Czech;
 }
 case PPSystemInfoLanguage_Greek:
 {
 return MLS_Greek;
 }
 case PPSystemInfoLanguage_Hebrew:
 {
 return MLS_Hebrew;
 }
 case PPSystemInfoLanguage_Romanian:
 {
 return MLS_Romanian;
 }
 case PPSystemInfoLanguage_Slovak:
 {
 return MLS_Slovak;
 }
 case PPSystemInfoLanguage_Thai:
 {
 return MLS_Thai;
 }
 case PPSystemInfoLanguage_Indonesian:
 {
 return MLS_Indonesian;
 }
 case PPSystemInfoLanguage_Malay:
 {
 return MLS_Malay;
 }
 case PPSystemInfoLanguage_Catalan:
 {
 return MLS_Catalan;
 }
 case PPSystemInfoLanguage_Hungarian:
 {
 return MLS_Hungarian;
 }
 case PPSystemInfoLanguage_Vietnamese:
 {
 return MLS_Vietnamese;
 }
 
 case PPSystemInfoLanguage_English:
 default:
 {
 return MLS_English;
 }
 }
 }
 
 
 //==============================================================================
 //
 //==============================================================================
 - (DictionaryTranslationEngineType)enginTypeBySytemLocale
 {
 DictionaryTranslationEngineType engineType = DictionaryTranslationEngineType_Google;
 
 if ([PPSystemInfoController locale]==PPSystemInfoLanguage_ChineseSimplified)
 {
 engineType = DictionaryTranslationEngineType_Baidu;
 }
 
 return engineType;
 }
 
 
 //==============================================================================
 //
 //==============================================================================
 - (NSString *)stringTranslatedFromOriginal:(NSString*)original
 {
 
 NSError *error = nil;
 NSString *translatedString =
 [PPDictionaryTranslationController translationWithString:original
 fromLanguage:self.translateFromLanguage
 toLanguage:self.translateToLanguage
 error:&error
 engineType:[self enginTypeBySytemLocale]];
 if (error==nil && [translatedString length]>0)
 {
 return  translatedString;
 }
 
 return nil;
 }
 */





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - (Private) recent contact action


//==============================================================================
//
//==============================================================================
- (void)reportRecentAction:(NSInteger)action content:(NSString *)content cardID:(NSString *)cardID
{
    if ([self.delegate respondsToSelector:@selector(contactAccessFlowController:recentContactAction:content:cardID:)])
    {
        [self.delegate contactAccessFlowController:self recentContactAction:action content:content cardID:cardID];
    }
}






////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - (Private) Contact info action


//==============================================================================
//
//==============================================================================
- (void)onClickContactInfoNoteFromViewController:(UIViewController *)viewController cardID:(NSString *)cardID editable:(BOOL)editable
{
    // 如果目前聯絡人已經不存在，跳toast並且不做處理
    if ([self checkExistAndShowToastIfNeededFromViewController:viewController withCardID:cardID]==NO)
    {
        return;
    }
    
    NSString *noteString = nil;
    if ([self.delegate respondsToSelector:@selector(contactAccessFlowController:noteWithCardID:)])
    {
         noteString = [self.delegate contactAccessFlowController:self noteWithCardID:cardID];
    }
    
    // !! 不能編輯時，如果note是空的，要顯示toast
    if (editable==NO)
    {
        if ([noteString length]==0)
        {
            [WCToastController showMessageToastFromSuperView:viewController.view
                                                 withMessage:WCCAFC_NoteIsEmpty
                                                    position:PPToastPositionCenter];
            return;
        }
    }
    
    // note資料存取
    self.cardIDForNote = cardID;
    
    NoteViewController *noteViewController = [[NoteViewController alloc] init];
    if (noteViewController)
    {
#if defined(PRODUCTLINE_WCT)
        noteViewController.maxLength = WCT_FML_Note;
#endif        
        noteViewController.noteViewControllerDelegate = self;

        noteViewController.titleText = WCCAFC_Note;
        noteViewController.noteEditting = editable;
        noteViewController.noteTextString = noteString;
        
        PPNavigationController *navigationController = [[PPNavigationController alloc] initWithRootViewController:noteViewController];
        [viewController presentViewController:navigationController animated:YES completion:nil];
        [navigationController release];
        
        [noteViewController release];
    }
}


//==============================================================================
//
//==============================================================================
- (void)onClickContactInfoEditFromViewController:(UIViewController *)viewController cardID:(NSString *)cardID
{
    // 如果目前聯絡人已經不存在，跳toast並且不做處理
    if ([self checkExistAndShowToastIfNeededFromViewController:viewController withCardID:cardID]==NO)
    {
        return;
    }
    
    [self showContactEditFromViewController:viewController
                                     cardID:cardID
                                   delegate:self.delegate
             contacEditViewControllerLayout:WCContactEditViewControllerLayout_Edit
                                     manual:NO];
}


//==============================================================================
//
//==============================================================================
- (void)onClickShareContactFromViewController:(UIViewController *)viewController cardID:(NSString *)cardID
{
    if (cardID==nil)
    {
        return ;
    }
    
    // 如果目前聯絡人已經不存在，跳toast並且不做處理
    if ([self checkExistAndShowToastIfNeededFromViewController:viewController withCardID:cardID]==NO)
    {
        return;
    }
    
    // 分享
    self.shareFlowController = [[[WCShareFlowController alloc] init] autorelease];
    
    if (self.shareFlowController)
    {
        [self.shareFlowController setDelegate:self];
        [self.shareFlowController setContactIdentifierArray:@[cardID]];
        
        NSArray *fileTypeOrderSources = nil;
        // 設定分享的樣式
        
        BOOL isForWCTMode = NO;
        
#if defined(PRODUCTLINE_WCT)
        isForWCTMode = YES;
#endif
        
        //////////////////////////////////////////////////
        
        if(isForWCTMode)
        {
            fileTypeOrderSources = @[@(WCFileTypeSelectView_ContactFileType_XLSX),
                                     @(WCFileTypeSelectView_ContactFileType_CSV_Gmail),
                                     @(WCFileTypeSelectView_ContactFileType_CSV_Outlook),
                                     @(WCFileTypeSelectView_ContactFileType_VCF),
                                     @(WCFileTypeSelectView_ContactFileType_Image),
                                     @(WCFileTypeSelectView_ContactFileType_Text)];
        }
        else
        {
            fileTypeOrderSources = @[@(WCFileTypeSelectView_ContactFileType_WCXF),
                                     @(WCFileTypeSelectView_ContactFileType_XLSX),
                                     @(WCFileTypeSelectView_ContactFileType_CSV_Gmail),
                                     @(WCFileTypeSelectView_ContactFileType_CSV_Outlook),
                                     @(WCFileTypeSelectView_ContactFileType_VCF),
                                     @(WCFileTypeSelectView_ContactFileType_Image),
                                     @(WCFileTypeSelectView_ContactFileType_Text)];
            
        }
        
        
        [self.shareFlowController showFromSuperViewController:viewController fileTypeOrderSource:fileTypeOrderSources];
    }
}


//==============================================================================
//
//==============================================================================
- (void)onClickSaveToSystemContactFromViewController:(UIViewController *)viewController cardID:(NSString *)cardID
{
    BOOL exportAbility = YES;
    
    if ([self.delegate respondsToSelector:@selector(accountExportAbilityWithContactAccessFlowController:)])
    {
        exportAbility = [self.delegate accountExportAbilityWithContactAccessFlowController:self];
    }
    
    if (exportAbility==NO)
    {
        [WCToastController showMessageToastFromSuperView:viewController.view
                                             withMessage:WCCAFC_NoExportAbility
                                                position:PPToastPositionCenter];
        return ;
    }
    
    if (cardID==nil)
    {
        return ;
    }
    
    // 如果目前聯絡人已經不存在，跳toast並且不做處理
    if ([self checkExistAndShowToastIfNeededFromViewController:viewController withCardID:cardID]==NO)
    {
        return;
    }
    
#if defined (PRODUCTLINE_WCSF)
    if ([PPNetworkReachabilityController checkForInternetConnection]==NO)
    {
        [WCToastController showMessageToastFromSuperView:viewController.view withMessage:WCCAFC_PleaseConnectNetwork position:PPToastPositionCenter];
        return ;
    }
#endif
    
    // 存到系統聯絡人
    self.exportFlowController = [[[WCExportFlowController alloc] init] autorelease];
    
    if (self.exportFlowController)
    {
        [self.exportFlowController setDelegate:self];
        
        //////////////////////////////////////////////////
        
        // 設定匯出的樣式
        
        BOOL isForWCTMode = NO;
        
#if defined(PRODUCTLINE_WCT)
        isForWCTMode = YES;
#endif
        //////////////////////////////////////////////////
        
        if(isForWCTMode)
        {
            [self.exportFlowController setFileTypeOrderSource:@[@(WCFileTypeSelectView_ContactFileType_XLSX),
                                                                @(WCFileTypeSelectView_ContactFileType_CSV_iWorks),
                                                                @(WCFileTypeSelectView_ContactFileType_CSV_Gmail),
                                                                @(WCFileTypeSelectView_ContactFileType_CSV_Outlook),
                                                                @(WCFileTypeSelectView_ContactFileType_VCF)]];
        }
        else
        {
            [self.exportFlowController setFileTypeOrderSource:@[@(WCFileTypeSelectView_ContactFileType_WCXF),
                                                                @(WCFileTypeSelectView_ContactFileType_XLSX),
                                                                @(WCFileTypeSelectView_ContactFileType_CSV_iWorks),
                                                                @(WCFileTypeSelectView_ContactFileType_CSV_Gmail),
                                                                @(WCFileTypeSelectView_ContactFileType_CSV_Outlook),
                                                                @(WCFileTypeSelectView_ContactFileType_VCF)]];
            
        }
        
        self.exportFlowController.syncAccountName = self.googleSyncAccount;
        [self.exportFlowController setContactIdentifierArray:@[cardID]];
        [self.exportFlowController exportAddressBookCardsFromSuperViewController:viewController];
    }
}


//==============================================================================
//
//==============================================================================
- (void)onClickTranslateContact:(WCContactInfoScrollViewController *)contactInfoScrollViewController cardID:(NSString *)cardID
{
    if ([PPNetworkReachabilityController checkForInternetConnection]==NO)
    {
        [PPAlertView showWithStyle:UIAlertViewStyleDefault
                             title:@""
                           message:[@"MLS_NetworkConnectFailed" localized]
                 cancelButtonTitle:WCCAFC_Ok
                 otherButtonTitles:nil];
        return;
    }
    
    if ([cardID length]==0)
    {
        return ;
    }
    
    [self showTranslatedContactInfoFromViewController:contactInfoScrollViewController contactIDArray:@[cardID]];
}


//==============================================================================
//
//==============================================================================
- (void)onClickRecognize:(WCContactInfoScrollViewController *)contactInfoScrollViewController cardID:(NSString *)cardID
{
    // 再辨識
    UIImage *frontCardImage = [contactInfoScrollViewController contactFrontCardImageInCurrentPage];
    UIImage *backCardImage = [contactInfoScrollViewController contactBackCardImageInCurrentPage];
    
    if (frontCardImage==nil &&backCardImage==nil)
    {
        [WCToastController showMessageToastFromSuperView:contactInfoScrollViewController.view withMessage:WCCAFC_NoImageToRecognize position:PPToastPositionCenter];
        return;
    }
    
    // 如果目前聯絡人已經不存在，跳toast並且不做處理
    if ([self checkExistAndShowToastIfNeededFromViewController:contactInfoScrollViewController withCardID:cardID]==NO)
    {
        return;
    }
    
    //////////////////////////////////////////////////
    // 取得語系列表
    NSArray *recogLanguages = nil;
    
    if ([self.delegate respondsToSelector:@selector(supportRecognizeLangugaesForContactAccessFlowController:)])
    {
        recogLanguages = [self.delegate supportRecognizeLangugaesForContactAccessFlowController:self];
    }
    
    if ([recogLanguages count]==0)
    {
        NSLog(@"不應該發生，檢查上面的delegate是否正常");
        return ;
    }
    
    //////////////////////////////////////////////////
    // 取得正反名面預設語系
    NSInteger frontLanguageID = -1;
    NSInteger backLanguageID = -1;
    
    if ([self.delegate respondsToSelector:@selector(contactAccessFlowControllerRequestFrontRecogLang:)])
    {
        frontLanguageID = [self.delegate contactAccessFlowControllerRequestFrontRecogLang:self];
    }
    
    if ([self.delegate respondsToSelector:@selector(contactAccessFlowControllerRequestBackRecogLang:)])
    {
        backLanguageID = [self.delegate contactAccessFlowControllerRequestBackRecogLang:self];
    }
    
    //////////////////////////////////////////////////
    WCCardModel *originCardModel = nil;
    
    if ([self.delegate respondsToSelector:@selector(contactAccessFlowController:cardModelWithCardID:)])
    {
        originCardModel = [self.delegate contactAccessFlowController:self cardModelWithCardID:cardID];
    }
    
    if (originCardModel==nil)
    {
        NSLog(@"不應該發生，檢查上面的delegate是否正常");
        return ;
    }
    
    //////////////////////////////////////////////////
    
    UIViewController *presentViewController = contactInfoScrollViewController;
    if (contactInfoScrollViewController.interfaceIdom==ContactInfoViewControllerUserInterfaceIdom_Pad)
    {
        presentViewController = [[[UIApplication sharedApplication] keyWindow] rootViewController];
    }
    
    [WCReRecognitionFlowController startFromViewController:presentViewController
                                            recogLanguages:recogLanguages
                                          defaultFrontLang:frontLanguageID
                                           defaultBackLang:backLanguageID
                                            frontCardImage:frontCardImage
                                             backCardImage:backCardImage
                                           originCardModel:originCardModel
                                         recognitionAction:^WCCardModel *(WCRecogSourceModel *sourceModel, BOOL isBackSide, NSError **error)
     {
         // TODO: 送出辨識, 名片圖要自已塞
         if (sourceModel==nil)
         {
             return nil;
         }
         
         if ([self.delegate respondsToSelector:@selector(contactAccessFlowController:requestRecogWithSourceModel:error:)])
         {
             if ([self.delegate respondsToSelector:@selector(contactAccessFlowControllerRequestOutputTranslate:)])
             {
                 // -1表示不支援
                 NSInteger outputTranslate =  [self.delegate contactAccessFlowControllerRequestOutputTranslate:self];
                 if (outputTranslate!=-1)
                 {
                     sourceModel.outputTranslate = outputTranslate;
                 }
             }
             
             return [self.delegate contactAccessFlowController:self requestRecogWithSourceModel:sourceModel error:error];
         }
         
         return nil;
     }
                                               completion:^(WCCardModel *resultModel, NSError *error)
     {
         if(error==nil)
         {
             // 如果目前聯絡人已經不存在，跳toast並且不做處理
             if ([self checkExistAndShowToastIfNeededFromViewController:contactInfoScrollViewController withCardID:cardID]==YES)
             {
                 // TODO: 辨識後要進編輯頁面
                 self.currentEditingCardModel = resultModel;
                 [self showContactEditFromViewController:presentViewController
                                                  cardID:resultModel.ID
                                                delegate:self.delegate
                          contacEditViewControllerLayout:WCContactEditViewControllerLayout_Add
                                                  manual:NO];
             }
         }
         [WCReRecognitionFlowController endOfReRecognitionFlowController];
     }];
}


//==============================================================================
//
//==============================================================================
- (void)onClickCommunitySearchFromViewController:(UIViewController *)viewController cardID:(NSString *)cardID
{
    // 社群搜尋
    if ([cardID length]==0)
    {
        return ;
    }
    
    // 如果目前聯絡人已經不存在，跳toast並且不做處理
    if ([self checkExistAndShowToastIfNeededFromViewController:viewController withCardID:cardID]==NO)
    {
        return;
    }
    
    if ([PPNetworkReachabilityController checkForInternetConnection]==NO)
    {
        [WCToastController showMessageToastFromSuperView:viewController.view
                                             withMessage:WCCAFC_PleaseConnectNetwork
                                                position:PPToastPositionCenter];
        return ;
    }
    
    //////////////////////////////////////////////////
    WCCardModel *cardModel = nil;
    if ([self.delegate respondsToSelector:@selector(contactAccessFlowController:cardModelWithCardID:)])
    {
        cardModel = [self.delegate contactAccessFlowController:self cardModelWithCardID:cardID];
    }
    
    if (cardModel)
    {
        [WCSocialSearchFlowController startFromViewController:viewController
                                                    cardModel:cardModel
                                                   completion:^(WCSocialSearchType searchType, NSString *content) {
                                                       
                                                       PPURLControllerType type = PPURLControllerType_None;
                                                       switch (searchType) {
                                                           case WCSocialSearchType_Facebook:
                                                           {
                                                               type = PPURLControllerType_Facebook;
                                                               break;
                                                           }
                                                           case WCSocialSearchType_LinkedIn:
                                                           {
                                                               type = PPURLControllerType_LinkedIn;
                                                               break;
                                                           }
                                                           case WCSocialSearchType_Twitter:
                                                           {
                                                               type = PPURLControllerType_Twitter;
                                                               break;
                                                           }
                                                           case WCSocialSearchType_SinaWebo:
                                                           {
                                                               type = PPURLControllerType_SinaWebo;
                                                               break;
                                                           }
                                                           default:
                                                               break;
                                                       }
                                                       [PPURLController showFromViewController:viewController
                                                                                   withURLType:type
                                                                                     parameter:content];
                                                   }];
    }
}


//==============================================================================
//
//==============================================================================
- (void)onClickDeleteContact:(UIViewController *)viewController cardID:(NSString *)cardID tag:(NSInteger)tag
{
    self.cardIDForDelete = cardID;
    
    [PPAlertView showWithStyle:UIAlertViewStyleDefault
                         title:@""
                       message:WCCAFC_ConfirmDeleteContacts
                      delegate:self
                           tag:tag
             cancelButtonTitle:WCCAFC_Cancel
             otherButtonTitles:WCCAFC_Delete, nil];
}


//==============================================================================
//
//==============================================================================
- (void)onClickChangeGroup:(UIViewController *)viewController cardID:(NSString *)cardID
{
    // 如果目前聯絡人已經不存在，跳toast並且不做處理
    if ([self checkExistAndShowToastIfNeededFromViewController:viewController withCardID:cardID]==NO)
    {
        return;
    }
    [WCGroupAccessFlowController sharedInstance].delegate = self;
    [WCGroupAccessFlowController sharedInstance].userInfo = cardID;
#if defined (PRODUCTLINE_WCT)
    [[WCGroupAccessFlowController sharedInstance] showChangeGroupViewControllerFromViewController:viewController];
#elif defined (PRODUCTLINE_WCM)
    [[WCGroupAccessFlowController sharedInstance] showWCMChangeGroupViewControllerFromViewController:viewController];
#endif
}


//==============================================================================
//
//==============================================================================
- (void)onClickChangeVisibleAccount:(UIViewController *)viewController cardID:(NSString *)cardID
{
    // for WCT
#if defined(PRODUCTLINE_WCT)
    
    // 如果目前聯絡人已經不存在，跳toast並且不做處理
    if ([self checkExistAndShowToastIfNeededFromViewController:viewController withCardID:cardID]==NO)
    {
        return;
    }
    
    if ([PPNetworkReachabilityController checkForInternetConnection]==NO)
    {
        [WCToastController showMessageToastFromSuperView:viewController.view
                                             withMessage:WCCAFC_PleaseConnectNetwork
                                                position:PPToastPositionCenter];
        return ;
    }
    
    // TODO: 檢查目前server中的帳號個數(other account)
    __block typeof(self) blockSelf = self;
    
    dispatch_async(dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_DEFAULT, 0), ^{
        BOOL canChange = YES;
        if([blockSelf.delegate respondsToSelector:@selector(checkAndAlertChangeVisibleAccontWithContactAccessFlowController:)])
        {
            canChange = [blockSelf.delegate checkAndAlertChangeVisibleAccontWithContactAccessFlowController:self];
        }
                
        //////////////////////////////////////////////////
        dispatch_async(dispatch_get_main_queue(), ^{
            
            if(canChange==NO)
            {
                return ;
            }
            
            
            // 如果是全公司共享，不能修改檢視用戶
            BOOL isShareToCompany = [PPSettingsController integerValueWithKey:WCContactAccessFlowController_SettingsKey_ShareToCompany];
            
            if (isShareToCompany)
            {
                [WCToastController showMessageToastFromSuperView:viewController.view
                                                     withMessage:WCCAFC_ShareToCompanyCantModify
                                                        position:PPToastPositionCenter];
                return ;
            }
            
            do
            {
                if(viewController==nil)
                {
                    break;
                }
                
                //////////////////////////////////////////////////
                
                WCTAccountSelectViewController *accountSelectViewController = [[WCTAccountSelectViewController alloc] init];
                
                if(accountSelectViewController==nil)
                {
                    break;
                }
                
                accountSelectViewController.delegate = self;
                accountSelectViewController.style = WCTAccountSelectViewControllerStyle_ChangeVisibleAccounts;
                accountSelectViewController.userInfo = cardID;
                
                //////////////////////////////////////////////////
                
                PPNavigationController *navigationController = [[PPNavigationController alloc] initWithRootViewController:accountSelectViewController];
                
                //////////////////////////////////////////////////
                
                [accountSelectViewController release];
                
                if(navigationController==nil)
                {
                    break;
                }
                
                [viewController presentViewController:navigationController
                                             animated:YES
                                           completion:nil];
                
                [navigationController release];
            }
            while (0);
        });
    });



#endif
}


//==============================================================================
//
//==============================================================================
- (void)onClickMergeiPhoneContactsFromViewController:(UIViewController*)viewController
{
    [WCABItemSelectFlowController showGroupViewControllerWithABSelectFlowControllerMode:WCABItemSelectFlowControllerMode_MergeSystemContact
                                                         abSelectFlowControllerDelegate:self
                                                                        syncAccountName:self.googleSyncAccount
                                                                fromSuperViewController:viewController];
}


//==============================================================================
//
//==============================================================================
- (void)onClickShowCardImageFromViewController:(UIViewController *)viewController
                                        cardID:(NSString *)cardID
                             showBackCardImage:(BOOL)showBackCardImage
                                   reloadImage:(BOOL)reloadImage
{
    if (self.cardImageFlowController==nil)
    {
        self.cardImageFlowController = [[[WCCardImageFlowController alloc] initWithDelegate:self] autorelease];
    }
    
    // 儲存是否要重load 前後名片圖
    self.cardImageFlowController.userInfo = @(reloadImage);
    //////////////////////////////////////////////////
    dispatch_async(dispatch_get_main_queue(), ^{
        [self.cardImageFlowController showFromViewController:viewController
                                                      cardID:cardID
                                           showBackCardImage:showBackCardImage];
    });
}


//==============================================================================
//
//==============================================================================
- (void)onClickChangeSystemGroup:(UIViewController *)viewController cardID:(NSString *)cardID
{
    [WCABItemSelectFlowController showGroupViewControllerWithABSelectFlowControllerMode:WCABItemSelectFlowControllerMode_ApToSystemContact
                                                         abSelectFlowControllerDelegate:self
                                                                        syncAccountName:self.googleSyncAccount
                                                                fromSuperViewController:self.contactEditViewController];
}


//==============================================================================
//
//==============================================================================
- (void)onClickChangeSalesforceTartet:(WCContactEditViewController *)viewController fieldDictioanry:(NSDictionary*)fieldDictioanry
{
    
#if defined (PRODUCTLINE_WCSF)
    // 未校正才可以改saveAs
    if ((self.currentEditingCardModel.tagMask & WC_TagMask_Unverified)!=WC_TagMask_Unverified)
    {
        [WCToastController showMessageToastFromSuperView:viewController.view
                                             withMessage:WCCAFC_MLS_ContactsHasSaveToSF
                                                position:PPToastPositionCenter];
        return ;
    }

    PPSelectItemViewController *selectItemViewController = [[PPSelectItemViewController alloc] init];
    if (selectItemViewController)
    {
        selectItemViewController.delegate = self;
        selectItemViewController.title = WCCAFC_ChangeGroup;
        [selectItemViewController.ppSectionController replaceSectionModels:[self saveAsSectionModeWithSelected:self.saveAs] forSearching:NO];
        PPNavigationController *navigationController = [[PPNavigationController alloc] initWithRootViewController:selectItemViewController];
        if (navigationController)
        {
            [viewController presentViewController:navigationController animated:YES completion:nil];
        }
        [navigationController release];
        
        self.saveAsItemSelectViewController = selectItemViewController;
        [selectItemViewController release];
    }
#endif
}


//==============================================================================
//
//==============================================================================
- (void)onClickContinueEditWithViewController:(WCContactEditViewController *)viewController
{
    //!! 繼續編輯要重load
    __block typeof(self) blockSelf = self;
    
    dispatch_async(dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_DEFAULT, 0), ^{
        // !! 如果存到local成功，要重設為未編輯
        blockSelf.contactEditViewController.edited = NO;
        blockSelf.currentEditingCardModel = nil;
        //////////////////////////////////////////////////
        dispatch_async(dispatch_get_main_queue(), ^{
            
            [blockSelf.contactEditViewController clearAndFetchData];
            [blockSelf.contactEditViewController reloadData];

        });
    });

}




////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - ContactInfoScrollViewControllerDataExchangeProtocol


//================================================================================
//
//================================================================================
- (BOOL)contactInfoScrollViewController:(WCContactInfoScrollViewController *)contactInfoScrollViewController
          favoriteWithcontactIdentifier:(NSString *)contactIdentifier
{
    if ([self.delegate respondsToSelector:@selector(contactAccessFlowController:isFavoriteWithCardID:)])
    {
        return [self.delegate contactAccessFlowController:self isFavoriteWithCardID:contactIdentifier];
    }
    return NO;
}


//================================================================================
//
//================================================================================
- (UIImage *)contactInfoScrollViewController:(WCContactInfoScrollViewController *)contactInfoScrollViewController
                           contactIdentifier:(NSString *)contactIdentifier
                   imageForPPContactMainType:(PPContactMainType)contactMainType
                            ppContactSubType:(PPContactSubType)contactSubType
{
    NSString *cardID = contactIdentifier;
    if (!cardID)
    {
        return nil;
    }
    
    WC_ImageType imageType = [WCFieldTypeConverter imageTypeFromPPContactMainType:contactMainType];
    UIImage *image = [self prepareCardImageWithCardID:cardID imageType:imageType];
    return image;
}


//================================================================================
//
//================================================================================
- (UIImage *)contactInfoScrollViewController:(WCContactInfoScrollViewController *)contactInfoScrollViewController
        defaultCardImageForContactIdentifier:(NSString *)contactIdentifier
{
    NSString *cardID = contactIdentifier;
    if (!cardID)
    {
        return nil;
    }
    
    if ([self.delegate respondsToSelector:@selector(contactAccessFlowController:virtualCardImageWithCardID:)])
    {
        return [self.delegate contactAccessFlowController:self virtualCardImageWithCardID:cardID];
    }
    return nil;
}


//================================================================================
//
//================================================================================
- (NSDictionary *)contactInfoScrollViewController:(WCContactInfoScrollViewController *)contactInfoScrollViewController
                                contactIdentifier:(NSString *)contactIdentifier
         fieldDictionaryforPPContactMainTypeArray:(NSArray *)contactMainTypeArray
{
    if (contactIdentifier==nil)
    {
        return nil;
    }
    
    WCCardModel *cardModel = nil;
    
    if ([self.delegate respondsToSelector:@selector(contactAccessFlowController:cardModelWithCardID:)])
    {
        cardModel = [[self.delegate contactAccessFlowController:self cardModelWithCardID:contactIdentifier] retain];
        
        if (cardModel)
        {
            // helpscan不會進到這個流程，所以不考慮
            BOOL isEditingMyCard = NO;//(contactEditViewController.contactEditViewControllerLayout==WCContactEditViewControllerLayout_MyCard);

            NSDictionary *fieldDictionary =  [self prepareFieldDictionaryWithCardModel:cardModel
                                                             forPPContactMainTypeArray:contactMainTypeArray
                                                                               forEdit:NO
                                                                     isShowCustomField:!isEditingMyCard
                                                                     isShowGroup:!isEditingMyCard
                                                                   isShowSharedAccount:!isEditingMyCard];
            
            [cardModel release];
            
            return fieldDictionary;
        }
    }
    
    return nil;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - ContactInfoScrollViewController DataSource


//==============================================================================
//
//==============================================================================
- (BOOL)shouldShowPhoneticOnContactInfoScrollViewController:(WCContactInfoScrollViewController *)contactInfoScrollViewController
{
    // !!檢視頁面不用顯示讀音
    return NO;
}


//================================================================================
//
//================================================================================
- (WCDisplayNameOrder)contactNameEastOrderInContactInfoScrollViewController:(WCContactInfoScrollViewController *)contactInfoScrollViewController
{
    // 傳入setting
    if ([self.delegate respondsToSelector:@selector(nameOrderForContactAccessFlowController:isEasternName:)])
    {
        return [self.delegate nameOrderForContactAccessFlowController:self isEasternName:YES];
    }
    
    return WCDisplayNameOrder_LastFirst;
}


//================================================================================
//
//================================================================================
- (WCDisplayNameOrder)contactNameWestOrderInContactInfoScrollViewController:(WCContactInfoScrollViewController *)contactInfoScrollViewController
{
    // 傳入setting
    if ([self.delegate respondsToSelector:@selector(nameOrderForContactAccessFlowController:isEasternName:)])
    {
        return [self.delegate nameOrderForContactAccessFlowController:self isEasternName:NO];
    }
    
    return WCDisplayNameOrder_FirstLast;
}


//================================================================================
//
//================================================================================
- (NSMutableArray *)ppContactMainTypeArrayFetchingDataForContactInfoScrollViewController:(WCContactInfoScrollViewController *)contactInfoScrollViewController  contactIdentifier:(NSString *)contactIdentifier
{
#if defined (PRODUCTLINE_WCSF)
    //////////////////////////////////////////////////
    // !! 編輯時要先取得saveAs，不然會來不及
//    self.saveAs = WC_SF_SaveAs_Contacts;
    
    if ([self.delegate respondsToSelector:@selector(salesforceSaveAsWithContactAccessFlowController:cardID:)])
    {
        self.saveAs = [self.delegate salesforceSaveAsWithContactAccessFlowController:self cardID:contactIdentifier];
    }
    
    if(self.saveAs==WC_SF_SaveAs_None)
    {
        NSArray *saveAsArray = [self supportedSaveAsArray];
        self.saveAs = [[saveAsArray firstObject] integerValue];
    }

    return [self prepareWCSFMainTypeArrayForEdit:NO saveAs:self.saveAs];
#elif defined (PRODUCTLINE_WCO365)
    return [self prepareWCO365MainTypeArrayForEdit:NO];
#else
    BOOL isEditingMyCard = (self.contactEditViewController.contactEditViewControllerLayout==WCContactEditViewControllerLayout_MyCard);
    BOOL isHelpScan = (self.contactEditViewController.contactEditViewControllerLayout==WCContactEditViewControllerLayout_HelpScan);

    return [self prepareWCMainTypeArrayForEdit:NO
                             isShowCustomField:!isEditingMyCard
                                   isShowGroup:(!isEditingMyCard&&!isHelpScan)
                           isShowSharedAccount:(!isEditingMyCard&&!isHelpScan)];
#endif
}


//================================================================================
//
//================================================================================
- (NSArray *)translateLanguageArrayInContactInfoScrollViewController:(WCContactInfoScrollViewController *)contactInfoScrollViewController translateLocation:(ContactInfoViewControllerTranslateLocation)translateLocation
{
    return nil;
    /*
     // 回傳來源與翻譯語系
     if (translateLocation==ContactInfoViewControllerTranslateLocation_Source)
     {
     if ([self.delegate respondsToSelector:@selector(supportRecognizeLangugaesForContactAccessFlowController:)])
     {
     NSArray *recogLanguages = [self.delegate supportRecognizeLangugaesForContactAccessFlowController:self];
     
     NSMutableArray *sourceLanguages =  [self sourceLanguagesFromRecogLangModels:recogLanguages];
     if ([sourceLanguages count]>0)
     {
     self.translateFromLanguage = [sourceLanguages firstObject];
     return [NSArray arrayWithArray:sourceLanguages];
     }
     }
     return nil;
     }
     else
     {
     
     NSMutableArray *toLanguages = [NSMutableArray array];
     
     NSString *defaultLanguage = [self toLanguageBySystemLanguage];
     if ([defaultLanguage isEqualToString:MLS_English]==NO)
     {
     [toLanguages addObject:defaultLanguage];
     }
     
     [toLanguages addObject:MLS_English];
     
     if ([toLanguages count]>0)
     {
     self.translateToLanguage = [toLanguages firstObject];
     return [NSArray arrayWithArray:toLanguages];
     }
     return nil;
     }
     */
}




////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - ContactInfoScrollViewControllerDelegate


//================================================================================
//
//================================================================================
- (void)contactInfoScrollViewController:(WCContactInfoScrollViewController *)contactInfoScrollViewController
                      contactIdentifier:(NSString *)contactIdentifier
                                 action:(ContactInfoViewControllerAction)action
{
    //    NSLog(@"%s - %@ - %lu", __PRETTY_FUNCTION__, contactIdentifier, (unsigned long)action);
    
    __block typeof(self) blockSelf = self;
    
    dispatch_async(dispatch_get_main_queue(), ^{
        switch (action)
        {
            case ContactInfoViewControllerAction_Back:
            {
                if ([blockSelf.delegate respondsToSelector:@selector(contactAccessFlowController:action:withCardID:error:)])
                {
                    [blockSelf.delegate contactAccessFlowController:self action:WCContactFlowControllerAction_InfoBack withCardID:contactIdentifier error:nil];
                }
                break;
            }
            case ContactInfoViewControllerAction_Favorite:
            {
                if ([blockSelf.delegate respondsToSelector:@selector(contactAccessFlowController:action:withCardID:error:)])
                {
                    [blockSelf.delegate contactAccessFlowController:self action:WCContactFlowControllerAction_SwitchFavorite withCardID:contactIdentifier error:nil];
                }
                break;
            }
            case ContactInfoViewControllerAction_Note:
            {
                BOOL noteEditable = YES;
                if (contactInfoScrollViewController.interfaceStyle==ContactInfoViewControllerInterfaceStyle_CompanyContacts ||
                    contactInfoScrollViewController.interfaceStyle==ContactInfoViewControllerInterfaceStyle_DuplicateBrowse)
                {
                    noteEditable = NO;
                }
                
                [blockSelf onClickContactInfoNoteFromViewController:contactInfoScrollViewController cardID:contactIdentifier editable:noteEditable];
                break;
            }
            case ContactInfoViewControllerAction_Edit:
            {
                [blockSelf onClickContactInfoEditFromViewController:contactInfoScrollViewController cardID:contactIdentifier];
                break;
            }
            case ContactInfoViewControllerAction_ShareContact:
            {
                // 使用分享元件
                [blockSelf onClickShareContactFromViewController:contactInfoScrollViewController cardID:contactIdentifier];
                break;
            }
            case ContactInfoViewControllerAction_SaveContact:
            {
                // 儲存到系統聯絡人
                [blockSelf onClickSaveToSystemContactFromViewController:contactInfoScrollViewController cardID:contactIdentifier];
                break;
            }
            case ContactInfoViewControllerAction_Translate:
            {
                // 翻譯聯絡人
                [blockSelf onClickTranslateContact:contactInfoScrollViewController cardID:contactIdentifier];
                break;
            }
            case ContactInfoViewControllerAction_Recognize:
            {
                // 重新辨識
                [blockSelf onClickRecognize:contactInfoScrollViewController cardID:contactIdentifier];
                break;
            }
            case ContactInfoViewControllerAction_CommunitySearch:
            {
                // 社群搜尋
                [blockSelf onClickCommunitySearchFromViewController:contactInfoScrollViewController cardID:contactIdentifier];
                break;
            }
            case ContactInfoViewControllerAction_ChangeGroup:
            {
                // 變更群組
                [blockSelf onClickChangeGroup:contactInfoScrollViewController cardID:contactIdentifier];
                break;
            }
            case ContactInfoViewControllerAction_ClickCardImage:
            {
                // 名片圖檢視
                [blockSelf onClickShowCardImageFromViewController:contactInfoScrollViewController
                                                           cardID:contactIdentifier
                                                showBackCardImage:!contactInfoScrollViewController.isShowFrontCardInCurrentContactPage
                                                      reloadImage:NO];
                break;
            }
            case ContactInfoViewControllerAction_DeleteContact:
            {
                // 刪除名片
                [blockSelf onClickDeleteContact:contactInfoScrollViewController cardID:contactIdentifier tag:WCCAFC_AlertTag_Info_Delete];
                break;
            }
            case ContactInfoViewControllerAction_ChangeVisibleAccount:
            {
                [blockSelf onClickChangeVisibleAccount:contactInfoScrollViewController cardID:contactIdentifier];
                break;
            }
            default:
                break;
        }
    });
}


//================================================================================
//
//================================================================================
- (void)contactInfoScrollViewController:(WCContactInfoScrollViewController *)contactInfoScrollViewController
                      contactIdentifier:(NSString *)contactIdentifier
               didSelectValueDictionary:(NSDictionary *)valueDictionary
{
    __block typeof(self) blockSelf = self;
    
    dispatch_async(dispatch_get_main_queue(), ^{
        NSArray *keyArray = [valueDictionary allKeys];
        BOOL recordAction = YES;
        BOOL needCheckNetwork = NO;
        
        for (id key in keyArray)
        {
            ContactActionType actionType = ContactActionType_Tel;
            PPURLControllerType urlType = PPURLControllerType_None;
            NSString *actionContent = nil;
            
            PPContactMainType type=(PPContactMainType)[key integerValue];
            
            // !! ipad不能打電話，所以不用處理
            if(UI_USER_INTERFACE_IDIOM()==UIUserInterfaceIdiomPad)
            {
                if(type==PPContactMainType_Phone)
                {
                    break;
                }
            }

            //////////////////////////////////////////////////

            NSArray *dataModelArray = [valueDictionary objectForKey:key];
            ContactDataExchangeModel *dataModel = [dataModelArray firstObject];
            if (dataModel)
            {
                switch (type)
                {
                    case PPContactMainType_Address:
                    {
                        //////////////////////////////////////////////////
                        
                        needCheckNetwork = YES;
                        actionType = ContactActionType_Map;
                        urlType = PPURLControllerType_GoogleMap;
                        actionContent = [self stringGoogleDisplayAddressWithDataModel:dataModel];
                        
                        //////////////////////////////////////////////////
                        // !! 如果是中國地址用百度，日本地址, 如果有裝navicon，就用navicon
                        NSString *fieldCountryCode =
                        (NSString *)[dataModel.propertyDictionary objectForKey:@(PPContactSubType_Address_CountryCode)];
                        
                        
                        if([[fieldCountryCode lowercaseString] isEqualToString:@"cn"])
                        {
                            urlType = PPURLControllerType_BaiduMap;
                        }
                        if([[fieldCountryCode lowercaseString] isEqualToString:@"jp"])
                        {
                            //  日本地址，有navicon就開navicon
                            if ([PPURLController canOpenURLWithType:PPURLControllerType_NaviCon])
                            {
                                urlType = PPURLControllerType_NaviCon;
                                
                                //////////////////////////////////////////////////
                                // navicon 參數不同
                                WCCardModel *cardModel = nil;
                                
                                if ([blockSelf.delegate respondsToSelector:@selector(contactAccessFlowController:cardModelWithCardID:)])
                                {
                                    cardModel = [blockSelf.delegate contactAccessFlowController:self cardModelWithCardID:contactIdentifier];
                                    
                                    if (cardModel)
                                    {
                                        NSString *name = [cardModel displayName];
                                        
                                        NSString *company = [cardModel displayCompany];
                                        NSString *address = actionContent;
                                        
                                        
                                        NSMutableString *title = [NSMutableString string];
                                        
                                        if([name length])
                                            [title appendString:name];
                                        
                                        if([company length])
                                        {
                                            if([title length])
                                                [title appendString:@"/"];
                                            
                                            [title appendString:company];
                                        }
                                        
                                        if(title.length<=0)
                                        {
                                            if([address length])
                                            {
                                                [title appendString:address];
                                            }
                                        }
                                        actionContent = [PPURLController parameterForNaviConWithAddress:actionContent
                                                                                                appName:@"UX0pU2eo"
                                                                                                  title:title
                                                                                                   text:nil];
                                    }
                                }
                            }
                        }
                        break;
                    }
                    case PPContactMainType_Phone:
                    {
                        //                    cardInfoAction = FlurryParamValue_CardInfoAction_ClickPhone;
                        
                        //////////////////////////////////////////////////
                        
                        actionType = ContactActionType_Tel;
                        urlType = PPURLControllerType_Tel;
                        NSString *value = [dataModel.propertyDictionary objectForKey:@(PPContactSubType_None)];
                        if ([value length]==0)
                        {
                            break;
                        }
                        NSMutableString *phone = [NSMutableString stringWithString:value];
                        [phone replaceOccurrencesOfString:@"\u202e"
                                               withString:@""
                                                  options:NSLiteralSearch
                                                    range:NSMakeRange(0, [phone length])];
                        [phone replaceOccurrencesOfString:@"\u202d"
                                               withString:@""
                                                  options:NSLiteralSearch
                                                    range:NSMakeRange(0, [phone length])];
                        [phone replaceOccurrencesOfString:@"\u202c"
                                               withString:@""
                                                  options:NSLiteralSearch
                                                    range:NSMakeRange(0, [phone length])];
                        [phone replaceOccurrencesOfString:@","
                                               withString:@","
                                                  options:NSLiteralSearch
                                                    range:NSMakeRange(0, [phone length])];
                        [phone replaceOccurrencesOfString:@"*"
                                               withString:@","
                                                  options:NSLiteralSearch
                                                    range:NSMakeRange(0, [phone length])];
                        actionContent = [NSString stringWithString:phone];
                        break;
                    }
                    case PPContactMainType_Email:
                    {
                        //                    cardInfoAction = FlurryParamValue_CardInfoAction_ClickEmail;
                        
                        //////////////////////////////////////////////////
                        actionType = ContactActionType_EMail;
                        urlType = PPURLControllerType_Email;
                        
                        NSString *value = [dataModel.propertyDictionary objectForKey:@(PPContactSubType_None)];
                        if ([value length]==0)
                        {
                            break;
                        }
                        
                        actionContent = [NSMutableString stringWithString:value];
                        
                        break;
                    }
                    case PPContactMainType_URL:
                    {
                        //                    cardInfoAction = FlurryParamValue_CardInfoAction_ClickHomepage;
                        
                        //////////////////////////////////////////////////
                        // 只有用url不需要紀錄
                        recordAction = NO;
                        needCheckNetwork = YES;
                        urlType = PPURLControllerType_Web;
                        
                        NSString *value = [dataModel.propertyDictionary objectForKey:@(PPContactSubType_None)];
                        if ([value length]==0)
                        {
                            break;
                        }
                        
                        actionContent = [NSMutableString stringWithString:value];
                        break;
                    }
                    case PPContactMainType_UserDefine:
                    {
#if defined (PRODUCTLINE_WCT)
                        NSDictionary *userInfo = [dataModel.propertyDictionary objectForKey:@(PPContactSubType_UserDefine_UserInfo)];
                        WCCustomFieldContentType contentType = (WCCustomFieldContentType)[[userInfo objectForKey:WCContactAccessFlowControllerCustomFieldKey_ContentType] integerValue];
                        
                        if(contentType==WCCustomFieldContentType_Email)
                        {
                            actionType = ContactActionType_EMail;
                            urlType = PPURLControllerType_Email;
                            
                            NSString *value = [dataModel.propertyDictionary objectForKey:@(PPContactSubType_UserDefine_Email)];
                            if ([value length]==0)
                            {
                                break;
                            }
                            
                            actionContent = [NSMutableString stringWithString:value];
                        }
                        else if(contentType==WCCustomFieldContentType_URL)
                        {
                            // 只有用url不需要紀錄
                            recordAction = NO;
                            needCheckNetwork = YES;
                            urlType = PPURLControllerType_Web;
                            
                            NSString *value = [dataModel.propertyDictionary objectForKey:@(PPContactSubType_UserDefine_URL)];
                            if ([value length]==0)
                            {
                                break;
                            }
                            
                            actionContent = [NSMutableString stringWithString:value];
                        }
#endif
                        break;
                    }
#if defined (PRODUCTLINE_WCO365)
                    case PPContactMainType_Other:
                    {
                        if (dataModel.labelType==PPContactLabelType_Other_URL_Work)
                        {
                            //////////////////////////////////////////////////
                            // 只有用url不需要紀錄
                            recordAction = NO;
                            needCheckNetwork = YES;
                            urlType = PPURLControllerType_Web;
                            
                            NSString *value = [dataModel.propertyDictionary objectForKey:@(PPContactSubType_None)];
                            if ([value length]==0)
                            {
                                break;
                            }
                            
                            actionContent = [NSMutableString stringWithString:value];
                        }
                        break;
                    }
#endif
                    case PPContactMainType_Name:
                    case PPContactMainType_Company:
                    case PPContactMainType_InstantMessage:
                    case PPContactMainType_Date:
                    case PPContactMainType_UnifiedBusinessNumber:
                    case PPContactMainType_NickName:
                    case PPContactMainType_PublicNote:
                    case PPContactMainType_Note:
                    case PPContactMainType_Group:
                    default:
                        break;
                }
            }
            //////////////////////////////////////////////////
            if (urlType==PPURLControllerType_None || [actionContent length]==0)
            {
                return ;
            }
            
            if (needCheckNetwork)
            {
                if ([PPNetworkReachabilityController checkForInternetConnection]==NO)
                {
                    [WCToastController showMessageToastFromSuperView:contactInfoScrollViewController.view withMessage:WCCAFC_PleaseConnectNetwork position:PPToastPositionCenter];
                    return ;
                }
            }
            //////////////////////////////////////////////////
            // !! 先過濾前後空白
            actionContent = [actionContent stringByTrimmingCharactersInSet:[NSCharacterSet whitespaceAndNewlineCharacterSet]];
            
            //////////////////////////////////////////////////
            if([PPURLController canOpenURLFromViewControllerWithType:urlType]==NO)
            {
                NSString *message = WCCAFC_ActionFailed;
                switch (urlType)
                {
                    case PPURLControllerType_Tel:
                    {
                        // !! 如果無法撥電話，不用顯示錯誤，ipad也無法撥電話
                        message = nil;
                        break;
                    }
                    case PPURLControllerType_Email:
                    {
                        message = WCCAFC_NoSettingEmail;
                        break;
                    }
                    default:
                        break;
                }
                
                if (message)
                {
                    [WCToastController showMessageToastFromSuperView:contactInfoScrollViewController.view
                                                         withMessage:message
                                                            position:PPToastPositionCenter];
                }
                return ;
            }
            
            if (urlType==PPURLControllerType_Web)
            {
                NSString *string= @"http://";
                if([actionContent rangeOfString:@"//"].length==0)
                {
                    string = [string stringByAppendingString:actionContent];
                }
                else
                {
                    string = actionContent;
                }
                
                string = [string stringByAddingPercentEncodingWithAllowedCharacters:[NSCharacterSet URLQueryAllowedCharacterSet]];
                NSURL *url = [NSURL URLWithString:string];

                // !! 因為PPURLController中不適合處理delegate, 所以網頁目前先由元件直接call
                PPWebViewController *ppWebViewController = [[PPWebViewController alloc] init];
                if (ppWebViewController==nil)
                {
                    break;
                }
                
                ppWebViewController.delegate  = self;
                ppWebViewController.hidesBottomBarWhenPushed    = YES;
                ppWebViewController.request                     = [NSURLRequest requestWithURL:url
                                                                                   cachePolicy:NSURLRequestUseProtocolCachePolicy
                                                                               timeoutInterval:PPWebViewDefaultRequestURLTimeout];
                //////////////////////////////////////////////////
                
                
                PPNavigationController *navigationController = [[PPNavigationController alloc] initWithRootViewController:ppWebViewController];
                if(navigationController!=nil)
                {
                    [contactInfoScrollViewController presentViewController:navigationController animated:YES completion:^{}];
                    
                    [navigationController release];
                }
                return ;
            }
            
            if([PPURLController showFromViewController:contactInfoScrollViewController
                                           withURLType:urlType
                                             parameter:actionContent])
            {
#if defined (PRODUCTLINE_WCT)
                // MARK: !! matomo log (email, map, skype)
                WCTMatomoController_Feature feature = WCTMatomoController_Feature_None;
                switch (actionType) {
                    case ContactActionType_EMail:
                    {
                        feature = WCTMatomoController_Feature_Email;
                        break;
                    }
                    case ContactActionType_Map:
                    {
                        feature = WCTMatomoController_Feature_Map;
                        break;
                    }
                    case ContactActionType_Skype:
                    {
                        feature = WCTMatomoController_Feature_Skype;
                        break;
                    }
                    default:
                        break;
                }
                
                if(feature!=WCTMatomoController_Feature_None)
                {
                    [WCTMatomoController sendLogWithFeature:feature];
                }
#elif defined (PRODUCTLINE_WCSF)
                // MARK: Matomo log (phone, sms, email)
                WCSFMatomoController_ContactAction action = WCSFMatomoController_ContactAction_None;
                switch (urlType)
                {
                    case PPURLControllerType_Tel:
                    {
                        action = WCSFMatomoController_ContactAction_Phone;
                        break;
                    }
                    case PPURLControllerType_SMS:
                    {
                        action = WCSFMatomoController_ContactAction_Message;
                        break;
                    }
                    case PPURLControllerType_Email:
                    {
                        action = WCSFMatomoController_ContactAction_Email;
                        break;
                    }
                    default:
                        break;
                }
                
                if(action!=WCSFMatomoController_ContactAction_None)
                {
                    [WCSFMatomoController sendContactActionLogWithAction:action];
                }
                
#endif
                //////////////////////////////////////////////////
                if (recordAction)
                {
                    //////////////////////////////////////////////////
                    [self reportRecentAction:actionType content:actionContent cardID:contactIdentifier];
                }
            }
            else
            {
                [WCToastController showMessageToastFromSuperView:contactInfoScrollViewController.view
                                                     withMessage:WCCAFC_InvalidContent
                                                        position:PPToastPositionCenter];
            }
        }
    });
    
}


//================================================================================
// 點選到電話欄位右側的圖示 (目前只有簡訊)
//================================================================================
- (void)contactInfoScrollViewController:(WCContactInfoScrollViewController *)contactInfoScrollViewController
                      contactIdentifier:(NSString *)contactIdentifier
                   didSelectPhoneNumber:(NSString *)phoneNumber
{
    if([PPURLController canOpenURLFromViewControllerWithType:PPURLControllerType_SMS])
    {
        [PPURLController showFromViewController:contactInfoScrollViewController withURLType:PPURLControllerType_SMS parameter:phoneNumber];
        
#if defined (PRODUCTLINE_WCSF)
        // MARK: Matomo log (sms)
        [WCSFMatomoController sendContactActionLogWithAction:WCSFMatomoController_ContactAction_Message];
#endif
        //////////////////////////////////////////////////
        NSMutableString *phone = [NSMutableString stringWithString:phoneNumber];
        [phone replaceOccurrencesOfString:@"\u202e"
                               withString:@""
                                  options:NSLiteralSearch
                                    range:NSMakeRange(0, [phone length])];
        [phone replaceOccurrencesOfString:@"\u202d"
                               withString:@""
                                  options:NSLiteralSearch
                                    range:NSMakeRange(0, [phone length])];
        [phone replaceOccurrencesOfString:@"\u202c"
                               withString:@""
                                  options:NSLiteralSearch
                                    range:NSMakeRange(0, [phone length])];
        [self reportRecentAction:ContactActionType_SMS content:phone cardID:contactIdentifier];
        
    }
    else
    {
        [WCToastController showMessageToastFromSuperView:contactInfoScrollViewController.view
                                             withMessage:WCCAFC_CantSendText
                                                position:PPToastPositionCenter];
    }
}


//================================================================================
// 設為預設值
//================================================================================
- (void)contactInfoScrollViewController:(WCContactInfoScrollViewController *)contactInfoScrollViewController
                      contactIdentifier:(NSString *)contactIdentifier
                          setFieldIndex:(NSUInteger)fieldIndex
                  toDefaultWithMainType:(PPContactMainType)contactMainType
{
    if ([self checkExistAndShowToastIfNeededFromViewController:contactInfoScrollViewController withCardID:contactIdentifier]==NO)
    {
        return ;
    }
    
    // 調整順序
    __block typeof(self) blockSelf = self;
    [blockSelf setBusy:@(YES)];
    
    dispatch_async(dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_DEFAULT, 0), ^{
        
        if ([blockSelf.delegate respondsToSelector:@selector(contactAccessFlowController:setFieldIndex:toDefaultWithCardID:fieldType:)])
        {
            WC_FieldType fieldType = [WCFieldTypeConverter fieldTypeFromPPContactMainType:contactMainType];
            
            [blockSelf.delegate contactAccessFlowController:blockSelf setFieldIndex:fieldIndex toDefaultWithCardID:contactIdentifier fieldType:fieldType];
        }
        
        dispatch_async(dispatch_get_main_queue(), ^{
            [blockSelf setBusy:@(NO)];
        });
    });
    
}


//================================================================================
// 切換翻譯語系
//================================================================================
- (void)contactInfoScrollViewController:(WCContactInfoScrollViewController *)contactInfoScrollViewController
                      contactIdentifier:(NSString *)contactIdentifier
                  translateFromLanguage:(NSString *)fromLanguage
                             toLanguage:(NSString *)toLanguage
{
    __block typeof(self) blockSelf = self;
    
    //    NSTimeInterval startTime = [NSDate timeIntervalSinceReferenceDate];
    
    // 使用reloadContactInformationInCurrentPage更新
    blockSelf.translateFromLanguage = fromLanguage;
    blockSelf.translateToLanguage = toLanguage;
    
    // !!這個api要在main thread
    dispatch_async(dispatch_get_main_queue(), ^{
        [contactInfoScrollViewController reloadContactInformationInCurrentPageWithCardID:contactIdentifier Completed:^{
            //            // !!如果太快load完，多等一下
            //            if ([NSDate timeIntervalSinceReferenceDate] - startTime <1.0)
            //            {
            //                [NSThread sleepForTimeInterval:1.0];
            //            }
            //
            //            [blockSelf setBusy:@(NO)];
        }];
    });
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - contact info notification controller


//===============================================================================
//
//===============================================================================
- (void)recvDisplayDataChanged:(NSNotification *)notification
{
    if (self.contactInfoScrollViewController)
    {
        NSString *cardID = [self.contactInfoScrollViewController contactIDInCurrentPage];
        NSArray *notificationCardIDs = [notification.userInfo objectForKey:WCDC_NOTIFY_UserInfo_kUpdateCard];
        
        for (NSString *notificationCardID in notificationCardIDs)
        {
            if ([notificationCardID isEqualToString:cardID])
            {
                [self.contactInfoScrollViewController reloadContactInformationInCurrentPageWithCardID:cardID Completed:nil];
                break;
            }
        }
    }
}



////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - UIAlertViewDelegate


//==============================================================================
//
//==============================================================================
- (void)alertView:(UIAlertView *)alertView didDismissWithButtonIndex:(NSInteger)buttonIndex
{
    NSString *buttonTitle = [alertView buttonTitleAtIndex:buttonIndex];
    if ([buttonTitle isEqualToString:WCCAFC_Delete])
    {
        if ([self.delegate respondsToSelector:@selector(contactAccessFlowController:action:withCardID:error:)])
        {
            [self.delegate contactAccessFlowController:self action:WCContactFlowControllerAction_Delete withCardID:self.cardIDForDelete error:nil];
            self.cardIDForDelete = nil;
            
            //////////////////////////////////////////////////
            __block typeof(self) blockSelf = self;
            
            dispatch_async(dispatch_get_main_queue(), ^{
                if(blockSelf.isDeallocing==YES)
                {
                    return ;
                }
                [blockSelf.contactInfoScrollViewController goBackAnimated:YES];
                
                if (alertView.tag==WCCAFC_AlertTag_CardImage_Delete)
                {
                    if(blockSelf.isDeallocing==YES)
                    {
                        return ;
                    }
                    [blockSelf dismissContactInfoViewControllerAnimated:YES];
                }
            });
        }
    }
}




////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - WCCardImageFlowControllerDelegate


//==============================================================================
//
//==============================================================================
- (BOOL)isCardExist:(NSString *)cardID
{
    if ([self.delegate respondsToSelector:@selector(contactAccessFlowController:isCardIDExist:)])
    {
        return [self.delegate contactAccessFlowController:self isCardIDExist:cardID];
    }
    return NO;
}


//==============================================================================
//
//==============================================================================
- (UIImage *)copyDefaultCardImageWithCardID:(NSString *)cardID
{
    if ([self.delegate respondsToSelector:@selector(contactAccessFlowController:virtualCardImageWithCardID:)])
    {
        return [[self.delegate contactAccessFlowController:self virtualCardImageWithCardID:cardID] retain];
    }
    return nil;
}


//==============================================================================
//
//==============================================================================
- (UIImage *)copyFrontCardImageWithCardID:(NSString *)cardID
{
    BOOL needReload = NO;
    needReload = [[self.cardImageFlowController userInfo] boolValue];
    if (needReload==NO)
    {
        // 目前只有contact info 會進入CardImage, 所以直接跟Contact info要圖
        return [[self.contactInfoScrollViewController contactFrontCardImageInCurrentPage] copy];
    }
    else
    {
        if ([self.delegate respondsToSelector:@selector(contactAccessFlowController:cardImageWithCardID:imageType:)])
        {
            return [[self.delegate contactAccessFlowController:self cardImageWithCardID:cardID imageType:WC_IT_FrontSide] retain];
        }
    }
    return nil;
}


//==============================================================================
//
//==============================================================================
- (UIImage *)copyBackCardImageWithCardID:(NSString *)cardID
{
    BOOL needReload = NO;
    needReload = [[self.cardImageFlowController userInfo] boolValue];
    if (needReload==NO)
    {
        // 目前只有contact info 會進入CardImage, 所以直接跟Contact info要圖
        return [[self.contactInfoScrollViewController contactBackCardImageInCurrentPage] copy];
    }
    else
    {
        if ([self.delegate respondsToSelector:@selector(contactAccessFlowController:cardImageWithCardID:imageType:)])
        {
            return [[self.delegate contactAccessFlowController:self cardImageWithCardID:cardID imageType:WC_IT_BackSide] retain];
        }
    }
    return nil;
}


//==============================================================================
//
//==============================================================================
- (BOOL)didFinishWithCardID:(NSString *)cardID
             frontCardImage:(UIImage*)frontCardImage
         isFrontCardChanged:(BOOL)isFrontCardChanged
              backCardImage:(UIImage *)backCardImage
          isBackCardChanged:(BOOL)isBackCardChanged
          isBackBecomeFront:(BOOL)isBackBecomeFront
{
    // TODO: !!如果兩張都是空的，要再檢查名片是不是空的
    // 如果要要提示是否刪除名片，是的話刪除並回到列表
    BOOL isEmptyCard = NO;
    if ([self.delegate respondsToSelector:@selector(contactAccessFlowController:isEmptyCardWithCardID:frontSideImage:backSideImage:)])
    {
        isEmptyCard = [self.delegate contactAccessFlowController:self isEmptyCardWithCardID:cardID frontSideImage:frontCardImage backSideImage:backCardImage];
    }
    
    if (isEmptyCard)
    {
        self.cardIDForDelete = cardID;
        
        [PPAlertView showWithStyle:UIAlertViewStyleDefault
                             title:@""
                           message:WCCAFC_ConfirmDeleteContacts
                          delegate:self
                               tag:WCCAFC_AlertTag_CardImage_Delete
                 cancelButtonTitle:WCCAFC_Cancel
                 otherButtonTitles:WCCAFC_Delete, nil];
        return NO;
    }
    else
    {
        // 更新名片圖
        if ([self.delegate respondsToSelector:@selector(contactAccessFlowController:updateCardImage:withCardID:imageType:error:)])
        {
            // 更新前名片圖
            [self.delegate contactAccessFlowController:self updateCardImage:frontCardImage withCardID:cardID imageType:WC_IT_FrontSide error:nil];
            
            // 更新後名片圖
            [self.delegate contactAccessFlowController:self updateCardImage:backCardImage withCardID:cardID imageType:WC_IT_BackSide error:nil];
        }
        
        if ([self.delegate respondsToSelector:@selector(contactAccessFlowController:action:withCardID:error:)])
        {
            // 根據名片圖的狀態，清除正反名片欄位記錄
            
            // 反面變正面要先處理
            if (isBackBecomeFront)
            {
                [self.delegate contactAccessFlowController:self action:WCContactFlowControllerAction_SetBackFieldAsFront withCardID:cardID error:nil];
            }
            
            if (isFrontCardChanged)
            {
                [self.delegate contactAccessFlowController:self action:WCContactFlowControllerAction_SetFrontFieldAsManul withCardID:cardID error:nil];
            }
            
            if (isBackCardChanged)
            {
                [self.delegate contactAccessFlowController:self action:WCContactFlowControllerAction_SetBackFieldAsManul withCardID:cardID error:nil];
            }
        }
        
        [self.contactInfoScrollViewController clearContactInformationInCurrentPage];
        
        //////////////////////////////////////////////////
        __block typeof(self) blockSelf = self;
        
        dispatch_async(dispatch_get_main_queue(), ^{
            
            blockSelf.cardImageFlowController = nil;
        });
        
        return YES;
    }
}


//==============================================================================
//
//==============================================================================
- (void)didFinishWithCardImageFlowController:(WCCardImageFlowController *)cardImageFlowController
{
    
    //////////////////////////////////////////////////
    __block typeof(self) blockSelf = self;
    
    dispatch_async(dispatch_get_main_queue(), ^{
        blockSelf.cardImageFlowController = nil;
    });
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - WCExportFlowControllerDelegate


//==============================================================================
//
//==============================================================================
- (WCDisplayNameOrder)contactNameEastOrderInExportFlowController:(WCExportFlowController *)exportFlowController
{
    if ([self.delegate respondsToSelector:@selector(nameOrderForContactAccessFlowController:isEasternName:)])
    {
        return [self.delegate nameOrderForContactAccessFlowController:self isEasternName:YES];
    }
    return WCDisplayNameOrder_FirstLast;
}


//==============================================================================
//
//==============================================================================
- (WCDisplayNameOrder)contactNameWestOrderInExportFlowController:(WCExportFlowController *)exportFlowController
{
    if ([self.delegate respondsToSelector:@selector(nameOrderForContactAccessFlowController:isEasternName:)])
    {
        return [self.delegate nameOrderForContactAccessFlowController:self isEasternName:NO];
    }
    return WCDisplayNameOrder_FirstLast;
}


//==============================================================================
//
//==============================================================================
- (WCABCardModel *)exportFlowController:(WCExportFlowController *)exportFlowController addressBookCardModelWithCardID:(NSString *)cardID
{
    if ([self.delegate respondsToSelector:@selector(contactAccessFlowController:isCardIDExist:)])
    {
        if ([self.delegate contactAccessFlowController:self isCardIDExist:cardID]==NO)
        {
            return nil;
        }
    }
    
    //////////////////////////////////////////////////
    if ([self.delegate respondsToSelector:@selector(contactAccessFlowController:addressBookCardModelWithCardID:)])
    {
        return (WCABCardModel *)[self.delegate contactAccessFlowController:self addressBookCardModelWithCardID:cardID];
    }
    return nil;
}


//==============================================================================
//
//==============================================================================
- (void)exportFlowController:(WCExportFlowController *)exportFlowController exportOneAddressBookCardModel:(WCABCardModel *)abCardModel withCardID:(NSString *)cardID
{
    if ([self.delegate respondsToSelector:@selector(contactAccessFlowController:updateAddressBookDataWithABCardModel:)])
    {
        [self.delegate contactAccessFlowController:self updateAddressBookDataWithABCardModel:abCardModel];
    }
}

- (void)exportFlowController:(WCExportFlowController *)exportFlowController didFinishWithError:(NSError *)error
{
    if (error)
    {
        [PPAlertView showWithStyle:UIAlertViewStyleDefault
                             title:@""
                           message:[@"MLS_ExportFailed" localized]
                 cancelButtonTitle:WCCAFC_Ok
                 otherButtonTitles:nil];
    }
    else
    {
        [exportFlowController goBackAnimated:YES];
    }
}

//==============================================================================
//
//==============================================================================
- (WCCardModel *)exportFlowController:(WCExportFlowController *)exportFlowController cardModelToWriteWithCardID:(NSString *)cardID
{
    // 這邊一定是匯出到系統聯絡人，所以不用處理
    return nil;
}


//==============================================================================
//
//==============================================================================
- (NSString *)exportFlowController:(WCExportFlowController *)exportFlowController groupNameToWriteWithGroupID:(WC_GroupID)groupID
{
    // 這邊一定是匯出到系統聯絡人，所以不用處理
    return nil;
}



//==============================================================================
//
//==============================================================================
- (NSData *)exportFlowController:(WCExportFlowController *)exportFlowController imageDataToWriteWithCardID:(NSString *)cardID imageType:(WC_ImageType)imageType
{
    if ([self.delegate respondsToSelector:@selector(contactAccessFlowController:cardImageDataWithCardID:imageType:)])
    {
        return [self.delegate contactAccessFlowController:self cardImageDataWithCardID:cardID imageType:imageType];
    }
    return nil;
}






////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - WCShareControllerDelegate


//==============================================================================
//
//==============================================================================
- (WCDisplayNameOrder)contactNameEastOrderInShareFlowController:(WCShareFlowController *)shareFlowController
{
    if ([self.delegate respondsToSelector:@selector(nameOrderForContactAccessFlowController:isEasternName:)])
    {
        return [self.delegate nameOrderForContactAccessFlowController:self isEasternName:YES];
    }
    
    return WCDisplayNameOrder_LastFirst;
}


//==============================================================================
//
//==============================================================================
- (WCDisplayNameOrder)contactNameWestOrderInShareFlowController:(WCShareFlowController *)shareFlowController
{
    if ([self.delegate respondsToSelector:@selector(nameOrderForContactAccessFlowController:isEasternName:)])
    {
        return [self.delegate nameOrderForContactAccessFlowController:self isEasternName:NO];
    }
    
    return WCDisplayNameOrder_FirstLast;
}


//==============================================================================
//
//==============================================================================
- (WCCardModel *)shareFlowController:(WCShareFlowController *)shareFlowController cardModelToWriteWithCardID:(NSString *)cardID
{
    if ([self.delegate respondsToSelector:@selector(contactAccessFlowController:isCardIDExist:)])
    {
        if ([self.delegate contactAccessFlowController:self isCardIDExist:cardID]==NO)
        {
            return nil;
        }
    }
    
    if ([self.delegate respondsToSelector:@selector(contactAccessFlowController:cardModelWithCardID:)])
    {
        return [self.delegate contactAccessFlowController:self cardModelWithCardID:cardID];
    }
    return nil;
}


//==============================================================================
//
//==============================================================================
- (NSString *)shareFlowController:(WCShareFlowController *)shareFlowController groupNameToWriteWithGroupID:(WC_GroupID)groupID
{
    if ([self.delegate respondsToSelector:@selector(contactAccessFlowController:groupNamesWithGroupIDArray:)])
    {
        return [self.delegate contactAccessFlowController:self groupNamesWithGroupIDArray:@[[NSString stringWithInteger:groupID]]];
    }
    
    return nil;
}


//==============================================================================
//
//==============================================================================
- (NSData *)shareFlowController:(WCShareFlowController *)shareFlowController imageDataToWriteWithCardID:(NSString *)cardID imageType:(WC_ImageType)imageType
{
    if ([self.delegate respondsToSelector:@selector(contactAccessFlowController:cardImageDataWithCardID:imageType:)])
    {
        return [self.delegate contactAccessFlowController:self cardImageDataWithCardID:cardID imageType:imageType];
    }
    
    return nil;
}


//==============================================================================
//
//==============================================================================
- (void)shareFlowController:(WCShareFlowController *)shareFlowController didWriteCardWithIndex:(NSInteger)index totalCount:(NSInteger)totalCount
{
    
}


//==============================================================================
//
//==============================================================================
- (void)shareFlowController:(WCShareFlowController *)shareFlowController didFinishWithError:(NSError *)error
{
    if (error==nil)
    {
        // 沒有錯誤
        [shareFlowController dismissShareViewControllerWithCompletion:nil];
    }
    else
    {
        if (error.code == WCShareFlow_Error_NoSettingEMail)
        {
            [PPAlertView showWithStyle:UIAlertViewStyleDefault
                                 title:@""
                               message:WCCAFC_NoSettingEmail
                     cancelButtonTitle:WCCAFC_Ok
                     otherButtonTitles:nil];
        }
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - PPWebViewControllerDelegate


//==============================================================================
//
//==============================================================================
- (void)ppWebViewController:(PPWebViewController *)ppWebViewController didFailLoadWithError:(NSError *)error
{
    if (error)
    {
        // 如果是網頁產生的-999不顯示
        if ([error.domain isEqualToString:NSURLErrorDomain]&&
            error.code==NSURLErrorCancelled)
        {
            return;
        }
        
        
        [PPAlertView showWithStyle:UIAlertViewStyleDefault
                             title:@""
                           message:[error localizedDescription]
                 cancelButtonTitle:WCCAFC_Ok
                 otherButtonTitles: nil];
    }
}






////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - NoteViewControllerDelegate


//==============================================================================
//
//==============================================================================
- (void)noteViewController:(NoteViewController *)noteViewController ppButton:(PPButton *)ppButton controlEvent:(UIControlEvents)controlEvent
{
    switch (ppButton.tag)
    {
        case NoteViewControllerButtonTag_Back:
        {
            [noteViewController goBackAnimated:YES];
            break;
        }
        case NoteViewControllerButtonTag_Done:
        {
            // 如果目前聯絡人已經不存在，跳toast並且不做處理
            NSError *error = nil;
            if ([self checkExistAndShowToastIfNeededFromViewController:self.contactInfoScrollViewController withCardID:self.cardIDForNote])
            {
                if ([self.delegate respondsToSelector:@selector(contactAccessFlowController:updateNote:withCardID:error:)])
                {
                    [self.delegate contactAccessFlowController:self updateNote:noteViewController.noteTextString withCardID:self.cardIDForNote error:&error];
                }
            }
            
            if (error!=nil)
            {
                PPAlertController *alertController = [PPAlertController alertControllerWithAlertControllerStyle:UIAlertControllerStyleAlert
                                                                                                              title:@""
                                                                                                            message:[error alertMessage]
                                                                                                   alertActionStyle:UIAlertActionStyleDefault];
                [noteViewController presentViewController:alertController animated:YES completion:nil];
            }
            else
            {
                [noteViewController goBackAnimated:YES];
            }
            break;
        }
        default:
            break;
    }
    self.cardIDForNote = nil;
}







////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - display methods


//==============================================================================
//
//==============================================================================
- (void)showContactInfoFromViewController:(UIViewController *)viewController
                      currentContactIndex:(NSInteger)currentContactIndex
                           contactIDArray:(NSArray *)contactIDArray
                           interfaceStyle:(ContactInfoViewControllerInterfaceStyle)interfaceStyle
                           needFullScreen:(BOOL)needFullScreen
                                 delegate:(id<WCContactAccessFlowControllerDelegate>)delegate
{
    if (viewController==nil)
    {
        return ;
    }
    
    //////////////////////////////////////////////////
    self.delegate = delegate;
    
    // reset data
    [self resetData];
    PPSplitViewController *splitViewController = [viewController splitViewController];
    
    NSString *currentCardID = nil;
    NSArray *cardIDArray = nil;
    if ([contactIDArray count]>0)
    {
        currentCardID = contactIDArray[currentContactIndex];
        cardIDArray = @[currentCardID];
    }
    
    
    NSInteger contactIndex = 0;
    // 如果要全螢幕顯示或splitViewcontroller是空的或displayMode是master
    if (needFullScreen==YES ||
        (splitViewController==nil ||
         splitViewController.displayMode==PPSplitViewControllerDisplayMode_Master))
    {
        cardIDArray = [NSArray arrayWithArray:contactIDArray];
        contactIndex = currentContactIndex;
    }
        
    if (self.contactInfoScrollViewController)
    {
        [self.contactInfoScrollViewController reloadContactInformationInCurrentPageWithCardID:currentCardID Completed:nil];
    }
    else
    {
        WCContactInfoScrollViewController *contactInfoScrollViewController =
        [[WCContactInfoScrollViewController alloc] initWithCurrentContactIndex:contactIndex
                                                        contactIdentifierArray:cardIDArray
                                                                interfaceStyle:interfaceStyle];
        
        // 記錄到flow controller 中
        self.contactInfoScrollViewController = contactInfoScrollViewController;

        contactInfoScrollViewController.delegate = self;
        contactInfoScrollViewController.dataSource = self;
        contactInfoScrollViewController.dataExchangeProtocol = self;
        contactInfoScrollViewController.isBackButtonShowed = YES;
        
        if ([self.delegate respondsToSelector:@selector(contactAccessFlowControllerRequestGoogleSyncAccount:)])
        {
            self.googleSyncAccount = [self.delegate contactAccessFlowControllerRequestGoogleSyncAccount:self];
        }
        
        // 設定介面模式
        if(UI_USER_INTERFACE_IDIOM()==UIUserInterfaceIdiomPad)
        {
            contactInfoScrollViewController.interfaceIdom = ContactInfoViewControllerUserInterfaceIdom_Pad;
        }
        else
        {
            contactInfoScrollViewController.interfaceIdom = ContactInfoViewControllerUserInterfaceIdom_Phone;
        }
        
        // 如果不是全螢幕顯示，而且有splitViewController, 就顯示到detail
        // 如果要全螢幕顯示或splitViewcontroller是空的或displayMode是master
        if (needFullScreen==YES ||
            (splitViewController==nil ||
             splitViewController.displayMode==PPSplitViewControllerDisplayMode_Master))
        {
            [viewController presentViewController:contactInfoScrollViewController animated:YES completion:nil];
        }
        else
        {
            contactInfoScrollViewController.isBackButtonShowed = NO;
            splitViewController.detailViewController = contactInfoScrollViewController;
        }
        
        
        [contactInfoScrollViewController release];
    }
}


//==============================================================================
//
//==============================================================================
- (BOOL)showTranslatedContactInfoFromViewController:(UIViewController *)viewController contactIDArray:(NSArray *)contactIDArray
{
    if (viewController==nil)
    {
        return NO;
    }
    
    WCContactInfoScrollViewController *contactInfoScrollViewController =
    [[WCContactInfoScrollViewController alloc] initWithCurrentContactIndex:0
                                                    contactIdentifierArray:contactIDArray
                                                            interfaceStyle:ContactInfoViewControllerInterfaceStyle_Translate];
    
    if (contactInfoScrollViewController)
    {
        contactInfoScrollViewController.delegate = self;
        contactInfoScrollViewController.dataSource = self;
        contactInfoScrollViewController.dataExchangeProtocol = self;
        
        
        [viewController presentViewController:contactInfoScrollViewController animated:YES completion:nil];
        
        [contactInfoScrollViewController release];
        return YES;
    }
    
    return NO;
}


//==============================================================================
//
//==============================================================================
- (void)dismissContactInfoViewControllerAnimated:(BOOL)animated
{
    [self.contactInfoScrollViewController goBackAnimated:animated];
    self.contactInfoScrollViewController.dataExchangeProtocol = nil;
    self.contactInfoScrollViewController.dataSource = nil;
    self.contactInfoScrollViewController.delegate = nil;
    self.contactInfoScrollViewController = nil;
}


//==============================================================================
//
//==============================================================================
- (void)showInfoGuideIfNeeded
{
    [self.contactInfoScrollViewController showGuideInCurrentPage];
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - ##############################################################################
#pragma mark CONTACT EDIT FLOW





#if defined (PRODUCTLINE_WCSF)
////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - PPButtonDelegate


//==============================================================================
//
//==============================================================================
- (void)ppButton:(PPButton *)ppButton controlEvent:(UIControlEvents)controlEvent
{
    [self.saveAsItemSelectViewController goBackAnimated:YES];
    self.saveAsItemSelectViewController = nil;
}






////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - PPSelectItemViewControllerDelegate


//==============================================================================
//
//==============================================================================
- (void)ppSelectItemViewController:(PPSelectItemViewController *)ppSelectItemViewController selectRowModel:(PPRowModel *)rowModel sectionModel:(PPSectionModel *)sectionModel
{
    // !! 如果沒有變更，不用切換
    __block typeof(self) blockSelf = self;
    
    WC_SF_SaveAs saveAs = WC_SF_SaveAs_Leads;
    if ([self.currentEditingCardModel saveAs]!=WC_SF_SaveAs_Leads) {
        saveAs = WC_SF_SaveAs_Contacts;
    }
    
    if(saveAs==rowModel.row)
    {
        // 沒有異動
        //////////////////////////////////////////////////
        dispatch_async(dispatch_get_main_queue(), ^{
            
            [self.saveAsItemSelectViewController dismissAnimated:YES completion:nil];
            self.saveAsItemSelectViewController = nil;
            
        });
    }
    else
    {
        // 變更介面
        dispatch_async(dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_DEFAULT, 0), ^{
            // 設定目前的編輯
            blockSelf.saveAs = (WC_SF_SaveAs)rowModel.row;
            
            [blockSelf updateCardModel:blockSelf.currentEditingCardModel withFieldDictionary:[blockSelf.contactEditViewController curTextFieldDictionary]];
            [blockSelf.currentEditingCardModel setSaveAs:blockSelf.saveAs];
            
            blockSelf.contactEditViewController.edited = YES;
            //////////////////////////////////////////////////
            dispatch_async(dispatch_get_main_queue(), ^{
                
                [self.saveAsItemSelectViewController dismissAnimated:YES completion:^{
                    
                    [blockSelf.contactEditViewController clearAndFetchData];
                    [blockSelf.contactEditViewController reloadData];
                }];
                self.saveAsItemSelectViewController = nil;

            });
        });
    }
}


//==============================================================================
//
//==============================================================================
- (PPBarViewItemModel *)closeItemModelForSelectItemViewController:(PPSelectItemViewController *)ppSelectItemViewController
{
    PPBarViewItemModel * itemModel = nil;
    PPButton *ppButton =  [PPButton ppButtonWithIconImageName:ImageNamePPButtonIconForSystemBackImitation
                                                          tag:WCCAFC_ButtonTag_SaveAsBack
                                                     delegate:self
                                        normalBackgroundColor:nil
                                   highlightedBackgroundColor:WCAppearanceDefine_ButtonBackgroundColor
                                              imageEdgeInsets:WCAppearanceDefine_ButtonImageEdgeInset];
    
    if (ppButton)
    {
        itemModel = [PPBarViewItemModel ppBarViewItemModelWithView:ppButton];
        itemModel.edgeInsetsForNormalBar = UIEdgeInsetsZero;
    }
    
    return itemModel;
}
#endif





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - WCABItemSelectFlowControllerDelegate


//==============================================================================
//
//==============================================================================
- (void)abSelectFlowController:(WCABItemSelectFlowController *)abSelectFlowController
            fromViewController:(UIViewController *)fromViewController
         didSelectABGroupModel:(WCABGroupModel *)abGroupModel
{
    if(abSelectFlowController.abSelectFlowControllerMode==WCABItemSelectFlowControllerMode_ApToSystemContact)
    {
        self.defaultSourceID = abGroupModel.abSourceID;
        self.defaultGroupID = abGroupModel.abGroupID;
        
        //////////////////////////////////////////////////
        // 更新編輯介面
        NSMutableDictionary *dictionary = [NSMutableDictionary dictionary];
        NSArray *newGroupArray=[self prepareSystemGroupArrayWithCardModel:self.currentEditingCardModel];
        [dictionary setObject:newGroupArray forKey:@(PPContactMainType_SystemGroup)];
        [self.contactEditViewController clearAndUpdateGroupDataFromFieldDictioanry:dictionary];
        
        //////////////////////////////////////////////////
        [fromViewController goBackAnimated:YES];
    }
}


//==============================================================================
//
//==============================================================================
- (void)abSelectFlowController:(WCABItemSelectFlowController *)abSelectFlowController
            fromViewController:(UIViewController *)fromViewController
         didSelectABCardModels:(NSArray *)abCardModels
{
    if(abSelectFlowController.abSelectFlowControllerMode==WCABItemSelectFlowControllerMode_MergeSystemContact)
    {
        // !!選取聯絡人，合併聯絡人才會用到，而且只會選一個
        WCABCardModel *abCardModel = [abCardModels firstObject];
        if(abCardModel)
        {
            // !! 如果沒有打開儲存到系統聯絡人要同時打開
            [PPSettingsController setIntegerValue:1 withKey:WCContactViewController_SettingsKey_EnableSystemContactCategory];
            
            //////////////////////////////////////////////////
            self.defaultSourceID = abCardModel.abSourceID;
            self.defaultGroupID = abCardModel.abGroupID;
            self.defaultPersonID = abCardModel.abPersonID;
            
            // 取得目前編輯界面的資料，再合併選取的聯絡人資料
            NSDictionary *fieldDictionary = [self.contactEditViewController.contactEditSectionController fieldDictionaryFromSectionModelForSearching:NO];
            [self updateCardModel:self.currentEditingCardModel withFieldDictionary:fieldDictionary];
            
            // 日期不用合併
            abCardModel.createdTime = nil;
            [self.currentEditingCardModel combineCard:abCardModel];
            //////////////////////////////////////////////////
            // 更新編輯介面
            NSMutableDictionary *dictionary = [self prepareFieldDictionaryWithCardModel:self.currentEditingCardModel
                                                              forPPContactMainTypeArray:[self prepareMainTypeArrayForEdit:YES]
                                                                                forEdit:YES
                                                                      isShowCustomField:YES
                                                                      isShowGroup:YES
                                                                    isShowSharedAccount:YES];
            [self.contactEditViewController clearAndUpdateContactMainTypeDataFromFieldDictioanry:dictionary];
        }
        
        //////////////////////////////////////////////////
        if (UI_USER_INTERFACE_IDIOM()==UIUserInterfaceIdiomPad)
        {
            if(fromViewController.navigationController)
            {
                
                [fromViewController.navigationController dismissAnimated:YES completion:nil];
            }
            else
            {
                [fromViewController dismissAnimated:YES completion:nil];
            }

        }
        else
        {
            [fromViewController goRootAnimated:YES];
        }
    }
}


//==============================================================================
//
//==============================================================================
- (NSString *)defaultSelectedABGroupIDInABSelectFlowController:(WCABItemSelectFlowController *)abSelectFlowController
{
    if(abSelectFlowController.abSelectFlowControllerMode==WCABItemSelectFlowControllerMode_ApToSystemContact)
    {
        return self.defaultGroupID;
    }
    
    return nil;
}


//==============================================================================
//
//==============================================================================
- (NSString *)defaultSelectedABSourceIDInABSelectFlowController:(WCABItemSelectFlowController *)abSelectFlowController
{
    if(abSelectFlowController.abSelectFlowControllerMode==WCABItemSelectFlowControllerMode_ApToSystemContact)
    {
        return self.defaultSourceID;
    }
    
    return nil;
}


//==============================================================================
//
//==============================================================================
- (void)abSelectFlowControllerFailWithError:(NSError *)error
{
    UIAlertController *alertController = [UIAlertController alertControllerWithTitle:@""
                                                                             message:error.localizedFailureReason
                                                                      preferredStyle:UIAlertControllerStyleAlert];
    
    [alertController addAction:[UIAlertAction actionWithTitle:WCCAFC_Ok
                                                        style:UIAlertActionStyleCancel
                                                      handler:nil]];
    [self.contactEditViewController presentViewController:alertController animated:YES completion:nil];
}




#pragma mark - WCContactEditViewControllerDataSource


//==============================================================================
//
//==============================================================================
- (NSMutableArray *)ppContactMainTypeArrayFetchingDataForWCContactEditViewController:(WCContactEditViewController *)contactEditViewController
{
    return [self prepareMainTypeArrayForEdit:YES];
}


//==============================================================================
//
//==============================================================================
- (NSMutableArray *)ppContactMainTypeArrayFetchingNewSectionFieldDataForWCContactEditViewController:(WCContactEditViewController *)contactEditViewController
{
    return [self prepareHiddenSectionArray];
}


//==============================================================================
//
//==============================================================================
- (NSUInteger)contactEditTableViewCellTextMaxLengthInWCContactEditViewController:(WCContactEditViewController *)contactEditViewController
                                                               ppContactMainType:(PPContactMainType)contactMainType
                                                                  contactSubType:(PPContactSubType)contactSubType
                                                                contactLabelType:(PPContactLabelType)contactLabelType
{
#if defined (PRODUCTLINE_WCT)
    
    switch (contactMainType)
    {
        case PPContactMainType_Name:
        {
            return WCT_FML_Name;
        }
        case PPContactMainType_Company:
        {
            return WCT_FML_Compnay;
        }
        case PPContactMainType_Address:
        {
            if (contactSubType==PPContactSubType_Address_CountryCode)
            {
                return WCT_FML_Address_Code;
            }
            else if (contactSubType==PPContactSubType_Address_Street)
            {
                return WCT_FML_Address_Street;
            }
            else
            {
                return WCT_FML_Address_Normal;
            }
        }
        case PPContactMainType_Phone:
        {
            return WCT_FML_Phone;
        }
        case PPContactMainType_Email:
        {
            return WCT_FML_Email;
        }
        case PPContactMainType_URL:
        {
            return WCT_FML_URL;
        }
        case PPContactMainType_InstantMessage:
        {
            return WCT_FML_IM;
        }
        case PPContactMainType_SocialNetwork:
        {
            return WCT_FML_SN;
        }
        case PPContactMainType_Note:
        {
            return WCT_FML_Note;
        }
        case PPContactMainType_UserDefine:
        {
            if(contactSubType==PPContactSubType_UserDefine_Text)
            {
                return WCT_FML_UserDefine_TextValue;
            }
            else
            {
                return WCT_FML_UserDefine_DefaultValue;
            }
        }
        case PPContactMainType_Other:
        {
            if (contactLabelType==PPContactLabelType_Other_UnifiedBusinessNumber)
            {
                return WCT_FML_UnifiedBusinessNo;
            }
            else if (contactLabelType==PPContactLabelType_Other_NickName)
            {
                return WCT_FML_Nickname;
            }
            else
            {
                return NSUIntegerMax;
            }
        }
        default:
            return NSUIntegerMax;
    }
#else
    return NSUIntegerMax;
#endif
}


//==============================================================================
//
//==============================================================================
- (BOOL)shouldShowPhoneticOnWCContactEditViewController:(WCContactEditViewController *)contactEditViewController
                                        contactMainType:(PPContactMainType)contactMainType
{
    if (contactMainType==PPContactMainType_Name)
    {
        return g_ShouldShowNamePhonetic;
    }
    else if (contactMainType==PPContactMainType_Company)
    {
        return g_ShouldShowCompanyPhonetic;
    }
    else
    {
        return NO;
    }
}


//==============================================================================
//
//==============================================================================
- (BOOL)shouldShowSelectPhoneticMenuOnWCContactEditViewController:(WCContactEditViewController *)contactEditViewController
{
    return g_ShouldShowPhoneticSelection;
}


//==============================================================================
//
//==============================================================================
- (NSMutableArray *)phoneticArrayWithWCContactEditViewController:(WCContactEditViewController *)contactEditViewController
                                                 clickedPhonetic:(NSString *)phonetic
                                                     sourceValue:(NSString *)sourceValue
                                                ppContactSubType:(PPContactSubType)contactSubtype
{
    if ([self.delegate respondsToSelector:@selector(contactAccessFlowController:phoneticArrayWithClickedPhonetic:sourceValue:isCompanyPhonetic:)])
    {
        BOOL isCompanyPhonetic = NO;
        
        if (contactSubtype==PPContactSubType_Company_NamePhonetic)
        {
            isCompanyPhonetic = YES;
        }
        return [self.delegate contactAccessFlowController:self
                         phoneticArrayWithClickedPhonetic:phonetic
                                              sourceValue:sourceValue
                                        isCompanyPhonetic:isCompanyPhonetic];
    }
    
    return nil;
}


//==============================================================================
//
//==============================================================================
- (BOOL)imageExistWithWCContactEditViewController:(WCContactEditViewController *)contactEditViewController
                                ppContactMainType:(PPContactMainType)contactMaintype
{
    NSString *cardID = (NSString *)contactEditViewController.userInfoObject;
    WC_ImageType imageType = [WCFieldTypeConverter imageTypeFromPPContactMainType:contactMaintype];
    
    if ([self.delegate respondsToSelector:@selector(contactAccessFlowController:hasCardImageWithCardID:imageType:)])
    {
        return [self.delegate contactAccessFlowController:self hasCardImageWithCardID:cardID imageType:imageType];
    }
    
    return NO;
}



//==============================================================================
//
//==============================================================================
- (NSMutableArray *)ppContactSubTypeArrayForSortingSectionRowWithPPContactMainType:(PPContactMainType)ppContactMainType
                                                       ppContactEditViewController:(WCContactEditViewController *)contactEditViewController
{
#if defined (PRODUCTLINE_WCSF)
        switch (ppContactMainType)
        {
            case PPContactMainType_Address:
            {
                if(g_ChineseEdtingFormat==YES)
                {
                    return  [NSMutableArray arrayWithArray:@[@(PPContactSubType_Address_Zip),
                                                             @(PPContactSubType_Address_State),
                                                             @(PPContactSubType_Address_City),
                                                             @(PPContactSubType_Address_Street),
                                                             @(PPContactSubType_Address_Country),
                                                             @(PPContactSubType_Address_CountryCode),
                                                             @(PPContactSubType_Address_Format),
                                                             @(PPContactSubType_Address_GPS),
                                                             @(PPContactSubType_Address_RecognitionLanguageCode)]];
                }
                else
                {
                    return nil;
                }
            }
            case PPContactMainType_Name:
            {
                if(g_ChineseEdtingFormat==YES)
                {
                    return  [NSMutableArray arrayWithArray:@[@(PPContactSubType_Name_LastName),
                                                             @(PPContactSubType_Name_FirstName)]];
                }
                else
                {
                    return  [NSMutableArray arrayWithArray:@[@(PPContactSubType_Name_FirstName),
                                                             @(PPContactSubType_Name_LastName)]];
                }
            }
            default:
                return nil;;
        }
#elif defined (PRODUCTLINE_WCO365)
    switch (ppContactMainType)
    {
        case PPContactMainType_Address:
        {
            if(g_ChineseEdtingFormat==YES)
            {
                return  [NSMutableArray arrayWithArray:@[@(PPContactSubType_Address_Zip),
                                                         @(PPContactSubType_Address_State),
                                                         @(PPContactSubType_Address_City),
                                                         @(PPContactSubType_Address_Street),
                                                         @(PPContactSubType_Address_Country),
                                                         @(PPContactSubType_Address_CountryCode),
                                                         @(PPContactSubType_Address_Format),
                                                         @(PPContactSubType_Address_GPS),
                                                         @(PPContactSubType_Address_RecognitionLanguageCode)]];
            }
            else
            {
                return nil;
            }
        }
        case PPContactMainType_Name:
        {
            if(g_ChineseEdtingFormat==YES)
            {
                return  [NSMutableArray arrayWithArray:@[@(PPContactSubType_Name_LastName),
                                                         @(PPContactSubType_Name_LastNamePhonetic),
                                                         @(PPContactSubType_Name_MiddleName),
                                                         @(PPContactSubType_Name_FirstName),
                                                         @(PPContactSubType_Name_FirstNamePhonetic),
                                                         @(PPContactSubType_Name_Surffix)]];
            }
            else
            {
                return  [NSMutableArray arrayWithArray:@[@(PPContactSubType_Name_FirstName),
                                                         @(PPContactSubType_Name_FirstNamePhonetic),
                                                         @(PPContactSubType_Name_MiddleName),
                                                         @(PPContactSubType_Name_LastName),
                                                         @(PPContactSubType_Name_LastNamePhonetic),
                                                         @(PPContactSubType_Name_Surffix)]];
            }
        }
        default:
            return nil;;
    }
#else
    if(g_ChineseEdtingFormat==YES)
    {
        switch (ppContactMainType)
        {
            case PPContactMainType_Address:
            {
                return  [NSMutableArray arrayWithArray:@[@(PPContactSubType_Address_Zip),
                                                         @(PPContactSubType_Address_State),
                                                         @(PPContactSubType_Address_City),
                                                         @(PPContactSubType_Address_Street),
                                                         @(PPContactSubType_Address_Country),
                                                         @(PPContactSubType_Address_CountryCode),
                                                         @(PPContactSubType_Address_Format),
                                                         @(PPContactSubType_Address_GPS),
                                                         @(PPContactSubType_Address_RecognitionLanguageCode)]];
            }
            case PPContactMainType_Name:
            {
                return  [NSMutableArray arrayWithArray:@[@(PPContactSubType_Name_LastName),
                                                         @(PPContactSubType_Name_LastNamePhonetic),
                                                         @(PPContactSubType_Name_MiddleName),
                                                         @(PPContactSubType_Name_FirstName),
                                                         @(PPContactSubType_Name_FirstNamePhonetic),
                                                         @(PPContactSubType_Name_Prefix),
                                                         @(PPContactSubType_Name_Surffix)]];
            }
            default:
                return nil;;
        }
    }
    else
    {
        switch (ppContactMainType)
        {
            case PPContactMainType_Address:
            {
                return  [NSMutableArray arrayWithArray:@[@(PPContactSubType_Address_Zip),
                                                         @(PPContactSubType_Address_State),
                                                         @(PPContactSubType_Address_City),
                                                         @(PPContactSubType_Address_Street),
                                                         @(PPContactSubType_Address_Country),
                                                         @(PPContactSubType_Address_CountryCode),
                                                         @(PPContactSubType_Address_Format),
                                                         @(PPContactSubType_Address_GPS),
                                                         @(PPContactSubType_Address_RecognitionLanguageCode)]];
            }
            case PPContactMainType_Name:
            {
                return  [NSMutableArray arrayWithArray:@[@(PPContactSubType_Name_FirstName),
                                                         @(PPContactSubType_Name_FirstNamePhonetic),
                                                         @(PPContactSubType_Name_MiddleName),
                                                         @(PPContactSubType_Name_LastName),
                                                         @(PPContactSubType_Name_LastNamePhonetic),
                                                         @(PPContactSubType_Name_Prefix),
                                                         @(PPContactSubType_Name_Surffix)]];
            }
            default:
                return nil;;
        }
    }
#endif

}





////////////////////////////////////////////////////////////////////////////////////////////////////


#pragma mark - WCContactViewControllerDelegate


//==============================================================================
//
//==============================================================================
- (BOOL)cardIDExistInWCContactViewEditViewController:(NSString *)cardID
{
    if ([self.delegate respondsToSelector:@selector(contactAccessFlowController:isCardIDExist:)])
    {
        return [self.delegate contactAccessFlowController:self isCardIDExist:cardID];
    }
    
    return NO;
}


//===============================================================================
//
//===============================================================================
- (void)contactEditViewController:(WCContactEditViewController *)contactEditViewController action:(WCContactEditViewControllerAction)action
{
#if DEBUG
    NSLog(@"%s - %ld - %@", __PRETTY_FUNCTION__, (unsigned long)action, self.isEditFinishedComplete?@"YES":@"NO");
#endif
    
    __block typeof(self) blockSelf = self;
    
    dispatch_async(dispatch_get_main_queue(), ^{
        switch (action)
        {
            case WCContactEditViewControllerAction_AlbumPhotoForHeadImage:
            {
                [WCImagePickerController showAlbumFromViewController:contactEditViewController completion:^(UIImage *pickedImage) {
                    //!!要等picker結束再present新的，所以再dispatch一次
                    dispatch_async(dispatch_get_main_queue(), ^{
                        [WCIDPhotoClipViewController showFromViewController:contactEditViewController sourceImage:pickedImage completion:^(UIImage *idPhotoImage) {
                            [contactEditViewController setImage:idPhotoImage forPPContactMainType:PPContactMainType_HeadImage ppContactSubType:PPContactSubType_HeadImage_Original];
                        }];
                    });
                }];
                break;
            }
            case WCContactEditViewControllerAction_CameraForHeadImage:
            {
                [WCImagePickerController showSystemCameraFromViewController:contactEditViewController completion:^(UIImage *pickedImage) {
                    dispatch_async(dispatch_get_main_queue(), ^{
                        [WCIDPhotoClipViewController showFromViewController:contactEditViewController sourceImage:pickedImage completion:^(UIImage *idPhotoImage) {
                            [contactEditViewController setImage:idPhotoImage forPPContactMainType:PPContactMainType_HeadImage ppContactSubType:PPContactSubType_HeadImage_Original];
                        }];
                    });
                }];
                break;
            }
            case WCContactEditViewControllerAction_ClipCardImageForHeadImage:
            {
                UIImage *imageToClip = [contactEditViewController imageForPPContactMainType:PPContactMainType_FrontCardImage ppContactSubType:PPContactSubType_FrontCardImage_Original];
                if (imageToClip)
                {
                    [WCIDPhotoClipViewController showFromViewController:contactEditViewController sourceImage:imageToClip completion:^(UIImage *idPhotoImage) {
                        [contactEditViewController setImage:idPhotoImage forPPContactMainType:PPContactMainType_HeadImage ppContactSubType:PPContactSubType_HeadImage_Original];
                    }];
                }
                break;
            }
            case WCContactEditViewControllerAction_AlbumPhotoForFrontCardImage:
            {
                [WCImagePickerController showAlbumFromViewController:contactEditViewController completion:^(UIImage *pickedImage) {
                    [contactEditViewController setImage:pickedImage forPPContactMainType:PPContactMainType_FrontCardImage ppContactSubType:PPContactSubType_FrontCardImage_Original];
                    // !! 更換名片圖後要清除rect
                    [contactEditViewController clearCardImageRectForPPContactFieldSource:PPContactFieldSource_FrontSide];
                }];
                break;
            }
            case WCContactEditViewControllerAction_CameraForFrontCardImage:
            {
                [WCImagePickerController showCameraFromViewController:contactEditViewController completion:^(UIImage *pickedImage) {
                    [contactEditViewController setImage:pickedImage forPPContactMainType:PPContactMainType_FrontCardImage ppContactSubType:PPContactSubType_FrontCardImage_Original];
                    // !! 更換名片圖後要清除rect
                    [contactEditViewController clearCardImageRectForPPContactFieldSource:PPContactFieldSource_FrontSide];
                }];
                break;
            }
            case WCContactEditViewControllerAction_AlbumPhotoForRearCardImage:
            {
                [WCImagePickerController showAlbumFromViewController:contactEditViewController completion:^(UIImage *pickedImage) {
                    [contactEditViewController setImage:pickedImage forPPContactMainType:PPContactMainType_BackCardImage ppContactSubType:PPContactSubType_BackCardImage_Original];
                    // !! 更換名片圖後要清除rect
                    [contactEditViewController clearCardImageRectForPPContactFieldSource:PPContactFieldSource_BackSide];
                }];
                break;
            }
            case WCContactEditViewControllerAction_CameraForRearCardImage:
            {
                [WCImagePickerController showCameraFromViewController:contactEditViewController completion:^(UIImage *pickedImage) {
                    [contactEditViewController setImage:pickedImage forPPContactMainType:PPContactMainType_BackCardImage ppContactSubType:PPContactSubType_BackCardImage_Original];
                    // !! 更換名片圖後要清除rect
                    [contactEditViewController clearCardImageRectForPPContactFieldSource:PPContactFieldSource_BackSide];
                }];
                break;
            }
                
            case WCContactEditViewControllerAction_ShowBrowse:
            {
                break;
            }
            case WCContactEditViewControllerAction_ChangeGroup:
            {
                [blockSelf onClickChangeGroup:contactEditViewController cardID:contactEditViewController.userInfoObject];
                break;
            }
            case WCContactEditViewControllerAction_ClickFrontCardImage:
            {
                break;
            }
            case WCContactEditViewControllerAction_ClickRearCardImage:
            {
                break;
            }
            case WCContactEditViewControllerAction_ClickRecognizeCardImage:
            {
                break;
            }
                
            case WCContactEditViewControllerAction_DeleteContacter:
            {
                if ([blockSelf.delegate respondsToSelector:@selector(contactAccessFlowController:action:withCardID:error:)])
                {
                    [blockSelf.delegate contactAccessFlowController:blockSelf action:WCContactFlowControllerAction_Delete withCardID:contactEditViewController.userInfoObject error:nil];
                    
                    //////////////////////////////////////////////////
                    [contactEditViewController goBackAnimated:NO];
                    blockSelf.currentEditingCardModel = nil;
                    blockSelf.contactEditViewController = nil;
                    [blockSelf.contactInfoScrollViewController goBackAnimated:YES];
                    blockSelf.contactInfoScrollViewController = nil;
                }
                
                break;
            }
            case WCContactEditViewControllerAction_EditFinishedSuccessfully: //編輯成功
            {
                // 前一個還沒結束前，不能做第二個
                if(blockSelf.isEditFinishedComplete==NO)
                {
                    break;
                }
                
                blockSelf.isEditFinishedComplete = NO;
                //////////////////////////////////////////////////
                // 編輯成功要reload contact info
                [self.contactInfoScrollViewController clearContactInformationInCurrentPage];
                
                __block typeof(self) blockSelf = self;
                
                dispatch_async(dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_DEFAULT, 0), ^{
                    
                    BOOL actionResult = NO;
                    if([blockSelf.delegate respondsToSelector:@selector(contactAccessFlowController:action:withCardID:error:)]==YES)
                    {
                        actionResult = [blockSelf.delegate contactAccessFlowController:blockSelf
                                                                                action:WCContactFlowControllerAction_EditSuccessful
                                                                            withCardID:contactEditViewController.userInfoObject
                                                                                 error:nil];
                    }
                    
                    if(actionResult)
                    {
                        BOOL enableSaveToiPhoneContact = [PPSettingsController integerValueWithKey:WCContactViewController_SettingsKey_EnableSystemContactCategory];
                        
                        // 如果不用存，default設回-1
                        if (enableSaveToiPhoneContact==YES)
                        {
                            // 有開啟儲存到系統聯絡人
                            
                            if([PPSettingsController integerValueWithKey:WCContactAccessFlowController_SettingsKey_ShowExportLimitationAlert])
                            {
                                // 等頁面出現後再顯示toast所以等0.3秒
                                dispatch_after(dispatch_time(DISPATCH_TIME_NOW, (int64_t)(0.3 * NSEC_PER_SEC)), dispatch_get_main_queue(), ^{
                                    [WCToastController showMessageToastFromSuperView:[UIApplication sharedApplication].keyWindow
                                                                         withMessage:WCCAFC_ExportLimitationAlert
                                                                messageTextAlignment:NSTextAlignmentLeft
                                                                            position:PPToastPositionCenter];
                                });
                            }
                        }
                        blockSelf.currentEditingCardModel = nil;
                    }

                    blockSelf.isEditFinishedComplete = YES;
                });


                break;
            }
            case WCContactEditViewControllerAction_EditFinishedWithNoChangeData:
            {
                // !! 因為資料沒有變更，所以直接用self.currentEditingCardModel就好
                if ([self.delegate respondsToSelector:@selector(contactAccessFlowController:updateCardModel:withABSourceID:abGroupID:abPersonID:error:)])
                {
                    self.currentEditingCardModel.modifiedTime = [NSDate date];
                    // !! 從編輯儲存要設為已校正
                    self.currentEditingCardModel.tagMask &= ~WC_TagMask_Unverified;
                    
                    BOOL enableSaveToiPhoneContact = [PPSettingsController integerValueWithKey:WCContactViewController_SettingsKey_EnableSystemContactCategory];
                    
                    // 如果不用存，default設回-1
                    if (enableSaveToiPhoneContact==NO)
                    {
                        self.defaultSourceID = nil;
                        self.defaultGroupID = nil;
                        self.defaultPersonID = nil;
                    }
                    else
                    {
                        // 有開啟儲存到系統聯絡人
                        
                        if([PPSettingsController integerValueWithKey:WCContactAccessFlowController_SettingsKey_ShowExportLimitationAlert])
                        {
                            // 等頁面出現後再顯示toast所以等0.3秒
                            dispatch_after(dispatch_time(DISPATCH_TIME_NOW, (int64_t)(0.3 * NSEC_PER_SEC)), dispatch_get_main_queue(), ^{
                                [WCToastController showMessageToastFromSuperView:[UIApplication sharedApplication].keyWindow
                                                                     withMessage:WCCAFC_ExportLimitationAlert
                                                            messageTextAlignment:NSTextAlignmentLeft
                                                                        position:PPToastPositionCenter];
                            });
                        }
                    }
                    [self.delegate contactAccessFlowController:self updateCardModel:self.currentEditingCardModel withABSourceID:self.defaultSourceID abGroupID:self.defaultGroupID abPersonID:self.defaultPersonID error:nil];
                }
                
                //////////////////////////////////////////////////
                // 編輯成功要reload contact info
                [self.contactInfoScrollViewController clearContactInformationInCurrentPage];
                
                BOOL actionResult = NO;
                if([blockSelf.delegate respondsToSelector:@selector(contactAccessFlowController:action:withCardID:error:)]==YES)
                {
                    actionResult = [blockSelf.delegate contactAccessFlowController:blockSelf
                                                                            action:WCContactFlowControllerAction_EditSuccessful
                                                                        withCardID:contactEditViewController.userInfoObject
                                                                             error:nil];
                }
                
                if (actionResult)
                {
                    blockSelf.currentEditingCardModel = nil;
                }
                break;
            }
            case WCContactEditViewControllerAction_EditFinishedWithEmptyDataAndImage:
            {
                [PPAlertView showWithStyle:UIAlertViewStyleDefault
                                     title:@""
                                   message:[@"MLS_SaveFailed" localized]
                         cancelButtonTitle:WCCAFC_Ok
                         otherButtonTitles:nil];
                
                break;
            }
            case WCContactEditViewControllerAction_GoBack:
            case WCContactEditViewControllerAction_GiveUpSavingContacter:
            {
                BOOL actionResult = NO;
                if([blockSelf.delegate respondsToSelector:@selector(contactAccessFlowController:action:withCardID:error:)]==YES)
                {
                    actionResult = [blockSelf.delegate contactAccessFlowController:blockSelf
                                                                            action:WCContactFlowControllerAction_GoBack
                                                                        withCardID:contactEditViewController.userInfoObject
                                                                             error:nil];
                }
                
                if (actionResult)
                {
#if defined (PRODUCTLINE_WCSF)
                    // !! salesforce版本會有儲存到salesforce失敗而停在編輯頁面
                    // 這時需要更新info
                    //////////////////////////////////////////////////
                    // 編輯成功要reload contact info
                    [self.contactInfoScrollViewController clearContactInformationInCurrentPage];
#endif
                    blockSelf.currentEditingCardModel = nil;
                }
                break;
            }
            case WCContactEditViewControllerAction_NonSaveContacterToSystem:
            {
                break;
            }
            case WCContactEditViewControllerAction_SaveContacterToSystem:
            {
                break;
            }
            case WCContactEditViewControllerAction_ChangeSystemGroup:
            {
                [blockSelf onClickChangeSystemGroup:contactEditViewController cardID:contactEditViewController.userInfoObject];
                break;
            }
            case WCContactEditViewControllerAction_ChangeVisibleAccount:
            {
                [blockSelf onClickChangeVisibleAccount:contactEditViewController cardID:contactEditViewController.userInfoObject];
                break;
            }
                
            case WCContactEditViewControllerAction_MergeiPhoneContact:
            {
                [blockSelf onClickMergeiPhoneContactsFromViewController:contactEditViewController];
                break;
            }
            case WCContactEditViewControllerAction_HandClipForFrontCard:
            case WCContactEditViewControllerAction_HandClipForRearCard:
            {
                // 手括辨識
                [self showClipRecognizeFromContactViewController:contactEditViewController showBackCardImage:(action==WCContactEditViewControllerAction_HandClipForRearCard)?YES:NO];
                break;
            }
            case WCContactEditViewControllerAction_ChangeSalesforceTarget:
            {
                [self onClickChangeSalesforceTartet:contactEditViewController fieldDictioanry:[contactEditViewController curTextFieldDictionary]];
                break;
            }
            case WCContactEditViewControllerAction_ContinueEdit:
            {
                // salesforces繼續編輯
                [self onClickContinueEditWithViewController:contactEditViewController];
                break;
            }
            default:
                break;
        }
        
    });
}


//===============================================================================
//
//===============================================================================
- (BOOL)contactEditViewControllerCouldEditHeadImage:(WCContactEditViewController *)contactEditViewController
{
    return YES;
}


//==============================================================================
//
//==============================================================================
- (BOOL)contactEditViewControllerWillSendDataWithEditFinished:(WCContactEditViewController *)contactEditViewController
{
    // !! WCM7.0.1後可以同步，所以不用擋了
    // 只有大頭貼也不能存
    //    if (![contactEditViewController validTextData] &&
    //        [contactEditViewController imageForPPContactMainType:PPContactMainType_FrontCardImage ppContactSubType:PPContactSubType_FrontCardImage_Original]==nil &&
    //        [contactEditViewController imageForPPContactMainType:PPContactMainType_BackCardImage ppContactSubType:PPContactSubType_BackCardImage_Original]==nil &&
    //        [contactEditViewController imageForPPContactMainType:PPContactMainType_HeadImage ppContactSubType:PPContactSubType_HeadImage_Original]!=nil)
    //    {
    //        [PPAlertView showWithStyle:UIAlertViewStyleDefault
    //                             title:@""
    //                           message:[@"MLS_SaveFailed" localized]
    //                 cancelButtonTitle:WCCAFC_Ok
    //                 otherButtonTitles:nil];
    //        return NO;
    //    }
    return YES;
}




////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - ContactDataExchangeProtocol


//===============================================================================
//
//===============================================================================
- (UIImage *)sender:(id)sender imageForPPContactMainType:(PPContactMainType)contactMainType ppContactSubType:(PPContactSubType)contactSubType
{
    WCContactEditViewController *contactEditViewController = (WCContactEditViewController *)sender;
    NSString *cardID = contactEditViewController.userInfoObject;
    
    if (!cardID)
    {
        return nil;
    }
    
    if (contactSubType==PPContactSubType_FrontCardImage_Default)
    {
        return [[self copyDefaultCardImageWithCardID:cardID] autorelease];
    }
    else
    {
        WC_ImageType imageType = [WCFieldTypeConverter imageTypeFromPPContactMainType:contactMainType];
        UIImage *image = [self prepareCardImageWithCardID:cardID imageType:imageType];
        return image;
    }
}


//===============================================================================
//
//===============================================================================
- (NSDictionary *)sender:(id)sender fieldDictionaryforPPContactMainTypeArray:(NSArray *)contactMainTypeArray
{
    WCContactEditViewController *contactEditViewController = (WCContactEditViewController *)sender;
    
    BOOL isCardExist = NO;
    
    
    if ([self.delegate respondsToSelector:@selector(contactAccessFlowController:isCardIDExist:)])
    {
        isCardExist = [self.delegate contactAccessFlowController:self isCardIDExist:contactEditViewController.userInfoObject];
    }
    
    if (isCardExist)
    {
        if (self.currentEditingCardModel==nil && [self.delegate respondsToSelector:@selector(contactAccessFlowController:cardModelWithCardID:)])
        {
            self.currentEditingCardModel = [self.delegate contactAccessFlowController:self cardModelWithCardID:contactEditViewController.userInfoObject];
        }
        
        if (self.currentEditingCardModel)
        {
            if([self.delegate respondsToSelector:@selector(selfAccountGuidWithContactAccessFlowController:)])
            {
                self.selfAccountGuid = [self.delegate selfAccountGuidWithContactAccessFlowController:self];
                
                if ([self.selfAccountGuid length]>0)
                {
                    self.currentEditingCardModel.editor = self.selfAccountGuid;
                }
            }
            BOOL isEditingMyCard = (contactEditViewController.contactEditViewControllerLayout==WCContactEditViewControllerLayout_MyCard);
            BOOL isHelpScan = (contactEditViewController.contactEditViewControllerLayout==WCContactEditViewControllerLayout_HelpScan);
            return [self prepareFieldDictionaryWithCardModel:self.currentEditingCardModel
                                   forPPContactMainTypeArray:contactMainTypeArray
                                                     forEdit:YES
                                           isShowCustomField:!isEditingMyCard
                                                 isShowGroup:(!isEditingMyCard&&!isHelpScan)
                                         isShowSharedAccount:(!isEditingMyCard&&!isHelpScan)];
        }
    }
    
    return nil;
}


//===============================================================================
//
//===============================================================================
- (BOOL)sender:(id)sender setImage:(UIImage *)image forPPContactMainType:(PPContactMainType)contactMainType error:(NSError **)error
{
    if ([self.delegate respondsToSelector:@selector(contactAccessFlowController:updateCardImage:withCardID:imageType:error:)])
    {
        WC_ImageType imageType = [WCFieldTypeConverter imageTypeFromPPContactMainType:contactMainType];
        
        NSError *returnError = nil;
        [self.delegate contactAccessFlowController:self updateCardImage:image withCardID:self.contactEditViewController.userInfoObject imageType:imageType error:&returnError];
        
#if defined (PRODUCTLINE_WCSF)
        // !! salesforce才要回傳錯誤
        if (error!=NULL)
        {
            *error = returnError;
        }
        
        return (returnError==nil);
#else
        return YES;
#endif
    }
    return NO;
}


//===============================================================================
//
//===============================================================================
- (BOOL)sender:(id)sender setFieldsDictionary:(NSDictionary *)fieldDictionary error:(NSError **)error
{
    BOOL result=YES;
    if ([self.delegate respondsToSelector:@selector(contactAccessFlowController:updateCardModel:withABSourceID:abGroupID:abPersonID:error:)])
    {
        self.currentEditingCardModel.modifiedTime = [NSDate date];
        
#if defined (PRODUCTLINE_WCSF) || defined (PRODUCTLINE_WCO365)
        NSDictionary *validDictianry = [self cleanNonValidFieldWithFieldDictionary:fieldDictionary];
        [self updateCardModel:self.currentEditingCardModel withFieldDictionary:validDictianry];
#else
        [self updateCardModel:self.currentEditingCardModel withFieldDictionary:fieldDictionary];
#endif
        // !! 從編輯儲存要設為已校正
        self.currentEditingCardModel.tagMask &= ~WC_TagMask_Unverified;
        
        BOOL enableSaveToiPhoneContact = [PPSettingsController integerValueWithKey:WCContactViewController_SettingsKey_EnableSystemContactCategory];
        
        // 如果不用存，default設回-1
        if (enableSaveToiPhoneContact==NO)
        {
            self.defaultSourceID = nil;
            self.defaultGroupID = nil;
            self.defaultPersonID = nil;
        }
        
        NSError *returnError = nil;
        [self.delegate contactAccessFlowController:self updateCardModel:self.currentEditingCardModel withABSourceID:self.defaultSourceID abGroupID:self.defaultGroupID abPersonID:self.defaultPersonID error:&returnError];
        
#if defined (PRODUCTLINE_WCSF) || defined (PRODUCTLINE_WCO365)
        // !! salesforce才要回傳錯誤
        if (error!=NULL)
        {
            *error = returnError;
        }
        
        return (returnError==nil);
#else
        return result;
#endif
    }
    return result;
}


//==============================================================================
//
//==============================================================================
- (BOOL)sender:(id)sender setFavorite:(BOOL)favorite error:(NSError **)error
{
    if ([sender isKindOfClass:[WCContactEditViewController class]])
    {
        if(favorite)
        {
            self.currentEditingCardModel.tagMask |= WC_TagMask_Favorite;
        }
        else
        {
            self.currentEditingCardModel.tagMask &= ~WC_TagMask_Favorite;
        }
        return YES;
    }
    return NO;
}


//==============================================================================
//
//==============================================================================
- (BOOL)favoriteWithSender:(id)sender
{
    if ([sender isKindOfClass:[WCContactEditViewController class]])
    {
        NSString *cardID = (NSString *)[(WCContactEditViewController *)sender userInfoObject];
        if ([self.delegate respondsToSelector:@selector(contactAccessFlowController:isFavoriteWithCardID:)])
        {
            return [self.delegate contactAccessFlowController:self isFavoriteWithCardID:cardID];
        }
    }
    
    return NO;
}




////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - contact edit methods


//==============================================================================
//
//==============================================================================
- (void)showContactEditFromViewController:(UIViewController *)viewController
                                   cardID:(NSString *)cardID
                                 delegate:(id<WCContactAccessFlowControllerDelegate>)delegate
           contacEditViewControllerLayout:(WCContactEditViewControllerLayout)contacEditViewControllerLayout
                                   manual:(BOOL)manual
{
    if (viewController==nil)
    {
        return;
    }
    
    //////////////////////////////////////////////////
    
    self.delegate = delegate;

    // !! 設為YES才能儲存
    self.isEditFinishedComplete = YES;
    //////////////////////////////////////////////////
    
    WCContactEditViewController *contactEditViewController = [[WCContactEditViewController alloc] init];
    if (contactEditViewController)
    {
        self.contactEditViewController = contactEditViewController;

        // set delegate
        contactEditViewController.delegate = self;
        contactEditViewController.dataSource = self;
        contactEditViewController.contactDataExchangeProtocol  = self;
        
        // !! 儲存cardID
        contactEditViewController.userInfoObject = cardID;
        
        [contactEditViewController setWCContactEditViewControllerLayout:contacEditViewControllerLayout];
        
        //!! 設定編輯介面的呈現方式，ipad, iphone不同
        if(UI_USER_INTERFACE_IDIOM()==UIUserInterfaceIdiomPad)
        {
            contactEditViewController.ppInterfaceOrientationController.mask = PPInterfaceOrientationControllerMask_LandscapeLeft|PPInterfaceOrientationControllerMask_LandscapeRight;
        }
        else
        {
            contactEditViewController.ppInterfaceOrientationController.mask = PPInterfaceOrientationControllerMask_Portrait;
        }
        
        if ([self.delegate respondsToSelector:@selector(appendCountryCodeWithContactAccessFlowController:)])
        {
            contactEditViewController.phoneAppendCountryCode = [self.delegate appendCountryCodeWithContactAccessFlowController:self];
        }
        
        if ([self.delegate respondsToSelector:@selector(autoFormatPhoneNumberWithContactAccessFlowController:)])
        {
            contactEditViewController.phoneAutoFormat = [self.delegate autoFormatPhoneNumberWithContactAccessFlowController:self];
        }
        
        if ([self.delegate respondsToSelector:@selector(showAddAndReplaceCardImageInEditViewControllerWithContactAccessFlowController:)])
        {
            contactEditViewController.hideAddOrFlipContactCardButton = ![self.delegate showAddAndReplaceCardImageInEditViewControllerWithContactAccessFlowController:self];
        }
        
        //////////////////////////////////////////////////
        // 設定是否儲存到系統聯絡人的值
        BOOL enableSaveToiPhoneContact = NO;
        if ([self.delegate respondsToSelector:@selector(contactAccessFlowControllerRequestEnableSaveToiPhoneContact:)])
        {
            enableSaveToiPhoneContact = [self.delegate contactAccessFlowControllerRequestEnableSaveToiPhoneContact:self];
        }
        
        [PPSettingsController setIntegerValue:enableSaveToiPhoneContact withKey:WCContactViewController_SettingsKey_EnableSystemContactCategory];
        
        if ([self.delegate respondsToSelector:@selector(contactAccessFlowControllerRequestDefaultABSourceID:)])
        {
            self.defaultSourceID = [self.delegate contactAccessFlowControllerRequestDefaultABSourceID:self];
        }
        
        if ([self.delegate respondsToSelector:@selector(contactAccessFlowControllerRequestDefaultABGroupID:)])
        {
            self.defaultGroupID = [self.delegate contactAccessFlowControllerRequestDefaultABGroupID:self];
        }
        
        if ([self.delegate respondsToSelector:@selector(contactAccessFlowControllerRequestGoogleSyncAccount:)])
        {
            self.googleSyncAccount = [self.delegate contactAccessFlowControllerRequestGoogleSyncAccount:self];
            contactEditViewController.syncAccountName = self.googleSyncAccount;
        }
        
        UIImage *defaultImage = [[self copyDefaultCardImageWithCardID:cardID] autorelease];
        [contactEditViewController setImage:defaultImage forPPContactMainType:PPContactMainType_FrontCardImage ppContactSubType:PPContactSubType_FrontCardImage_Default];
        
        //////////////////////////////////////////////////
        if(manual==NO)
        {
            // !!new card flow, 在非手動新增要先塞圖片
            if(contacEditViewControllerLayout==WCContactEditViewControllerLayout_Add)
            {
                UIImage *frontImage = [self prepareCardImageWithCardID:cardID imageType:WC_IT_FrontSide];
                [contactEditViewController setImage:frontImage forPPContactMainType:PPContactMainType_FrontCardImage ppContactSubType:PPContactSubType_FrontCardImage_Original];
                
                UIImage *backImage = [self prepareCardImageWithCardID:cardID imageType:WC_IT_BackSide];
                [contactEditViewController setImage:backImage forPPContactMainType:PPContactMainType_BackCardImage ppContactSubType:PPContactSubType_BackCardImage_Original];
                
                UIImage *idPhoto = [self prepareCardImageWithCardID:cardID imageType:WC_IT_IDPhoto];
                [contactEditViewController setImage:idPhoto forPPContactMainType:PPContactMainType_HeadImage ppContactSubType:PPContactSubType_HeadImage_Original];
            }
        }

        //////////////////////////////////////////////////
        // !! 編輯時要先取得saveAs，不然會來不及
#if defined (PRODUCTLINE_WCSF)
        if ([self.delegate respondsToSelector:@selector(salesforceSaveAsWithContactAccessFlowController:cardID:)])
        {
            self.saveAs = [self.delegate salesforceSaveAsWithContactAccessFlowController:self cardID:cardID];
        }
        
        if(self.saveAs==WC_SF_SaveAs_None)
        {
            NSArray *saveAsArray = [self supportedSaveAsArray];
            self.saveAs = [[saveAsArray firstObject] integerValue];
        }
#endif

        //////////////////////////////////////////////////
        
        [contactEditViewController clearAndFetchData];
        
        //////////////////////////////////////////////////
        
        PPNavigationController *navigationController = [[PPNavigationController alloc] initWithRootViewController:contactEditViewController];
        
        if(navigationController!=nil)
        {
            [viewController presentViewController:navigationController animated:YES completion:^{
            }];
        }
        
        [contactEditViewController release];
        [navigationController release];
    }
}


//==============================================================================
//
//==============================================================================
- (void)dismissContactEditViewControllerAnimated:(BOOL)animated
{
    [self.contactEditViewController goBackAnimated:animated];
    self.contactEditViewController.dataSource = nil;
    self.contactEditViewController.delegate = nil;
    self.contactEditViewController = nil;
}






////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - ##################################
#pragma mark common use delegate

#pragma mark - WCGroupAccessFlowControllerDelegate


//==============================================================================
//
//==============================================================================
- (NSMutableArray *)sourceGroupArrayForGroupAccessFlowController:(WCGroupAccessFlowController *)groupAccessFlowController error:(NSError **)error
{
    return [self allGroupModels];
}

//==============================================================================
//
//==============================================================================
- (BOOL)groupAccessFlowController:(WCGroupAccessFlowController *)groupAccessFlowController requestIsExistGroupNamed:(NSString *)groupNamed
{
    if ([self.delegate respondsToSelector:@selector(contactAccessFlowController:isExistGroupNamed:)])
    {
        return [self.delegate contactAccessFlowController:self isExistGroupNamed:groupNamed];
    }
    return NO;
}

//==============================================================================
//
//==============================================================================
- (WCGroupModel *)groupAccessFlowController:(WCGroupAccessFlowController *)groupAccessFlowController
            requestGroupModelByNewGroupName:(NSString *)groupName
                             superGroupGuid:(NSString *)superGroupGuid
                                      error:(NSError **)error
{
    if ([self.delegate respondsToSelector:@selector(contactAccessFlowController:groupModelByNewGroupName:)])
    {
        return [self.delegate contactAccessFlowController:self groupModelByNewGroupName:groupName];
    }
    return nil;
}

//==============================================================================
//
//==============================================================================
- (NSArray *)selectedGroupArrayForGroupAccessFlowController:(WCGroupAccessFlowController *)groupAccessFlowController error:(NSError **)error
{
    return [self selectedGroupModelsWithCardID:groupAccessFlowController.userInfo];
}


//==============================================================================
//
//==============================================================================
- (void)groupAccessFlowController:(WCGroupAccessFlowController *)groupAccessFlowController groupsDidSelected:(NSArray *)groupArray
{
    [self groupDidSelectedArray:groupArray infoCardID:groupAccessFlowController.userInfo];
}


//==============================================================================
//
//==============================================================================
- (NSError *)groupAccessFlowController:(WCGroupAccessFlowController *)groupAccessFlowController didFinishViewController:(UIViewController *)viewController
{
#if defined (PRODUCTLINE_WCT)
    [viewController goBackAnimated:YES];
#endif
    return nil;
}




////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - WCAccountSelectViewControllerDelegate Method

// for WCT
#if defined(PRODUCTLINE_WCT)

//================================================================================
//
//================================================================================
- (NSArray *)allAccountListForAccountSelectViewController:(WCTAccountSelectViewController *)accountSelectViewController
{
    // 所有帳號列表
    if ([self.delegate respondsToSelector:@selector(allAccountsWithContactAccessFlowController:)])
    {
        WCCardModel *currentCardModel = nil;
        NSMutableArray *accountToBeShared = [NSMutableArray array];
        NSArray *allAccounts = [self.delegate allAccountsWithContactAccessFlowController:self];
        
        if (self.contactEditViewController)
        {
            // 編輯
            currentCardModel = self.currentEditingCardModel;
        }
        else
        {
            // 檢視
            if ([self.delegate respondsToSelector:@selector(contactAccessFlowController:cardModelWithCardID:)])
            {
                currentCardModel = [self.delegate contactAccessFlowController:self cardModelWithCardID:accountSelectViewController.userInfo];
            }
        }
        
        // 要過濾掉自已, boss及已選取的人
        for (WCTAccountRelationModel *relationModel in allAccounts)
        {
            if([[currentCardModel sharedAccountGUIDArray] containsObject:relationModel.guid]==NO &&
               (relationModel.relation!=WCTAccountRelationModel_Relation_Boss) &&
               [[currentCardModel owner] isEqualToString:relationModel.guid]==NO)
            {
                [accountToBeShared addObject:relationModel];
            }
        }
        return accountToBeShared;
    }
    return nil;
}


//================================================================================
//
//================================================================================
- (NSArray *)selectedAccountGuidListForAccountSelectViewController:(WCTAccountSelectViewController *)accountSelectViewController
{
    // !! 已可檢視的用戶不用顯示了
    return nil;
    // 回傳目前的可檢視用戶
    //    NSMutableArray *adjustedAccountGuids = [NSMutableArray array];
    //
    //    // 加入自已
    //    if (self.selfAccountGuid)
    //    {
    //        [adjustedAccountGuids addObject:self.selfAccountGuid];
    //    }
    //
    //    // 加入主管
    //    if (self.bossAccountGuid)
    //    {
    //        [adjustedAccountGuids addObject:self.bossAccountGuid];
    //    }
    //
    //
    //    if (self.contactEditViewController)
    //    {
    //        // 編輯
    //        NSArray *orinalAccountGuid =  [self.currentEditingCardModel sharedAccountGUIDArray];
    //
    //        [adjustedAccountGuids addObjectsFromArray:orinalAccountGuid];
    //
    //    }
    //    else
    //    {
    //        // 檢視
    //        if ([self.delegate respondsToSelector:@selector(contactAccessFlowController:requestSharedAccountGuidWithCardID:)])
    //        {
    //            // 其他
    //            NSArray *orinalAccountGuid =  [self.delegate contactAccessFlowController:self requestSharedAccountGuidWithCardID:accountSelectViewController.userInfo];
    //
    //            [adjustedAccountGuids addObjectsFromArray:orinalAccountGuid];
    //
    //
    //        }
    //
    //    }
    //
    //    return adjustedAccountGuids;
}


//================================================================================
//
//================================================================================
- (NSString *)ownerAccountGuidForAccountSelectViewController:(WCTAccountSelectViewController *)accountSelectViewController
{
    // !! 不用顯示owner了
    return nil;
    // 回傳擁有者的account guid
    //    if (self.contactEditViewController)
    //    {
    //        // 編輯
    //        return [self.currentEditingCardModel owner];
    //    }
    //    else
    //    {
    //        // 檢視
    //        if ([self.delegate respondsToSelector:@selector(contactAccessFlowController:requestOwnerGuidWithCardID:)])
    //        {
    //            return [self.delegate contactAccessFlowController:self requestOwnerGuidWithCardID:accountSelectViewController.userInfo];
    //        }
    //    }
    //
    //    return nil;
}


//================================================================================
//
//================================================================================
- (void)accountSelectViewController:(WCTAccountSelectViewController *)accountSelectViewController didSelectAccountArray:(NSArray *)selectAccountArray
{
    // 回傳勾選的結果
    NSMutableArray *visibleAccountGuids = [NSMutableArray array];
    
    for (WCTAccountRelationModel *accountRelationModel in selectAccountArray)
    {
        [visibleAccountGuids addObject:accountRelationModel.guid];
    }
    
    if (self.contactEditViewController)
    {
        // 編輯
        // !!要加入已可檢查的用戶 (不包含擁有者)
        [visibleAccountGuids addObjectsFromArray:self.currentEditingCardModel.sharedAccountGUIDArray];
        
        self.currentEditingCardModel.sharedAccountGUIDArray = visibleAccountGuids;
        
        // 轉換為contactEditViewController的格式，更新回去
        NSMutableDictionary *dictionary = [NSMutableDictionary dictionary];
        NSArray *newSharedAccounts=[self prepareSharedAccountWithCardModel:self.currentEditingCardModel];
        if ([newSharedAccounts count]>0)
        {
            [dictionary setObject:newSharedAccounts forKey:@(PPContactMaintype_VisibleAccount)];
            [self.contactEditViewController clearAndUpdateGroupDataFromFieldDictioanry:dictionary];
        }
    }
    else
    {
        if ([self checkExistAndShowToastIfNeededFromViewController:self.contactInfoScrollViewController withCardID:accountSelectViewController.userInfo])
        {
            
            // 檢視
            // !!要加入已可檢查的用戶 (不包含擁有者)
            if ([self.delegate respondsToSelector:@selector(contactAccessFlowController:cardModelWithCardID:)])
            {
                WCCardModel *currentCardModel = [self.delegate contactAccessFlowController:self cardModelWithCardID:accountSelectViewController.userInfo];
                [visibleAccountGuids addObjectsFromArray:currentCardModel.sharedAccountGUIDArray];
            }
            
            if ([self.delegate respondsToSelector:@selector(contactAccessFlowController:updateVisibleAccountGuids:withCardID:)])
            {
                [self.delegate contactAccessFlowController:self updateVisibleAccountGuids:visibleAccountGuids withCardID:accountSelectViewController.userInfo];
                
                // !! 如果是從info進來，要reload
                [self.contactInfoScrollViewController clearContactInformationInCurrentPage];
            }
        }
    }
    
    [accountSelectViewController goBackAnimated:YES];
}
#endif





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - class methods

//==============================================================================
//
//==============================================================================
+ (void)setShouldShowPhonetic:(BOOL)shouldShowPhonetic
{
    
}


//==============================================================================
//
//==============================================================================
+ (void)setShouldShowNamePhonetic:(BOOL)shouldShowPhonetic
{
    g_ShouldShowNamePhonetic = shouldShowPhonetic;
}


//==============================================================================
//
//==============================================================================
+ (void)setShouldShowCompanyPhonetic:(BOOL)shouldShowPhonetic
{
    g_ShouldShowCompanyPhonetic = shouldShowPhonetic;
}


//==============================================================================
//
//==============================================================================
+ (void)setShouldShowPhoneticSelection:(BOOL)shouldShowPhoneticSelection
{
    g_ShouldShowPhoneticSelection = shouldShowPhoneticSelection;
}


//==============================================================================
//
//==============================================================================
+ (void)setChineseEditingFormat:(BOOL)chineseEditingFormat
{
    g_ChineseEdtingFormat = chineseEditingFormat;
}

@end
