//
//  WCContactFlowController.h
//  WorldCardMobile7
//
//  Created by sanhue on 2015/7/8.
//  Copyright (c) 2015年 penpower. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "WCABCardModel.h"
#import "WCCardModel.h"
#import "WCGroupModel.h"
#import "WCImageDefine.h"
#import "WCRecogSourceModel.h"
#import "WCContactEditViewController+PublicParameterDefine.h"
#import "WCDisplayNameDefine.h"
#import "ContactInfoViewController.h"
#import "WCContactAccessFlowController+SettingKeys.h"
#import "WCContactInfoScrollViewController.h"
#import "WCContactEditViewController.h"

////////////////////////////////////////////////////////////////////////////////////////////////////
typedef NS_ENUM(NSInteger, WCContactFlowControllerAction)
{
    WCContactFlowControllerAction_None = 0,
    WCContactFlowControllerAction_InfoBack,   // 檢視頁返回，
    WCContactFlowControllerAction_SwitchFavorite,   // 變更favorite的狀態，favorite -> non-favorite, non-favorite -> favorite
    WCContactFlowControllerAction_Delete,           // 刪除名片
    WCContactFlowControllerAction_EditSuccessful,   // 編輯成功
    WCContactFlowControllerAction_GoBack,           // 放棄編輯退出
    WCContactFlowControllerAction_SetFrontFieldAsManul, // 把指定的cardID的前名片欄位設為手動
    WCContactFlowControllerAction_SetBackFieldAsManul, // 把指定的cardID的後名片欄位設為手動
    WCContactFlowControllerAction_SetBackFieldAsFront, // 把指定的cardID的後名片欄位設為前名片欄位
};
////////////////////////////////////////////////////////////////////////////////////////////////////

@class WCContactAccessFlowController;

@protocol WCContactAccessFlowControllerDelegate <NSObject>

#pragma mark - request data

#pragma mark - nameOrder settings request


/**
 * 取得名字的順序設定
 * @param contactAccessFlowController 發出delegate的controller 實體
 * @param isEasternName 要東方還是西方的姓名
 * @return WCDisplayNameOrder 姓名順序
 */
- (WCDisplayNameOrder)nameOrderForContactAccessFlowController:(WCContactAccessFlowController *)contactAccessFlowController isEasternName:(BOOL)isEasternName;


#pragma mark - auto format settings request


/**
 * 電話自動格式化設定
 * @param contactAccessFlowController 發出delegate的controller 實體
 * @return BOOL 是否要自動格式化電話
 */
- (BOOL)autoFormatPhoneNumberWithContactAccessFlowController:(WCContactAccessFlowController *)contactAccessFlowController;

/**
 * 電話加入國碼，電話自動格式化設定為YES時才有用
 * @param contactAccessFlowController 發出delegate的controller 實體
 * @return BOOL 是否要在電話自動加上國碼
 */
- (BOOL)appendCountryCodeWithContactAccessFlowController:(WCContactAccessFlowController *)contactAccessFlowController;


#pragma mark - hand clip recognize request


/**
 * 取得支援的辨識語系列表
 * @param contactAccessFlowController 發出delegate的controller 實體
 * @return NSMutableArray array of WCKernelRecogLangModel
 */
- (NSArray *)supportRecognizeLangugaesForContactAccessFlowController:(WCContactAccessFlowController *)contactAccessFlowController;

/**
 * 取得支援的辨識欄位列表
 * @param contactAccessFlowController 發出delegate的controller 實體
 * @return NSMutableArray array of WCKernelRecogTypeModel
 */
- (NSArray *)supportRecognizeFieldTypesForContactAccessFlowController:(WCContactAccessFlowController *)contactAccessFlowController;

/**
 * 取得支援的辨識欄位列表
 * @param contactAccessFlowController 發出delegate的controller 實體
 * @return NSMutableArray array of WCKernelRecogTypeModel
 */
- (WCCardModel *)contactAccessFlowController:(WCContactAccessFlowController *)contactAccessFlowController
                    clipRecogWithSourceModel:(WCRecogSourceModel *)recogSourceModel
                           originalCardModel:(WCCardModel *)originalCardModel
                                       error:(NSError **)error;


#pragma mark - group data request

/**
 * 手動新增時會用到，取得預設的群組資訊，
 * @param contactAccessFlowController 發出delegate的controller 實體
 * @return NSMutableArray array of group ID(NSString)
 */
- (NSArray *)contactAccessFlowControllerRequestDefaultGroupIDArray:(WCContactAccessFlowController *)contactAccessFlowController;

/**
 * 取得carID所包含的group
 * @param contactAccessFlowController 發出delegate的controller 實體
 * @param cardID 要取得哪一個聯絡人的group資訊，nil表示全部都要load
 * @return NSMutableArray array of WCGroupModel
 */
- (NSMutableArray *)contactAccessFlowController:(WCContactAccessFlowController *)contactAccessFlowController allGroupModelsWithCardID:(NSString *)cardID;

/**
 * 回傳group名稱，如是多個會以","分隔
 * @param contactAccessFlowController 發出delegate的controller 實體
 * @param groupIDArray 要取得名稱的group ID
 * @return NSString 回傳group名稱，如是多個會以","分隔
 */
- (NSString *)contactAccessFlowController:(WCContactAccessFlowController *)contactAccessFlowController groupNamesWithGroupIDArray:(NSArray *)groupIDArray;

/**
 * 取得群組是否存在
 * @param contactAccessFlowController 發出delegate的controller 實體
 * @param groupNamed 要檢查的群組名稱
 * @return BOOL YES if exist, else NO
 */
- (BOOL)contactAccessFlowController:(WCContactAccessFlowController *)contactAccessFlowController isExistGroupNamed:(NSString*)groupNamed;


/**
 * 新增群組
 * @param contactAccessFlowController 發出delegate的controller 實體
 * @param groupName 要新增的群組名稱
 * @return WCGroupModel 新增的groupModel
 */
- (WCGroupModel *)contactAccessFlowController:(WCContactAccessFlowController *)contactAccessFlowController groupModelByNewGroupName:(NSString *)groupName;


#pragma mark - contact data request

/**
 * 取得cardID所屬的CardModel
 * @param contactAccessFlowController 發出delegate的controller 實體
 * @param cardID 要取得哪一個聯絡人的card model
 * @return WCCardModel 要求的card model
 */
- (WCCardModel *)contactAccessFlowController:(WCContactAccessFlowController *)contactAccessFlowController cardModelWithCardID:(NSString *)cardID;



/**
 * 檢查是否我的最愛的名片
 * @param contactAccessFlowController 發出delegate的controller 實體
 * @param cardID 要取得哪一個聯絡人的card model
 * @return BOOL YES: 是我的最愛名片，else NO
 */
- (BOOL)contactAccessFlowController:(WCContactAccessFlowController *)contactAccessFlowController isFavoriteWithCardID:(NSString *)cardID;

/**
 * 取得讀音候還列表
 * @param contactAccessFlowController 發出delegate的controller 實體
 * @param phonetic 目前的讀音
 * @param sourceValue 用來查詢的原文
 * @param isCompanyPhonetic 是否是公司讀音
 * @return UIImage 要求的名片圖
 */
- (NSMutableArray *)contactAccessFlowController:(WCContactAccessFlowController *)contactAccessFlowController
               phoneticArrayWithClickedPhonetic:(NSString *)phonetic
                                    sourceValue:(NSString *)sourceValue
                              isCompanyPhonetic:(BOOL)isCompanyPhonetic;


#pragma mark - contact image data request

/**
 * 詢問是否有名片圖
 * @param contactAccessFlowController 發出delegate的controller 實體
 * @param cardID 要取得哪一個聯絡人的card model
 * @param imageType 要取得正反或大頭貼
 * @return BOOL YES: 有名片圖，NO: 沒有圖
 */
- (BOOL)contactAccessFlowController:(WCContactAccessFlowController *)contactAccessFlowController hasCardImageWithCardID:(NSString*)cardID imageType:(WC_ImageType)imageType;


/**
 * 取得cardID所屬的名片圖
 * @param contactAccessFlowController 發出delegate的controller 實體
 * @param cardID 要取得哪一個聯絡人的card model
 * @param imageType 要取得正反或大頭貼
 * @return UIImage 要求的名片圖
 */
- (UIImage *)contactAccessFlowController:(WCContactAccessFlowController *)contactAccessFlowController cardImageWithCardID:(NSString*)cardID imageType:(WC_ImageType)imageType;

/**
 * 取得cardID所屬的名片圖
 * @param contactAccessFlowController 發出delegate的controller 實體
 * @param cardID 要取得哪一個聯絡人的card model
 * @param imageType 要取得正反或大頭貼
 * @return NSData 要求的名片圖data
 */
- (NSData *)contactAccessFlowController:(WCContactAccessFlowController *)contactAccessFlowController cardImageDataWithCardID:(NSString*)cardID imageType:(WC_ImageType)imageType;


#pragma mark - update data

/**
 * 通知需要ap處理的動作
 * @param contactAccessFlowController 發出delegate的controller 實體
 * @param action 要處理的動作
 * @param cardID 動作對象的cardID
 * @param error 回傳錯誤
 */
- (BOOL)contactAccessFlowController:(WCContactAccessFlowController *)contactAccessFlowController
                             action:(WCContactFlowControllerAction)action
                         withCardID:(NSString *)cardID
                              error:(NSError **)error;

/**
 * 更新cardModel
 * @param contactAccessFlowController 發出delegate的controller 實體
 * @param cardModel 修改後的cardModel
 * @param abSourceID 要存到系統聯絡人的哪一個 source, 如果 abSourceID，abGroupID，abPersonID都是 nil, 表示不用儲存到系統聯絡人
 * @param abGroupID 要存到系統聯絡人的哪一個 group, 如果 abSourceID，abGroupID，abPersonID都是 nil, 表示不用儲存到系統聯絡人
 * @param abPersonID 要存到哪一個系統聯絡人, 有合併系統聯絡人時才會有， 如果 abSourceID，abGroupID，abPersonID都是 nil, 表示不用儲存到系統聯絡人
 * @param error 回傳錯誤
 */
- (void)contactAccessFlowController:(WCContactAccessFlowController *)contactAccessFlowController
                    updateCardModel:(WCCardModel *)cardModel
                     withABSourceID:(NSString *)abSourceID
                          abGroupID:(NSString *)abGroupID
                         abPersonID:(NSString *)abPersonID
                              error:(NSError **)error;

/**
 * 更新名片圖
 * @param contactAccessFlowController 發出delegate的controller 實體
 * @param cardImage 要更新的image，nil 表示要刪除
 * @param cardID 要更新影像的cardID
 * @param imageType 要取得正反或大頭貼
 * @param error 回傳錯誤
 */
- (void)contactAccessFlowController:(WCContactAccessFlowController *)contactAccessFlowController
                    updateCardImage:(UIImage *)cardImage
                         withCardID:(NSString *)cardID
                          imageType:(WC_ImageType)imageType
                              error:(NSError **)error;

#pragma mark - option

@optional




#pragma mark - custom field date request

/**
 * 取得所有自訂欄位
 * @param contactAccessFlowController 發出delegate的controller 實體
 * @return NSArray array of WCCustomFieldInfo
 */
- (NSArray *)contactAccessFlowControllerRequestCustomFieldInfos:(WCContactAccessFlowController *)contactAccessFlowController;


#pragma mark 辨識語系

/////////////////////////////////////////////////////////////////////////////////////////////////////
// 正反面辨識語系

/**
 * 取得目前設定的正面辨識語系
 * @param contactAccessFlowController 發出delegate的controller 實體
 * @return 正面辨識語系，如果沒有回傳-1
 */
- (NSInteger)contactAccessFlowControllerRequestFrontRecogLang:(WCContactAccessFlowController *)contactAccessFlowController;


/**
 * 取得目前設定的反面辨識語系
 * @param contactAccessFlowController 發出delegate的controller 實體
 * @return 反面辨識語系，如果沒有回傳-1
 */
- (NSInteger)contactAccessFlowControllerRequestBackRecogLang:(WCContactAccessFlowController *)contactAccessFlowController;

/**
 * 取得中文辨識結果設定
 * @param contactAccessFlowController 發出delegate的controller 實體
 * @return 中文辨識結果設定，如果沒有回傳-1
 */
- (NSInteger)contactAccessFlowControllerRequestOutputTranslate:(WCContactAccessFlowController *)contactAccessFlowController;


#pragma mark address book專用
////////////////////////////////////////////////////////////////////////////////////////////////////
// address book專用

/**
 * 取得cardID所屬的WCABCardModel
 * @param contactAccessFlowController 發出delegate的controller 實體
 * @param cardID 要取得哪一個聯絡人的card model
 * @return WCABCardModel 要求的card model
 */
- (WCABCardModel *)contactAccessFlowController:(WCContactAccessFlowController *)contactAccessFlowController addressBookCardModelWithCardID:(NSString *)cardID;


/**
 * 更新address book資料，匯出系統聯絡人時。可能會回傳匯入後的資料，要寫入資料庫
 * @param contactAccessFlowController 發出delegate的controller 實體
 * @param abCardModel 修改後的WCABCardModel
 */
- (void)contactAccessFlowController:(WCContactAccessFlowController *)contactAccessFlowController updateAddressBookDataWithABCardModel:(WCABCardModel *)abCardModel;

/**
 * 更新聯絡人的群組資訊
 * @param contactAccessFlowController 發出delegate的controller 實體
 * @param cardID 要修正的cardID
 * @param groupIDArray 新的群組，未分類可設為nil, groupID "string" array
 */
- (void)contactAccessFlowController:(WCContactAccessFlowController *)contactAccessFlowController updateCard:(NSString*)cardID withGroupIDArray:(NSArray *)groupIDArray;


#pragma mark note專用
////////////////////////////////////////////////////////////////////////////////////////////////////
// note專用

/**
 * 取得cardID的note
 * @param contactAccessFlowController 發出 delegate 的c ontroller 實體
 * @param cardID 要取得哪一個聯絡人的card model
 * @return NSString 要求的note
 */
- (NSString *)contactAccessFlowController:(WCContactAccessFlowController *)contactAccessFlowController noteWithCardID:(NSString *)cardID;


/**
 * 更新cardID的note
 * @param contactAccessFlowController 發出 delegate 的c ontroller 實體
 * @param note 要更新的資料
 * @param cardID 聯絡人id
 */
- (void)contactAccessFlowController:(WCContactAccessFlowController *)contactAccessFlowController updateNote:(NSString *)note withCardID:(NSString *)cardID error:(NSError **)error;


#pragma mark contact edit 專用


/**
 * 存儲到系統聯絡人
 * @param contactAccessFlowController 發出 delegate 的controller 實體
 * @return YES, 要開啟儲存到系統聯絡人，else NO
 */
- (BOOL)contactAccessFlowControllerRequestEnableSaveToiPhoneContact:(WCContactAccessFlowController *)contactAccessFlowController;;

/**
 * 取得預設的系統群組 sourceID
 * @param contactAccessFlowController 發出 delegate 的controller 實體
 * @return sourceID, detault nil;
 */
- (NSString *)contactAccessFlowControllerRequestDefaultABSourceID:(WCContactAccessFlowController *)contactAccessFlowController;

/**
 * 取得預設的系統群組 groupID
 * @param contactAccessFlowController 發出 delegate 的controller 實體
 * @return groupID, default nil;
 */
- (NSString *)contactAccessFlowControllerRequestDefaultABGroupID:(WCContactAccessFlowController *)contactAccessFlowController;


/**
 * 取得目前同步帳號
 * @param contactAccessFlowController 發出 delegate 的controller 實體
 * @return NSString - 目前的同步帳號，沒有的話會回傳nil
 */
- (NSString *)contactAccessFlowControllerRequestGoogleSyncAccount:(WCContactAccessFlowController *)contactAccessFlowController;

#pragma mark 可檢視用戶 (WCT用)
////////////////////////////////////////////////////////////////////////////////////////////////////



/**
 * 是否可以顯示可檢視用戶
 * @param contactAccessFlowController 發出delegate的controller 實體
 * @return NSArray array of WCTAccountRelationModel
 */
- (BOOL)checkAndAlertChangeVisibleAccontWithContactAccessFlowController:(WCContactAccessFlowController *)contactAccessFlowController;


/**
 * 取得所有帳號列表
 * @param contactAccessFlowController 發出delegate的controller 實體
 * @return NSArray array of WCTAccountRelationModel
 */
- (NSArray *)allAccountsWithContactAccessFlowController:(WCContactAccessFlowController *)contactAccessFlowController;


/**
 * 依card id取得名片所屬的owner guid
 * @param contactAccessFlowController 發出delegate的controller 實體
 * @param cardID 要求名片所屬的owner guid的cardID
 * @return NSString owner guid
 */
- (NSString *)contactAccessFlowController:(WCContactAccessFlowController *)contactAccessFlowController
              requestOwnerGuidWithCardID:(NSString *)cardID;


/**
 * 依card id取得可檢視用戶
 * @param contactAccessFlowController 發出delegate的controller 實體
 * @param cardID 要求取得可檢視用戶的cardID
 * @return NSArray array of account guid
 */
- (NSArray *)contactAccessFlowController:(WCContactAccessFlowController *)contactAccessFlowController
               requestSharedAccountGuidWithCardID:(NSString *)cardID;


/**
 * 通知選取的可檢視用戶
 * @param contactAccessFlowController 發出delegate的controller 實體
 * @param visibleAccountGuids 目前選取的可檢視用戶 NSArray of account guid string
 * @param cardID 要更新可檢視用戶的名片ID

 */
- (void)contactAccessFlowController:(WCContactAccessFlowController *)contactAccessFlowController
          updateVisibleAccountGuids:(NSArray *)visibleAccountGuids
                         withCardID:(NSString *)cardID;


#pragma mark 用戶資訊 (WCT用)
////////////////////////////////////////////////////////////////////////////////////////////////////

/**
 * 取得自已帳號的guid
 * @param contactAccessFlowController 發出delegate的controller 實體
 * @return NSString 自已帳號的guid
 */
- (NSString *)selfAccountGuidWithContactAccessFlowController:(WCContactAccessFlowController *)contactAccessFlowController;

/**
 * 取得boss guid
 * @param contactAccessFlowController 發出delegate的controller 實體
 * @return NSString boss account guid
 */
- (NSString *)bossAccountGuidWithContactAccessFlowController:(WCContactAccessFlowController *)contactAccessFlowController;

/**
 * 依guid取得帳號關係
 * @param contactAccessFlowController 發出delegate的controller 實體
 * @param guid 要要求帳號關係的guid
 * @return NSString 與本機帳號的關系
 */
- (NSString *)contactAccessFlowController:(WCContactAccessFlowController *)contactAccessFlowController
                  requestRelationWithGuid:(NSString *)guid;

/**
 * 依guid取得帳號名稱
 * @param contactAccessFlowController 發出delegate的controller 實體
 * @param guid 要要求帳號名稱的guid
 * @return NSString 要顯示的帳號名稱
 */
- (NSString *)contactAccessFlowController:(WCContactAccessFlowController *)contactAccessFlowController
               requestAccountNameWithGuid:(NSString *)guid;

/**
 * 取得帳號匯出權限
 * @param contactAccessFlowController 發出delegate的controller 實體
 * @return BOOL YES: 有權限，NO: 無權限。不實作此delegate預設為YES.
 */
- (BOOL)accountExportAbilityWithContactAccessFlowController:(WCContactAccessFlowController *)contactAccessFlowController;


#pragma mark WCSF用

/**
 * 取得salesforce的所有picklist item
 * @param contactAccessFlowController 發出delegate的controller 實體
 * @param cardID 再編輯的名片ID
 * @return WC_SF_SaveAs
 */
- (WC_SF_SaveAs)salesforceSaveAsWithContactAccessFlowController:(WCContactAccessFlowController *)contactAccessFlowController cardID:(NSString *)cardID;

/**
 * 取得salesforce的所有picklist item
 * @param contactAccessFlowController 發出delegate的controller 實體
 * @param fieldName picklist的fieldName
 * @param defaultItemIndex 回傳預設選項的index
 * @param editable 回傳此欄位是否可編輯
 * @return all picklist item
 */
- (NSArray *)salesforcePicklistItemsWithContactAccessFlowController:(WCContactAccessFlowController *)contactAccessFlowController fieldName:(NSString *)fieldName defaultItemIndex:(NSInteger*)defaultItemIndex editable:(BOOL *)editable;

/**
 * 取得salesforce的支援的儲存至列表
 * @param contactAccessFlowController 發出delegate的controller 實體
 * @return all save as item
 */
- (NSArray *)salesforceSupportedSaveAsArrayWithContactAccessFlowController:(WCContactAccessFlowController *)contactAccessFlowController;



#pragma mark 其他
////////////////////////////////////////////////////////////////////////////////////////////////////

/**
 * 將欄位設為預設(第一筆)
 * @param contactAccessFlowController 發出delegate的controller 實體
 * @param fieldIndex 要修改為預設的欄位index
 * @param cardID 要修改的名片ID
 * @param fieldType 要修改的field type
 */
- (void)contactAccessFlowController:(WCContactAccessFlowController *)contactAccessFlowController setFieldIndex:(NSInteger)fieldIndex toDefaultWithCardID:(NSString *)cardID fieldType:(WC_FieldType)fieldType;


/**
 * 儲存最近連繫聯絡人動作
 * @param contactAccessFlowController 發出delegate的controller 實體
 * @param action 目前動作的ID
 * @param content 目前動作的內容
 * @param cardID 要修改的名片ID
 */
- (void)contactAccessFlowController:(WCContactAccessFlowController *)contactAccessFlowController recentContactAction:(NSInteger)action content:(NSString *)content cardID:(NSString *)cardID;

/**
 * 再辨識
 * @param contactAccessFlowController 發出delegate的controller 實體
 * @param recogSourceModel 辨識的model, 
 * @param error 錯誤碼
 * @return WCCardModel 辨識後的結果
 */
- (WCCardModel *)contactAccessFlowController:(WCContactAccessFlowController *)contactAccessFlowController
                 requestRecogWithSourceModel:(WCRecogSourceModel *)recogSourceModel
                                       error:(NSError **)error;




/**
 * 取得cardID所屬的假名片圖
 * @param contactAccessFlowController 發出delegate的controller 實體
 * @param cardID 要取得哪一個聯絡人的假名片圖
 * @return UIImage 要求的名片圖
 */
- (UIImage *)contactAccessFlowController:(WCContactAccessFlowController *)contactAccessFlowController virtualCardImageWithCardID:(NSString*)cardID;



/**
 * 在編輯介面中是否要顯示新增跟更換名片圖，沒有實作此delegate預設是YES
 * @param contactAccessFlowController 發出delegate的controller 實體
 * @return BOOL YES要秀，NO不用秀
 */
- (BOOL)showAddAndReplaceCardImageInEditViewControllerWithContactAccessFlowController:(WCContactAccessFlowController *)contactAccessFlowController;


/**
 * 檢查cardID是否存在, infoview在做一些動作前會檢查
 * @param contactAccessFlowController 發出delegate的controller 實體
 * @param cardID 要檢查的聯絡人ID
 * @return BOOL YES:存在，NO:不存在, default NO
 */
- (BOOL)contactAccessFlowController:(WCContactAccessFlowController *)contactAccessFlowController isCardIDExist:(NSString *)cardID;


/**
 * 檢查是否為空名片，以傳入的名片圖為依據來判斷是否為空名片
 * @param contactAccessFlowController 發出delegate的controller 實體
 * @param cardID 要檢查的聯絡人ID
 * @param frontSideImage 正面名片
 * @param backSideImage 反面名片
 * @return BOOL YES:空名片，NO:不是空名片
 */
- (BOOL)contactAccessFlowController:(WCContactAccessFlowController *)contactAccessFlowController isEmptyCardWithCardID:(NSString *)cardID frontSideImage:(UIImage *)frontSideImage backSideImage:(UIImage *)backSideImage;


@end

////////////////////////////////////////////////////////////////////////////////////////////////////
@interface WCContactAccessFlowController : NSObject

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Property

@property (nonatomic, assign) id<WCContactAccessFlowControllerDelegate> delegate;

//給外部ap使用
@property (nonatomic,retain) id userInfo;

/// 編輯畫面是否需要顯示群組, defualt YES
@property (nonatomic, assign) BOOL isEditNeedShowGroup;

/// 檢視畫面是否需要顯示群組, defualt YES
@property (nonatomic, assign) BOOL isInfoNeedShowGroup;

- (BOOL)isEditing;

@property (nonatomic, retain, readonly) WCContactInfoScrollViewController *contactInfoScrollViewController;
@property (nonatomic, retain, readonly) WCContactEditViewController *contactEditViewController;

////////////////////////////////////////////////////////////////////////////////////////////////////


#pragma mark - contact info methods


/**
 * 顯示info頁面
 * @param viewController 從哪一個頁面顯示
 * @param currentContactIndex 顯示第幾筆聯絡人
 * @param contactIDArray 目前所有聯絡人cardID列表
 * @param interfaceStyle 檢視畫面的模式
 * @param needFullScreen 使用全螢幕顯示，或顯示到splitView Controller的detail中
 * @param delegate 處理delegate的實體
 */
- (void)showContactInfoFromViewController:(UIViewController *)viewController
                      currentContactIndex:(NSInteger)currentContactIndex
                           contactIDArray:(NSArray *)contactIDArray
                           interfaceStyle:(ContactInfoViewControllerInterfaceStyle)interfaceStyle
                           needFullScreen:(BOOL)needFullScreen
                                 delegate:(id<WCContactAccessFlowControllerDelegate>)delegate;
/**
 * 關閉檢視頁面
 * @param animated 關閉時是否使用動畫
 */
- (void)dismissContactInfoViewControllerAnimated:(BOOL)animated;

/**
 * 通知 info 顯示 guide
 */
- (void)showInfoGuideIfNeeded;


#pragma mark - contact edit methods

/**
 * 顯示編輯頁面
 * @param viewController 從哪一個view controller 顯示
 * @param cardID 要編輯的cardID
 * @param delegate 處理delegate的實體
 * @param contacEditViewControllerLayout 新增 or 編輯
 * @param manual 手動新增
 */
- (void)showContactEditFromViewController:(UIViewController *)viewController
                                   cardID:(NSString *)cardID
                                 delegate:(id<WCContactAccessFlowControllerDelegate>)delegate
           contacEditViewControllerLayout:(WCContactEditViewControllerLayout)contacEditViewControllerLayout
                                   manual:(BOOL)manual;
/**
 * 關閉編輯頁面
 * @param animated 關閉時是否使用動畫
 */
- (void)dismissContactEditViewControllerAnimated:(BOOL)animated;


#pragma mark - action methods

/// info的note編輯
- (void)onClickContactInfoNoteFromViewController:(UIViewController *)viewController cardID:(NSString *)cardID editable:(BOOL)editable;

/**
 * info 顯示名片圖編輯
 * @param viewController 名片圖編輯要從哪個頁面顯示
 * @param cardID 要秀哪一個名片的名片圖
 * @param showBackCardImage 進入時是否顯示反面
 * @param reloadImage YES: 會重新秀過delegate向外部取圖，NO: 使用contactInfo的圖
 */
- (void)onClickShowCardImageFromViewController:(UIViewController *)viewController
                                        cardID:(NSString *)cardID
                             showBackCardImage:(BOOL)showBackCardImage
                                   reloadImage:(BOOL)reloadImage;

/// 按下info編輯
- (void)onClickContactInfoEditFromViewController:(UIViewController *)viewController cardID:(NSString *)cardID;

/// 按下分享按鈕時使用
- (void)onClickShareContactFromViewController:(UIViewController *)viewController cardID:(NSString *)cardID;

/// 按下儲存到系統聯絡人
- (void)onClickSaveToSystemContactFromViewController:(UIViewController *)viewController cardID:(NSString *)cardID;

/// 按下社群搜尋
- (void)onClickCommunitySearchFromViewController:(UIViewController *)viewController cardID:(NSString *)cardID;

- (void)onClickContinueEditWithViewController:(WCContactEditViewController *)viewController;

#pragma mark - class methods

/// 是否要顯示讀音欄位
+ (void)setShouldShowPhonetic:(BOOL)shouldShowPhonetic __deprecated;

/// 是否要顯示姓名讀音欄位
+ (void)setShouldShowNamePhonetic:(BOOL)shouldShowPhonetic;

/// 是否要顯示公司讀音欄位
+ (void)setShouldShowCompanyPhonetic:(BOOL)shouldShowPhonetic;

/// 是否要顯示讀音欄位候選按鈕
+ (void)setShouldShowPhoneticSelection:(BOOL)shouldShowPhoneticSelection;

/// 設定編輯是使用東方或是西方排版
+ (void)setChineseEditingFormat:(BOOL)chineseEditingFormat;

@end
