//
//  WCReRecognitionFlowController.m
//  Pods
//
//  Created by sanhue on 2015/9/6.
//
//

#import "WCReRecognitionFlowController.h"
#import "WCReRecognitionSelectViewController.h"
#import "WCKernelRecogLangModel.h"

static WCReRecognitionSelectViewController *g_reRecognitionSelectViewController = nil;
static WCReRecognitionFlowController *g_reRecognitionFlowContorller = nil;
////////////////////////////////////////////////////////////////////////////////////////////////////
@interface WCReRecognitionFlowController () <WCReRecognitionSelectViewControllerDelegate>

@property (nonatomic, copy) ReRecognitionFinish completion;
@property (nonatomic, copy) ReRecognitionAction action;
@property (nonatomic, retain) WCCardModel *originCardModel;
@end

////////////////////////////////////////////////////////////////////////////////////////////////////
@implementation WCReRecognitionFlowController





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark
#pragma mark - init/dealloc methods


//==============================================================================
//
//==============================================================================
- (instancetype)init
{
    self = [super init];
    if (self)
    {
        
    }
    return self;
}


//==============================================================================
//
//==============================================================================
- (void)dealloc
{
    self.originCardModel = nil;
    self.action = nil;
    self.completion = nil;
    //////////////////////////////////////////////////
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark
#pragma mark - (Private) 依正反面辨識語系調整列表


//==============================================================================
//
//==============================================================================
- (NSArray *)reorderRecogLanguages:(NSArray *)recogLanguages withLangID:(NSInteger)langID
{
    //////////////////////////////////////////////////
    // 判斷正反面的辨識語系是否有在列表中，如果有移到第一位，如果沒有，使用英文為預設語系
    BOOL isContainsInRecogLanguages = NO;
    NSMutableArray *result = [NSMutableArray array];
    for (WCKernelRecogLangModel *langModel in recogLanguages)
    {
        if (langModel.langCode == langID)
        {
            [result insertObject:langModel atIndex:0];
            isContainsInRecogLanguages = YES;
        }
        else
        {
            [result addObject:langModel];
        }
    }

    //////////////////////////////////////////////////
    // 判斷正反面的辨識語系是否有在列表中，如果有移到第一位，如果沒有，使用英文為預設語系
    if (isContainsInRecogLanguages==NO)
    {
        [result sortUsingComparator:^NSComparisonResult(WCKernelRecogLangModel * obj1, WCKernelRecogLangModel *obj2) {
            return (obj1.langCode==3)?NSOrderedAscending:NSOrderedDescending;
        }];
    }
    
    if ([result count])
    {
        return [NSArray arrayWithArray:result];
    }
    
    return nil;
}






////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark
#pragma mark - WCReRecognitionSelectViewControllerDelegate


//==============================================================================
//
//==============================================================================
- (void)didCancelWithViewController:(WCReRecognitionSelectViewController *)viewController
{
    if (self.completion)
    {
        // TODO: 錯誤處理
        NSError *error = [NSError errorWithDomain:NSStringFromClass([self class])
                                             code:WCReRecognitionFlowControllerErrorCode_Cancel
                                         userInfo:nil];
        self.completion (nil, error);
    }
}


//==============================================================================
//
//==============================================================================
- (void)didFinishWithViewController:(WCReRecognitionSelectViewController *)viewController
{
    if (self.completion)
    {
        // TODO: 錯誤處理
        self.completion (self.originCardModel, nil);
    }
}


//==============================================================================
//
//==============================================================================
- (void)requestRecognizeWithFrontSourceModel:(WCRecogSourceModel *)frontSourceModel
                             backSourceModel:(WCRecogSourceModel *)backSourceModel
{
    // 辨識正面
    NSError *error = nil;
    WCCardModel *cardModel = nil;
    if (frontSourceModel!=nil && self.action)
    {
        cardModel =   self.action (frontSourceModel, NO, &error);
        // TODO: 錯誤處理
    }
    
    if (cardModel)
    {
        // 清除原本的正面辨識結果
        [self.originCardModel removeFieldWithSource:WC_FS_FrontRecog];
        [self.originCardModel combineCard:cardModel];
        self.originCardModel.frontRecogLang = frontSourceModel.recogLang;
        cardModel = nil;
    }
    
    //////////////////////////////////////////////////
    // 辨識反面
    if (backSourceModel!=nil && self.action)
    {
        cardModel =   self.action (backSourceModel, YES, &error);
        // TODO: 錯誤處理
    }
    
    if (cardModel)
    {
        // 清除原本的正面辨識結果
        [self.originCardModel removeFieldWithSource:WC_FS_BackRecog];
        [self.originCardModel combineCard:cardModel];
        self.originCardModel.backRecogLang = backSourceModel.recogLang;
    }
}


//==============================================================================
//
//==============================================================================
- (WCCardModel *)WCReRecognitionSelectViewController:(WCReRecognitionSelectViewController *)viewController
                     requestRecognizeWithSourceModel:(WCRecogSourceModel *)sourceModel
                                          isBackSide:(BOOL)isBackSide
                                               error:(NSError **)error
{
    if (self.action)
    {
        return  self.action (sourceModel, isBackSide, error);
    }
    
    return nil;
}






////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark
#pragma mark - class methods


//==============================================================================
//
//==============================================================================
+ (void)startFromViewController:(UIViewController *)viewController
                 recogLanguages:(NSArray *)recogLanguages
               defaultFrontLang:(NSInteger)defaultFrontLang
                defaultBackLang:(NSInteger)defaultBackLang
                 frontCardImage:(UIImage *)frontCardImage
                  backCardImage:(UIImage *)backCardImage
            showRecogSideOnCell:(BOOL)showRecogSideOnCell
                originCardModel:(WCCardModel *)originCardModel
              recognitionAction:(ReRecognitionAction)recognitionAction
                     completion:(ReRecognitionFinish)completion
{
    [g_reRecognitionFlowContorller release];
    g_reRecognitionFlowContorller = [[WCReRecognitionFlowController alloc] init];
    
    if (g_reRecognitionFlowContorller)
    {
        g_reRecognitionFlowContorller.originCardModel = originCardModel;
        g_reRecognitionFlowContorller.action = recognitionAction;
        g_reRecognitionFlowContorller.completion = completion;
        
        //////////////////////////////////////////////////
        [g_reRecognitionSelectViewController release];
        g_reRecognitionSelectViewController = [[WCReRecognitionSelectViewController alloc] init];
        if (g_reRecognitionSelectViewController)
        {
            g_reRecognitionSelectViewController.showRecogSideInCell = showRecogSideOnCell;
            
            NSInteger frontLang = defaultFrontLang;
            if(originCardModel.frontRecogLang!=-1)
            {
                frontLang = originCardModel.frontRecogLang;
            }
            
            NSInteger backLang = defaultBackLang;
            if(originCardModel.backRecogLang!=-1)
            {
                backLang = originCardModel.backRecogLang;
            }
            
            g_reRecognitionSelectViewController.delegate = g_reRecognitionFlowContorller;
            
            g_reRecognitionSelectViewController.frontRecogLanguages =
            [g_reRecognitionFlowContorller reorderRecogLanguages:recogLanguages
                                                      withLangID:frontLang] ;
            
            g_reRecognitionSelectViewController.backRecogLanguages =
            [g_reRecognitionFlowContorller reorderRecogLanguages:recogLanguages
                                                      withLangID:backLang];
            
            g_reRecognitionSelectViewController.frontCardImage = frontCardImage;
            g_reRecognitionSelectViewController.backCardImage = backCardImage;
            
            //////////////////////////////////////////////////
            
            [viewController.view addSubview:g_reRecognitionSelectViewController.view];
        }
    }
}


//==============================================================================
//
//==============================================================================
+ (void)startFromViewController:(UIViewController *)viewController
                 recogLanguages:(NSArray *)recogLanguages
               defaultFrontLang:(NSInteger)defaultFrontLang
                defaultBackLang:(NSInteger)defaultBackLang
                 frontCardImage:(UIImage *)frontCardImage
                  backCardImage:(UIImage *)backCardImage
                originCardModel:(WCCardModel *)originCardModel
              recognitionAction:(ReRecognitionAction)recognitionAction
                     completion:(ReRecognitionFinish)completion
{
    [self startFromViewController:viewController
                   recogLanguages:recogLanguages
                 defaultFrontLang:defaultFrontLang
                  defaultBackLang:defaultBackLang
                   frontCardImage:frontCardImage
                    backCardImage:backCardImage
              showRecogSideOnCell:YES
                  originCardModel:originCardModel
                recognitionAction:recognitionAction
                       completion:completion];
}


//==============================================================================
//
//==============================================================================
+ (void)endOfReRecognitionFlowController
{
    [g_reRecognitionSelectViewController release];
    g_reRecognitionSelectViewController = nil;
    
    [g_reRecognitionFlowContorller release];
    g_reRecognitionFlowContorller = nil;
}

@end
