//
//  WCIDPhotoClipViewcontroller.m
//  Pods
//
//  Created by sanhue on 2015/8/8.
//
//

#import "WCIDPhotoClipViewController.h"
#import "PPClipContactPhotoViewController.h"
#import "PPNavigationController.h"
#import "WCAppearanceDefine.h"
#import "UIColor+HexString.h"

////////////////////////////////////////////////////////////////////////////////////////////////////
static WCIDPhotoClipViewController *staticIDPhotoClipViewController;

////////////////////////////////////////////////////////////////////////////////////////////////////
@interface WCIDPhotoClipViewController () <PPClipContactPhotoViewControllerDelegate>
@property (nonatomic, copy) WCIDPhotoClipCompletion completion;
@end


////////////////////////////////////////////////////////////////////////////////////////////////////
@implementation WCIDPhotoClipViewController





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark
#pragma mark - init/dealloc methods


//==============================================================================
//
//==============================================================================
- (instancetype)init
{
    self = [super init];
    if (self)
    {
        
    }
    return self;
}


//==============================================================================
//
//==============================================================================
- (void)dealloc
{
    self.completion = nil;
    //////////////////////////////////////////////////
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark
#pragma mark - (Private) show


//==============================================================================
//
//==============================================================================
- (void)showFromViewController:(UIViewController *)viewController sourceImage:(UIImage *)sourceImage
{
    PPClipContactPhotoViewController *clipContactPhotoViewController = [[PPClipContactPhotoViewController alloc] init];
    
    if (clipContactPhotoViewController)
    {
        if (UI_USER_INTERFACE_IDIOM()==UIUserInterfaceIdiomPhone)
        {
            [clipContactPhotoViewController.ppInterfaceOrientationController setMask:PPInterfaceOrientationControllerMask_Portrait];
        }
        else
        {
            [clipContactPhotoViewController.ppInterfaceOrientationController setMask:PPInterfaceOrientationControllerMask_LandscapeLeft|PPInterfaceOrientationControllerMask_LandscapeRight];
        }
        clipContactPhotoViewController.delegate = self;
        clipContactPhotoViewController.sourceImage = sourceImage;
        
        clipContactPhotoViewController.backgroundColorForToolBar = WCAppearanceDefine_NavigationBarColor;
        clipContactPhotoViewController.backgroundColorForTitleBar = WCAppearanceDefine_NavigationBarColor;
        clipContactPhotoViewController.backgroundColorForMask = [[UIColor colorWithHexString:@"#1d375f"] colorWithAlphaComponent:0.7];
        

        [viewController presentViewController:clipContactPhotoViewController animated:YES completion:nil];
        
        [clipContactPhotoViewController release];
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark
#pragma mark - PPClipContactPhotoViewController
- (void)ppClipContactPhotoViewController:(PPClipContactPhotoViewController *)ppClipContactPhotoViewController resignContactPhoto:(UIImage *)contactPhoto
{

    if (self.completion!=nil)
    {
        self.completion (contactPhoto);
    }
    
    //////////////////////////////////////////////////
    
    [ppClipContactPhotoViewController goBackAnimated:YES];
    
    //////////////////////////////////////////////////
    
    dispatch_async(dispatch_get_main_queue(), ^{
        [staticIDPhotoClipViewController release];
        staticIDPhotoClipViewController = nil;
    });
}


- (void)ppClipContactPhotoViewControllerDidCancel:(PPClipContactPhotoViewController *)ppClipContactPhotoViewController
{
    [ppClipContactPhotoViewController goBackAnimated:YES];
    
    //////////////////////////////////////////////////
    
    dispatch_async(dispatch_get_main_queue(), ^{
        [staticIDPhotoClipViewController release];
        staticIDPhotoClipViewController = nil;
    });
}







////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark
#pragma mark - class methods


//==============================================================================
//
//==============================================================================
+ (void)showFromViewController:(UIViewController *)viewController
                   sourceImage:(UIImage *)sourceImage
                    completion:(WCIDPhotoClipCompletion)completion
{
    [staticIDPhotoClipViewController release];
    staticIDPhotoClipViewController = [[WCIDPhotoClipViewController alloc] init];
    if (staticIDPhotoClipViewController)
    {
        staticIDPhotoClipViewController.completion = completion;
        [staticIDPhotoClipViewController showFromViewController:viewController sourceImage:sourceImage];
    }
}


@end
