//
//  CVCManualCaptureController.m
//  Pods
//
//  Created by Duke on 2015/4/7.
//
//

#import "CVCManualCaptureController.h"
#import "WCCaptureViewController+ResourceDefine.h"
#import "WCCaptureViewController+SettingsKey.h"
#import "PPSettingsController.h"
#import "PPGuideController.h"
#import "PPButton+Factory.h"
#import "UIDevice+DeviceModel.h"
#import "PPAutoResizedLabel+Factory.h"
#import "PPCameraView.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

typedef NS_ENUM(NSUInteger, CVCManualCaptureController_ButtonTag)
{
    ButtonTag_None  = 1000,
    ButtonTag_Flash,
    ButtonTag_ImageEnhance,
    ButtonTag_AutoCrop,
    ButtonTag_Guide,
    ButtonTag_RecogLanguage,
    ButtonTag_Capture,
    ButtonTag_Cancel,
    ButtonTag_Done,
};

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface CVCManualCaptureController()

// Settings Bar
@property (nonatomic, retain) PPBarView *settingsBar;
@property (nonatomic, retain) PPButton *ppButtonFlash;
@property (nonatomic, retain) PPButton *ppButtonImageEnhance;
@property (nonatomic, retain) PPButton *ppButtonAutoCrop;
@property (nonatomic, retain) PPButton *ppButtonGuide;

// Capture Bar
@property (nonatomic, retain) PPButton *ppButtonCapture;
@property (nonatomic, retain) PPButton *ppButtonCancel;
@property (nonatomic, retain) PPButton *ppButtonRecogLanguage;

// Subviews of OverlayView
@property (nonatomic ,retain) UIImageView *cardDirectionImageView;

// Others
@property (nonatomic, assign) CGSize thumbIconSize;
@property (nonatomic ,assign) NSInteger captureCount;
@property (nonatomic, assign) WCCaptureViewController_CaptureSide captureSide;
@property (nonatomic, retain) NSString *recogLanguage;

@end


////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation CVCManualCaptureController

////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Life cycle methods

//================================================================================
//
//================================================================================
- (id)init
{
    if(self = [super init])
    {
        //////////////////////////////////////////////////
        
        self.captureCount = 0;
        self.captureSide = CaptureMode_None;
        
        
        //////////////////////////////////////////////////
        // Capture ToolBar
        
        _ppButtonRecogLanguage = [[PPButton alloc] initWithFrame:UIButtonAdditions_DefaultRect];
        if (self.ppButtonRecogLanguage != nil)
        {
            self.ppButtonRecogLanguage.titleEdgeInsets = WCCVC_LD_CaptureBarTitleEdgeInset;
            self.ppButtonRecogLanguage.tag = ButtonTag_RecogLanguage;
            self.ppButtonRecogLanguage.ppGuideIndex = ButtonTag_RecogLanguage;
            [self.ppButtonRecogLanguage addControlEvents:UIControlEventTouchUpInside];
            [self.ppButtonRecogLanguage setDelegate:self];
        }
        
        //--------------------------------------------------
        
        self.ppButtonCapture = [PPButton ppButtonWithIconImageName:WCCVC_IFP_CaptureButton
                                                               tag:ButtonTag_Capture
                                                          delegate:self
                                             normalBackgroundColor:nil
                                        highlightedBackgroundColor:nil
                                                   imageEdgeInsets:WCCVC_LD_CaptureBarImageEdgeInset];
        
        if (self.ppButtonCapture != nil)
        {
            self.ppButtonCapture.ppGuideIndex = ButtonTag_Capture;
            [self.ppButtonCapture addControlEvents:UIControlEventTouchUpInside];
        }
        
        //--------------------------------------------------

        self.ppButtonCancel = [PPButton ppButtonWithIconImageName:WCCVC_IFP_CancelButton
                                                               tag:ButtonTag_Cancel
                                                          delegate:self
                                             normalBackgroundColor:nil
                                        highlightedBackgroundColor:nil
                                                   imageEdgeInsets:WCCVC_LD_CaptureBarImageEdgeInset];
        if (self.ppButtonCancel != nil)
        {
            self.ppButtonCancel.ppGuideIndex = ButtonTag_Cancel;
            [self.ppButtonCancel addControlEvents:UIControlEventTouchUpInside];
            
            self.ppButtonCancel.clipsToBounds = NO;
            self.ppButtonCancel.imageView.clipsToBounds = NO;
        }

        //--------------------------------------------------
        
        if (self.captureBar != nil)
        {
            [self.captureBar setIgnoreEdgeInset:YES];
            [self.captureBar setStyle:PPBarViewStyle_Average];
            [self.captureBar setViews:@[self.ppButtonRecogLanguage] forBlockType:PPBarViewBlockType_Left];
            [self.captureBar setViews:@[self.ppButtonCapture] forBlockType:PPBarViewBlockType_Center];
            [self.captureBar setViews:@[self.ppButtonCancel] forBlockType:PPBarViewBlockType_Right];
        }
        
        
        //////////////////////////////////////////////////
        // Settings ToolBar
        
        self.ppButtonFlash = [PPButton ppButtonWithIconImageName:WCCVC_IFP_FlashButton
                                                             tag:ButtonTag_Flash
                                                        delegate:self
                                           normalBackgroundColor:nil
                                      highlightedBackgroundColor:nil
                                                 imageEdgeInsets:WCCVC_LD_SettingsBarImageEdgeInset];
        
        if (self.ppButtonFlash != nil)
        {
            self.ppButtonFlash.ppGuideIndex = ButtonTag_Flash;
            [self.ppButtonFlash addControlEvents:UIControlEventTouchUpInside];
        }
        
        //--------------------------------------------------
        
        self.ppButtonImageEnhance = [PPButton ppButtonWithIconImageName:WCCVC_IFP_ImageEnhanceButton
                                                                    tag:ButtonTag_ImageEnhance
                                                               delegate:self
                                                  normalBackgroundColor:nil
                                             highlightedBackgroundColor:nil
                                                        imageEdgeInsets:WCCVC_LD_SettingsBarImageEdgeInset];
        
        if (self.ppButtonImageEnhance != nil)
        {
            self.ppButtonImageEnhance.ppGuideIndex = ButtonTag_ImageEnhance;
            [self.ppButtonImageEnhance addControlEvents:UIControlEventTouchUpInside];
        }
        
        //--------------------------------------------------

        self.ppButtonAutoCrop = [PPButton ppButtonWithIconImageName:WCCVC_IFP_AutoCropButton
                                                                tag:ButtonTag_AutoCrop
                                                           delegate:self
                                              normalBackgroundColor:nil
                                         highlightedBackgroundColor:nil
                                                    imageEdgeInsets:WCCVC_LD_SettingsBarImageEdgeInset];

        if (self.ppButtonAutoCrop != nil)
        {
            self.ppButtonAutoCrop.ppGuideIndex = ButtonTag_AutoCrop;
            [self.ppButtonAutoCrop addControlEvents:UIControlEventTouchUpInside];
        }

        //--------------------------------------------------
        
        self.ppButtonGuide = [PPButton ppButtonWithIconImageName:WCCVC_IFP_GuideButton
                                                             tag:ButtonTag_Guide
                                                        delegate:self
                                           normalBackgroundColor:nil
                                      highlightedBackgroundColor:nil
                                                 imageEdgeInsets:WCCVC_LD_SettingsBarImageEdgeInset];

        if (self.ppButtonGuide != nil)
        {
            self.ppButtonGuide.ppGuideIndex = ButtonTag_Guide;
            [self.ppButtonGuide addControlEvents:UIControlEventTouchUpInside];
        }
        
        //--------------------------------------------------

        _settingsBar = [[PPBarView alloc] init];
        if(self.settingsBar)
        {
            [self.settingsBar setIgnoreEdgeInset:YES];
            [self.settingsBar setStyle:PPBarViewStyle_Average];
            [self.settingsBar setTranslatesAutoresizingMaskIntoConstraints:NO];
            [self.settingsBar setBackgroundColor:[UIColor clearColor]];
            [self.overlayView addSubview:self.settingsBar];
            
            self.settingsBar.backgroundImageView.backgroundColor = WCCVC_LD_DarkBlueColor;
            self.settingsBar.backgroundImageView.alpha = WCCVC_LD_SettingsBarAlpha;
            
            if([PPCameraView canUseFlashForCameraType:PPCameraType_Back] == YES)
            {
                [self.settingsBar setViews:@[self.ppButtonFlash, self.ppButtonImageEnhance, self.ppButtonAutoCrop, self.ppButtonGuide] forBlockType:PPBarViewBlockType_Center];
            }
            else
            {
                [self.settingsBar setViews:@[self.ppButtonImageEnhance, self.ppButtonAutoCrop, self.ppButtonGuide] forBlockType:PPBarViewBlockType_Center];
            }
        }
        
        
        //////////////////////////////////////////////////
        // target view
        
        if(self.targetView)
        {
//            PPDeviceModelID deviceModelID = [UIDevice deviceModelID];
//            if(deviceModelID==PPDeviceModelID_iPhone_13Mini||
//               deviceModelID==PPDeviceModelID_iPhone_13Pro||
//               deviceModelID==PPDeviceModelID_iPhone_13ProMax||
//               deviceModelID==PPDeviceModelID_iPhone_13)
//            {
//                self.targetView.horzBoxInset = WCCVC_LD_UnfixedTargetBoxMargin_iPhone13;
//                self.targetView.vertBoxInset = WCCVC_LD_UnfixedTargetBoxMargin_iPhone13;
//            }
//            else
            {
                self.targetView.horzBoxInset = WCCVC_LD_UnfixedTargetBoxMargin;
                self.targetView.vertBoxInset = WCCVC_LD_UnfixedTargetBoxMargin;
            }
            [self.overlayView addSubview:self.targetView];
        }
        
        
        //////////////////////////////////////////////////
        // Card Direction Image View
        
        _cardDirectionImageView = [[UIImageView alloc] init];
        if (self.cardDirectionImageView)
        {
            [self.cardDirectionImageView setTranslatesAutoresizingMaskIntoConstraints:NO];
            [self.targetView addSubview:self.cardDirectionImageView];
        }
    }
    
    return self;
}


//================================================================================
//
//================================================================================
- (void)dealloc
{
    self.cardDirectionImageView = nil;
    
    self.ppButtonRecogLanguage  = nil;
    self.ppButtonCapture        = nil;
    self.ppButtonCancel         = nil;
    
    self.ppButtonImageEnhance   = nil;
    self.ppButtonFlash          = nil;
    self.ppButtonAutoCrop       = nil;
    self.ppButtonGuide          = nil;
    self.settingsBar            = nil;
    self.recogLanguage          = nil;
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Instance Methods - Guide

//================================================================================
//
//================================================================================
- (NSArray *)guideDataModelsWithClassName:(NSString *)className
{
    NSArray *guideDataModels = @[[PPGuideDataModel modelWithTargetClassName:className
                                                                 guideIndex:ButtonTag_Flash
                                                                      title:WCCVC_MLS_GuideFlashTitle
                                                                    message:WCCVC_MLS_GuideFlashMessage
                                                            layoutDirection:PPGuideDataModel_LayoutDirection_Vert],
                                 
                                 [PPGuideDataModel modelWithTargetClassName:className
                                                                 guideIndex:ButtonTag_ImageEnhance
                                                                      title:WCCVC_MLS_GuideImageEnhanceTitle
                                                                    message:WCCVC_MLS_GuideImageEnhanceMessage
                                                            layoutDirection:PPGuideDataModel_LayoutDirection_Vert],
                                 
                                 [PPGuideDataModel modelWithTargetClassName:className
                                                                 guideIndex:ButtonTag_AutoCrop
                                                                      title:WCCVC_MLS_GuideAutoCropTitle
                                                                    message:WCCVC_MLS_GuideAutoCropMessage
                                                            layoutDirection:PPGuideDataModel_LayoutDirection_Vert],                                 
                                 ];
    
    return guideDataModels;
}


//================================================================================
//
//================================================================================
- (void)manuallyShowGuide
{
    UIView *guideView = nil;
    
    if([self.delegate respondsToSelector:@selector(captureControllerRequestShowGuide:)])
    {
        guideView = [self.delegate captureControllerRequestShowGuide:self];
    }
    
    [PPGuideController clearAllGuideScripts];
    
    [PPGuideController addGuideScriptWithName:WCCVC_ManualCaptureGuide
                              guideDataModels:[self guideDataModelsWithClassName:guideView.ppGuideClassName]];
     
    [PPGuideController manuallyShowGuideWithView:guideView];
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Instance Methods - subview layout

//================================================================================
//
//================================================================================
- (void)addOptionalSubviews
{
    [self addInfoLabelWithSuperView:self.cardDirectionImageView];
    [self setupInfoLabelLayoutConstraintsWithMaxSize:WCCVC_LD_InfoLabelMaxSize];

    // !!不能加在self.ppButtonCancel上，旋轉後範圍不對。
    [self addCaptureCountLabelWithSuperview:self.ppButtonCancel.imageView];
}


//================================================================================
//
//================================================================================
- (void)setupSubviewsInterfaceOrientation:(UIInterfaceOrientation)orientation
{
    [super setupSubviewsInterfaceOrientation:orientation];
    
    //////////////////////////////////////////////////
    
    [self rotateView:self.ppButtonFlash];
    [self rotateView:self.ppButtonImageEnhance];
    [self rotateView:self.ppButtonAutoCrop];
    [self rotateView:self.ppButtonGuide];
    
    [self rotateView:self.ppButtonCapture];
    [self rotateView:self.ppButtonCancel];
    
    [self rotateView:self.cardDirectionImageView];
    [self updateCardDirectionImageView:orientation];
}


//================================================================================
// setup overlayView layout constraint
//================================================================================
- (void)setupOverlayViewLayoutConstraintWithStyle:(CVCBaseCaptureController_LayoutStyle)layoutStyle
{
    CGFloat settingsBarHeight = (layoutStyle == LayoutStyle_AnimationStart) ? 1 : WCCVC_LD_SettingsBarHeight;
    NSMutableArray *layoutConstraints = [NSMutableArray array];
    NSDictionary *views = @{@"settingsBar":self.settingsBar,
                            @"targetView":self.targetView};
    NSDictionary *metrics = @{@"settingsBarHeight": @(settingsBarHeight)};
    
    
    // 水平佈局
    [layoutConstraints addObjectsFromArray:[NSLayoutConstraint constraintsWithVisualFormat:@"H:|[targetView]|"
                                                                                   options:NSLayoutFormatDirectionLeftToRight
                                                                                   metrics:metrics
                                                                                     views:views]];
    
    [layoutConstraints addObjectsFromArray:[NSLayoutConstraint constraintsWithVisualFormat:@"H:|[settingsBar]|"
                                                                                   options:NSLayoutFormatDirectionLeftToRight
                                                                                   metrics:metrics
                                                                                     views:views]];
    
    // 垂直佈局
    [layoutConstraints addObjectsFromArray:[NSLayoutConstraint constraintsWithVisualFormat:@"V:|[settingsBar(settingsBarHeight)][targetView]|"
                                                                                   options:NSLayoutFormatDirectionLeadingToTrailing
                                                                                   metrics:metrics
                                                                                     views:views]];
    
    // 畫面中央佈局
    [layoutConstraints addObject: [NSLayoutConstraint constraintWithItem:self.cardDirectionImageView
                                                               attribute:NSLayoutAttributeCenterX
                                                               relatedBy:NSLayoutRelationEqual
                                                                  toItem:self.targetView
                                                               attribute:NSLayoutAttributeCenterX
                                                              multiplier:1.0f
                                                                constant:0.0f]];
    
    [layoutConstraints addObject: [NSLayoutConstraint constraintWithItem:self.cardDirectionImageView
                                                               attribute:NSLayoutAttributeCenterY
                                                               relatedBy:NSLayoutRelationEqual
                                                                  toItem:self.targetView
                                                               attribute:NSLayoutAttributeCenterY
                                                              multiplier:1.0f
                                                                constant:0.0f]];

    
    //////////////////////////////////////////////////
    // synchronize overlayViewLayoutConstraints
    
    @synchronized(self)
    {
        if ([layoutConstraints count] > 0)
        {
            if(self.overlayViewLayoutConstraints != nil)
            {
                [self.overlayView removeConstraints:self.overlayViewLayoutConstraints];
            }
            
            [self.overlayView addConstraints:layoutConstraints];
            self.overlayViewLayoutConstraints = layoutConstraints;
        }
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Instance Methods - subview content/status

//================================================================================
//
//================================================================================
- (void)setupCaptureCount:(NSInteger)captureCount
{
    self.captureCount = captureCount;
    
    if(captureCount == 0)
    {
        [self.ppButtonCancel setTag:ButtonTag_Cancel];
        
        [self.ppButtonCancel setImageWithName:WCCVC_IFP_CancelButton];
    }
    else
    {
        [self.ppButtonCancel setTag:ButtonTag_Done];
        
        [self updateCaptureCountLabelWithNumber:self.captureCount];
        
        [self.ppButtonCancel setImageWithName:WCCVC_IFP_DoneButton];
    }
}


//================================================================================
//
//================================================================================
- (void)setupCaptureSide:(WCCaptureViewController_CaptureSide)captureSide
{
    self.captureSide = captureSide;
    
    if(self.captureSide != CaptureSide_None)
    {
        [self updateCardDirectionImageView:self.interfaceOrientation];
    }
}


//================================================================================
//
//================================================================================
- (void)setupFlashState:(BOOL)enableFlash
{
    [self.ppButtonFlash setSelected:enableFlash];
}


//================================================================================
//
//================================================================================
- (void)setupImageEnhanceState:(BOOL)enableImageEnhance
{
    [self.ppButtonImageEnhance setSelected:enableImageEnhance];
}


//================================================================================
//
//================================================================================
- (void)setupAutoCropState:(BOOL)enableAutoCrop
{
    [self.ppButtonAutoCrop setSelected:enableAutoCrop];
}


//================================================================================
//
//================================================================================
- (void)setupRecogLanguageState:(NSString *)recogLanguage
{
    if([recogLanguage length] == 0)
    {
        self.ppButtonRecogLanguage.hidden = YES;
    }
    else
    {
        self.ppButtonRecogLanguage.hidden = NO;
    
        if([self.recogLanguage isEqualToString:recogLanguage] == NO)
        {
            self.recogLanguage = recogLanguage;
            [self.ppButtonRecogLanguage setTitle:recogLanguage maxWidth:0.0];
        }
        
        [self updateInfoLabelLastingWithText:recogLanguage];
    }    
}






////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Instance Methods - Flow action methods

//================================================================================
//
//================================================================================
- (void)actionWhenGetStillImage
{
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Private methods

//================================================================================
//
//================================================================================
- (void)updateCardDirectionImageView:(UIInterfaceOrientation)orientation
{
    UIImage *cardDirectionImage = nil;
    
    if (UIInterfaceOrientationIsPortrait(orientation))
    {
        if(self.captureSide == CaptureSide_Front)
        {
            cardDirectionImage = [UIImage imageWithName:WCCVC_IFP_CardDirectionPortraitFrontSide];
        }
        else if(self.captureSide == CaptureSide_Back)
        {
            cardDirectionImage = [UIImage imageWithName:WCCVC_IFP_CardDirectionPortraitBackSide];
        }
    }
    else
    {
        if(self.captureSide == CaptureSide_Front)
        {
            cardDirectionImage = [UIImage imageWithName:WCCVC_IFP_CardDirectionLandscapeFrontSide];
        }
        else if(self.captureSide == CaptureSide_Back)
        {
            cardDirectionImage = [UIImage imageWithName:WCCVC_IFP_CardDirectionLandscapeBackSide];
        }
    }

    //////////////////////////////////////////////////
    
    if(cardDirectionImage != nil)
    {
        cardDirectionImage = [UIImage imageWithCGImage:cardDirectionImage.CGImage
                                                 scale:WCCVC_LD_ImageScale
                                           orientation:cardDirectionImage.imageOrientation];
        
        //////////////////////////////////////////////////
        
        [self.cardDirectionImageView setImage:cardDirectionImage];
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - PPButtonDelegate

//================================================================================
//
//================================================================================
- (void)ppButton:(PPButton *)ppButton controlEvent:(UIControlEvents)controlEvent
{
    switch (ppButton.tag)
    {
        case ButtonTag_Flash:
        {
            [self setupFlashState:!ppButton.selected];
            
            if(ppButton.selected == YES)
            {
                [self updateInfoLabelTemporaryWithText:WCCVC_MLS_FlashOn];
            }
            else
            {
                [self updateInfoLabelTemporaryWithText:WCCVC_MLS_FlashOff];
            }

            if ([self.delegate respondsToSelector:@selector(captureController:requestUpdateFlashState:)])
            {
                [self.delegate captureController:self requestUpdateFlashState:[ppButton isSelected]];
            }
            break;
        }
            
        case ButtonTag_ImageEnhance:
        {
            [self setupImageEnhanceState:!ppButton.selected];
            
            if(ppButton.selected == YES)
            {
                [self updateInfoLabelTemporaryWithText:WCCVC_MLS_ImageEnhanceOn];
            }
            else
            {
                [self updateInfoLabelTemporaryWithText:WCCVC_MLS_ImageEnhanceOff];
            }
            
            if ([self.delegate respondsToSelector:@selector(captureController:requestUpdateImageEnhanceState:)])
            {
                [self.delegate captureController:self requestUpdateImageEnhanceState:[ppButton isSelected]];
            }
            
            break;
        }
            
        case ButtonTag_AutoCrop:
        {
            [self setupAutoCropState:!ppButton.selected];
            
            if(ppButton.selected == YES)
            {
                [self updateInfoLabelTemporaryWithText:WCCVC_MLS_AutoCropOn];
            }
            else
            {
                [self updateInfoLabelTemporaryWithText:WCCVC_MLS_AutoCropOff];
            }
            
            if ([self.delegate respondsToSelector:@selector(captureController:requestUpdateAutoCropState:)])
            {
                [self.delegate captureController:self requestUpdateAutoCropState:[ppButton isSelected]];
            }
            
            break;
        }
            
        case ButtonTag_Guide:
        {
            [self manuallyShowGuide];
            break;
        }
         
        case ButtonTag_RecogLanguage:
        {
            if ([self.delegate respondsToSelector:@selector(captureControllerRequestSelectRecogLanguage:)])
            {
                [self.delegate captureControllerRequestSelectRecogLanguage:self];
            }
            
            break;
        }
            
        case ButtonTag_Capture:
        {
            if ([self.delegate respondsToSelector:@selector(captureControllerRequestCapture:)])
            {
                [self.delegate captureControllerRequestCapture:self];
            }
            break;
        }
            
        case ButtonTag_Cancel:
        {
            if ([self.delegate respondsToSelector:@selector(captureControllerRequestCancel:)])
            {
                [self.delegate captureControllerRequestCancel:self];
            }
            break;
        }
            
        case ButtonTag_Done:
        {
            if ([self.delegate respondsToSelector:@selector(captureControllerRequestDone:)])
            {
                [self.delegate captureControllerRequestDone:self];
            }
            break;
        }
            
        default:
        {
            break;
        }
    }
}



@end
