//
//  PPCSVWriter.m
//  WorldCardMobile
//
//  Created by harry on 11-6-29.
//  Copyright 2009 __MyCompanyName__. All rights reserved.
//

#import "PPCSVWriter.h"
#import "PPSystemInfoController.h"

@implementation PPCSVWriter
@synthesize _delegate;


//================================================================================
//
//================================================================================
- (id)initWithDelegate:(id)aDelegate andDelegateUserData:(NSObject*)aUserData andFilePath:(NSString*)aFilePath andEncoding:(PPCSVWriterEncoding)aEncoding willSendByEmail:(BOOL)willSendByEmail
{
    if ((self = [super init]) != nil) 
	{
        if(aFilePath)
        {
            _filePath = [aFilePath retain];
        }
        
        if(aUserData)
        {
            _delegateUserData = [aUserData retain];
        }
        
        _delegate = aDelegate;
        _csvWriterEncoding = aEncoding;
        _stringEncoding = NSUTF8StringEncoding;
        _willSendByEmail = willSendByEmail;
        
        CFStringEncoding cfEncoding = kCFStringEncodingUTF8;
        switch (aEncoding) {
            case KPPCSVWriterEncoding_UTF8:
                _stringEncoding = NSUTF8StringEncoding;
                break;
                
            case KPPCSVWriterEncoding_UTF16:
                
                // !! 不要將_stringEncoding設定為NSUnicodeStringEncoding
                //    用NSUnicodeStringEncoding轉換string到data時前面都會加上BOM
                //    但我們只需要在檔頭加BOM即可
                _stringEncoding = NSUTF16LittleEndianStringEncoding;
                break;
                
            case KPPCSVWriterEncoding_ANSI:            
                //cfEncoding = CFStringGetSystemEncoding();
                cfEncoding = [PPCSVWriter pp_getStringEncodingByCurrentSystemLanguage];
                _stringEncoding = CFStringConvertEncodingToNSStringEncoding(cfEncoding);
                break;
                
            default:
                _stringEncoding = NSUTF8StringEncoding;
                break;
        }
    }
    
    return self;
}


//================================================================================
//
//================================================================================
-(void)dealloc
{
    if(_filePath)
    {
        [_filePath release];
        _filePath = nil;
    }
    
    if(_delegateUserData)
    {
        [_delegateUserData release];
        _delegateUserData = nil;
    }
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Private methods

//================================================================================
//
//================================================================================
- (void)pp_writeOneLineDataArrayToFile:(NSFileHandle*)aFileHandle withDataArray:(NSArray*)aDataArray withEncoding:(NSStringEncoding)aStringEncoding isAddNewLineAtEnd:(BOOL)bIsAddNewLineAtEnd isAddDoubleQuotation:(BOOL)bIsAddDoubleQuotation
{
    NSStringEncoding theStringEncoding = aStringEncoding;
    NSString* nsSeperatorText = @",";
    
    if(aFileHandle == nil) return;
    if(aDataArray == nil || [aDataArray count] <= 0) return;
    
    NSInteger iDataArrayCount = [aDataArray count];
    for(NSInteger i=0; i<iDataArrayCount; i++)
    {
        NSObject* oneItem = nil;
        NSString* oneText = nil;
        NSData* oneTextData = nil;
        
        NSMutableString* mutableFormattedText = nil;
        NSString* finalText = nil;
        
        oneItem = [aDataArray objectAtIndex:i];
        if(oneItem)
        {
            if([oneItem isKindOfClass:[NSString class]] == YES)
            {
                oneText = (NSString*)oneItem;
                if(oneText)
                {
                    if(bIsAddDoubleQuotation)
                    {
                        mutableFormattedText = [[NSMutableString alloc]initWithString:oneText];
                        if(mutableFormattedText)
                        {
                            // MARK: 引號處理
                            [mutableFormattedText replaceOccurrencesOfString:@"\"" withString:@"\"\"" options:NSCaseInsensitiveSearch range:NSMakeRange(0, [mutableFormattedText length])];
                            
                            finalText = [[NSString alloc]initWithFormat:@"\"%@\"",mutableFormattedText];
                            if(finalText)
                            {                        
                                oneTextData = [finalText dataUsingEncoding:theStringEncoding allowLossyConversion:YES];
                                if(oneTextData)
                                {
                                    [aFileHandle writeData:oneTextData];
                                }
                                
                                [finalText release];
                                finalText = nil;
                            }
                            [mutableFormattedText release];
                            mutableFormattedText = nil;
                        }
                    }
                    else
                    {
                        oneTextData = [oneText dataUsingEncoding:theStringEncoding allowLossyConversion:YES];
                        if(oneTextData)
                        {
                            [aFileHandle writeData:oneTextData];
                        }                        
                    }
                }
            }
        }
        
        //不是最後一欄, 則在後面補上分隔符號(逗點)
        if(i != (iDataArrayCount -1))
        {
            oneTextData = [nsSeperatorText dataUsingEncoding:theStringEncoding allowLossyConversion:YES];
            if(oneTextData)
            {
                [aFileHandle writeData:oneTextData];
            }
        }
    }
    
    if(bIsAddNewLineAtEnd)
    {
        // MARK: 發送mail時0x0A會因不明原因被改為0x0D0A的處理
        NSString *newLineSymbol = nil;
        
        if(_willSendByEmail == YES)
        {
            // 換行符號改為0x0A就好，iOS email發送時會自動加上0x0D ??? (超怪)
            newLineSymbol = [[NSString alloc] initWithFormat:@"%C", 0x0A];
        }
        else
        {
            newLineSymbol = [[NSString alloc] initWithFormat:@"%C%C", 0x0D, 0x0A];
        }
        
        if(newLineSymbol)
        {
            NSData* oneTextData = nil;
            oneTextData = [newLineSymbol dataUsingEncoding:theStringEncoding allowLossyConversion:YES];
            if(oneTextData)
            {
                [aFileHandle writeData:oneTextData];
            }
            
            [newLineSymbol release];
            newLineSymbol = nil;
        }
    }
}


//================================================================================
//
//================================================================================
+ (CFStringEncoding)pp_getStringEncodingByCurrentSystemLanguage
{
    CFStringEncoding retEncoding;
    PPSystemInfoLanguage language = [PPSystemInfoController language];
    
    switch (language)
    {
        case PPSystemInfoLanguage_ChineseTraditional:
            retEncoding = kCFStringEncodingMacChineseTrad;
            break;
            
        case PPSystemInfoLanguage_ChineseSimplified:
            retEncoding = kCFStringEncodingMacChineseSimp;
            break;
            
        case PPSystemInfoLanguage_Japanese:
            retEncoding = kCFStringEncodingDOSJapanese;
            break;
            
        case PPSystemInfoLanguage_Korean:
            retEncoding = kCFStringEncodingMacKorean;
            break;
            
        case PPSystemInfoLanguage_Turkish:
            retEncoding = kCFStringEncodingMacTurkish;
            break;
            
        case PPSystemInfoLanguage_Arabic:
            retEncoding = kCFStringEncodingMacArabic;
            break;
            
        default:
            retEncoding = kCFStringEncodingMacRoman;
            break;
    }
    
    return retEncoding;
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Public methods

//================================================================================
//
//================================================================================
- (BOOL)startWriting
{
    BOOL bSucess = NO;
    PPCSVFileHeader* csvFileHeader = nil;
    NSFileHandle* oneFileHandle = nil;
    BOOL bAddDoubleQuotation = NO;
    
    
    if(_delegate == nil || [_filePath length] == 0)
        return NO;
    
    NSFileManager* oneFileManager = [NSFileManager defaultManager];
    BOOL bIsDirectory = NO;
    if(oneFileManager)
    {
        //-------------------------------
        //  Remove Old CSV File if needed
        //-------------------------------
        if([oneFileManager fileExistsAtPath:_filePath isDirectory:&bIsDirectory] == YES)
        {
            if(bIsDirectory == NO)
            {
                [oneFileManager removeItemAtPath:_filePath error:nil];
            }
        }
        
        //-------------------------------
        //  Create New CSV File
        //-------------------------------
        [oneFileManager createFileAtPath:_filePath contents:nil attributes:nil];
    }
    
    //////////////////////////////////////////////////
    
    oneFileHandle = [NSFileHandle fileHandleForWritingAtPath:_filePath];
    if(oneFileHandle)
    {
        do
        {
            if([_delegate writerQueryHeader:_delegateUserData outputFileHeader:&csvFileHeader] != KPPCSVWriterRet_Success)
            {
                break;
            }
            
            // write unicode BOM
            if(_stringEncoding == NSUTF16LittleEndianStringEncoding)
            {
                Byte byteOrderMark[2] = {0xFF, 0xFE};
                
                [oneFileHandle writeData:[NSData dataWithBytes:byteOrderMark length:2]];
            }
            
            //////////////////////////////////////////////////
            
            NSArray* dataArray = nil;
            
            if([_delegate writerQueryTitleDataArray:_delegateUserData outputContactData:&dataArray addDoubleQuotation:&bAddDoubleQuotation] != KPPCSVWriterRet_Success)
            {
                break;
            }
            
            if(dataArray)
            {
                [self pp_writeOneLineDataArrayToFile:oneFileHandle withDataArray:dataArray withEncoding:_stringEncoding isAddNewLineAtEnd:YES isAddDoubleQuotation:bAddDoubleQuotation];
            }

            //////////////////////////////////////////////////

            NSInteger iContactCount = csvFileHeader.iContactCount;
            
            for(int i=0; i<iContactCount; i++)
            {
                @autoreleasepool
                {
                    if([_delegate writerQueryItemDataArray:_delegateUserData contactIndex:i outputContactData:&dataArray] != KPPCSVWriterRet_Success)
                    {
                        bSucess = NO;
                        break;
                    }
                    
                    if(dataArray)
                    {
                        [self pp_writeOneLineDataArrayToFile:oneFileHandle
                                               withDataArray:dataArray
                                                withEncoding:_stringEncoding
                                           isAddNewLineAtEnd:(i==iContactCount-1)?NO:YES
                                        isAddDoubleQuotation:bAddDoubleQuotation];
                    }
                    
                    bSucess = YES;                    
                }
            }
        }
        while(0);
        
        [oneFileHandle closeFile];
        oneFileHandle = nil;
    }
    
    [_delegate writerDidFinishWriting:_delegateUserData];
    
    return bSucess;
}


@end
