//
//  PPCSVReader.m
//  Pods
//
//  Created by Howard on 2016/9/21.
//
//

#import "PPCSVReader.h"

@implementation PPCSVReader

//================================================================================
//
//================================================================================
+ (NSMutableArray *)curCSVHandleStringsBasedOnCommaChar:(NSArray *)InfoArray
{
    if(InfoArray==nil)
        return nil;
    
    NSMutableArray *ResInfoArray = [[[NSMutableArray alloc] init] autorelease];
    
    bool mhasdsig = false;
    NSString *MergeTmp = nil;
    
    for(NSInteger j=0;j<[InfoArray count];j++)
    {
        
        NSString *Info = [InfoArray objectAtIndex:j];
        
        NSInteger PreCount = 0;
        NSInteger SufCount = 0;
        
        for(NSInteger l=0;l<[Info length];l++)
        {
            if([Info characterAtIndex:l]==(unichar)('"'))
            {
                PreCount++;
            }
            else
            {
                break;
            }
        }
        
        for(NSInteger l=[Info length]-1;l>0;l--)
        {
            if([Info characterAtIndex:l]==(unichar)('"'))
            {
                SufCount++;
            }
            else
            {
                break;
            }
        }
        
        //////////////////////////////////////////////////
        if([Info hasPrefix:@"\""] && [Info hasSuffix:@"\""] && [Info length]==1 && mhasdsig)
        {
            mhasdsig = false;
            
            NSString *LastMergeStr = [InfoArray objectAtIndex:j];
            LastMergeStr = [LastMergeStr substringWithRange:NSMakeRange(0, [LastMergeStr length]-1)];
            MergeTmp = [MergeTmp stringByAppendingString:LastMergeStr];
            
            if([MergeTmp containsString:@"\"\""])
            {
                MergeTmp = [MergeTmp stringByReplacingOccurrencesOfString:@"\"\"" withString:@"\""];
            }
            
            if(MergeTmp!=nil)
                [ResInfoArray addObject:MergeTmp];
            
            [MergeTmp retain];
            MergeTmp = nil;
        }
        else if([Info hasPrefix:@"\""] && [Info hasSuffix:@"\""] && [Info length]==1 && !mhasdsig) {
            mhasdsig = true;
            MergeTmp = @",";
        }
        else if([Info hasPrefix:@"\""] && [Info hasSuffix:@"\""]) {
            NSString *tmp = [InfoArray objectAtIndex:j];
            
            tmp = [tmp substringWithRange:NSMakeRange(1, [tmp length]-2)];
            
            if([tmp containsString:@"\"\""]) {
                tmp = [tmp stringByReplacingOccurrencesOfString:@"\"\"" withString:@"\""];
            }
            
            if(tmp!=nil)
                [ResInfoArray addObject:tmp];
        }
        else if([Info hasPrefix:@"\""] && !(PreCount%2==0)) {
            mhasdsig = true;
            MergeTmp = [InfoArray objectAtIndex:j];
            MergeTmp = [MergeTmp substringWithRange:NSMakeRange(1, [MergeTmp length]-1)];
            MergeTmp = [MergeTmp stringByAppendingString:@","];
        }
        else if([Info hasSuffix:@"\""] && !(SufCount%2==0)) {
            mhasdsig = false;
            
            NSString *LastMergeStr = [InfoArray objectAtIndex:j];
            LastMergeStr = [LastMergeStr substringWithRange:NSMakeRange(0, [LastMergeStr length]-1)];
            MergeTmp = [MergeTmp stringByAppendingString:LastMergeStr];
            
            if([MergeTmp containsString:@"\"\""]) {
                MergeTmp = [MergeTmp stringByReplacingOccurrencesOfString:@"\"\"" withString:@"\""];
            }
            
            if(MergeTmp!=nil)
                [ResInfoArray addObject:MergeTmp];
            
            [MergeTmp retain];
            MergeTmp = nil;
        }
        else if(mhasdsig){
            
            NSString *tmp = [InfoArray objectAtIndex:j];
            tmp = [tmp stringByAppendingString:@","];
            MergeTmp = [MergeTmp stringByAppendingString:tmp];
        }
        else {
            
            if([Info containsString:@"\"\""]) {
                Info = [Info stringByReplacingOccurrencesOfString:@"\"\"" withString:@"\""];
            }
            
            if(Info!=nil)
                [ResInfoArray addObject:Info];
        }
        
    }
    
    return ResInfoArray;
}


//================================================================================
//
//================================================================================
+ (NSMutableArray *)curCSVHandleStringsBasedOnEnterChar:(NSArray *)InfoArray
{
    if(InfoArray==nil)
        return nil;
    
    NSMutableArray *PersonArray = [[[NSMutableArray alloc] init] autorelease];
    
    NSString *mMergeTmp  = nil;
    bool mMergeTest = false;
    bool mHandlePre = false;
    bool mHandleSuf = false;
    
    for(int i=0;i<[InfoArray count];i++) {
        NSString *str = [InfoArray objectAtIndex:i];
        
        if(str==nil || [str length]==0) {
            
        }
        else {
            if(!mMergeTest){
                int MaxIdx = -1;
                for(int j=0;j<[str length];j++) {
                    if([str characterAtIndex:j]==(unichar)(','))
                        MaxIdx = j;
                }
                
                int NextIdx = MaxIdx+1;
                
                if(NextIdx>=0 && NextIdx<[str length]) {
                    if([str characterAtIndex:NextIdx]==(unichar)('"'))
                        mHandlePre = true;
                }
                
                
                int numOfSign = 0;
                for(int j=0;j<[str length];j++) {
                    if([str characterAtIndex:j]==(unichar)('"')) {
                        int Pidx = j-1;
                        int Sidx = j+1;
                        
                        BOOL checkother = YES;
                        if(j==[str length]-1 || j==0) {
                            numOfSign++;
                            checkother = NO;
                        }
                        if(Pidx>=0 && checkother) {
                            if([str characterAtIndex:Pidx]==(unichar)(',')) {
                                numOfSign++;
                                checkother = NO;
                            }
                        }
                        if(Sidx<[str length] && checkother) {
                            if([str characterAtIndex:Sidx]==(unichar)(',')) {
                                numOfSign++;
                            }
                        }
                    }
                }
                if(numOfSign%2==1) {
                    mHandlePre = true;
                }
            }
            ///////////
            if(mMergeTest) {
                int MinIdx = -1;
                for(int j=0;j<[str length];j++) {
                    if([str characterAtIndex:j]==(unichar)(',')) {
                        MinIdx = j;
                        break;
                    }
                }
                int PrevIdx = MinIdx-1;
                
                if(PrevIdx>=0 && PrevIdx<[str length]) {
                    if([str characterAtIndex:PrevIdx]==(unichar)('"'))
                        mHandleSuf = true;
                    int PrevPrevIdx = PrevIdx -1;
                    if(PrevPrevIdx>=0 && PrevPrevIdx<[str length]) {
                        if([str characterAtIndex:PrevPrevIdx]==(unichar)('"'))
                            mHandleSuf = false;
                    }
                }
                
                ////
                int numOfSign = 0;
                for(int j=0;j<[str length];j++) {
                    if([str characterAtIndex:j]==(unichar)('"')) {
                        int Pidx = j-1;
                        int Sidx = j+1;
                        
                        BOOL checkother = YES;
                        if(j==[str length]-1 || j==0) {
                            numOfSign++;
                            checkother = NO;
                        }
                        if(Pidx>=0 && checkother) {
                            if([str characterAtIndex:Pidx]==(unichar)(',')) {
                                numOfSign++;
                                checkother = NO;
                            }
                        }
                        if(Sidx<[str length] && checkother) {
                            if([str characterAtIndex:Sidx]==(unichar)(',')) {
                                numOfSign++;
                            }
                        }
                    }
                }
                if(numOfSign%2==1) {
                    mHandleSuf = true;
                }
                ///
                
                if(i==[InfoArray count]-1 && [str hasSuffix:@"\""]) {
                    mHandleSuf = true;
                }
                
            }
        }
        ///////////
        
        if([str hasPrefix:@"\""] && [str hasSuffix:@"\""] && !mMergeTest && !mHandlePre) {
            //NSLog(@"Insert : %@", str);
            if(str!=nil)
                [PersonArray addObject:str];
        }
        else if(mHandlePre) {
            mHandlePre = false;
            str = [str stringByAppendingString:@"\n"];
            mMergeTmp = str;
            mMergeTest = true;
        }
        else if(mHandleSuf) {
            mHandleSuf = false;
            mMergeTest = false;
            
            mMergeTmp = [mMergeTmp stringByAppendingString:str];
            //NSLog(@"Insert : %@", mMergeTmp);
            if(mMergeTmp!=nil)
                [PersonArray addObject:mMergeTmp];
            
            [mMergeTmp retain];
            mMergeTmp = nil;
        }
        else if(mMergeTest) {
            str = [str stringByAppendingString:@"\n"];
            mMergeTmp = [mMergeTmp stringByAppendingString:str];
        }
        else {
            //NSLog(@"Insert : %@", str);
            if(str!=nil)
                [PersonArray addObject:str];
        }
    }
    
    return PersonArray;
}


@end
