//
//  WCAlbumFlowController.h
//  
//
//  Created by Howard on 2016/1/21.
//
//

#import <Foundation/Foundation.h>

// Define
#import "WCAlbumFlowControllerDelegate.h"
#import "WCAlbumFlowControllerDatasource.h"

@interface WCAlbumFlowController : NSObject

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Property

@property (nonatomic,assign) NSInteger maxAddedCardCount; // -1 代表無上限
@property (nonatomic,assign) NSUInteger curAddedCardCount;

/// 到達上限的alert是否顯示"馬上訂閱", default NO, office, salesforce才要
@property (nonatomic,assign) BOOL showSubscribeWhenReachMaxCount;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method


/**
 *  新增相片選取
 *
 *  @param superViewController         來源視圖
 *  @param albumFlowControllerDelegate 委託者
 *
 */
- (void)presentSelectImageViewControllerFromSuperViewController:(UIViewController *)superViewController
                                    albumFlowControllerDelegate:(id<WCAlbumFlowControllerDelegate>)albumFlowControllerDelegate;


/**
 *  新增相片(多選)
 *
 *  @param superViewController         來源視圖
 *  @param albumFlowControllerDatasource 委託者
 *  @param albumFlowControllerDelegate 委託者
 *
 */
- (void)presentNewImageViewControllerFromSuperViewController:(UIViewController *)superViewController
                               albumFlowControllerDatasource:(id<WCAlbumFlowControllerDatasource>)albumFlowControllerDatasource
                                 albumFlowControllerDelegate:(id<WCAlbumFlowControllerDelegate>)albumFlowControllerDelegate;


/**
 *  新增相片(單選)
 *
 *  @param superViewController         來源視圖
 *  @param albumFlowControllerDatasource 委託者
 *  @param albumFlowControllerDelegate 委託者
 *
 */
- (void)presentMyCardSelectImageViewControllerFromSuperViewController:(UIViewController *)superViewController
                                        albumFlowControllerDatasource:(id<WCAlbumFlowControllerDatasource>)albumFlowControllerDatasource
                                          albumFlowControllerDelegate:(id<WCAlbumFlowControllerDelegate>)albumFlowControllerDelegate;
@end
