//
//  SearchPhoneTextFieldTableViewCell.m
//  Extension
//
//  Created by AndrewLai on 2018/3/26.
//

#import "SearchPhoneTextFieldTableViewCell.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface SearchPhoneTextFieldTableViewCell() <PPButtonDelegate>

@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation SearchPhoneTextFieldTableViewCell

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Dellocating Object

//================================================================================
//
//================================================================================
- (id)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier
{
    self = [super initWithStyle:style reuseIdentifier:reuseIdentifier];
    if (self!=nil)
    {
        _searchOperatorButton = [[PPButton alloc] init];
        if (self.searchOperatorButton!=nil)
        {
            [self.searchOperatorButton setTitleColor:[UIColor grayColor]];
            [self.searchOperatorButton setContentHorizontalAlignment:UIControlContentHorizontalAlignmentLeft];
            [self.searchOperatorButton addControlEvents:UIControlEventTouchUpInside];
            [self.searchOperatorButton setDelegate:self];
            
            [self.contentView addSubview:self.searchOperatorButton];
        }
        
        _directionImageView = [[UIImageView alloc] init];
        if (self.directionImageView!=nil)
        {
            self.directionImageView.image = [UIImage imageWithName:@"WCContactInfoViewControllerButtonMoreLanguage-Highlighted"];
            self.directionImageView.contentMode = UIViewContentModeScaleAspectFit;
            
            [self.contentView addSubview:self.directionImageView];
        }
        
        self.contactTableViewCellLineView.drawHorizontalLine = YES;
    }
    
    return self;
}


//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_directionImageView removeFromSuperview];
    [_directionImageView release];
    _directionImageView = nil;
    
    [_searchOperatorButton removeFromSuperview];
    [_searchOperatorButton release];
    _searchOperatorButton = nil;

    //////////////////////////////////////////////////
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Layout Of View

//================================================================================
//
//================================================================================
- (void)layoutSubviews
{
    [super layoutSubviews];
    
    //////////////////////////////////////////////////
    CGRect searchButtonFrame = self.textField.frame;
    searchButtonFrame.size.height = searchButtonFrame.size.height/2;;
    self.searchOperatorButton.frame = searchButtonFrame;
    
    CGRect imageViewFrame = CGRectMake(0, 0, 20, 20);
    imageViewFrame.origin.x = CGRectGetMaxX(searchButtonFrame)-imageViewFrame.size.width-5;
    imageViewFrame.origin.y = CGRectGetMidY(searchButtonFrame)-imageViewFrame.size.height/2;
    self.directionImageView.frame = imageViewFrame;
    
    CGRect textFieldFrame = searchButtonFrame;
    textFieldFrame.origin.y = CGRectGetMaxY(searchButtonFrame)+PPTableViewCellLineView_LineWidth;
    self.textField.frame = textFieldFrame;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPButtonDelegate

//================================================================================
//
//================================================================================
- (void)ppButton:(PPButton *)ppButton controlEvent:(UIControlEvents)controlEvent
{
    if (self.operatorDelegate!=nil && [self.delegate respondsToSelector:@selector(searchPhoneTextFieldTableViewCellDidClickOperatorButton:)]==YES)
    {
        [self.operatorDelegate searchPhoneTextFieldTableViewCellDidClickOperatorButton:self];
    }
}


@end
