//
//  SearchOptionTableHeaderView.m
//  ADAL
//
//  Created by AndrewLai on 2018/4/23.
//

#import "SearchOptionTableHeaderView.h"

#import "WCAdvancedSearchViewController+ResourceDefine.h"
#import "WCAppearanceDefine.h"

#import "PPButton.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

static CGFloat const SearchOptionTableHeaderViewSubViewMargin = 10;
static CGFloat const SearchOptionTableHeaderViewSubViewHeight = 30;

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface SearchOptionTableHeaderView () <PPButtonDelegate>

@property (nonatomic, retain) UILabel *optionTitleLabel;
@property (nonatomic, retain) PPButton *clearAllButton;

@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation SearchOptionTableHeaderView





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Dellocating Objects

//================================================================================
//
//================================================================================
- (id)initWithFrame:(CGRect)frame
{
    if (self = [super initWithFrame:frame])
    {
        self.backgroundColor = WCAppearanceDefine_SectionIndexHighlightColor;
        
        _optionTitleLabel = [[UILabel alloc] initWithFrame:CGRectZero];
        if (self.optionTitleLabel!=nil)
        {
            self.optionTitleLabel.text = WCASVC_MLS_NavigationOptionTitle;
            self.optionTitleLabel.textColor = WCAppearanceDefine_SectionIndexTitleHighlightColor;
            [self.optionTitleLabel sizeToFit];
            
            [self addSubview:self.optionTitleLabel];
        }
        
        _clearAllButton = [[PPButton alloc] initWithFrame:CGRectZero];
        if (self.clearAllButton!=nil)
        {
            [self.clearAllButton setTitle:WCASVC_MLS_NavigationClearAll maxWidth:0.0];
            [self.clearAllButton setTitleColor:WCAppearanceDefine_SectionIndexTitleHighlightColor];
            [self.clearAllButton sizeToFit];
            self.clearAllButton.delegate = self;
            
            [self.clearAllButton addControlEvents:UIControlEventTouchUpInside];
            [self addSubview:self.clearAllButton];
        }
    }
    
    return self;
}


//================================================================================
//
//================================================================================
- (void)dealloc
{
    [self.clearAllButton removeFromSuperview];
    self.clearAllButton.delegate = nil;
    self.clearAllButton = nil;
    
    [self.optionTitleLabel removeFromSuperview];
    self.optionTitleLabel = nil;
    
    //////////////////////////////////////////////////
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Laying out Subviews

//================================================================================
//
//================================================================================
- (void)layoutSubviews
{
    [super layoutSubviews];
    
    //////////////////////////////////////////////////
    self.optionTitleLabel.frame = CGRectMake(SearchOptionTableHeaderViewSubViewMargin,
                                             7,
                                             self.optionTitleLabel.frame.size.width,
                                             SearchOptionTableHeaderViewSubViewHeight);
    self.clearAllButton.frame = CGRectMake(self.bounds.size.width-SearchOptionTableHeaderViewSubViewMargin-self.clearAllButton.frame.size.width,
                                           7,
                                           self.clearAllButton.frame.size.width,
                                           SearchOptionTableHeaderViewSubViewHeight);
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPButtonDelegate

//================================================================================
//
//================================================================================
- (void)ppButton:(PPButton *)ppButton controlEvent:(UIControlEvents)controlEvent
{
    if (self.delegate!=nil && [self.delegate respondsToSelector:@selector(didClickClearAllButtonInSearchOptionTableHeaderView:)]==YES)
    {
        [self.delegate didClickClearAllButtonInSearchOptionTableHeaderView:self];
    }
}

@end
